/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.fi;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.mservice.fi.handler.TaxSkillHandler;

public enum TaxSkillServiceEnum {
    ZZS("zzssbjqr", "kd.taxc.bdtaxr.mservice.fi.handler.TcvatSkillHandler"),
    QYSDS("qysdssbjqr", "kd.taxc.bdtaxr.mservice.fi.handler.TccitSkillHandler"),
    CCXWS("ccxwssbjqr", "kd.taxc.bdtaxr.mservice.fi.handler.TcretSkillHandler"),
    DEFAULT;

    private String taxSkill;
    private String service;
    private static Log logger;

    public String getTaxSkill() {
        return this.taxSkill;
    }

    public String getService() {
        return this.service;
    }

    private TaxSkillServiceEnum(String taxSkill, String service) {
        this.taxSkill = taxSkill;
        this.service = service;
    }

    private TaxSkillServiceEnum() {
    }

    public static TaxSkillHandler getHandler(String taxSkill) {
        for (TaxSkillServiceEnum value : TaxSkillServiceEnum.values()) {
            if (!value.getTaxSkill().equals(taxSkill)) continue;
            try {
                return (TaxSkillHandler)Class.forName(value.getService()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error("TaxSkillServiceEnum getHandler error");
                logger.error((Throwable)e);
            }
        }
        return null;
    }

    static {
        logger = LogFactory.getLog(TaxSkillServiceEnum.class);
    }
}

