/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.fi.handler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.mservice.fi.handler.TaxSkillHandler;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractSkillHandler
implements TaxSkillHandler {
    private static Log logger = LogFactory.getLog(AbstractSkillHandler.class);

    @Override
    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        SkillRunResult result = skillRunContext.getSkillResult();
        result.setSkillNum(skillRunContext.getSkillNum());
        result.setDate(skillRunContext.getEndTime());
        List<Map<String, String>> currentData = this.doCalData(skillRunContext);
        result.setTotalCount(this.doCalTotalCount(currentData));
        result.setFailCount(Integer.valueOf(0));
        skillRunContext.setStartTime(DateUtils.getFirstDateOfMonth((Date)skillRunContext.getStartTime()));
        skillRunContext.setEndTime(DateUtils.getLastDateOfMonth((Date)skillRunContext.getEndTime()));
        List<Map<String, String>> currentMonthData = this.doCalData(skillRunContext);
        result.setData(currentMonthData);
        return result;
    }

    protected Integer doCalTotalCount(List<Map<String, String>> currentData) {
        if (CollectionUtils.isEmpty(currentData)) {
            return 0;
        }
        int total = 0;
        for (Map<String, String> currentDatum : currentData) {
            if ("dclfxsl".equals(currentDatum.get("number"))) continue;
            try {
                total += Integer.parseInt(currentDatum.get("value"));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        return total;
    }

    protected List<Map<String, String>> doCalData(SkillRunContext skillRunContext) {
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        this.getParamMap1(data, skillRunContext);
        this.getParamMap2(data, skillRunContext);
        this.getParamMap3(data, skillRunContext);
        return data;
    }

    private void getParamMap3(List<Map<String, String>> data, SkillRunContext skillRunContext) {
        HashMap<String, String> param3Map = new HashMap<String, String>();
        param3Map.put("name", ResManager.loadKDString((String)"\u53d1\u73b0\u98ce\u9669\u6570\u91cf", (String)"AbstractSkillHandler_1", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        String riskCount = this.doCountDeclareRisk(skillRunContext);
        param3Map.put("value", riskCount);
        param3Map.put("valueType", "0");
        param3Map.put("number", "fxfxsl");
        HashMap<String, String> param4Map = new HashMap<String, String>();
        param4Map.put("name", ResManager.loadKDString((String)"\u5f85\u5904\u7406\u98ce\u9669\u6570\u91cf", (String)"AbstractSkillHandler_2", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        param4Map.put("value", riskCount);
        param4Map.put("valueType", "0");
        param4Map.put("number", "dclfxsl");
        data.add(param3Map);
        data.add(param4Map);
    }

    private void getParamMap2(List<Map<String, String>> data, SkillRunContext skillRunContext) {
        HashMap<String, String> param2Map = new HashMap<String, String>();
        param2Map.put("name", ResManager.loadKDString((String)"\u751f\u6210\u7533\u62a5\u8868\u6570\u636e", (String)"AbstractSkillHandler_3", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        param2Map.put("value", this.doCountDeclare(skillRunContext));
        param2Map.put("valueType", "0");
        param2Map.put("number", "scsbbsj");
        data.add(param2Map);
    }

    protected void getParamMap1(List<Map<String, String>> data, SkillRunContext skillRunContext) {
        HashMap<String, String> param1Map = new HashMap<String, String>();
        param1Map.put("name", ResManager.loadKDString((String)"\u751f\u6210\u5e95\u7a3f\u6570\u636e", (String)"AbstractSkillHandler_4", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        param1Map.put("value", this.doCountDraft(skillRunContext));
        param1Map.put("valueType", "0");
        param1Map.put("number", "scdgsj");
        data.add(param1Map);
    }

    protected abstract String doCountDraft(SkillRunContext var1);

    protected abstract String doCountDeclare(SkillRunContext var1);

    protected abstract String doCountDeclareRisk(SkillRunContext var1);
}

