/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.fi.handler;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.service.taxdeclare.RiskDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.RiskDataServiceImpl;
import kd.taxc.bdtaxr.mservice.fi.handler.AbstractSkillHandler;

public class TcretSkillHandler
extends AbstractSkillHandler {
    private static RiskDataService riskDataService = new RiskDataServiceImpl();

    @Override
    protected void getParamMap1(List<Map<String, String>> data, SkillRunContext skillRunContext) {
        HashMap<String, String> param1Map = new HashMap<String, String>();
        param1Map.put("name", ResManager.loadKDString((String)"\u751f\u6210\u7a0e\u6e90\u6570\u636e", (String)"TcretSkillHandler_0", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        param1Map.put("value", this.doCountDraft(skillRunContext));
        param1Map.put("valueType", "0");
        param1Map.put("number", "scsysj");
        data.add(param1Map);
    }

    @Override
    protected String doCountDraft(SkillRunContext skillRunContext) {
        int fcsBasic = this.doCountFcsBasic(skillRunContext);
        int fcsRent = this.doCountFcsRent(skillRunContext);
        int tds = this.doCountTds(skillRunContext);
        int yhs = this.doCountYhs(skillRunContext);
        int cc = this.doCountCar(skillRunContext);
        int cb = this.doCountShip(skillRunContext);
        int air = this.doCountAir(skillRunContext);
        int solid = this.doCountSolid(skillRunContext);
        int qs = this.doCountQs(skillRunContext);
        int count = fcsBasic + fcsRent + tds + yhs + cc + cb + air + solid + qs;
        return String.valueOf(count);
    }

    @Override
    protected String doCountDeclare(SkillRunContext skillRunContext) {
        DynamicObjectCollection declareList = this.doQueryDeclareList(skillRunContext);
        if (CollectionUtils.isEmpty((Collection)declareList)) {
            return "0";
        }
        return String.valueOf(declareList.size());
    }

    @Override
    protected String doCountDeclareRisk(SkillRunContext skillRunContext) {
        DynamicObjectCollection declareList = this.doQueryDeclareList(skillRunContext);
        long declareCount = CollectionUtils.isEmpty((Collection)declareList) ? 0L : declareList.stream().filter(d -> "1".equals(d.getString("riskstatus"))).count();
        List maps = riskDataService.queryTctrcResultByTax("ccxws", skillRunContext.getStartTime(), skillRunContext.getEndTime());
        int riskCount = maps.size();
        return String.valueOf(declareCount + (long)riskCount);
    }

    private DynamicObjectCollection doQueryDeclareList(SkillRunContext skillRunContext) {
        Date startTime = skillRunContext.getStartTime();
        Date endTime = skillRunContext.getEndTime();
        QFilter createTimeFilter = new QFilter("createtime", ">=", (Object)startTime).and(new QFilter("createtime", "<=", (Object)endTime));
        QFilter typeFilter = new QFilter("type", "=", (Object)"ccxws");
        return QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"", (QFilter[])new QFilter[]{createTimeFilter, typeFilter});
    }

    private int doCountQs(SkillRunContext skillRunContext) {
        return this.doCountByCreateTime(skillRunContext, "tdm_qishui_dj");
    }

    private int doCountSolid(SkillRunContext skillRunContext) {
        return this.doCountByCreateTime(skillRunContext, "tdm_solid_waste_info");
    }

    private int doCountAir(SkillRunContext skillRunContext) {
        return this.doCountByCreateTime(skillRunContext, "tdm_pollution_air_water");
    }

    private int doCountShip(SkillRunContext skillRunContext) {
        return this.doCountByCreateTime(skillRunContext, "tdm_ship_tax_fund_info");
    }

    private int doCountCar(SkillRunContext skillRunContext) {
        return this.doCountByCreateTime(skillRunContext, "tdm_car_tax_fund_info");
    }

    private int doCountYhs(SkillRunContext skillRunContext) {
        return this.doCountByCreateTime(skillRunContext, "tcret_yhs_tax_source_info");
    }

    private int doCountTds(SkillRunContext skillRunContext) {
        return this.doCountByCreateTime(skillRunContext, "tdm_tds_basic_info");
    }

    private int doCountFcsRent(SkillRunContext skillRunContext) {
        return this.doCountByCreateTime(skillRunContext, "tdm_house_rental_info");
    }

    private int doCountFcsBasic(SkillRunContext skillRunContext) {
        return this.doCountByCreateTime(skillRunContext, "tdm_fcs_basic_info");
    }

    private int doCountByCreateTime(SkillRunContext skillRunContext, String meta) {
        Date startTime = skillRunContext.getStartTime();
        Date endTime = skillRunContext.getEndTime();
        QFilter createTimeFilter = new QFilter("createtime", ">=", (Object)startTime).and(new QFilter("createtime", "<=", (Object)endTime));
        DynamicObjectCollection result = QueryServiceHelper.query((String)meta, (String)"", (QFilter[])new QFilter[]{createTimeFilter});
        if (CollectionUtils.isEmpty((Collection)result)) {
            return 0;
        }
        return result.size();
    }
}

