/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.ruleEngine;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.RuleEngineDto;
import kd.taxc.bdtaxr.common.dto.RuleTimeFilterDto;
import kd.taxc.bdtaxr.common.helper.ExrateConvertHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.mservice.api.ruleEngine.RuleEnginService;
import kd.taxc.bdtaxr.mservice.api.ruleEngine.RuleFilterService;
import kd.taxc.bdtaxr.servicehelper.ServiceFactory;
import org.apache.commons.lang.StringUtils;

public class AssertAcceDepreEnginServiceImpl
implements RuleEnginService {
    private BigDecimal reverse = new BigDecimal(-1);
    private RuleFilterService ruleFilterService = ServiceFactory.getService(RuleFilterService.class);

    @Override
    public Object getRuleEnginData(RuleEngineDto ruleEngineDto) {
        String prefix = ruleEngineDto.getPrefix();
        String entityType = ruleEngineDto.getEntityType();
        Long orgId = ruleEngineDto.getOrgId();
        Long taxorgId = ruleEngineDto.getTaxorgid();
        Date startDate = ruleEngineDto.getStartdate();
        Date endDate = ruleEngineDto.getEnddate();
        DynamicObject rule = ruleEngineDto.getRule();
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(Collections.singletonList(taxorgId), (Date)startDate, (Date)endDate);
        Map<String, BigDecimal> exrateMap = ruleEngineDto.getRuleSetAccounting().stream().filter(a -> a.containsProperty(prefix + "exratejson")).map(a -> a.getString(prefix + "exratejson")).collect(Collectors.toMap(k -> k, v -> BigDecimal.ZERO, (m, n) -> m));
        for (Map.Entry<String, BigDecimal> entry : exrateMap.entrySet()) {
            BigDecimal exrate = ExrateConvertHelper.calcExrate((String)entry.getKey(), (Date)startDate, (Date)endDate);
            entry.setValue(exrate);
        }
        HashMap<String, Cloneable> resultMap = new HashMap<String, Cloneable>();
        HashMap<String, List<BigDecimal>> amountMap = new HashMap<String, List<BigDecimal>>();
        ArrayList<DynamicObject> accountList = new ArrayList<DynamicObject>();
        for (DynamicObject rulesetting : ruleEngineDto.getRuleSetAccounting()) {
            QFilter qFilters;
            String org;
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            DynamicObject table = rulesetting.getDynamicObject(prefix + "table");
            String entryName = table.getString("name");
            if (!entryName.equals("tccit_tax_acce_diff")) continue;
            String conditionjson = rulesetting.getString(prefix + "conditionjson");
            String fieldsubname = rulesetting.getDynamicObject(prefix + "amountfield").getString("fieldsubname");
            Map fieldMap = RuleConfigUtils.get((Long)table.getLong("id"));
            List<Long> cOrgs = Collections.singletonList(taxorgId);
            QFilter mappingQfilter = EngineCalcFilterService.getMappingQfilter((Long)DeclareTaxType.QYSDS.getBaseTaxId(), (Long)table.getLong("id"), cOrgs, (Date)startDate, (Date)endDate);
            if (mappingQfilter != null) {
                filterList.add(mappingQfilter);
            }
            if (null != (org = (String)fieldMap.get("orgstate"))) {
                String entityKey = entryName;
                String orgFieldName = org;
                if (org.contains(".")) {
                    String[] split = org.split("\\.");
                    entityKey = split[0];
                    orgFieldName = split[1];
                }
                List orgListByRelation = EngineCalcFilterService.getOrgListByRelation((Map)orgRelationMap, cOrgs, (String)entryName, (String)entityKey, (String)orgFieldName);
                filterList.add(new QFilter(org, "in", (Object)orgListByRelation));
            }
            String advancedconf = rulesetting.getString(prefix + "advancedconfjson");
            BigDecimal exrate = BigDecimal.ZERO;
            if (rulesetting.containsProperty(prefix + "exratejson")) {
                exrate = exrateMap.getOrDefault(rulesetting.getString(prefix + "exratejson"), BigDecimal.ZERO);
            }
            RuleTimeFilterDto ruleTimeFilterDto = new RuleTimeFilterDto(advancedconf, startDate, endDate, filterList, fieldsubname, fieldMap, entryName);
            this.ruleFilterService.setRuleConfigTimeFilter(ruleTimeFilterDto);
            if (StringUtils.isNotBlank((String)conditionjson) && (qFilters = FilterBuilderUtils.buildFilter((String)conditionjson, (String)entryName)) != null) {
                filterList.add(qFilters);
            }
            String amountField = rulesetting.getDynamicObject(prefix + "amountfield").getString("fieldname");
            ArrayList queryFields = Lists.newArrayList((Object[])new String[]{"id,accountingperiod", "declareperiod", "assetsnumber", "assetsvalue"});
            queryFields.add(amountField);
            String selectField = queryFields.stream().distinct().collect(Collectors.joining(","));
            DynamicObjectCollection accountingList = QueryServiceHelper.query((String)entryName, (String)selectField, (QFilter[])filterList.toArray(new QFilter[0]));
            accountingList = null != accountingList ? accountingList : new DynamicObjectCollection();
            this.calAmount(prefix, amountMap, rulesetting, amountField, accountingList, rule, startDate, endDate, orgId, taxorgId, entityType, exrate, accountList);
        }
        resultMap.put("amount_map", amountMap);
        resultMap.put("account_detail", accountList);
        return resultMap;
    }

    private DynamicObject getDepreciationData(String prefix, BigDecimal detailTotalAmount, DynamicObject rulesetting, DynamicObject rule, Date startDate, Date endDate, Long orgid, Long taxorgId, DynamicObject detailEntity, BigDecimal exrate, BigDecimal amount) {
        String depreciateTypeNum = rule.getDynamicObject("depreciatetype").getString("number");
        detailEntity.set("taxaccountserialno", (Object)UUID.randomUUID().toString());
        detailEntity.set("org", (Object)orgid);
        detailEntity.set("taxorg", (Object)taxorgId);
        detailEntity.set("skssqq", (Object)startDate);
        detailEntity.set("skssqz", (Object)endDate);
        detailEntity.set("bizname", (Object)rulesetting.getString(prefix + "bizname"));
        detailEntity.set("table", (Object)rulesetting.getDynamicObject(prefix + "table").getLong("id"));
        detailEntity.set("amountfield", (Object)rulesetting.getDynamicObject(prefix + "amountfield").getLong("id"));
        detailEntity.set("datatype", rulesetting.get(prefix + "datatype"));
        detailEntity.set("datadirection", rulesetting.get(prefix + "datadirection"));
        detailEntity.set("filtercondition", rulesetting.get(prefix + "filtercondition"));
        detailEntity.set("conditionjson", rulesetting.get(prefix + "conditionjson"));
        detailEntity.set("advancedconfjson", rulesetting.get(prefix + "advancedconfjson"));
        detailEntity.set("absolute", rulesetting.get(prefix + "absolute"));
        detailEntity.set("ruleid", (Object)rule.getLong("id"));
        detailEntity.set("itemnumber", (Object)depreciateTypeNum);
        detailEntity.set("entrytype", (Object)(StringUtils.isBlank((String)prefix) ? "depreciate" : prefix));
        detailEntity.set("fetchamount", (Object)detailTotalAmount);
        detailEntity.set("amount", (Object)amount);
        if (detailEntity.containsProperty("exrate")) {
            detailEntity.set("exrate", (Object)exrate);
        }
        return detailEntity;
    }

    private void calAmount(String prefix, Map<String, List<BigDecimal>> map, DynamicObject rulesetting, String amountField, DynamicObjectCollection accountingList, DynamicObject rule, Date startDate, Date endDate, Long orgid, Long taxorgId, String entityType, BigDecimal exrate, List<DynamicObject> accountList) {
        BigDecimal detailTotalAmount = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : accountingList) {
            detailTotalAmount = detailTotalAmount.add(this.getAbsAmount(rulesetting, amountField, dynamicObject, prefix));
        }
        String datadirection = rulesetting.getString(prefix + "datadirection");
        BigDecimal amount = this.getAmount(detailTotalAmount, datadirection, null, null);
        DynamicObject detailEntity = BusinessDataServiceHelper.newDynamicObject((String)entityType);
        if (detailEntity.containsProperty("exrate")) {
            detailEntity.set("exrate", (Object)exrate);
            if (BigDecimal.ZERO.compareTo(exrate) < 0) {
                amount = amount.multiply(exrate).setScale(10, 4);
            }
        }
        List objects = map.computeIfAbsent(amountField, a -> new ArrayList());
        objects.add(amount);
        accountList.add(this.getDepreciationData(prefix, detailTotalAmount, rulesetting, rule, startDate, endDate, orgid, taxorgId, detailEntity, exrate, amount));
    }

    public BigDecimal getAbsAmount(DynamicObject setting, String selectField, DynamicObject dynamicObject, String prefix) {
        BigDecimal amount = Boolean.TRUE.equals(setting.getBoolean(prefix + "absolute")) ? dynamicObject.getBigDecimal(selectField).abs() : dynamicObject.getBigDecimal(selectField);
        return amount;
    }

    @Override
    public BigDecimal getAmount(BigDecimal detailTotalamount, String datadirection, String datatype, BigDecimal taxrate) {
        BigDecimal amount = "positive".equals(datadirection) ? detailTotalamount : detailTotalamount.multiply(this.reverse);
        return amount;
    }
}

