/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.ruleEngine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.RuleTimeFilterDto;
import kd.taxc.bdtaxr.common.enums.RuleConfigEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.mservice.api.ruleEngine.GlBalanceService;

public class GlBalanceServiceImpl
implements GlBalanceService {
    private static final Log logger = LogFactory.getLog(GlBalanceServiceImpl.class);
    private static final Map<String, String> beginToEndMap = new HashMap<String, String>();
    private static final String GL_BALANCE = "gl_balance";
    private static final String TDM_BALANCE = "tdm_balance_new";

    @Override
    public boolean financeBeginEnd(String fieldsubname, String advancedconf) {
        return StringUtil.equals((CharSequence)GL_BALANCE, (CharSequence)fieldsubname) && (StringUtil.equals((CharSequence)RuleConfigEnum.TOBEGIN.getRuleConfigCode(), (CharSequence)advancedconf) || StringUtil.equals((CharSequence)RuleConfigEnum.TOEND.getRuleConfigCode(), (CharSequence)advancedconf));
    }

    @Override
    public boolean tdmBalanceNew(String fieldsubname, String advancedconf) {
        return StringUtil.equals((CharSequence)TDM_BALANCE, (CharSequence)fieldsubname) && (StringUtil.equals((CharSequence)RuleConfigEnum.TOBEGIN.getRuleConfigCode(), (CharSequence)advancedconf) || StringUtil.equals((CharSequence)RuleConfigEnum.TOEND.getRuleConfigCode(), (CharSequence)advancedconf));
    }

    @Override
    public DynamicObjectCollection queryAccountingList(RuleTimeFilterDto ruleTimeFilterDto) {
        String advancedconf = ruleTimeFilterDto.getAdvancedconf();
        if (StringUtil.equals((CharSequence)RuleConfigEnum.TOBEGIN.getRuleConfigCode(), (CharSequence)advancedconf)) {
            return this.getBeginAccountingByDate(ruleTimeFilterDto);
        }
        if (StringUtil.equals((CharSequence)RuleConfigEnum.TOEND.getRuleConfigCode(), (CharSequence)advancedconf)) {
            return this.getEndAccountingByDate(ruleTimeFilterDto);
        }
        return new DynamicObjectCollection();
    }

    private DynamicObjectCollection getBeginAccountingByDate(RuleTimeFilterDto ruleTimeFilterDto) {
        List filterList = ruleTimeFilterDto.getFilterList();
        Date queryDate = DateUtils.getLastDateOfMonth((Date)ruleTimeFilterDto.getStartdate());
        String entryName = ruleTimeFilterDto.getEntryName();
        String selectFieldwithid = ruleTimeFilterDto.getSelectFieldwithid();
        String amountField = ruleTimeFilterDto.getAmountField();
        CopyOnWriteArrayList resultFilter = new CopyOnWriteArrayList(filterList);
        for (Object filter : resultFilter) {
            if ("period.begindate".equals(filter.getProperty()) && "<=".equals(filter.getCP())) {
                filter.__setProperty("endperiod");
                filter.__setCP("in");
                filter.__setValue(this.getBdPeriod(new QFilter("begindate", ">", (Object)queryDate)));
                filter.or("endperiod.begindate", "is null", null);
            }
            if (!"period.begindate".equals(filter.getProperty()) || !">=".equals(filter.getCP())) continue;
            filter.__setProperty("period");
            filter.__setCP("in");
            filter.__setValue(this.getBdPeriod(new QFilter("enddate", "=", (Object)queryDate)));
        }
        DynamicObjectCollection currentAccountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]));
        for (QFilter filter : resultFilter) {
            if (!"period".equals(filter.getProperty()) || !"in".equals(filter.getCP())) continue;
            filter.__setProperty("period");
            filter.__setCP("in");
            filter.__setValue(this.getBdPeriod(new QFilter("enddate", "<", (Object)queryDate)));
        }
        selectFieldwithid = selectFieldwithid.replace(amountField, beginToEndMap.get(amountField));
        DynamicObjectCollection preAccountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]));
        currentAccountingList.addAll((Collection)preAccountingList);
        return currentAccountingList;
    }

    private DynamicObjectCollection getEndAccountingByDate(RuleTimeFilterDto ruleTimeFilterDto) {
        List filterList = ruleTimeFilterDto.getFilterList();
        Date queryDate = DateUtils.getLastDateOfMonth((Date)ruleTimeFilterDto.getEnddate());
        String entryName = ruleTimeFilterDto.getEntryName();
        String selectFieldwithid = ruleTimeFilterDto.getSelectFieldwithid();
        CopyOnWriteArrayList resultFilter = new CopyOnWriteArrayList(filterList);
        for (QFilter filter : resultFilter) {
            if ("period.begindate".equals(filter.getProperty()) && ">=".equals(filter.getCP())) {
                filter.__setProperty("endperiod");
                filter.__setCP("in");
                filter.__setValue(this.getBdPeriod(new QFilter("begindate", ">", (Object)queryDate)));
                filter.or("endperiod.begindate", "is null", null);
            }
            if (!"period.begindate".equals(filter.getProperty()) || !"<=".equals(filter.getCP())) continue;
            filter.__setProperty("period");
            filter.__setCP("in");
            filter.__setValue(this.getBdPeriod(new QFilter("enddate", "<=", (Object)queryDate)));
        }
        DynamicObjectCollection accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])resultFilter.toArray(new QFilter[0]));
        if (accountingList.size() > 0) {
            return accountingList;
        }
        return new DynamicObjectCollection();
    }

    @Override
    public List<Long> getBdPeriod(QFilter qFilter) {
        QFilter q1 = new QFilter("periodnumber", "!=", (Object)13);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{q1, qFilter});
        if (CollectionUtils.isEmpty((Collection)query)) {
            return new ArrayList<Long>();
        }
        return query.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    static {
        beginToEndMap.put("beginlocal", "endlocal as beginlocal");
        beginToEndMap.put("beginqty", "endqty as beginqty");
        beginToEndMap.put("endlocal", "endlocal");
        beginToEndMap.put("endqty", "endqty");
    }
}

