/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.ruleEngine;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleEnginEntityTypeEnum;
import kd.taxc.bdtaxr.common.dto.RuleEngineDto;
import kd.taxc.bdtaxr.common.dto.RuleTimeFilterDto;
import kd.taxc.bdtaxr.common.enums.DataDirection;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.enums.RuleConfigEnum;
import kd.taxc.bdtaxr.common.enums.YearProfitRuleTypeEnum;
import kd.taxc.bdtaxr.common.helper.ExrateConvertHelper;
import kd.taxc.bdtaxr.common.helper.TaxcCustomSourceDataServiceHelper;
import kd.taxc.bdtaxr.common.service.RuleFilterConditionService;
import kd.taxc.bdtaxr.common.taxdeclare.draft.fi.GetGLBalanceCommonUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.RuleConfigUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.mservice.api.ruleEngine.GlBalanceService;
import kd.taxc.bdtaxr.mservice.api.ruleEngine.RuleEnginService;
import kd.taxc.bdtaxr.mservice.api.ruleEngine.RuleFilterService;
import kd.taxc.bdtaxr.mservice.api.ruleEngine.TdmBalanceFilterService;
import kd.taxc.bdtaxr.servicehelper.ServiceFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class RuleEnginServiceImpl
implements RuleEnginService {
    private static Log logger = LogFactory.getLog(RuleEnginServiceImpl.class);
    private static final String TDM_FINANCE_LRB = "tdm_finance_lrb";
    private RuleFilterService ruleFilterService = ServiceFactory.getService(RuleFilterService.class);
    private GlBalanceService glBalanceService = ServiceFactory.getService(GlBalanceService.class);
    private TdmBalanceFilterService tdmBalanceFilterService = ServiceFactory.getService(TdmBalanceFilterService.class);
    private BigDecimal reverse = new BigDecimal(-1);
    private static final String MAPPING_TYPE = "mappingtype";
    private static final String MAPPING_ID = "mappingid";
    private final List<String> finance_filters = Lists.newArrayList((Object[])new String[]{"tdm_finance_hblrbfilter", "tdm_finance_hbzcfzbfilter", "tdm_finance_lrbfilter", "tdm_finance_syzqybdfilter", "tdm_finance_xjllbfilter", "tdm_finance_zcfzbfilter"});
    private static final Map<String, List<String>> TCVAT_NSRXX_COMBINE_MAP = new HashMap(){
        {
            this.put("tcvat_nsrxx", Lists.newArrayList((Object[])new String[]{"tcvvt_finance_zcfzbxzzybq", "tcvvt_finance_zcfzbxqykj", "tcvvt_finance_lrbxqyyj", "tcvvt_finance_lrbnbxqy", "tcvvt_finance_lrbyzzxsr", "tcvvt_finance_zcfzbxzzybq"}));
        }
    };

    @Override
    public Object getRuleEnginData(RuleEngineDto ruleEngineDto) {
        long start = System.currentTimeMillis();
        Date startdate = ruleEngineDto.getStartdate();
        Date enddate = ruleEngineDto.getEnddate();
        String entityType = ruleEngineDto.getEntityType();
        Long taxorgid = ruleEngineDto.getTaxorgid();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        Map orgRelationMap = ruleEngineDto.getCxtMap().get("orgRelationMap") != null ? (Map)ruleEngineDto.getCxtMap().get("orgRelationMap") : TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(Collections.singletonList(taxorgid), (Date)startdate, (Date)enddate);
        Map fiBdAccounts = ruleEngineDto.getCxtMap().get("fiBdAccounts") != null ? (Map)ruleEngineDto.getCxtMap().get("fiBdAccounts") : GetGLBalanceCommonUtil.create((Long)taxorgid);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityType);
        Map<String, BigDecimal> exrateMap = ruleEngineDto.getRuleSetAccounting().stream().filter(a -> a.containsProperty("exratejson")).map(a -> a.getString("exratejson")).collect(Collectors.toMap(k -> k, v -> BigDecimal.ZERO, (m, n) -> m));
        for (Map.Entry<String, BigDecimal> entry : exrateMap.entrySet()) {
            BigDecimal exrate = ExrateConvertHelper.calcExrate((String)entry.getKey(), (Date)startdate, (Date)enddate);
            entry.setValue(exrate);
        }
        Map ruleFilterMap = ruleEngineDto.getRuleFilterMap();
        for (DynamicObject rulesetting : ruleEngineDto.getRuleSetAccounting()) {
            String selectFieldwithid;
            boolean needConditionjson;
            Map fieldMap;
            String org;
            boolean isLrbBnljSqqmsYearStart;
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            List orgList = Collections.singletonList(taxorgid);
            ArrayList<QFilter> filterListZjtx = new ArrayList<QFilter>();
            DynamicObject table = rulesetting.getDynamicObject("table");
            DynamicObject amountfield = rulesetting.getDynamicObject("amountfield");
            String entryName = table.getString("name");
            String conditionjson = rulesetting.getString("conditionjson");
            String advancedconf = rulesetting.getString("advancedconfjson");
            String amountField = amountfield.getString("fieldname");
            String fieldsubname = amountfield.getString("fieldsubname");
            String datadirection = rulesetting.getString("datadirection");
            String datatype = rulesetting.getString("datatype");
            BigDecimal taxRate = null;
            if (DataType.JSFLQS.getCode().equals(datatype) || DataType.CYSLDSQS.getCode().equals(datatype)) {
                taxRate = rulesetting.getBigDecimal("vatrate");
            } else if (DataType.GJQS.getCode().equals(datatype)) {
                taxRate = rulesetting.getBigDecimal("jsbl");
            }
            String itemNumber = this.getNumber(rulesetting);
            boolean bl = isLrbBnljSqqmsYearStart = (entityType.equals("tccit_yj_profits_accdet") || entityType.equals("tccit_yj_profits_acc_sjjt")) && TDM_FINANCE_LRB.equalsIgnoreCase(fieldsubname) && "bqje".equals(amountField) && StringUtil.equals((CharSequence)RuleConfigEnum.SQQMS.getRuleConfigCode(), (CharSequence)advancedconf) && DateUtils.getMonthOfDate((Date)startdate) == 1;
            if (isLrbBnljSqqmsYearStart) {
                DynamicObject object = this.createDynamicObject(dataEntityType, ruleEngineDto, rulesetting, table, amountfield, itemNumber);
                object.set("fetchamount", (Object)BigDecimal.ZERO);
                object.set("amount", (Object)BigDecimal.ZERO);
                list.add(object);
                filterList.clear();
                continue;
            }
            Map dataSourceMapping = EngineCalcFilterService.getMappingResult((Long)ruleEngineDto.getTaxCategoryId(), (Long)table.getLong("id"), orgList, (Date)startdate, (Date)enddate);
            String mappingFieldKey = (String)dataSourceMapping.get("fieldkey");
            QFilter mappingQfilter = EngineCalcFilterService.getMappingQfilter((Map)dataSourceMapping);
            if (mappingQfilter != null) {
                filterList.add(mappingQfilter);
                filterListZjtx.add(mappingQfilter);
            }
            if (null != (org = (String)(fieldMap = RuleConfigUtils.get((Long)table.getLong("id"))).get("orgstate"))) {
                String entityKey = entryName;
                String orgFieldName = org;
                if (org.contains(".")) {
                    String[] split = org.split("\\.");
                    entityKey = split[0];
                    orgFieldName = split[1];
                }
                orgList = EngineCalcFilterService.getOrgListByRelation((Map)orgRelationMap, orgList, (String)entryName, (String)entityKey, (String)orgFieldName);
                filterList.add(new QFilter(org, "in", (Object)orgList));
                filterListZjtx.add(new QFilter(org, "in", (Object)orgList));
            }
            RuleTimeFilterDto ruleTimeFilterDto = new RuleTimeFilterDto(advancedconf, startdate, enddate, filterList, fieldsubname, fieldMap, entryName);
            this.ruleFilterService.setRuleConfigTimeFilter(ruleTimeFilterDto);
            boolean bl2 = needConditionjson = Arrays.asList("tccit_fdctdyw_accdetail", "tccit_fdc_acc_sjjt").contains(entityType) && "tcvat_nsrxx".equals(entryName) && "tcret_ccxws_zb_hb".equals(fieldsubname);
            if (this.isNewCombineFinance(table)) {
                needConditionjson = true;
            }
            if (StringUtils.isNotBlank((String)conditionjson) && !needConditionjson) {
                if ((entryName.equals("gl_voucher") || entryName.equals("gl_balance")) && conditionjson.contains("assgrp")) {
                    conditionjson = RuleFilterConditionService.queryAssgrp((String)conditionjson);
                }
                try {
                    QFilter qFilters = FilterBuilderUtils.buildFilter((String)conditionjson, (String)("tdm_finance_main".equalsIgnoreCase(entryName) ? TDM_FINANCE_LRB : entryName));
                    qFilters = GetGLBalanceCommonUtil.parseQFilter((Long)taxorgid, (String)entryName, (QFilter)qFilters, (Map)fiBdAccounts);
                    if (qFilters != null) {
                        filterList.add(qFilters);
                        filterListZjtx.add(qFilters);
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
            String selectField = amountField;
            if (!StringUtil.equals((CharSequence)entryName, (CharSequence)fieldsubname)) {
                if (needConditionjson) {
                    selectField = amountField;
                    selectFieldwithid = "id," + amountField;
                } else {
                    selectField = fieldsubname + "." + amountField;
                    selectFieldwithid = fieldsubname + ".id as id," + fieldsubname + "." + amountField;
                }
            } else {
                selectFieldwithid = "id," + amountField;
            }
            if (ruleEngineDto.getEnableGroupByMappingField().booleanValue() && EmptyCheckUtils.isNotEmpty((Object)mappingFieldKey)) {
                QFilter idQ = new QFilter("id", "=", table.getPkValue());
                QFilter accessmapQ = new QFilter("entryentity.accessmap", "!=", (Object)0L);
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tctb_custom_datasource", (String)"entryentity.fieldsubname,entryentity.fieldname,entryentity.accessmap", (QFilter[])new QFilter[]{idQ, accessmapQ});
                selectFieldwithid = !StringUtil.equals((CharSequence)entryName, (CharSequence)dynamicObject.getString("entryentity.fieldsubname")) ? selectFieldwithid + "," + dynamicObject.getString("entryentity.fieldsubname") + "." + mappingFieldKey + " as " + mappingFieldKey : selectFieldwithid + "," + mappingFieldKey;
            }
            boolean isBeginOrEnd = this.glBalanceService.financeBeginEnd(fieldsubname, advancedconf);
            ruleTimeFilterDto.setSelectFieldwithid(selectFieldwithid);
            ruleTimeFilterDto.setAmountField(amountField);
            Map filterMap = (Map)ruleFilterMap.get(entryName);
            DynamicObjectCollection accountingList = this.queryAccountList(isBeginOrEnd, filterMap, fieldMap, filterList, startdate, enddate, ruleTimeFilterDto.getStartdate(), ruleTimeFilterDto.getEnddate(), fieldsubname, entryName, selectFieldwithid, amountField, orgList, conditionjson, table, itemNumber, advancedconf, filterListZjtx);
            if (!isBeginOrEnd) {
                isBeginOrEnd = this.glBalanceService.tdmBalanceNew(fieldsubname, advancedconf);
            }
            String field = "tdm_finance_main".equals(entryName) || "tpo_declare_main_tsd".equals(entryName) ? amountField : selectField;
            Boolean absolute = rulesetting.getBoolean("absolute");
            BigDecimal exrate = BigDecimal.ZERO;
            if (rulesetting.containsProperty("exratejson")) {
                exrate = exrateMap.getOrDefault(rulesetting.getString("exratejson"), BigDecimal.ZERO);
            }
            if (ruleEngineDto.getEnableGroupByMappingField().booleanValue() && EmptyCheckUtils.isNotEmpty((Object)mappingFieldKey)) {
                Map<Long, List<DynamicObject>> accountingMap = accountingList.stream().collect(Collectors.groupingBy(d -> d.getLong(mappingFieldKey)));
                Map mappingIdMap = (Map)dataSourceMapping.get("mappingList");
                List mappingIds = (List)mappingIdMap.get(ruleEngineDto.getTaxorgid());
                if (EmptyCheckUtils.isNotEmpty((Object)mappingIds)) {
                    for (Long mappingId : mappingIds) {
                        List<DynamicObject> value = accountingMap.get(mappingId);
                        DynamicObject object = this.createDynamicObject(dataEntityType, ruleEngineDto, rulesetting, table, amountfield, itemNumber);
                        if (EmptyCheckUtils.isNotEmpty(dataSourceMapping.get("business"))) {
                            object.set(MAPPING_TYPE, dataSourceMapping.get("business"));
                            object.set(MAPPING_ID, (Object)mappingId);
                        }
                        this.calcAmount(list, datadirection, datatype, taxRate, object, isBeginOrEnd, selectField, value, field, absolute, exrate, entryName);
                    }
                    continue;
                }
                DynamicObject object = this.createDynamicObject(dataEntityType, ruleEngineDto, rulesetting, table, amountfield, itemNumber);
                this.calcAmount(list, datadirection, datatype, taxRate, object, isBeginOrEnd, selectField, (List<DynamicObject>)accountingList, field, absolute, exrate, entryName);
                continue;
            }
            DynamicObject object = this.createDynamicObject(dataEntityType, ruleEngineDto, rulesetting, table, amountfield, itemNumber);
            this.calcAmount(list, datadirection, datatype, taxRate, object, isBeginOrEnd, selectField, (List<DynamicObject>)accountingList, field, absolute, exrate, entryName);
        }
        logger.info("\u7ed3\u675f\u6267\u884cgetRuleEnginData,entityType={}\uff0c\u8017\u65f6\uff1a{}", (Object)ruleEngineDto.getEntityType(), (Object)(System.currentTimeMillis() - start));
        return list;
    }

    private void calcAmount(List<DynamicObject> list, String datadirection, String datatype, BigDecimal taxRate, DynamicObject object, boolean isBeginOrEnd, String selectField, List<DynamicObject> accountingList, String field, Boolean absolute, BigDecimal exrate, String entryName) {
        BigDecimal detailTotalAmount = BigDecimal.ZERO;
        if (EmptyCheckUtils.isNotEmpty(accountingList)) {
            if (this.finance_filters.contains(entryName)) {
                String[] split = selectField.split("\\.");
                detailTotalAmount = accountingList.stream().map(s -> ((DynamicObject)s.getDynamicObjectCollection(split[0]).get(0)).getBigDecimal(split[1])).map(s -> absolute != false ? s.abs() : s).reduce(BigDecimal.ZERO, BigDecimal::add);
            } else {
                for (DynamicObject dynamicObject : accountingList) {
                    if (isBeginOrEnd) {
                        detailTotalAmount = detailTotalAmount.add(dynamicObject.getBigDecimal(selectField));
                        continue;
                    }
                    Object value = dynamicObject.get(field);
                    if (value == null) continue;
                    if (value instanceof String && (value.equals("null") || EmptyCheckUtils.isEmpty((Object)value))) {
                        detailTotalAmount = detailTotalAmount.add(BigDecimal.ZERO);
                    }
                    detailTotalAmount = detailTotalAmount.add(absolute != false ? this.toBigDecimal(value.toString()).abs() : this.toBigDecimal(value.toString()));
                }
            }
        }
        detailTotalAmount = isBeginOrEnd ? (absolute.booleanValue() ? detailTotalAmount.setScale(10, 4).abs() : detailTotalAmount.setScale(10, 4)) : detailTotalAmount.setScale(10, 4);
        object.set("fetchamount", (Object)detailTotalAmount);
        BigDecimal amount = this.getAmountNew(detailTotalAmount, datadirection, datatype, taxRate);
        if (object.containsProperty("exrate")) {
            object.set("exrate", (Object)exrate);
            if (BigDecimal.ZERO.compareTo(exrate) < 0) {
                amount = amount.multiply(exrate).setScale(10, 4);
            }
        }
        object.set("amount", (Object)amount);
        list.add(object);
    }

    private DynamicObject createDynamicObject(MainEntityType dataEntityType, RuleEngineDto ruleEngineDto, DynamicObject rulesetting, DynamicObject table, DynamicObject amountfield, String itemNumber) {
        DynamicObject object = new DynamicObject((DynamicObjectType)dataEntityType);
        object.set("taxaccountserialno", (Object)ruleEngineDto.getTaxaccountserialno());
        object.set("org", (Object)ruleEngineDto.getOrgId());
        object.set("taxorg", (Object)ruleEngineDto.getTaxorgid());
        object.set("skssqq", (Object)ruleEngineDto.getStartdate());
        object.set("skssqz", (Object)ruleEngineDto.getEnddate());
        object.set("bizname", rulesetting.get("bizname"));
        object.set("table", (Object)table.getLong("id"));
        object.set("amountfield", (Object)amountfield.getLong("id"));
        object.set("datadirection", rulesetting.get("datadirection"));
        object.set("absolute", (Object)rulesetting.getString("absolute"));
        object.set("filtercondition", (Object)this.getFiltercondition(object, rulesetting));
        object.set("ruleid", rulesetting.getParent());
        if (ruleEngineDto.getEnableGroupByMappingField().booleanValue()) {
            object.set(MAPPING_TYPE, (Object)"bos_org");
            object.set(MAPPING_ID, (Object)ruleEngineDto.getTaxorgid());
        }
        String ruleEnginEntityType = ruleEngineDto.getRuleEnginEntityType();
        if (RuleEnginEntityTypeEnum.YEAR_ACC_ENGINE.getEntityType().equals(ruleEnginEntityType)) {
            YearProfitRuleTypeEnum profitRuleTypeEnum = YearProfitRuleTypeEnum.get((String)ruleEngineDto.getEntityType());
            object.set("entrytype", (Object)(profitRuleTypeEnum != null ? profitRuleTypeEnum.getEntryType() : rulesetting.getString("projecttype")));
            object.set("itemnumber", (Object)itemNumber);
            object.set("conditionjson", (Object)rulesetting.getString("conditionjson"));
            object.set("advancedconfjson", (Object)rulesetting.getString("advancedconfjson"));
        } else if (RuleEnginEntityTypeEnum.TCCIT_YJ_PROFITS_ACCDET.getEntityType().equals(ruleEnginEntityType)) {
            String yjprofitslogic = (String)SystemParamUtil.getAppParameter((String)"tccit", (String)"yjprofitslogic", (long)ruleEngineDto.getOrgId());
            object.set("entrytype", (Object)("bqfse".equals(yjprofitslogic) ? "profits" : "profits-bqlje"));
            object.set("itemnumber", (Object)itemNumber);
            object.set("conditionjson", (Object)rulesetting.getString("conditionjson"));
            object.set("advancedconfjson", (Object)rulesetting.getString("advancedconfjson"));
        } else if (RuleEnginEntityTypeEnum.TCCIT_YJ_ASSETS_ACCDET.getEntityType().equals(ruleEnginEntityType)) {
            object.set("entrytype", (Object)"yjassets");
            object.set("itemnumber", (Object)itemNumber);
            object.set("conditionjson", (Object)rulesetting.getString("conditionjson"));
            object.set("advancedconfjson", (Object)rulesetting.getString("advancedconfjson"));
        } else if (RuleEnginEntityTypeEnum.TCCIT_YJ_OTHER_ACCDET.getEntityType().equals(ruleEnginEntityType)) {
            object.set("entrytype", (Object)"yjother");
            object.set("itemnumber", (Object)itemNumber);
            object.set("conditionjson", (Object)rulesetting.getString("conditionjson"));
            object.set("advancedconfjson", (Object)rulesetting.getString("advancedconfjson"));
        } else if (RuleEnginEntityTypeEnum.TCCIT_TECHTRANS_ACCDETAIL.getEntityType().equals(ruleEnginEntityType)) {
            object.set("entrytype", (Object)"incredpresent");
            object.set("itemnumber", ((DynamicObject)rulesetting.getParent()).get("id"));
            object.set("conditionjson", (Object)rulesetting.getString("conditionjson"));
            object.set("advancedconfjson", (Object)rulesetting.getString("advancedconfjson"));
        } else if (RuleEnginEntityTypeEnum.TCCIT_INCRED_ACCDETAIL.getEntityType().equals(ruleEnginEntityType)) {
            object.set("entrytype", (Object)"incredincome");
            object.set("itemnumber", ((DynamicObject)rulesetting.getParent()).get("id"));
            object.set("conditionjson", (Object)rulesetting.getString("conditionjson"));
            object.set("advancedconfjson", (Object)rulesetting.getString("advancedconfjson"));
        } else if (RuleEnginEntityTypeEnum.TCCIT_TREDUCED_ACCDETAIL.getEntityType().equals(ruleEnginEntityType)) {
            object.set("entrytype", (Object)"treducedincome");
            object.set("itemnumber", ((DynamicObject)rulesetting.getParent()).get("id"));
            object.set("conditionjson", (Object)rulesetting.getString("conditionjson"));
            object.set("advancedconfjson", (Object)rulesetting.getString("advancedconfjson"));
        } else if (RuleEnginEntityTypeEnum.TCCIT_ADD_DEDUCTION_DETAIL.getEntityType().equals(ruleEnginEntityType)) {
            object.set("entrytype", (Object)"adddeduction");
            object.set("itemnumber", ((DynamicObject)rulesetting.getParent()).get("id"));
            object.set("conditionjson", (Object)rulesetting.getString("conditionjson"));
            object.set("advancedconfjson", (Object)rulesetting.getString("advancedconfjson"));
        } else if (RuleEnginEntityTypeEnum.TCCIT_NONTAX_ACCDETAIL.getEntityType().equals(ruleEnginEntityType)) {
            object.set("entrytype", (Object)"nontaxincome");
            object.set("itemnumber", ((DynamicObject)rulesetting.getParent()).get("id"));
            object.set("conditionjson", (Object)rulesetting.getString("conditionjson"));
            object.set("advancedconfjson", (Object)rulesetting.getString("advancedconfjson"));
        } else {
            object.set("datatype", (Object)rulesetting.getString("datatype"));
        }
        return object;
    }

    private String getFiltercondition(DynamicObject object, DynamicObject rulesetting) {
        DynamicProperty property = object.getDynamicObjectType().getProperty("filtercondition");
        int maxLenth = ((TextAreaProp)property).getMaxLenth();
        if (maxLenth == 0) {
            return "";
        }
        String filtercondition = rulesetting.getString("filtercondition").replaceAll(" ", "");
        boolean lessMaxLenth = filtercondition.length() < maxLenth;
        return lessMaxLenth ? filtercondition : filtercondition.substring(0, maxLenth - 10) + "...";
    }

    private String getNumber(DynamicObject rulesetting) {
        String itemNumber = "";
        try {
            DynamicObject parent = (DynamicObject)rulesetting.getParent();
            DataEntityPropertyCollection properties = parent.getDynamicObjectType().getProperties();
            if (properties.containsKey((Object)"standingbooks")) {
                itemNumber = parent.getDynamicObject("standingbooks").getString("number");
            } else if (properties.containsKey((Object)"item")) {
                itemNumber = parent.getDynamicObject("item").getString("number");
            } else if (properties.containsKey((Object)"itemchoicename")) {
                itemNumber = parent.getDynamicObject("itemchoicename").getString("number");
            }
        }
        catch (Exception e) {
            return itemNumber;
        }
        return itemNumber;
    }

    @Override
    public BigDecimal getAmount(BigDecimal detailTotalamount, String datadirection, String datatype, BigDecimal taxrate) {
        return this.getLvtYzAmount(detailTotalamount, datadirection, datatype, taxrate, null);
    }

    public BigDecimal getAmountNew(BigDecimal detailTotalamount, String datadirection, String datatype, BigDecimal taxrate) {
        BigDecimal amount = DataDirection.POSITIVE.getCode().equals(datadirection) ? detailTotalamount : detailTotalamount.multiply(this.reverse);
        if (taxrate != null) {
            if (DataType.JSFLQS.getCode().equals(datatype)) {
                amount = amount.divide(BigDecimal.ONE.add(taxrate), 10, RoundingMode.HALF_UP);
            } else if (DataType.CYSLDSQS.getCode().equals(datatype)) {
                if (taxrate.compareTo(BigDecimal.ZERO) != 0) {
                    amount = amount.divide(taxrate, 10, RoundingMode.HALF_UP);
                }
            } else if (DataType.SEHSHSJ.getCode().equals(datatype)) {
                if (!taxrate.equals(BigDecimal.ZERO)) {
                    amount = amount.divide(taxrate, 10, RoundingMode.HALF_UP).multiply(BigDecimal.ONE.add(taxrate));
                }
            } else if (DataType.GJQS.getCode().equals(datatype)) {
                amount = amount.multiply(taxrate);
            }
        }
        return amount;
    }

    @Override
    public BigDecimal getLvtYzAmount(BigDecimal detailTotalamount, String datadirection, String datatype, BigDecimal taxrate, BigDecimal yzTaxRate) {
        BigDecimal amount = DataDirection.POSITIVE.getCode().equals(datadirection) ? detailTotalamount : detailTotalamount.multiply(this.reverse);
        if (taxrate != null) {
            if (DataType.JSFLQS.getCode().equals(datatype)) {
                amount = amount.divide(BigDecimal.ONE.add(taxrate), 10, RoundingMode.HALF_UP);
            } else if (DataType.CYSLDSQS.getCode().equals(datatype)) {
                if (taxrate.compareTo(BigDecimal.ZERO) != 0) {
                    amount = amount.divide(taxrate, 10, RoundingMode.HALF_UP);
                }
            } else if (DataType.SEHSHSJ.getCode().equals(datatype)) {
                if (!taxrate.equals(BigDecimal.ZERO)) {
                    amount = amount.divide(taxrate, 10, RoundingMode.HALF_UP).multiply(BigDecimal.ONE.add(taxrate));
                }
            } else if (yzTaxRate != null && "yjjsflqs".equals(datatype)) {
                amount = amount.subtract(amount.divide(BigDecimal.ONE.add(taxrate), 10, RoundingMode.HALF_UP).multiply(yzTaxRate));
            }
        }
        return amount;
    }

    private List<String> getSbbIds(List<Long> orgIds, Date startDate, Date endDate, DynamicObject table, String entryName) {
        List<String> sbbIds = new ArrayList<String>();
        QFilter tableid = new QFilter("id", "=", (Object)table.getLong("id"));
        QFilter[] filters = new QFilter[]{tableid};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"name,subname,ischild,entryentity.id,entryentity.fieldname,entryentity.orgstate,entryentity.datastate,entryentity.yearstate,entryentity.monthstate", (QFilter[])filters);
        DynamicObject orgstate = collection.stream().filter(s -> "true".equals(s.getString("entryentity.orgstate"))).findFirst().orElseGet(() -> new DynamicObject());
        DynamicObject datastate = collection.stream().filter(s -> "true".equals(s.getString("entryentity.datastate"))).findFirst().orElseGet(() -> new DynamicObject());
        QFilter orgFilter = new QFilter(orgstate.getString("entryentity.fieldname"), "in", orgIds);
        QFilter skssqqFilter = new QFilter(datastate.getString("entryentity.fieldname"), ">=", (Object)DateUtils.getDayFirst((Date)startDate));
        QFilter skssqzFilter = new QFilter(datastate.getString("entryentity.fieldname"), "<=", (Object)DateUtils.getDayLast((Date)endDate));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entryName, (String)"id", (QFilter[])new QFilter[]{orgFilter, skssqqFilter, skssqzFilter});
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            sbbIds = dynamicObjects.stream().map(s -> s.getString("id")).collect(Collectors.toList());
        }
        return sbbIds;
    }

    private void addRightsIncomeFilter(List<QFilter> filterList, String itemNumber, Map<String, List<QFilter>> filterMap) {
        if (StringUtils.isNotBlank((String)itemNumber) && filterMap.get(itemNumber) != null) {
            filterList.addAll((Collection<QFilter>)filterMap.get(itemNumber));
        }
    }

    private boolean isNewCombineFinance(DynamicObject table) {
        String name = table.getString("name");
        String subname = table.getString("subname");
        return TCVAT_NSRXX_COMBINE_MAP.get(name) != null && TCVAT_NSRXX_COMBINE_MAP.get(name).contains(subname);
    }

    private DynamicObjectCollection queryAccountList(Boolean isBeginOrEnd, Map<String, List<QFilter>> filterMap, Map<String, String> fieldMap, List<QFilter> filterList, Date startdate, Date enddate, Date newStartdate, Date newEnddate, String fieldsubname, String entryName, String selectFieldwithid, String amountField, List<Long> orgIds, String conditionjson, DynamicObject table, String itemNumber, String advancedconf, List<QFilter> filterListZjtx) {
        long start = System.currentTimeMillis();
        DynamicObjectCollection accountingList = new DynamicObjectCollection();
        if (isBeginOrEnd.booleanValue()) {
            RuleTimeFilterDto ruleTimeFilterDto = new RuleTimeFilterDto(advancedconf, startdate, enddate, filterList, fieldsubname, fieldMap, entryName, selectFieldwithid, amountField);
            accountingList = this.glBalanceService.queryAccountingList(ruleTimeFilterDto);
        } else if ("tccit_tax_acce_diff".equals(entryName)) {
            filterListZjtx.add(new QFilter("accountingperiod", ">=", (Object)DateUtils.getDayFirst((Date)newStartdate)));
            filterListZjtx.add(new QFilter("accountingperiod", "<=", (Object)DateUtils.getDayLast((Date)newEnddate)));
            DynamicObjectCollection queryTemp = QueryServiceHelper.query((String)entryName, (String)(amountField + ",id,assetsnumber,accountingperiod"), (QFilter[])filterListZjtx.toArray(new QFilter[0]));
            Map<String, List<DynamicObject>> collect = queryTemp.stream().collect(Collectors.groupingBy(a -> a.getString("assetsnumber")));
            for (Map.Entry<String, List<DynamicObject>> stringListEntry : collect.entrySet()) {
                DynamicObject dynamicObject = (DynamicObject)stringListEntry.getValue().stream().reduce((a, b) -> a.getDate("accountingperiod").before(b.getDate("accountingperiod")) ? b : a).get();
                accountingList.add((Object)dynamicObject);
            }
        } else if ("tdm_finance_main".equals(entryName) || this.isNewCombineFinance(table)) {
            QFilter q;
            List<String> sbbids = this.getSbbIds(orgIds, newStartdate, newEnddate, table, entryName);
            QFilter filter = new QFilter("sbbid", "in", sbbids);
            if (StringUtils.isNotBlank((String)conditionjson) && StringUtils.isNotBlank((String)fieldsubname) && (q = FilterBuilderUtils.buildFilter((String)conditionjson, (String)fieldsubname)) != null) {
                filter = filter.and(q);
            }
            accountingList = QueryServiceHelper.query((String)fieldsubname, (String)selectFieldwithid, (QFilter[])new QFilter[]{filter});
        } else if ("tdm_balance_new".equals(entryName)) {
            List<QFilter> qFilters = this.tdmBalanceFilterService.buildBalanceNewFilter(newStartdate, newEnddate, filterList, selectFieldwithid, null);
            accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])qFilters.toArray(new QFilter[0]));
        } else if ("tcvat_nsrxx".equals(entryName) && "tcret_ccxws_zb_hb".equals(fieldsubname)) {
            DynamicObjectCollection mainIds = QueryServiceHelper.query((String)entryName, (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
            List ids = mainIds.stream().map(e -> e.getString("id")).collect(Collectors.toList());
            if (ids.size() > 0) {
                QFilter filter = new QFilter("sbbid", "in", ids);
                if (StringUtils.isNotBlank((String)conditionjson)) {
                    QFilter qFilters = FilterBuilderUtils.buildFilter((String)conditionjson, (String)"tcret_ccxws_zb_hb");
                    filter.and(qFilters);
                }
                accountingList = QueryServiceHelper.query((String)fieldsubname, (String)selectFieldwithid, (QFilter[])new QFilter[]{filter});
            }
        } else if (filterMap != null) {
            this.addRightsIncomeFilter(filterList, itemNumber, filterMap);
            accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])filterList.toArray(new QFilter[0]));
        } else if ("gl_balance".equals(entryName) && !isBeginOrEnd.booleanValue()) {
            for (QFilter qFilter : filterList) {
                if ("period.begindate".equals(qFilter.getProperty()) && ">=".equals(qFilter.getCP())) {
                    qFilter.__setProperty("period");
                    qFilter.__setCP("in");
                    qFilter.__setValue(this.glBalanceService.getBdPeriod(new QFilter("begindate", ">=", qFilter.getValue())));
                }
                if (!"period.begindate".equals(qFilter.getProperty()) || !"<=".equals(qFilter.getCP())) continue;
                qFilter.__setProperty("period");
                qFilter.__setCP("in");
                qFilter.__setValue(this.glBalanceService.getBdPeriod(new QFilter("enddate", "<=", qFilter.getValue())));
            }
            accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])filterList.toArray(new QFilter[0]));
        } else {
            if ("tpo_declare_main_tsd".equals(entryName)) {
                String selectKeyEntity = entryName;
                Long tableId = table.getLong("id");
                QFilter filter = StringUtil.isNotBlank((CharSequence)conditionjson) ? FilterBuilderUtils.buildFilter((String)conditionjson, (String)entryName) : null;
                String selectKey = this.getCellNumber(tableId, filter);
                String whereFilter = conditionjson;
                String accesslogic = null;
                Long categoryId = null;
                BigDecimal reduce = orgIds.stream().map(orgId -> TaxcCustomSourceDataServiceHelper.queryBizDataRetSum((Long)orgId, (Date)startdate, (Date)enddate, (Long)tableId, (String)selectKey, (String)selectKeyEntity, (String)whereFilter, (String)accesslogic, (Long)categoryId)).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                accountingList = new DynamicObjectCollection();
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"tpo_declare_detail_tsd");
                object.set("value", (Object)reduce);
                accountingList.add((Object)object);
                return accountingList;
            }
            if (this.finance_filters.contains(entryName)) {
                String selectKeyEntity = entryName;
                Long tableId = table.getLong("id");
                String whereFilter = conditionjson;
                String accesslogic = advancedconf;
                String selectKey = amountField;
                BigDecimal amount = TaxcCustomSourceDataServiceHelper.queryBizDataRetSum(orgIds, (Date)startdate, (Date)enddate, (long)tableId, (String)selectKey, (String)selectKeyEntity, (String)whereFilter, (String)accesslogic);
                accountingList = new DynamicObjectCollection();
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)entryName);
                DynamicObjectCollection rows = object.getDynamicObjectCollection(fieldsubname);
                DynamicObject row = rows.addNew();
                row.set(selectKey, (Object)amount);
                accountingList.add((Object)object);
                return accountingList;
            }
            accountingList = QueryServiceHelper.query((String)entryName, (String)selectFieldwithid, (QFilter[])filterList.toArray(new QFilter[0]));
        }
        logger.info("\u7ed3\u675f\u6267\u884cqueryAccountList,entryName={}\uff0c\u8017\u65f6\uff1a{}", (Object)entryName, (Object)(System.currentTimeMillis() - start));
        return accountingList;
    }

    private String getCellNumber(Long tableId, QFilter customFilter) {
        QFilter[] recombine;
        if (customFilter == null) {
            return "value";
        }
        QFilter rowFiter = null;
        QFilter colFilter = null;
        for (QFilter filter : recombine = customFilter.recombine()) {
            String[] split;
            String property = filter.getProperty();
            if (!property.startsWith("entryentity.") || (split = property.split("\\.")).length != 3) continue;
            String prop = split[1];
            if ("row".equals(prop)) {
                rowFiter = filter.getValue() instanceof Collection ? new QFilter(split[2], "in", filter.getValue()) : new QFilter(split[2], "=", filter.getValue());
                continue;
            }
            if (!"column".equals(prop)) continue;
            colFilter = filter.getValue() instanceof Collection ? new QFilter(split[2], "in", filter.getValue()) : new QFilter(split[2], "=", filter.getValue());
        }
        if (rowFiter == null || colFilter == null) {
            return "";
        }
        String rowNumber = null;
        String colNumber = null;
        String parentNumber = this.getParentNumber(tableId);
        if (StringUtil.isNotBlank((CharSequence)parentNumber)) {
            colFilter.and(new QFilter("parent.number", "=", (Object)parentNumber));
        }
        DynamicObject rowObj = QueryServiceHelper.queryOne((String)"tpo_row_member", (String)"number", (QFilter[])new QFilter[]{rowFiter});
        DynamicObject colObj = QueryServiceHelper.queryOne((String)"tpo_col_member", (String)"number", (QFilter[])new QFilter[]{colFilter});
        if (rowObj != null) {
            rowNumber = rowObj.getString("number");
        }
        if (colObj != null) {
            colNumber = colObj.getString("number");
        }
        String cellNumber = String.format("%s#%s", rowNumber, colNumber);
        return cellNumber;
    }

    public String getParentNumber(Long tableId) {
        DynamicObject object = QueryServiceHelper.queryOne((String)"tctb_custom_datasource", (String)"entityname,bblx.number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tableId)});
        String parentNumber = "";
        if ("tpo_declare_main_tsd".equals(object.getString("entityname"))) {
            String bblx = object.getString("bblx.number");
            if ("rdesd_yhmx".equals(bblx)) {
                parentNumber = "yhmxb";
            }
            if ("rdesd_gxqyyhmx".equals(bblx)) {
                parentNumber = "gxqyyhmxb";
            }
        }
        return parentNumber;
    }

    private BigDecimal toBigDecimal(String str) {
        try {
            return new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }
}

