/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.upgradeservice;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class DeferPayApplyUpgradeService
implements IUpgradeService {
    private static final Map<Integer, String> monthMap = new HashMap<Integer, String>(){
        {
            this.put(1, "january");
            this.put(2, "february");
            this.put(3, "march");
            this.put(4, "april");
            this.put(5, "may");
            this.put(6, "june");
            this.put(7, "july");
            this.put(8, "august");
            this.put(9, "september");
            this.put(10, "october");
            this.put(11, "november");
            this.put(12, "december");
        }
    };

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = ResManager.loadKDString((String)"\u7f13\u7f34\u7533\u8bf7\u6570\u636e\u5347\u7ea7\u6210\u529f", (String)"DeferPayApplyUpgradeService_0", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]);
        try {
            boolean exitsSbbTable = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_declare_main");
            boolean exitsSbbEntryTable = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tctb_declare_entry");
            if (exitsSbbTable && exitsSbbEntryTable) {
                this.update();
            } else {
                info = log = ResManager.loadKDString((String)"\u65e0\u9700\u5347\u7ea7\u7f13\u7f34\u7533\u8bf7\u6570\u636e", (String)"DeferPayApplyUpgradeService_1", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]);
            }
        }
        catch (Exception var9) {
            success = true;
            info = log = this.getStackTraceMessage(var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        String insertSql1 = "INSERT INTO t_bdtaxr_pay_record(fid, fyjje, fjkbl, fpaystatus, fdeadline, fsjje, fsyqjje, fpayer, fpaydate, fsbbid, fhjsqid, fsbbentryid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String querySql1 = "select fid,fbqybtse,fpayer,fpaydate,fskssqz,forgid,fnsrtype,ftaxlimit from t_tctb_declare_main where fpaystatus='paid' and fid not in (select fsbbid from t_bdtaxr_pay_record)";
        List sbbList1 = DBUtils.query((String)querySql1);
        if (sbbList1 != null && sbbList1.size() > 0) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(sbbList1.size());
            for (Map sbb : sbbList1) {
                String fnsrtype = (String)sbb.get("FNSRTYPE");
                String taxType = this.getTaxType(fnsrtype, null);
                Object fid = sbb.get("FID");
                Object fbqybtse = sbb.get("FBQYBTSE");
                Object fpayer = sbb.get("FPAYER");
                Object fpaydate = sbb.get("FPAYDATE");
                Date fskssqz = (Date)sbb.get("FSKSSQZ");
                Object forgid = sbb.get("FORGID");
                String ftaxlimit = (String)sbb.get("FTAXLIMIT");
                Date taxCalenderDate = this.getTaxCalenderDate(forgid, fskssqz, taxType, ftaxlimit);
                if (ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"DeferPayApplyUpgradeService_2", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]).equals(taxType)) {
                    String queryEntry = "select fentryid,fbqdybtse from t_tctb_declare_entry where fid=" + fid;
                    List entry = DBUtils.query((String)queryEntry);
                    if (entry != null && entry.size() > 0) {
                        for (Map e : entry) {
                            Object fentryid = e.get("FENTRYID");
                            Object fbqdybtse = e.get("FBQDYBTSE");
                            paramList.add(new Object[]{DBUtils.getLongId((String)"t_bdtaxr_pay_record"), fbqdybtse, 1, "1", taxCalenderDate, fbqdybtse, 0, fpayer, fpaydate, fid, 0, fentryid});
                        }
                        continue;
                    }
                    paramList.add(new Object[]{DBUtils.getLongId((String)"t_bdtaxr_pay_record"), fbqybtse, 1, "1", taxCalenderDate, fbqybtse, 0, fpayer, fpaydate, fid, 0, 0});
                    continue;
                }
                paramList.add(new Object[]{DBUtils.getLongId((String)"t_bdtaxr_pay_record"), fbqybtse, 1, "1", taxCalenderDate, fbqybtse, 0, fpayer, fpaydate, fid, 0, 0});
            }
            DBUtils.executeBatch((String)insertSql1, paramList);
        }
        String insertSql2 = "INSERT INTO t_bdtaxr_pay_record(fid, fyjje, fjkbl, fpaystatus, fdeadline, fsjje, fsyqjje, fsbbid, fhjsqid, fsbbentryid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String querySql2 = "select fid,fbqybtse,fskssqz,forgid,fnsrtype,ftaxlimit from t_tctb_declare_main where fpaystatus='unpaid' and fdeclarestatus='declared' and fid not in (select fsbbid from t_bdtaxr_pay_record)";
        List sbbList2 = DBUtils.query((String)querySql2);
        if (sbbList2 != null && sbbList2.size() > 0) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(sbbList2.size());
            for (Map sbb : sbbList2) {
                String fnsrtype = (String)sbb.get("FNSRTYPE");
                String taxType = this.getTaxType(fnsrtype, null);
                Object fid = sbb.get("FID");
                Object fbqybtse = sbb.get("FBQYBTSE");
                Date fskssqz = (Date)sbb.get("FSKSSQZ");
                Long forgid = (Long)sbb.get("FORGID");
                String ftaxlimit = (String)sbb.get("FTAXLIMIT");
                Date taxCalenderDate = this.getTaxCalenderDate(forgid, fskssqz, taxType, ftaxlimit);
                if (ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"DeferPayApplyUpgradeService_2", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]).equals(taxType)) {
                    String queryEntry = "select fentryid,fbqdybtse from t_tctb_declare_entry where fid=" + fid;
                    List entry = DBUtils.query((String)queryEntry);
                    if (entry != null && entry.size() > 0) {
                        for (Map e : entry) {
                            Object fentryid = e.get("FENTRYID");
                            Object fbqdybtse = e.get("FBQDYBTSE");
                            paramList.add(new Object[]{DBUtils.getLongId((String)"t_bdtaxr_pay_record"), fbqdybtse, 1, "2", taxCalenderDate, 0, fbqdybtse, fid, 0, fentryid});
                        }
                        continue;
                    }
                    paramList.add(new Object[]{DBUtils.getLongId((String)"t_bdtaxr_pay_record"), fbqybtse, 1, "2", taxCalenderDate, 0, fbqybtse, fid, 0, 0});
                    continue;
                }
                paramList.add(new Object[]{DBUtils.getLongId((String)"t_bdtaxr_pay_record"), fbqybtse, 1, "2", taxCalenderDate, 0, fbqybtse, fid, 0, 0});
            }
            DBUtils.executeBatch((String)insertSql2, paramList);
        }
    }

    private Date getTaxCalenderDate(Object orgId, Date skssqz, String taxtype, String taxlimit) {
        long registerAddress;
        String registerAddressStr;
        List taxMain = DBUtils.query((String)("select fregisteraddress from t_tctb_tax_main where forgid=" + orgId));
        if (taxMain != null && taxMain.size() > 0 && (registerAddressStr = (String)((Map)taxMain.get(0)).get("FREGISTERADDRESS")) != null && StringUtils.isNotBlank((CharSequence)registerAddressStr) && (registerAddress = Long.parseLong(registerAddressStr)) != 0L) {
            long parent;
            List calEntry = DBUtils.query((String)"select fid from t_tpo_tax_calendar_entry where fcity=? or fprovinces=?", (Object[])new Object[]{registerAddress, registerAddress});
            if (calEntry != null && calEntry.size() > 0) {
                return this.getTaxCalenderDate(skssqz, registerAddress, taxtype, taxlimit);
            }
            List admindivision = DBUtils.query((String)"sys", (String)("select FPARENTID from t_bd_admindivision where fid=" + registerAddress));
            Date taxCalenderDate = null;
            if (admindivision != null && admindivision.size() > 0 && (parent = ((Long)((Map)admindivision.get(0)).get("FPARENTID")).longValue()) != 0L && (taxCalenderDate = this.getTaxCalenderDate(skssqz, parent, taxtype, taxlimit)) == null && (admindivision = DBUtils.query((String)"sys", (String)("select FPARENTID from t_bd_admindivision where fid=" + parent))) != null && admindivision.size() > 0 && (parent = ((Long)((Map)admindivision.get(0)).get("FPARENTID")).longValue()) != 0L) {
                taxCalenderDate = this.getTaxCalenderDate(skssqz, parent, taxtype, taxlimit);
            }
            return taxCalenderDate;
        }
        return null;
    }

    private Date getTaxCalenderDate(Date skssqz, Object addressId, String taxtype, String taxlimit) {
        String date;
        Date dqjkqx = null;
        skssqz = DateUtils.addMonth((Date)skssqz, (int)1);
        int year = DateUtils.getYearOfDate((Date)skssqz);
        int month = DateUtils.getMonthOfDate((Date)skssqz);
        QFilter yearFilter = new QFilter("year", "=", (Object)String.valueOf(year));
        QFilter cityFilter = new QFilter("entryentity.city", "=", addressId).or(new QFilter("entryentity.provinces", "=", addressId));
        QFilter taxtypeFilter = null;
        if (ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"DeferPayApplyUpgradeService_2", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]).equals(taxtype)) {
            taxtypeFilter = new QFilter("entryentity.taxtype", "=", (Object)"1");
        } else if (ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"DeferPayApplyUpgradeService_3", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]).equals(taxtype)) {
            taxtypeFilter = new QFilter("entryentity.taxtype", "=", (Object)"2");
        } else if (ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"DeferPayApplyUpgradeService_4", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]).equals(taxtype)) {
            taxtypeFilter = new QFilter("entryentity.taxtype", "=", (Object)"3");
        } else if (ResManager.loadKDString((String)"\u623f\u4ea7\u7a0e", (String)"DeferPayApplyUpgradeService_5", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]).equals(taxtype)) {
            taxtypeFilter = new QFilter("entryentity.taxtype", "=", (Object)"4");
        } else if (ResManager.loadKDString((String)"\u9644\u52a0\u7a0e\u8d39", (String)"DeferPayApplyUpgradeService_6", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]).equals(taxtype)) {
            taxtypeFilter = new QFilter("entryentity.taxtype", "=", (Object)"5");
        }
        QFilter methodsFilter = null;
        if ("month".equals(taxlimit)) {
            methodsFilter = new QFilter("entryentity.methods", "=", (Object)"2");
        } else if ("season".equals(taxlimit)) {
            methodsFilter = new QFilter("entryentity.methods", "=", (Object)"1");
        } else if ("year".equals(taxlimit)) {
            methodsFilter = new QFilter("entryentity.methods", "=", (Object)"3");
        }
        DynamicObject taxCal = QueryServiceHelper.queryOne((String)"tpo_tax_calendar", (String)("entryentity." + monthMap.get(month) + " as date"), (QFilter[])new QFilter[]{yearFilter, cityFilter, taxtypeFilter, methodsFilter});
        if (taxCal != null && !"\u2014\u2014".equals(date = taxCal.getString("date")) && StringUtils.isNotBlank((CharSequence)date)) {
            String s = date.replaceAll("\\D", "-");
            String[] split = s.split("-");
            Calendar instance = Calendar.getInstance();
            instance.setTime(skssqz);
            instance.set(2, Integer.parseInt(split[0]) - 1);
            instance.set(5, Integer.parseInt(split[1]));
            dqjkqx = instance.getTime();
        }
        return dqjkqx;
    }

    private String getTaxType(String type, String taxtype) {
        String taxType = null;
        if (type != null) {
            if ("zzsybnsr".equals(type)) {
                if (taxtype == null || "1".equals(taxtype)) {
                    taxType = ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"DeferPayApplyUpgradeService_2", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]);
                } else if ("2".equals(taxtype)) {
                    taxType = ResManager.loadKDString((String)"\u9644\u52a0\u7a0e\u8d39", (String)"DeferPayApplyUpgradeService_6", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]);
                }
            } else {
                taxType = type.startsWith("zzs") ? ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"DeferPayApplyUpgradeService_2", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]) : (type.startsWith("qysds") ? ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"DeferPayApplyUpgradeService_3", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]) : TemplateTypeConstant.getNsrtypemap().getOrDefault(type, ""));
            }
        }
        return taxType;
    }

    private String getStackTraceMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element).append('\n');
        }
        return sb.toString();
    }
}

