/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.upgradeservice;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import org.apache.commons.lang3.ObjectUtils;

public class FinanceTaxableListUpgradeService
implements IUpgradeService {
    private static String CWBB_ND = "cwbbnd";
    private static String CWBB_FND = "cwbbfnd";
    private static Log LOGGER = LogFactory.getLog(FinanceTaxableListUpgradeService.class);
    UpgradeResult result = new UpgradeResult();

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String selectsql = "SELECT FID FROM T_BDTAXR_TAXABLE_LISTING WHERE FSBBCATEGORY = 'cwbb'";
        String updatesql = "UPDATE T_BDTAXR_TAXABLE_LISTING SET FSBBCATEGORY = ? WHERE FID = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(512);
        List boom_survey = DBUtils.query((String)"taxc", (String)selectsql);
        if (ObjectUtils.isEmpty((Object)boom_survey)) {
            return this.result;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (Map map : boom_survey) {
            stringBuilder.append(map.get("FID"));
            stringBuilder.append(",");
        }
        int i = stringBuilder.lastIndexOf(",");
        if (i != -1) {
            stringBuilder.deleteCharAt(i);
        }
        stringBuilder.append(")");
        String selectsql2 = "SELECT FID,FSKSSQQ,FSKSSQZ FROM T_BDTAXR_TAXABLE_LISTING WHERE FID IN " + stringBuilder;
        DataSet collection = DBUtils.queryDataSet((String)"FinanceTaxableListUpgradeService", (String)selectsql2, (Object[])new Object[0]);
        LOGGER.info("\u6267\u884c\u5347\u7ea7\u5f00\u59cb");
        if (!ObjectUtils.isEmpty((Object)collection)) {
            while (collection.hasNext()) {
                Row row = collection.next();
                LOGGER.info("\u6570\u636e\u5347\u7ea7\u4e2d" + row);
                Date skssqq = ObjectUtils.isEmpty((Object)row.getDate("FSKSSQQ")) ? null : row.getDate("FSKSSQQ");
                Date skssqz = ObjectUtils.isEmpty((Object)row.getDate("FSKSSQZ")) ? null : row.getDate("FSKSSQZ");
                Calendar instance = Calendar.getInstance();
                if (ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) continue;
                instance.setTime(skssqq);
                int startMonth = instance.get(2) + 1;
                instance.setTime(skssqz);
                int endMonth = instance.get(2) + 1;
                if (startMonth == 1 && endMonth == 12) {
                    params.add(new Object[]{CWBB_ND, Long.parseLong(row.getString("FID"))});
                    continue;
                }
                params.add(new Object[]{CWBB_FND, Long.parseLong(row.getString("FID"))});
            }
        }
        if (ObjectUtils.isNotEmpty(params)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)updatesql, params);
        }
        this.result.setSuccess(true);
        return this.result;
    }
}

