/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;

public class RuleFetchMainUpgradeService
extends AbstractUpgradeFormPlugin {
    private Log LOGGER = LogFactory.getLog(RuleFetchMainUpgradeService.class);
    private static final String BDTAXR_RULE_FETCH_MAIN = "bdtaxr_rule_fetch_main";
    private static final String TPO_DECLARE_MAIN_TSD = "tpo_declare_main_tsd";
    private static final String TPO_TEMPLATE = "tpo_template";
    private static final String T_BDTAXR_RULEFETCH_MAIN = "t_bdtaxr_rulefetch_main";
    private static final Long TAXSYSTEM = 1L;
    private static final Long TAXAREAGROUP = 1708040530098667520L;
    private static final String UPDATE_SQL = "update t_bdtaxr_rulefetch_main set ftaxsystem=?,ftaxareagroup=? where fid = ?;";
    private static final String TIGHT_QUERY_SQL = "select fid from t_bdtaxr_rulefetch_main  where ftaxsystem = 0 or ftaxsystem is null;";
    private static final List<String> GTCP_TEMPLATETYPES = Arrays.asList("Overseas_VAT", "Overseas_CIT", "USA_CIT", "Overseas_VAT_RTA", "USA_CIT_RTA", "Overseas_CIT_RTA");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u53d6\u6570\u4e0b\u94bb\u5f39\u7a97\u4e3b\u8868\u6570\u636e\u5904\u7406\u6210\u529f\uff01", (String)"RuleFetchMainUpgradeService_0", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
        try {
            this.LOGGER.info("\u5f00\u59cb\u6267\u884c\u901a\u7528\uff1a\u53d6\u6570\u4e0b\u94bb\u5f39\u7a97\u4e3b\u8868\u6570\u636e\u5347\u7ea7\u5904\u7406===>>>>>>");
            List<String> tables = Collections.singletonList(T_BDTAXR_RULEFETCH_MAIN);
            for (String table : tables) {
                if (DB.exitsTable((DBRoute)DBRoute.of((String)TAXC), (String)table)) continue;
                result.setLog("Not exist table,no run process," + JsonUtil.toJson(tables));
                return result;
            }
            List<String> metas = Arrays.asList(TPO_DECLARE_MAIN_TSD, BDTAXR_RULE_FETCH_MAIN, TPO_TEMPLATE);
            for (String meta : metas) {
                if (this.metaIsExist(meta).booleanValue()) continue;
                this.LOGGER.info(">>>>>>\u5143\u6570\u636e\u4e0d\u5b58\u5728");
                result.setLog("Not exist metadata,no run process," + JsonUtil.toJson(metas));
                return result;
            }
            this.LOGGER.info(">>>>>>\u5f00\u59cb\u5347\u7ea7");
            this.update();
            this.LOGGER.info(">>>>>>\u5347\u7ea7\u7ed3\u675f");
        }
        catch (Exception e) {
            result.setLog(ResManager.loadKDString((String)"\u53d6\u6570\u4e0b\u94bb\u5f39\u7a97\u4e3b\u8868\u6570\u636e\u5904\u7406\u5931\u8d25\uff01", (String)"RuleFetchMainUpgradeService_1", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]));
            this.LOGGER.error("RuleFetchMainUpgradeService FAILURE", (Throwable)e);
            result.setSuccess(true);
            result.setErrorInfo(this.getStackTraceMessage(e));
        }
        return result;
    }

    private void update() {
        ArrayList<Object[]> paramList0 = new ArrayList<Object[]>(256);
        DynamicObjectCollection templates = QueryServiceHelper.query((String)TPO_TEMPLATE, (String)"id ", (QFilter[])new QFilter("type", "in", GTCP_TEMPLATETYPES).toArray());
        List tempIds = templates.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
        List<Long> rangePks = this.queryRangePk();
        DynamicObjectCollection mains = QueryServiceHelper.query((String)BDTAXR_RULE_FETCH_MAIN, (String)"id,org,skssqq,skssqz,templateid,purpose", (QFilter[])new QFilter[]{new QFilter("templateid", ">", (Object)0L), new QFilter("id", "in", rangePks)});
        ArrayList<DynamicObject> gtcpList = new ArrayList<DynamicObject>();
        for (DynamicObject main : mains) {
            Long templateid = main.getLong("templateid");
            if (!tempIds.contains(templateid)) {
                Long ftaxsystem = TAXSYSTEM;
                Long ftaxareagroup = TAXAREAGROUP;
                Long fid = main.getLong("id");
                paramList0.add(new Object[]{ftaxsystem, ftaxareagroup, fid});
                continue;
            }
            gtcpList.add(main);
        }
        DynamicObjectCollection tsds = QueryServiceHelper.query((String)TPO_DECLARE_MAIN_TSD, (String)"id,org,skssqq,skssqz,templateid,draftpurpose,taxsystem,taxareagroup", (QFilter[])new QFilter[]{new QFilter("templateid", "in", tempIds), QFilter.isNotNull((String)"skssqq"), QFilter.isNotNull((String)"skssqz")});
        Map<String, List<DynamicObject>> map = tsds.stream().collect(Collectors.groupingBy(a -> a.getLong("org") + "" + DateUtils.format((Date)a.getDate("skssqq")) + "" + DateUtils.format((Date)a.getDate("skssqz")) + "" + a.getLong("templateid") + "" + a.getString("draftpurpose")));
        for (DynamicObject main : gtcpList) {
            String key = main.getLong("org") + "" + DateUtils.format((Date)main.getDate("skssqq")) + "" + DateUtils.format((Date)main.getDate("skssqz")) + "" + main.getLong("templateid") + "" + main.getString("purpose");
            if (!map.containsKey(key) || map.get(key).size() != 1) continue;
            DynamicObject tsd = map.get(key).get(0);
            Long ftaxsystem = tsd.getLong("taxsystem");
            Long ftaxareagroup = tsd.getLong("taxareagroup");
            Long fid = main.getLong("id");
            paramList0.add(new Object[]{ftaxsystem, ftaxareagroup, fid});
        }
        try (TXHandle h = TX.requiresNew((String)"RuleFetchMainUpgradeService");){
            try {
                this.LOGGER.info(">>>>>>\u66f4\u65b0\u6570\u636e{}\u6761", (Object)paramList0.size());
                if (EmptyCheckUtils.isNotEmpty(paramList0)) {
                    DBUtils.executeBatch((String)TAXC, (String)UPDATE_SQL, paramList0);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private List<Long> queryRangePk() {
        ArrayList<Long> list = new ArrayList<Long>(16);
        try (TXHandle h = TX.required();){
            try {
                DB.query((DBRoute)DBRoute.of((String)TAXC), (String)TIGHT_QUERY_SQL, rs -> {
                    ArrayList list1 = new ArrayList(16);
                    while (rs.next()) {
                        list.add(rs.getLong("FID"));
                    }
                    return list1;
                });
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        return list;
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return this.LOGGER;
    }
}

