/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.mservice.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxccode.TaxcCodeDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TaxCodeResultUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = "";
        try {
            boolean b1 = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tpo_declare_main_tsd");
            boolean b2 = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tpo_declare_detail_tsd");
            if (b1 && b2) {
                log = this.update();
            } else {
                info = log = ResManager.loadKDString((String)"\u65e0\u9700\u5347\u7ea7\u6d77\u5916\u7a0e\u7a0e\u7801\u670d\u52a1\u5f39\u7a97\u7ed3\u679c\u6570\u636e", (String)"TaxCodeResultUpgradeService_1", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            log = ResManager.loadKDString((String)"\u6d77\u5916\u7a0e\u7a0e\u7801\u670d\u52a1\u5f39\u7a97\u7ed3\u679c\u6570\u636e\u5347\u7ea7\u5931\u8d25", (String)"TaxCodeResultUpgradeService_2", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]);
            info = e.getMessage();
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public String update() {
        Map<String, List<Map<String, Object>>> declareRowMap = this.queryDeclareUpdateData();
        if (ObjectUtils.isEmpty(declareRowMap)) {
            return ResManager.loadKDString((String)"\u65e0\u9700\u5347\u7ea7\u6d77\u5916\u7a0e\u7a0e\u7801\u670d\u52a1\u5f39\u7a97\u7ed3\u679c\u6570\u636e", (String)"TaxCodeResultUpgradeService_1", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]);
        }
        String mainInsertSql = "INSERT INTO t_bdtaxr_taxcode_result (fid, fdraftid, forgid, ftemplateid, ftaxamount, ftaxationsys, ftaxtype, fskssqq, fskssqz, freportkey, ftaxareagroup, fdraftpurpose, fsplitstartdate, fcreater, fcreatedate, ftaxcode) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String detailSql = "INSERT INTO t_bdtaxr_taxcode_detail (fid, fentryid, fseq, ftotaldays,fdays, fproportion, ftaxbaseamount, fsumintervalamount, ftaxcodetype, ftaxratetype, fintervalstartdate, fintervalenddate, fresultnumber, fresultname, fresultsource, fresultid, fstartdate, fenddate) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        String detailSql1 = "INSERT INTO t_bdtaxr_taxcode_detail_l (fpkid, fentryid, flocaleid, fresultname) VALUES(?,?,?,?)";
        String subDetailSql = "INSERT INTO t_bdtaxr_taxcode_sdetail (fentryid, fdetailid, fseq, finterval, fintervaltaxrate, fintervalamount, fintervaltaxamount) VALUES(?,?,?,?,?,?,?) ";
        String updateSql = "update t_bdtaxr_tax_details set fisupgrade = '1' where fid = ? ";
        ArrayList<Object[]> mainParamList = new ArrayList<Object[]>(declareRowMap.size());
        ArrayList<Object[]> detailParamList = new ArrayList<Object[]>(declareRowMap.size());
        ArrayList<Object[]> detailParamList1 = new ArrayList<Object[]>(declareRowMap.size());
        ArrayList<Object[]> subDetailParamList = new ArrayList<Object[]>(declareRowMap.size());
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(declareRowMap.size());
        Map<String, Map<String, Long>> reportKeyTaxCodeValue = this.queryTaxCodeInfoData();
        for (Map.Entry<String, List<Map<String, Object>>> entry : declareRowMap.entrySet()) {
            BigDecimal taxAmount = BigDecimal.ZERO;
            BigDecimal ysAmount = BigDecimal.ZERO;
            for (Map<String, Object> row : entry.getValue()) {
                taxAmount = taxAmount.add(ObjectUtils.isEmpty((Object)row.get("FINTERVALRATEAMOUNT")) ? BigDecimal.ZERO : (BigDecimal)row.get("FINTERVALRATEAMOUNT"));
                ysAmount = ysAmount.add(ObjectUtils.isEmpty((Object)row.get("FINTERVALAMOUNT")) ? BigDecimal.ZERO : (BigDecimal)row.get("FINTERVALAMOUNT"));
            }
            int mainCount = 0;
            int subDetailSeq = 1;
            Long fid = DBUtils.getLongId((String)"t_bdtaxr_taxcode_result");
            Long fentryid = DBUtils.getLongId((String)"t_bdtaxr_taxcode_detail");
            for (Map<String, Object> row : entry.getValue()) {
                ArrayList<Object> mainValueList = new ArrayList<Object>(16);
                ArrayList<Object> detailValueList = new ArrayList<Object>(16);
                ArrayList<Object> detailValueList1 = new ArrayList<Object>(16);
                ArrayList<Object> subDetailValueList = new ArrayList<Object>(16);
                ArrayList<Object> updateValueList = new ArrayList<Object>(16);
                updateValueList.add(row.get("FID"));
                updateParamList.add(updateValueList.toArray());
                if (mainCount == 0) {
                    mainValueList.add(fid);
                    mainValueList.add(row.get("FDRAFTID"));
                    mainValueList.add(row.get("FORGID"));
                    mainValueList.add(row.get("FTEMPLATEID"));
                    mainValueList.add(taxAmount);
                    mainValueList.add(row.get("FTAXATIONSYS"));
                    mainValueList.add(row.get("FTAXTYPE"));
                    mainValueList.add(row.get("FSKSSQQ"));
                    mainValueList.add(row.get("FSKSSQZ"));
                    mainValueList.add(row.get("FREPORTKEY"));
                    mainValueList.add(row.get("FTAXAREAGROUP"));
                    mainValueList.add(row.get("FDRAFTPURPOSE"));
                    mainValueList.add(row.get("FSKSSQQ"));
                    mainValueList.add(1L);
                    mainValueList.add(new Date());
                    String key = String.valueOf(row.get("FORGID")) + String.valueOf(row.get("FTEMPLATEID")) + String.valueOf(row.get("FSKSSQQ")) + String.valueOf(row.get("FSKSSQZ")) + String.valueOf(row.get("FTAXATIONSYS")) + String.valueOf(row.get("FTAXTYPE")) + String.valueOf(row.get("FTAXAREAGROUP")) + String.valueOf(row.get("FDRAFTPURPOSE")) + String.valueOf(row.get("FREPORTKEY"));
                    mainValueList.add(ObjectUtils.isEmpty(reportKeyTaxCodeValue.get(key)) ? Long.valueOf(0L) : (ObjectUtils.isEmpty((Object)reportKeyTaxCodeValue.get(key).get(String.valueOf(row.get("FREPORTKEY")))) ? Long.valueOf(0L) : reportKeyTaxCodeValue.get(key).get(String.valueOf(row.get("FREPORTKEY")))));
                    mainParamList.add(mainValueList.toArray());
                    detailValueList.add(fid);
                    detailValueList.add(fentryid);
                    detailValueList.add(1);
                    detailValueList.add(ObjectUtils.isNotEmpty((Object)row.get("FSKSSQQ")) && ObjectUtils.isNotEmpty((Object)row.get("FSKSSQZ")) ? DateUtils.getDayDiff((Date)((Date)row.get("FSKSSQQ")), (Date)((Date)row.get("FSKSSQZ"))) + 1 : 0);
                    detailValueList.add(ObjectUtils.isNotEmpty((Object)row.get("FSKSSQQ")) && ObjectUtils.isNotEmpty((Object)row.get("FSKSSQZ")) ? DateUtils.getDayDiff((Date)((Date)row.get("FSKSSQQ")), (Date)((Date)row.get("FSKSSQZ"))) + 1 : 0);
                    detailValueList.add(new BigDecimal("1.0000"));
                    detailValueList.add(ysAmount);
                    detailValueList.add(taxAmount);
                    detailValueList.add(row.get("FTAXCODETYPE"));
                    detailValueList.add(row.get("FTAXTYPE"));
                    detailValueList.add(row.get("FSKSSQQ"));
                    detailValueList.add(row.get("FSKSSQZ"));
                    detailValueList.add("");
                    detailValueList.add("");
                    detailValueList.add("bd_taxrate");
                    detailValueList.add("");
                    detailValueList.add(null);
                    detailValueList.add(null);
                    detailParamList.add(detailValueList.toArray());
                    Long fpkid = DBUtils.getLongId((String)"t_bdtaxr_taxcode_detail_l");
                    detailValueList1.add(fpkid);
                    detailValueList1.add(fentryid);
                    detailValueList1.add("zh_CN");
                    detailValueList1.add("");
                    detailParamList1.add(detailValueList1.toArray());
                    ++mainCount;
                }
                Long fdetailId = DBUtils.getLongId((String)"t_bdtaxr_taxcode_sdetail");
                subDetailValueList.add(fentryid);
                subDetailValueList.add(fdetailId);
                subDetailValueList.add(subDetailSeq++);
                subDetailValueList.add(row.get("FRANGE"));
                subDetailValueList.add(row.get("FTAXRATE") instanceof BigDecimal ? BigDecimalUtil.multiplyObject((Object)row.get("FTAXRATE"), (Object)new BigDecimal("0.01"), (int)10) : BigDecimal.ZERO);
                subDetailValueList.add(row.get("FINTERVALAMOUNT"));
                subDetailValueList.add(row.get("FINTERVALRATEAMOUNT"));
                subDetailParamList.add(subDetailValueList.toArray());
            }
        }
        DBUtils.executeBatch((String)mainInsertSql, mainParamList);
        DBUtils.executeBatch((String)detailSql, detailParamList);
        DBUtils.executeBatch((String)detailSql1, detailParamList1);
        DBUtils.executeBatch((String)subDetailSql, subDetailParamList);
        DBUtils.executeBatch((String)updateSql, updateParamList);
        return ResManager.loadKDString((String)"\u6d77\u5916\u7a0e\u7a0e\u7801\u670d\u52a1\u5f39\u7a97\u7ed3\u679c\u6570\u636e\u5347\u7ea7\u6210\u529f", (String)"TaxCodeResultUpgradeService_0", (String)"taxc-bdtaxr-mservice", (Object[])new Object[0]);
    }

    private Map<String, List<Map<String, Object>>> queryDeclareUpdateData() {
        String querySql = "select FID,FRANGE,FTAXRATE,FINTERVALAMOUNT,FINTERVALRATEAMOUNT,FDRAFTID,FSKSSQQ,FSKSSQZ,FORGID,FTAXATIONSYS,FREPORTKEY,FTEMPLATEID,FTAXTYPE,FTAXCODETYPE,FTAXAREAGROUP,FTAXRATETYPE,FDRAFTPURPOSE from t_bdtaxr_tax_details where   fisupgrade = '0' and ftemplateid in (1657982743440669696,1686895520800370688)  and freportkey in ( 'generalincome_tax_rate#generalincome_therate', 'taxrate#solidarity_surcharge_taxrate', 'taxrate#trade_tax_taxrate', 'taxrate#local_income_tax_taxrate', 'taxrate#inhabitants_taxprop_taxrate', 'taxrate#enterprise_tax_taxrate', 'taxrate#special_enter_tax_taxrate', 'Tax_rate#Federation_TaxRax', 'Tax_rate_Texas_FT#Texas_FT_TaxRax', 'Tax_rate_maine#Maine_TaxRax', 'Tax_rate_common#Alabama_TaxRax', 'Tax_rate_common#Alaska_TaxRax', 'Tax_rate_common#Arizona_TaxRax', 'Tax_rate_common#Arkansas_TaxRax', 'Tax_rate_common#California_TaxRax', 'Tax_rate_common#Colorado_TaxRax', 'Tax_rate_common#Connecticut_TaxRax', 'Tax_rate_common#Delaware_TaxRax', 'Tax_rate_common#Florida_TaxRax', 'Tax_rate_common#Georgia_TaxRax', 'Tax_rate_common#Hawaii_TaxRax', 'Tax_rate_common#Idaho_TaxRax', 'Tax_rate_common#Illinois_TaxRax', 'Tax_rate_common#Indiana_TaxRax', 'Tax_rate_common#Iowa_TaxRax', 'Tax_rate_common#Kansas_TaxRax', 'Tax_rate_common#Kentucky_TaxRax', 'Tax_rate_common#Louisiana_TaxRax', 'Tax_rate_common#Maryland_TaxRax', 'Tax_rate_common#Massachusetts_TaxRax', 'Tax_rate_common#Michigan_TaxRax', 'Tax_rate_common#Minnesota_TaxRax', 'Tax_rate_common#Mississippi_TaxRax', 'Tax_rate_common#Missouri_TaxRax', 'Tax_rate_common#Montana_TaxRax', 'Tax_rate_common#Nebraska_TaxRax', 'Tax_rate_common#New_Hampshire_TaxRax', 'Tax_rate_common#New_Jersey_TaxRax', 'Tax_rate_common#New_Mexico_TaxRax', 'Tax_rate_common#New_York_TaxRax', 'Tax_rate_common#North_Carolina_TaxRax', 'Tax_rate_common#North_Dakota_TaxRax', 'Tax_rate_common#Oklahoma_TaxRax', 'Tax_rate_common#Oregon_TaxRax', 'Tax_rate_common#Pennsylvania_TaxRax', 'Tax_rate_common#Rhode_Island_TaxRax', 'Tax_rate_common#South_Carolina_TaxRax', 'Tax_rate_common#Tennessee_TaxRax', 'Tax_rate_common#Utah_TaxRax', 'Tax_rate_common#Vermont_TaxRax', 'Tax_rate_common#Virginia_TaxRax', 'Tax_rate_common#Washington_DC_TaxRax', 'Tax_rate_common#West_Virginia_TaxRax', 'Tax_rate_common#Wisconsin_TaxRax')";
        List list = DBUtils.query((String)querySql);
        if (ObjectUtils.isEmpty((Object)list)) {
            return new HashMap<String, List<Map<String, Object>>>(0);
        }
        HashMap<String, List<Map<String, Object>>> temMap = new HashMap<String, List<Map<String, Object>>>(list.size());
        for (Map row : list) {
            String key = String.valueOf(row.get("FORGID")) + String.valueOf(row.get("FTEMPLATEID")) + String.valueOf(row.get("FSKSSQQ")) + String.valueOf(row.get("FSKSSQZ")) + String.valueOf(row.get("FTAXATIONSYS")) + String.valueOf(row.get("FTAXTYPE")) + String.valueOf(row.get("FTAXAREAGROUP")) + String.valueOf(row.get("FDRAFTPURPOSE")) + String.valueOf(row.get("FREPORTKEY"));
            if (temMap.containsKey(key)) {
                ((List)temMap.get(key)).add(row);
                continue;
            }
            ArrayList<Map> rowsList = new ArrayList<Map>(16);
            rowsList.add(row);
            temMap.put(key, rowsList);
        }
        return temMap;
    }

    private Map<String, Map<String, Long>> queryTaxCodeInfoData() {
        String querySql = "select A.FORGID,A.FTEMPLATEID,A.FSKSSQQ,A.FSKSSQZ,A.FTAXSYSTEM,A.FTAXTYPE,A.FTAXAREAGROUP,A.FDRAFTPURPOSE,B.FCELLNUMBER,B.FVALUE  from t_tpo_declare_main_tsd a  join t_tpo_declare_detail_tsd b on a.fid  = b.fentryid   where a.ftemplateid  in (1657982743440669696,1686895520800370688)  and b.fcellnumber  in (  'generalincome_tax_rate#generalincome_therate',  'taxrate#solidarity_surcharge_taxrate',  'taxrate#trade_tax_taxrate',  'taxrate#local_income_tax_taxrate',  'taxrate#inhabitants_taxprop_taxrate',  'taxrate#enterprise_tax_taxrate',  'taxrate#special_enter_tax_taxrate',  'Tax_rate#Federation_TaxRax',  'Tax_rate_Texas_FT#Texas_FT_TaxRax',  'Tax_rate_maine#Maine_TaxRax',  'Tax_rate_common#Alabama_TaxRax',  'Tax_rate_common#Alaska_TaxRax',  'Tax_rate_common#Arizona_TaxRax',  'Tax_rate_common#Arkansas_TaxRax',  'Tax_rate_common#California_TaxRax',  'Tax_rate_common#Colorado_TaxRax',  'Tax_rate_common#Connecticut_TaxRax',  'Tax_rate_common#Delaware_TaxRax',  'Tax_rate_common#Florida_TaxRax',  'Tax_rate_common#Georgia_TaxRax',  'Tax_rate_common#Hawaii_TaxRax',  'Tax_rate_common#Idaho_TaxRax',  'Tax_rate_common#Illinois_TaxRax',  'Tax_rate_common#Indiana_TaxRax',  'Tax_rate_common#Iowa_TaxRax',  'Tax_rate_common#Kansas_TaxRax',  'Tax_rate_common#Kentucky_TaxRax',  'Tax_rate_common#Louisiana_TaxRax',  'Tax_rate_common#Maryland_TaxRax',  'Tax_rate_common#Massachusetts_TaxRax',  'Tax_rate_common#Michigan_TaxRax',  'Tax_rate_common#Minnesota_TaxRax',  'Tax_rate_common#Mississippi_TaxRax',  'Tax_rate_common#Missouri_TaxRax',  'Tax_rate_common#Montana_TaxRax',  'Tax_rate_common#Nebraska_TaxRax',  'Tax_rate_common#New_Hampshire_TaxRax',  'Tax_rate_common#New_Jersey_TaxRax',  'Tax_rate_common#New_Mexico_TaxRax',  'Tax_rate_common#New_York_TaxRax',  'Tax_rate_common#North_Carolina_TaxRax',  'Tax_rate_common#North_Dakota_TaxRax',  'Tax_rate_common#Oklahoma_TaxRax',  'Tax_rate_common#Oregon_TaxRax',  'Tax_rate_common#Pennsylvania_TaxRax',  'Tax_rate_common#Rhode_Island_TaxRax',  'Tax_rate_common#South_Carolina_TaxRax',  'Tax_rate_common#Tennessee_TaxRax',  'Tax_rate_common#Utah_TaxRax',  'Tax_rate_common#Vermont_TaxRax',  'Tax_rate_common#Virginia_TaxRax',  'Tax_rate_common#Washington_DC_TaxRax',  'Tax_rate_common#West_Virginia_TaxRax',  'Tax_rate_common#Wisconsin_TaxRax')  ";
        List list = DBUtils.query((String)querySql);
        if (ObjectUtils.isEmpty((Object)list)) {
            return new HashMap<String, Map<String, Long>>(0);
        }
        HashMap<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>(list.size());
        ArrayList<String> taxCodeNumber = new ArrayList<String>(16);
        for (Map row : list) {
            String value = String.valueOf(row.get("FVALUE"));
            if (StringUtil.equalsIgnoreCase((CharSequence)value, (CharSequence)"0.00%")) continue;
            String[] values = value.split("\\|");
            taxCodeNumber.add(ObjectUtils.isNotEmpty((Object)values) && values.length > 1 ? values[1] : "");
        }
        TaxResult taxResult = TaxcCodeDataServiceHelper.loadTaxcCodeByNumbers(taxCodeNumber);
        HashMap taxCodeIdMap = new HashMap();
        if (null != taxResult && ObjectUtils.isNotEmpty((Object)taxResult.getData())) {
            List list1 = (List)taxResult.getData();
            list1.stream().forEach(o -> taxCodeIdMap.put(o.getString("name") + "|" + o.getString("number"), o.getLong("id")));
        }
        for (Map row : list) {
            String key = String.valueOf(row.get("FORGID")) + String.valueOf(row.get("FTEMPLATEID")) + String.valueOf(row.get("FSKSSQQ")) + String.valueOf(row.get("FSKSSQZ")) + String.valueOf(row.get("FTAXSYSTEM")) + String.valueOf(row.get("FTAXTYPE")) + String.valueOf(row.get("FTAXAREAGROUP")) + String.valueOf(row.get("FDRAFTPURPOSE")) + String.valueOf(row.get("FCELLNUMBER"));
            if (map.containsKey(key)) {
                ((Map)map.get(key)).put(String.valueOf(row.get("FCELLNUMBER")), taxCodeIdMap.get(String.valueOf(row.get("FVALUE"))));
                continue;
            }
            HashMap map1 = new HashMap(8);
            map1.put(String.valueOf(row.get("FCELLNUMBER")), taxCodeIdMap.get(String.valueOf(row.get("FVALUE"))));
            map.put(key, map1);
        }
        return map;
    }
}

