/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.datadetails.filter;

import kd.taxc.bdtaxr.business.datadetails.filter.DateFilterService;
import kd.taxc.bdtaxr.business.datadetails.filter.impl.DefaultDateFilterServiceImpl;
import kd.taxc.bdtaxr.business.datadetails.filter.impl.OverSeasCitDateFilterServiceImpl;

public class DateFilterServiceFactory {
    public static DateFilterService create(String templateType) {
        DateFilterService dateFilterService = DateFilterServiceEnum.getService(templateType);
        if (null == dateFilterService) {
            dateFilterService = DateFilterServiceEnum.getService("default");
        }
        return dateFilterService;
    }

    static enum DateFilterServiceEnum {
        DEFAULT(new String[]{"default"}, new DefaultDateFilterServiceImpl()),
        ITP_PROVISTON_TAXES(new String[]{"USA_CIT", "Overseas_CIT", "sdsjt_bd", "sdsjt_jt"}, new OverSeasCitDateFilterServiceImpl());

        private final String[] templateTypes;
        private final DateFilterService service;

        public static DateFilterService getService(String templateType) {
            for (DateFilterServiceEnum e : DateFilterServiceEnum.values()) {
                for (String key : e.getTemplateTypes()) {
                    if (!key.equalsIgnoreCase(templateType)) continue;
                    return e.getService();
                }
            }
            return null;
        }

        private DateFilterServiceEnum(String[] templateType, DateFilterService service) {
            this.service = service;
            this.templateTypes = templateType;
        }

        public DateFilterService getService() {
            return this.service;
        }

        public String[] getTemplateTypes() {
            return this.templateTypes;
        }
    }
}

