/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.mq.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.mq.accrual.AccrualMQMessage;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class AccrualListingConsumer
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(AccrualListingConsumer.class);
    private static final String BDTAXR_TAXABLE_LISTING = "bdtaxr_accrual_listing";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        String str = (String)message;
        LOGGER.info("AccrualListingConsumer messageId:{}, message:{}", (Object)messageId, (Object)str);
        try {
            DynamicObject object;
            AccrualMQMessage accrualMQMessage = (AccrualMQMessage)SerializationUtils.fromJsonString((String)str, AccrualMQMessage.class);
            QFilter q1 = new QFilter("org", "=", (Object)accrualMQMessage.getOrgid());
            QFilter q2 = new QFilter("taxsystem", "=", (Object)accrualMQMessage.getTaxsystem());
            QFilter q3 = new QFilter("taxareagroup", "=", (Object)accrualMQMessage.getTaxareagroup());
            String accountsettype = accrualMQMessage.getAccountsettype();
            QFilter q4 = new QFilter("accountsettype", "=", (Object)(EmptyCheckUtils.isNotEmpty((Object)accountsettype) ? accountsettype : ""));
            QFilter q5 = new QFilter("taxtype", "=", (Object)accrualMQMessage.getTaxtype());
            QFilter q6 = new QFilter("skssqq", "=", (Object)accrualMQMessage.getSkssqq()).and("skssqz", "=", (Object)accrualMQMessage.getSkssqz());
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
            qFilters.addAll(Arrays.asList(q1, q2, q3, q4, q5, q6));
            if (accrualMQMessage.getTemplatetype() != null) {
                qFilters.add(new QFilter("templatetype", "=", (Object)accrualMQMessage.getTemplatetype()));
            }
            if (1L != accrualMQMessage.getTaxsystem() && 0L != accrualMQMessage.getTaxsystem()) {
                qFilters.add(new QFilter("draftpurpose", "=", (Object)"sjjt"));
            }
            QFilter q7 = new QFilter("templatetype", "not in", Arrays.asList("sdsjt_bd", "jtysbbd_bd", "yhs_bd", "fcs_bd", "cztdsys_bd"));
            qFilters.add(q7);
            DynamicObject tsd = QueryServiceHelper.queryOne((String)"tpo_declare_main_tsd", (String)"billno,billstatus", (QFilter[])qFilters.toArray(new QFilter[0]));
            String billno = "";
            String billstatus = "nodata";
            if (tsd != null) {
                billno = tsd.getString("billno");
                billstatus = tsd.getString("billstatus");
            }
            if ((object = BusinessDataServiceHelper.loadSingle((String)BDTAXR_TAXABLE_LISTING, (String)"billno,billstatus", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6})) != null) {
                object.set("billno", (Object)billno);
                object.set("billstatus", (Object)billstatus);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
            }
            acker.ack(messageId);
        }
        catch (Throwable throwable) {
            LOGGER.error(String.format("AccrualListingConsumer execute error!messageId:%s, message:%s", messageId, str), throwable);
            acker.discard(messageId);
        }
    }
}

