/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.mq.consumer;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.business.mq.consumer.DeclareMQMessage;
import kd.taxc.bdtaxr.common.enums.DeclareCateGory;
import kd.taxc.bdtaxr.common.vo.DeclareRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;

public class DeclareConsumer
implements MessageConsumer {
    public static final Log logger = LogFactory.getLog(DeclareConsumer.class);
    public static final String SERVICE_NAME = "DeclareService";
    public static final String METHOD_NAME = "generate";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try {
            String str = (String)message;
            logger.info("DeclareConsumer message:" + str);
            DeclareMQMessage declareMQMessage = (DeclareMQMessage)SerializationUtils.fromJsonString((String)str, DeclareMQMessage.class);
            String category = declareMQMessage.getCategory();
            DeclareCateGory cateGory = DeclareCateGory.valueOfCode((String)category);
            if (cateGory != null) {
                DeclareRequest declareRequest = new DeclareRequest();
                declareRequest.setCategory(category);
                declareRequest.setDataType("schedule");
                declareRequest.setOrgId(declareMQMessage.getOrgId());
                declareRequest.setExecuteTime(declareMQMessage.getExecuteTime());
                declareRequest.setStartDate(declareMQMessage.getStartDate());
                declareRequest.setEndDate(declareMQMessage.getEndDate());
                declareRequest.setCombineDeclare(declareMQMessage.getCombineDeclare());
                String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)cateGory.getAppId(), (String)SERVICE_NAME, (String)METHOD_NAME, (Object[])new Object[]{SerializationUtils.toJsonString((Object)declareRequest)});
                EngineResponse response = (EngineResponse)SerializationUtils.fromJsonString((String)result, EngineResponse.class);
                if (response.getSuccess().booleanValue()) {
                    acker.ack(messageId);
                } else {
                    acker.discard(messageId);
                }
            } else {
                acker.discard(messageId);
            }
        }
        catch (Throwable throwable) {
            logger.error("DeclareConsumer execute error", throwable);
            acker.discard(messageId);
        }
    }
}

