/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.multidideclare;

import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.DeclareCellKeyVo;

public class DeclareCellKeyService {
    private static Log logger = LogFactory.getLog(DeclareCellKeyService.class);
    private static final String SPLIT_STRING = "#";

    public static DeclareCellKeyVo getMembersByCellKey(String cellKey) {
        DeclareCellKeyVo cellKeyVo = new DeclareCellKeyVo();
        if (StringUtil.isBlank((CharSequence)cellKey) || !cellKey.contains(SPLIT_STRING)) {
            return cellKeyVo;
        }
        int firstIndex = cellKey.indexOf(SPLIT_STRING);
        int lastIndex = cellKey.lastIndexOf(SPLIT_STRING);
        String rowMember = cellKey.substring(0, firstIndex);
        String colMember = cellKey.substring(lastIndex + 1);
        cellKeyVo.setRowMember(rowMember);
        cellKeyVo.setColMember(colMember);
        if (firstIndex != lastIndex) {
            try {
                int cellIndex = Integer.parseInt(cellKey.substring(firstIndex + 1, lastIndex));
                cellKeyVo.setIndex(cellIndex);
            }
            catch (NumberFormatException e) {
                logger.error("key\u683c\u5f0f\u4e0d\u89c4\u8303\uff01\u65e0\u6cd5\u89e3\u6790\u51faindex\uff01" + cellKey);
            }
        }
        return cellKeyVo;
    }

    public static String getRowMemberByCellKey(String cellKey) {
        if (StringUtil.isBlank((CharSequence)cellKey) || !cellKey.contains(SPLIT_STRING)) {
            return cellKey;
        }
        int firstIndex = cellKey.indexOf(SPLIT_STRING);
        return cellKey.substring(0, firstIndex);
    }

    public static boolean isSameRow(String ... cellKeys) {
        for (int i = 1; i < cellKeys.length; ++i) {
            String cellKey = cellKeys[i - 1];
            int firstIndex = cellKey.indexOf(SPLIT_STRING);
            int lastIndex = cellKey.lastIndexOf(SPLIT_STRING);
            String rowMember = cellKey.substring(0, firstIndex);
            String cellKeyNext = cellKeys[i];
            int firstIndexNext = cellKeyNext.indexOf(SPLIT_STRING);
            int lastIndexNext = cellKeyNext.lastIndexOf(SPLIT_STRING);
            String rowMemberNext = cellKeyNext.substring(0, firstIndex);
            if (!rowMember.equals(rowMemberNext)) {
                return false;
            }
            if (firstIndex == lastIndex && firstIndexNext != lastIndexNext || firstIndex != lastIndex && firstIndexNext == lastIndexNext) {
                return false;
            }
            if (firstIndex == lastIndex || firstIndexNext == lastIndexNext) continue;
            try {
                int cellIndex = Integer.parseInt(cellKey.substring(firstIndex + 1, lastIndex));
                int cellIndexNext = Integer.parseInt(cellKeyNext.substring(firstIndexNext + 1, lastIndexNext));
                if (cellIndex == cellIndexNext) continue;
                return false;
            }
            catch (NumberFormatException e) {
                logger.error("key\u683c\u5f0f\u4e0d\u89c4\u8303\uff01\u65e0\u6cd5\u89e3\u6790\u51faindex\uff01");
                return false;
            }
        }
        return true;
    }

    public static String newCellKeyByRowIndex(String cellKey, int rowIndex) {
        if (StringUtil.isBlank((CharSequence)cellKey) || !cellKey.contains(SPLIT_STRING)) {
            return cellKey;
        }
        int firstIndex = cellKey.indexOf(SPLIT_STRING);
        int lastIndex = cellKey.lastIndexOf(SPLIT_STRING);
        String rowMember = cellKey.substring(0, firstIndex);
        String colMember = cellKey.substring(lastIndex + 1);
        return rowMember + SPLIT_STRING + rowIndex + SPLIT_STRING + colMember;
    }

    public static DynamicRowModel matchDynamicRow(List<DynamicRowModel> list, String cellKey) {
        if (CollectionUtils.isEmpty(list) || StringUtil.isBlank((CharSequence)cellKey)) {
            return null;
        }
        DeclareCellKeyVo cellKeyVo = DeclareCellKeyService.getMembersByCellKey(cellKey);
        return DeclareCellKeyService.matchDynamicRowByMembers(list, cellKeyVo);
    }

    public static DynamicRowModel matchDynamicRowByMembers(List<DynamicRowModel> list, DeclareCellKeyVo cellKeyVo) {
        if (CollectionUtils.isEmpty(list) || cellKeyVo == null) {
            return null;
        }
        for (DynamicRowModel rowModel : list) {
            int rowIndex;
            String dynRowNo = rowModel.getDynRowNo();
            String dynRowMatchKey = DeclareCellKeyService.getRowMemberByDynamicRowNo(dynRowNo);
            int startRow = rowModel.getStartRow().intValue();
            if (!cellKeyVo.getRowMember().equals(dynRowMatchKey) || (rowIndex = cellKeyVo.getIndex()) != 0 && rowIndex < startRow) continue;
            return rowModel;
        }
        return null;
    }

    public static String getRowMemberByDynamicRowNo(String dynamicRowNo) {
        if (StringUtil.isEmpty((CharSequence)dynamicRowNo) || !dynamicRowNo.contains(SPLIT_STRING)) {
            return dynamicRowNo;
        }
        int firstIndex = dynamicRowNo.indexOf(SPLIT_STRING);
        return dynamicRowNo.substring(0, firstIndex);
    }
}

