/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.multidideclare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.basedata.VersionBaseDataServiceFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.basedata.service.VersionBaseDataService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.DeclareReportCalculateFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.DeclareReportCalculateService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportchangedata.DeclareReportChangeDataServiceFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportchangedata.service.DeclareReportChangeDataService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportentityfields.DeclareReportEntityFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportentityfields.service.DeclareReportEntityService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.DeclareReportHideFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.DeclareReportHideService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttemplate.DeclareReportTemplateFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttemplate.service.DeclareReportTemplateService;
import kd.taxc.bdtaxr.business.template.DynamicRowBizBusiness;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.verify.CheckResult;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.vo.DeclareChangeDataCheckCustomVo;
import kd.taxc.bdtaxr.common.vo.DeclareDataCheckVo;
import kd.taxc.bdtaxr.common.vo.DynamicRowCheckVo;
import kd.taxc.bdtaxr.common.vo.DynamicRowFormulaVo;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.GetTemplateVo;
import org.apache.commons.collections.CollectionUtils;

public class DeclareReportHelpService {
    private static Log LOGGER = LogFactory.getLog(DeclareReportHelpService.class);
    private static DeclareReportEntityService declareReportEntityService;
    private static DeclareReportTemplateService declareReportTemplateService;
    private static VersionBaseDataService versionBaseDataService;
    private static DeclareReportHideService declareReportHideService;
    private static DeclareReportChangeDataService declareReportChangeDataService;
    private static DeclareReportCalculateService declareReportCalculateService;
    private static TaxDeclareDataService taxDeclareDataService;

    public static Map<String, EntityField> getEntityFields(DeclareRequestModel requestModel, List<DynamicRowModel> dynRowList) {
        if (requestModel == null || requestModel.getModelId() == null || requestModel.getTemplateId() == null) {
            throw new IllegalArgumentException("Illegal Arguments!");
        }
        Map typeMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_FIELDS_TYPE_SHOW_BY_VERSION, (Object[])new Object[]{requestModel.getModelId(), requestModel.getTemplateId(), dynRowList, requestModel.getSkssqq(), requestModel.getSkssqz()});
        declareReportEntityService = DeclareReportEntityFactory.createHandler(requestModel.getTemplateType());
        if (declareReportEntityService != null) {
            Map businessTypeMap = declareReportEntityService.getBusinessEntityFields(requestModel, dynRowList);
            if (typeMap != null) {
                businessTypeMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_ALL_FIEDS_TYPE, (Object[])new Object[]{businessTypeMap, dynRowList});
                typeMap.putAll(businessTypeMap);
            }
        }
        return typeMap;
    }

    public static Map<String, EntityField> getEntityFieldsByMetadata(DeclareRequestModel requestModel, List<DynamicRowModel> dynRowList) {
        long start = System.currentTimeMillis();
        if (requestModel == null || requestModel.getMetaDataMap() == null || requestModel.getTemplateId() == null) {
            throw new KDBizException("Illegal Arguments!");
        }
        Map<String, EntityField> typeMap = TaxDeclarePluginService.getFieldsTypeByDynRowMap(requestModel.getMetaDataMap(), dynRowList);
        declareReportEntityService = DeclareReportEntityFactory.createHandler(requestModel.getTemplateType());
        if (declareReportEntityService != null) {
            Map<String, EntityField> businessTypeMap = declareReportEntityService.getBusinessEntityFields(requestModel, dynRowList);
            if (typeMap != null) {
                typeMap.putAll(businessTypeMap);
            }
        }
        LOGGER.info("logflag getEntityFieldsByMetadata cost:{}ms", (Object)(System.currentTimeMillis() - start));
        return typeMap;
    }

    public static List<Long> queryTaxcOrgIdByIsTaxpayerWithPerm() {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdsWithPerm((Long)RequestContext.get().getCurrUserId());
        if (!ObjectUtils.isEmpty((Object)taxResult) && taxResult.isSuccess() && !ObjectUtils.isEmpty((Object)taxResult.getData())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static List<Long> queryTaxcOrgIdByIsTaxpayerWithPerm(String appId, String entityNum, String permItemId) {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityNum, (String)permItemId);
        if (!ObjectUtils.isEmpty((Object)taxResult) && taxResult.isSuccess() && !ObjectUtils.isEmpty((Object)taxResult.getData())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static List<DynamicObject> queryTaxcOrgByOrgIds(List<Long> orgIds) {
        TaxResult listTaxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIds(orgIds);
        if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            return (List)listTaxResult.getData();
        }
        return new ArrayList<DynamicObject>();
    }

    public static Map<String, List<FormulaVo>> getCheckFormulas(DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, String> showItems) {
        Map checkFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CHECK_FORMULAS, (Object[])new Object[]{requestModel.getTemplateId(), responseModel.getDynRowList()});
        if (checkFormulas == null || showItems == null) {
            return checkFormulas;
        }
        HashMap<String, List<FormulaVo>> checkFormulasNew = new HashMap<String, List<FormulaVo>>(checkFormulas.size());
        for (Map.Entry entry : checkFormulas.entrySet()) {
            if (!"1".equals(showItems.get(entry.getKey()))) continue;
            checkFormulasNew.put((String)entry.getKey(), (List<FormulaVo>)entry.getValue());
        }
        return checkFormulasNew;
    }

    public static Map<String, List<FormulaVo>> getCheckFormulasByType(Long templateId, List<DynamicRowModel> dynRowList, Map<String, String> showItems, String checkType) {
        Map checkFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CHECK_FORMULAS_BY_CHECK_TYPE, (Object[])new Object[]{templateId, checkType, dynRowList});
        if (checkFormulas == null || showItems == null) {
            return checkFormulas;
        }
        HashMap<String, List<FormulaVo>> checkFormulasNew = new HashMap<String, List<FormulaVo>>(checkFormulas.size());
        for (Map.Entry entry : checkFormulas.entrySet()) {
            if (!"1".equals(showItems.get(entry.getKey()))) continue;
            checkFormulasNew.put((String)entry.getKey(), (List<FormulaVo>)entry.getValue());
        }
        return checkFormulasNew;
    }

    public static TemplateVo parseTemplateByData(DeclareRequestModel requestModel, TemplateVo template, Map<String, String> data, List<DynamicRowModel> dynRowList) {
        declareReportTemplateService = DeclareReportTemplateFactory.createHandler(requestModel.getTemplateType());
        if (declareReportTemplateService != null) {
            template = declareReportTemplateService.parseTemplateByData(template, data, dynRowList);
        }
        return template;
    }

    public static TemplateVo parseTemplateByCalResponse(TemplateVo template, DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, EntityField> typeMap) {
        declareReportTemplateService = DeclareReportTemplateFactory.createHandler(requestModel.getTemplateType());
        if (declareReportTemplateService != null) {
            template = declareReportTemplateService.parseTemplateByCalResponse(template, requestModel, responseModel, typeMap);
        }
        return template;
    }

    public static TemplateVo parseTemplateByCurrentData(TemplateVo template, DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, EntityField> typeMap, Map<String, String> showData) {
        declareReportTemplateService = DeclareReportTemplateFactory.createHandler(requestModel.getTemplateType());
        if (declareReportTemplateService != null) {
            template = declareReportTemplateService.parseTemplateByCurrentData(template, requestModel, responseModel, typeMap, showData);
        }
        return template;
    }

    public static DynamicObjectCollection getVersionBaseData(DeclareRequestModel requestModel, String entityName, String selectFields, QFilter[] filters) {
        versionBaseDataService = VersionBaseDataServiceFactory.createHandler(requestModel.getTemplateType());
        if (versionBaseDataService != null) {
            return versionBaseDataService.getVersionBaseData(requestModel, entityName, selectFields, filters);
        }
        return null;
    }

    public static GetTemplateVo getTemplateVo(DeclareRequestModel requestModel, DeclareResponseModel responseModel) {
        GetTemplateVo getTemplateVo = new GetTemplateVo();
        if (requestModel == null) {
            return getTemplateVo;
        }
        List<String> hideRows = null;
        List<String> hideCols = null;
        List<String> hideModificationNotes = null;
        List<String> hideSheets = null;
        declareReportHideService = DeclareReportHideFactory.createHandler(requestModel.getTemplateType());
        if (declareReportHideService != null) {
            hideRows = responseModel == null ? null : declareReportHideService.hideRow(responseModel.getDynRowList());
            hideCols = declareReportHideService.hideCol(requestModel);
            List<String> hideRowsByRequestModel = declareReportHideService.hideRowByRequestModel(requestModel);
            if (CollectionUtils.isNotEmpty(hideRowsByRequestModel)) {
                if (hideRows == null) {
                    hideRows = new ArrayList<String>(hideRowsByRequestModel.size());
                }
                hideRows.addAll(hideRowsByRequestModel);
            }
            hideModificationNotes = declareReportHideService.hideModificationNotes();
            hideSheets = declareReportHideService.hideSheets(requestModel);
        }
        getTemplateVo.setRequestModel(requestModel);
        getTemplateVo.setResponseModel(responseModel);
        getTemplateVo.setHideRows(hideRows);
        getTemplateVo.setHideCols(hideCols);
        getTemplateVo.setHideModificationNotes(hideModificationNotes);
        getTemplateVo.setHideSheets(hideSheets);
        return getTemplateVo;
    }

    public static DeclareResponseModel reGetData(DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, String> changedDatas) {
        requestModel.setPreData(changedDatas);
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, responseModel.getDynRowList());
        return taxDeclareDataService.refreshData(requestModel, typeMap);
    }

    public static DeclareResponseModel reGetMultiData(DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, String> changedDatas) {
        requestModel.setPreData(changedDatas);
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFields(requestModel, responseModel.getDynRowList());
        FormulaCollectionVo allFormulas = (FormulaCollectionVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CAL_FORMULAS, (Object[])new Object[]{requestModel, responseModel.getDynRowList()});
        responseModel = (DeclareResponseModel)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.CALCULATE_DECLARE_DATA, (Object[])new Object[]{requestModel, allFormulas, responseModel.getDynRowList(), typeMap});
        return responseModel;
    }

    public static CheckResult checkDataCustomBeforeChange(DeclareChangeDataCheckCustomVo declareChangeDataCheckCustomVo) {
        declareReportChangeDataService = DeclareReportChangeDataServiceFactory.createHandler(declareChangeDataCheckCustomVo.getRequestModel().getTemplateType());
        if (declareReportChangeDataService != null) {
            return declareReportChangeDataService.checkDataCustomBeforeChange(declareChangeDataCheckCustomVo);
        }
        return new CheckResult("", true);
    }

    public static Map<String, String> adjustDataCustomAfterChange(DeclareChangeDataCheckCustomVo declareChangeDataCheckCustomVo) {
        declareReportChangeDataService = DeclareReportChangeDataServiceFactory.createHandler(declareChangeDataCheckCustomVo.getRequestModel().getTemplateType());
        if (declareReportChangeDataService != null) {
            return declareReportChangeDataService.afterChangeData(declareChangeDataCheckCustomVo);
        }
        return declareChangeDataCheckCustomVo.getCurrentMap();
    }

    public static CheckResult checkBeforeSave(DeclareDataCheckVo declareDataCheckVo) {
        Map<String, List<FormulaVo>> checkFormulas = DeclareReportHelpService.getCheckFormulasByType(declareDataCheckVo.getRequestModel().getTemplateId(), declareDataCheckVo.getDynRowList(), declareDataCheckVo.getShowItems(), "B");
        List checkFormulaList = (List)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.CAL_CHECK_FORMULAS, (Object[])new Object[]{declareDataCheckVo.getRequestModel(), declareDataCheckVo.getCurrentMap(), checkFormulas, declareDataCheckVo.getTypeMap()});
        if (CollectionUtils.isNotEmpty((Collection)checkFormulaList)) {
            return new CheckResult((String)((Map)checkFormulaList.get(0)).get("content"), false);
        }
        Map<String, List<DynamicRowFormulaVo>> dynamicRowCheckFormulas = DynamicRowBizBusiness.getCheckFormulas(declareDataCheckVo.getRequestModel().getTemplateId(), "B");
        if (kd.taxc.bdtaxr.common.utils.ObjectUtils.isNotEmpty(dynamicRowCheckFormulas)) {
            DynamicRowCheckVo checkVo = new DynamicRowCheckVo();
            checkVo.setRequestModel(declareDataCheckVo.getRequestModel());
            checkVo.setFormulas(dynamicRowCheckFormulas);
            checkVo.setData(declareDataCheckVo.getCurrentMap());
            checkVo.setDynRowList(declareDataCheckVo.getDynRowList());
            checkVo.setTypeMap(declareDataCheckVo.getTypeMap());
            List<Map<String, String>> dynamicRowCheckResult = DynamicRowBizBusiness.calCheckFormulas(checkVo);
            if (CollectionUtils.isNotEmpty(dynamicRowCheckResult)) {
                return new CheckResult(dynamicRowCheckResult.get(0).get("content"), false);
            }
        }
        return new CheckResult("", true);
    }

    public static DeclareResponseModel refreshData(DeclareRequestModel requestModel, FormulaCollectionVo Formulas, List<DynamicRowModel> dynRowList, Map<String, EntityField> typeMap) {
        DeclareResponseModel responseModel = (DeclareResponseModel)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.CALCULATE_DECLARE_DATA, (Object[])new Object[]{requestModel, Formulas, dynRowList, typeMap});
        declareReportCalculateService = DeclareReportCalculateFactory.createHandler(requestModel.getTemplateType());
        if (declareReportCalculateService != null) {
            responseModel = declareReportCalculateService.afterCalculate(requestModel, responseModel, dynRowList, typeMap);
        }
        return responseModel;
    }

    public static String getFormulaNameByCurrentData(Map<String, String> data, Map param, Map<String, EntityField> typeMap, List<DynamicRowModel> dynRowList, FormulaVo formulaVo) {
        Map result = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.CAL_STYLE_FORMULAS, (Object[])new Object[]{data, param, typeMap, dynRowList, Collections.singletonList(formulaVo)});
        return (String)result.get(formulaVo.getFormulaKey());
    }

    public static List<Map<String, String>> doCheckFormula(DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, String> showItems, Map<String, String> showData, Map<String, EntityField> typeMap) {
        Map<String, List<FormulaVo>> checkFormulas = DeclareReportHelpService.getCheckFormulas(requestModel, responseModel, showItems);
        List checkFormulaList = (List)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.CAL_CHECK_FORMULAS, (Object[])new Object[]{requestModel, showData, checkFormulas, typeMap});
        Map<String, List<DynamicRowFormulaVo>> dynamicRowCheckFormulas = DynamicRowBizBusiness.getCheckFormulas(requestModel.getTemplateId(), null);
        if (kd.taxc.bdtaxr.common.utils.ObjectUtils.isNotEmpty(dynamicRowCheckFormulas)) {
            DynamicRowCheckVo checkVo = new DynamicRowCheckVo();
            checkVo.setRequestModel(requestModel);
            checkVo.setFormulas(dynamicRowCheckFormulas);
            checkVo.setData(showData);
            checkVo.setDynRowList(responseModel.getDynRowList());
            checkVo.setTypeMap(typeMap);
            List<Map<String, String>> dynamicRowCheckResult = DynamicRowBizBusiness.calCheckFormulas(checkVo);
            if (CollectionUtils.isNotEmpty(dynamicRowCheckResult)) {
                checkFormulaList.addAll(dynamicRowCheckResult);
            }
        }
        return checkFormulaList;
    }

    static {
        taxDeclareDataService = new TaxDeclareDataServiceImpl();
    }
}

