/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.multidideclare;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.domain.MultiEntityField;
import kd.taxc.bdtaxr.business.multidideclare.MultiDiTemplateHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.refactor.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.refactor.formula.context.CalFormulaContext;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.DeclareReportFactory;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.FormulaCalVo;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;

@Deprecated
public class MultiDataService {
    private static Log logger = LogFactory.getLog(MultiDataService.class);
    private static final String MODEL_FIELD_TYPE = "fieldType_%s";
    private static final String TEMPLATE_FIELD_TYPE = "fieldType_%s_%s_%s";
    public static final String DEFAULT_DECIMAL_FORMAT = "#####0.00";
    public static final String DECIMAL_INIT_FORMAT = "#####0";
    public static final String MICROMETER_DECIMAL_INIT_FORMAT = "###,##0";
    public static final ArrayList<String> DECLARE_MAIN_FIELDS = Lists.newArrayList((Object[])new String[]{"skssqq", "skssqz", "nsrsbh", "nsrmc"});
    private static DeclareReportService declareReportService;

    public static DeclareResponseModel queryData(DeclareRequestModel declareModel) {
        DeclareResponseModel responseModel = new DeclareResponseModel();
        if (null == declareModel) {
            return responseModel;
        }
        Long id = declareModel.getId();
        HashMap<String, String> data = new HashMap<String, String>(16);
        Long templateId = declareModel.getTemplateId();
        if (null == templateId) {
            return responseModel;
        }
        List dynamicRowModelList = DynamicRowService.getDynRowSetList((Long)templateId);
        declareModel.setTemplateId(templateId);
        Long fid = declareModel.getId();
        QFilter mianqFilter = new QFilter("id", "=", (Object)fid);
        QFilter qFilter = new QFilter("entryid", "=", (Object)fid);
        Long modelId = declareModel.getModelId();
        DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)modelId);
        String mainTable = declareTable.getMainTable();
        String detailTable = declareTable.getDetalTable();
        String queryFieds = MetadataUtil.getAllFieldToQuery((String)mainTable);
        DynamicObject mainObj = QueryServiceHelper.queryOne((String)mainTable, (String)queryFieds, (QFilter[])new QFilter[]{mianqFilter});
        if (mainObj == null) {
            return responseModel;
        }
        for (String field : queryFieds.split(",")) {
            data.put(mainTable + "#" + field, mainObj.getString(field));
        }
        try {
            long orgId = mainObj.getLong("org");
            data.putAll(YbnsrService.getOrgInfoById((long)orgId, (String)mainTable));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        DynamicObjectCollection temp = QueryServiceHelper.query((String)detailTable, (String)"cellnumber, dynrowno, index, value, valuetype", (QFilter[])new QFilter[]{qFilter}, (String)"index");
        HashMap dyMap = new HashMap();
        List rowList = new ArrayList();
        for (DynamicObject d : temp) {
            String cellKey = d.getString("cellnumber");
            String cellValue = d.getString("value");
            data.put(cellKey, cellValue);
            String dynrowno = d.getString("dynrowno");
            if (!StringUtils.isNotEmpty((CharSequence)dynrowno)) continue;
            rowList = (List)dyMap.get(dynrowno);
            if (rowList == null) {
                rowList = new ArrayList();
            }
            boolean find = false;
            block4: for (Map map : rowList) {
                for (Map.Entry entry : map.entrySet()) {
                    if (!((String)entry.getKey()).split("#")[0].equals(cellKey.split("#")[0]) || !((String)entry.getKey()).split("#")[1].equals(cellKey.split("#")[1])) continue;
                    map.put(cellKey, cellValue);
                    find = true;
                    continue block4;
                }
            }
            if (!find) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(cellKey, cellValue);
                rowList.add(map);
            }
            dyMap.put(dynrowno, rowList);
        }
        for (DynamicRowModel dyn : dynamicRowModelList) {
            dyn.setRowList((List)dyMap.get(dyn.getDynRowNo()));
        }
        responseModel.setId(id);
        responseModel.setTemplateId(templateId);
        responseModel.setData(data);
        responseModel.setDynRowList(dynamicRowModelList);
        responseModel.setParamMap(declareModel.getBusinessMap());
        return responseModel;
    }

    public static DeclareResponseModel refreshData(DeclareRequestModel declareModel, FormulaCollectionVo formulas, List<DynamicRowModel> dynRowList, Map<String, EntityField> typeMap) {
        DeclareResponseModel responseModel = new DeclareResponseModel();
        if (null == declareModel) {
            return responseModel;
        }
        Long id = declareModel.getId();
        HashMap data = new HashMap();
        Long templateId = declareModel.getTemplateId();
        Map metaMap = declareModel.getMetaDataMap();
        Map businessMap = declareModel.getBusinessMap();
        HashMap paramMap = new HashMap();
        HashMap<String, Object> ruleParamMap = new HashMap<String, Object>();
        ruleParamMap.put("orgId", declareModel.getOrgId());
        if (declareModel.getExtendParams() != null && declareModel.getExtendParams().size() > 0) {
            ruleParamMap.putAll(declareModel.getExtendParams());
        }
        if (businessMap != null) {
            paramMap.putAll(businessMap);
            ruleParamMap.putAll(businessMap);
        }
        if ((declareReportService = DeclareReportFactory.createHandler((String)declareModel.getTemplateType())) != null) {
            paramMap.putAll(declareReportService.getFormmulaParams());
        }
        if (declareModel.getBusinessValue("maindataid") != null) {
            ruleParamMap.put("maindataid", Long.valueOf(declareModel.getBusinessValue("maindataid")));
        }
        ruleParamMap.put("skssqq", declareModel.getSkssqq());
        ruleParamMap.put("skssqz", declareModel.getSkssqz());
        ruleParamMap.put("operation", declareModel.getOperation());
        ruleParamMap.put("modelId", declareModel.getModelId());
        ruleParamMap.put("templateId", declareModel.getTemplateId());
        ruleParamMap.put("cacheId", UUID.randomUUID());
        DeclareService declareService = new DeclareService();
        Map nsrxxMap = YbnsrService.createMutiCnDeclareMain((long)declareModel.getModelId(), (String)String.valueOf(declareModel.getId()), (String)declareModel.getBillNo(), (String)declareModel.getTemplateType(), (String)String.valueOf(declareModel.getOrgId()), (String)declareModel.getSkssqq(), (String)declareModel.getSkssqz(), (boolean)true, (Map)declareModel.getExtendParams(), (Long)declareModel.getTemplateId());
        FormulaCalVo formulaModel = new FormulaCalVo(paramMap, ruleParamMap, nsrxxMap, metaMap, templateId, dynRowList);
        formulaModel.setMetaTypeMap(typeMap);
        formulaModel.getParamMap().putAll(nsrxxMap);
        if (CollectionUtils.isNotEmpty(dynRowList)) {
            Map dynMap = DynamicRowService.getDynRowData(dynRowList);
            formulaModel.getParamMap().putAll(dynMap);
        }
        long t1 = System.currentTimeMillis();
        logger.info("\u5f00\u59cb\u8c03\u7528\u516c\u5f0f\u670d\u52a1\u8ba1\u7b97----");
        ConcurrentHashMap dataMap = new ConcurrentHashMap();
        CalFormulaContext calFormulaContext = new CalFormulaContext();
        Map calMap = calFormulaContext.initCal(formulaModel, dataMap, formulas.getFormulas(), formulas.getRformulas(), formulas.getMformulas());
        long t2 = System.currentTimeMillis();
        logger.info("\u8c03\u7528\u516c\u5f0f\u670d\u52a1\u8ba1\u7b97\u8017\u65f6\uff1a{}", (Object)(t2 - t1));
        data.putAll(calMap);
        data.putAll(nsrxxMap);
        responseModel.setId(id);
        responseModel.setTemplateId(templateId);
        responseModel.setData(data);
        responseModel.setDynRowList(dynRowList);
        return responseModel;
    }

    public static Map<String, String> changeData(DeclareResponseModel responseModel, DeclareRequestModel requestModel, Map<String, String> variableKeys, Map<String, String> currentMap, Map<String, EntityField> typeMap) {
        HashMap<String, String> resultMap = new HashMap();
        logger.info("\u5f00\u59cb\u8fdb\u884ccalExec\u8ba1\u7b97(\u542b\u7ea7\u8054).....");
        long time = System.currentTimeMillis();
        HashedMap dataMap = new HashedMap();
        if (requestModel.getBusinessMap() != null) {
            dataMap.putAll(requestModel.getBusinessMap());
            dataMap.putAll(currentMap);
        }
        FormulaCalVo formulaCalVo = new FormulaCalVo();
        HashedMap dataMapObj = new HashedMap((Map)dataMap);
        formulaCalVo.setParamMap((Map)dataMapObj);
        formulaCalVo.setDataMap((Map)dataMap);
        declareReportService = DeclareReportFactory.createHandler((String)requestModel.getTemplateType());
        if (declareReportService != null) {
            formulaCalVo.getParamMap().putAll(declareReportService.getFormmulaParams());
        }
        FormulaCollectionVo allFormulas = responseModel.getAllFormulas();
        Map formulaVoMap = allFormulas.getFormulas();
        Map qformulasMap = allFormulas.getQformulas();
        Map cformulasMap = allFormulas.getCformulas();
        Map rformulaMap = allFormulas.getRformulas();
        for (Map.Entry map : cformulasMap.entrySet()) {
            if (!map.getKey().toString().endsWith("rownumber") && !map.getKey().toString().endsWith("seqno")) continue;
            dataMap.put(map.getKey().toString(), map.getValue().toString());
        }
        formulaCalVo.setMetaTypeMap(typeMap);
        resultMap = new CalFormulaContext().linkageCal(variableKeys, (Map)dataMap, formulaCalVo, formulaVoMap, rformulaMap, new String[0]);
        logger.info("\u7ed3\u675fcalExec\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time));
        return resultMap;
    }

    private void addDefaultData(Map<String, String> data, Map<String, String> metaMap, List<DynamicRowModel> dynRowList, Long templateId) {
        HashMap<String, String> dynTableMap = new HashMap<String, String>();
        if (dynRowList != null) {
            for (DynamicRowModel dynamicRowModel : dynRowList) {
                String dynRowNo = dynamicRowModel.getDynRowNo();
                String tableName = dynRowNo.split("#")[0];
                dynTableMap.put(tableName, tableName);
            }
        }
        Map entityFieldMap = TemplateUtils.getAllEntity(metaMap);
        Map metadataRowList = TemplateFormulaServiceHelper.getMetadataRowList((Long)templateId);
        entityFieldMap.entrySet().stream().forEach(v -> {
            String key = (String)v.getKey();
            String[] split = key.split("#");
            String tableName = split[0];
            EntityField fieldType = (EntityField)v.getValue();
            if ("Decimal".equals(fieldType.getFieldType()) && !data.containsKey(key) && !dynTableMap.containsKey(tableName)) {
                Set formulaRows = (Set)metadataRowList.get(tableName);
                if ("tctb_declare_entry".equals(tableName)) {
                    String prefix = split[0] + "#" + split[1] + "#";
                    if (formulaRows.contains(prefix)) {
                        data.put(key, TemplateUtils.dataFormatPreSave((Object)"0", (EntityField)fieldType));
                    }
                } else {
                    data.put(key, TemplateUtils.dataFormatPreSave((Object)"0", (EntityField)fieldType));
                }
            }
        });
    }

    public static Map<String, MultiEntityField> getAllFieldTypeToShow(Long modeId) {
        String cacheKey = String.format(MODEL_FIELD_TYPE, modeId);
        HashMap<String, MultiEntityField> result = null;
        if (result != null) {
            return result;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modeId);
        DynamicObject[] fieldTypes = BusinessDataServiceHelper.load((String)"tpo_col_member", (String)"number,name, datatype, defaultvalue, format, minlength, maxlength", (QFilter[])qFilter.toArray());
        if (fieldTypes == null || fieldTypes.length == 0) {
            return new HashMap<String, MultiEntityField>(1);
        }
        result = new HashMap<String, MultiEntityField>(fieldTypes.length);
        for (DynamicObject b : fieldTypes) {
            MultiEntityField entityField = new MultiEntityField();
            entityField.setFieldName(b.getString("name"));
            entityField.setFieldType(b.getString("datatype"));
            entityField.setDefaultValue(b.getString("defaultvalue"));
            entityField.setFormat(b.getString("format"));
            entityField.setMaxLength(b.getInt("maxlength"));
            result.put(b.getString("number"), entityField);
        }
        if (result != null) {
            CacheUtils.put((String)cacheKey, result);
        }
        return result;
    }

    public static Map<String, EntityField> getFieldsTypeToShow(Long modeId, Long templateId) {
        QFilter templateFilter = new QFilter("id", "=", (Object)templateId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"tpo_template", (String)"modifytime", (QFilter[])new QFilter[]{templateFilter});
        String cacheKey = String.format(TEMPLATE_FIELD_TYPE, modeId, templateId, obj.get("modifytime") == null ? "" : Long.valueOf(((Date)obj.get("modifytime")).getTime()));
        HashMap<String, EntityField> result = (HashMap<String, EntityField>)CacheUtils.get((String)cacheKey);
        if (result != null) {
            return result;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modeId);
        DynamicObject[] fieldTypes = BusinessDataServiceHelper.load((String)"tpo_col_member", (String)"number, datatype, defaultvalue, format, minlength, maxlength", (QFilter[])qFilter.toArray());
        if (fieldTypes == null) {
            return new HashMap<String, EntityField>(0);
        }
        HashMap<String, EntityField> colEntityFields = new HashMap<String, EntityField>(fieldTypes.length);
        for (DynamicObject b : fieldTypes) {
            if (StringUtil.isBlank((CharSequence)b.getString("number"))) continue;
            EntityField entityField = new EntityField();
            entityField.setFieldType(b.getString("datatype"));
            entityField.setDefaultValue((Object)b.getString("defaultvalue"));
            entityField.setFormatStr(b.getString("format"));
            entityField.setMaxLength(b.getInt("maxlength"));
            colEntityFields.put(b.getString("number"), entityField);
        }
        if (fieldTypes == null || fieldTypes.length == 0) {
            return new HashMap<String, EntityField>(1);
        }
        Map<String, DynamicObject> reportItems = MultiDiTemplateHelper.getReportItemsByTemplate(templateId.toString());
        result = new HashMap<String, EntityField>(reportItems.size());
        for (String cellKey : reportItems.keySet()) {
            String[] keys;
            String key;
            EntityField e;
            if (!cellKey.contains("#") || (e = (EntityField)colEntityFields.get(key = (keys = cellKey.split("#"))[keys.length - 1])) == null) continue;
            e.setFieldId(cellKey);
            result.put(cellKey, e);
        }
        if (result != null) {
            CacheUtils.put((String)cacheKey, result);
        }
        return result;
    }

    public static Map<String, EntityField> getAllFieldsType(Map<String, EntityField> typeMap, List<DynamicRowModel> dynList) {
        if (typeMap == null) {
            return new HashMap<String, EntityField>(0);
        }
        if (dynList == null || dynList.size() == 0 || typeMap.isEmpty()) {
            return typeMap;
        }
        HashMap<String, EntityField> addedMetaTypeMap = new HashMap<String, EntityField>();
        for (Map.Entry<String, EntityField> entry : typeMap.entrySet()) {
            DynamicRowModel dyn;
            if (entry.getValue() == null) continue;
            String key = entry.getKey().toString();
            if (!(entry.getValue() instanceof EntityField)) {
                entry.setValue((EntityField)JSONObject.parseObject((String)JSON.toJSONString((Object)entry.getValue()), EntityField.class));
            }
            if ((dyn = DynamicRowService.matchDyn(dynList, (String)key)) == null || dyn.getRowList() == null || dyn.getRowList().size() <= 1) continue;
            for (int i = 0; i < dyn.getRowList().size(); ++i) {
                String newKey = DynamicRowService.getNewKey((String)key, (long)(i + 1));
                addedMetaTypeMap.put(newKey, entry.getValue());
            }
        }
        if (addedMetaTypeMap != null) {
            typeMap.putAll(addedMetaTypeMap);
        }
        return typeMap;
    }

    public static Map<String, Long> getRowColMember(Long modeId, String entry) {
        if (modeId == null || !entry.equals("tpo_row_member") && !entry.equals("tpo_col_member")) {
            return null;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modeId);
        DynamicObject[] cols = BusinessDataServiceHelper.load((String)entry, (String)"number, id", (QFilter[])qFilter.toArray());
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (DynamicObject b : cols) {
            if (StringUtils.isEmpty((CharSequence)b.getString("number"))) continue;
            result.put(b.getString("number"), b.getLong("id"));
        }
        return result;
    }

    public static Map<String, String> changeToShow(Map<String, String> srcMap, Map<String, FormulaVo> celltypeFormulas, Map<String, EntityField> typeMap) {
        if (srcMap == null) {
            return null;
        }
        if (celltypeFormulas != null) {
            // empty if block
        }
        if (typeMap != null) {
            for (Map.Entry<String, String> entry : srcMap.entrySet()) {
                String key = entry.getKey();
                if (StringUtil.isEmpty((CharSequence)key)) continue;
                String value = MultiDataService.dataFormat(entry.getValue(), (EntityField)JSONObject.parseObject((String)JSON.toJSONString((Object)typeMap.get(key)), EntityField.class));
                srcMap.put(entry.getKey(), value);
            }
        }
        return srcMap;
    }

    public static Map<String, String> changeToSave(Map<String, String> srcMap, Map<String, FormulaVo> celltypeFormulas, Map<String, EntityField> typeMap) {
        if (srcMap == null) {
            return null;
        }
        if (celltypeFormulas != null) {
            // empty if block
        }
        if (typeMap != null) {
            for (Map.Entry<String, String> entry : srcMap.entrySet()) {
                String key = entry.getKey();
                if (StringUtil.isEmpty((CharSequence)key)) continue;
                String value = MultiDataService.saveDataFormat(entry.getValue(), (EntityField)JSONObject.parseObject((String)JSON.toJSONString((Object)typeMap.get(key)), EntityField.class));
                srcMap.put(entry.getKey(), value);
            }
        }
        return srcMap;
    }

    public static String saveDataFormat(Object dataObj, EntityField fieldType) {
        if (dataObj == null) {
            return null;
        }
        if (fieldType != null) {
            if ("decimal".equalsIgnoreCase(fieldType.getFieldType())) {
                try {
                    return dataObj.toString().replace(",", "");
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if (dataObj instanceof Date && "time".equalsIgnoreCase(fieldType.getFieldType())) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
                return DateUtils.format((Date)((Date)dataObj), (String)format);
            }
            if (dataObj instanceof Date && "date".equalsIgnoreCase(fieldType.getFieldType())) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd";
                }
                return DateUtils.format((Date)((Date)dataObj), (String)format);
            }
            if ("integer".equalsIgnoreCase(fieldType.getFieldType())) {
                return dataObj.toString().replace(",", "");
            }
        }
        return dataObj.toString();
    }

    public static String dataFormat(Object dataObj, EntityField fieldType) {
        if (dataObj == null) {
            return null;
        }
        if (fieldType != null) {
            if ("decimal".equalsIgnoreCase(fieldType.getFieldType())) {
                try {
                    BigDecimal bd = new BigDecimal(dataObj.toString());
                    String format = fieldType.getFormatStr();
                    if (StringUtil.isBlank((CharSequence)format)) {
                        format = DEFAULT_DECIMAL_FORMAT;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat(format);
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(bd);
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if (dataObj instanceof Date && "time".equalsIgnoreCase(fieldType.getFieldType())) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
                return DateUtils.format((Date)((Date)dataObj), (String)format);
            }
            if (dataObj instanceof Date && "date".equalsIgnoreCase(fieldType.getFieldType())) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd";
                }
                return DateUtils.format((Date)((Date)dataObj), (String)format);
            }
            if (dataObj instanceof String && "date".equalsIgnoreCase(fieldType.getFieldType())) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd";
                }
                try {
                    dataObj = DateUtils.format((Date)DateUtils.stringToDate((String)dataObj.toString()), (String)format);
                }
                catch (Exception e) {
                    logger.error("{}format illigal! {}", dataObj, (Object)e);
                }
            } else if ("integer".equalsIgnoreCase(fieldType.getFieldType())) {
                return DataFormatUtils.formatInteger((Object)dataObj, (String)DECIMAL_INIT_FORMAT);
            }
        }
        return dataObj.toString();
    }

    public static String dataFormatByDefaultValue(Object dataObj, EntityField fieldType) {
        if (dataObj == null && fieldType == null) {
            return null;
        }
        if (fieldType != null && fieldType.getFieldType() != null) {
            String fieldTypeStr = fieldType.getFieldType().trim();
            if ("decimal".equalsIgnoreCase(fieldTypeStr)) {
                if (dataObj == null) {
                    dataObj = BigDecimal.ZERO;
                }
                try {
                    BigDecimal bd = new BigDecimal(dataObj.toString());
                    String format = fieldType.getFormatStr();
                    if (StringUtil.isBlank((CharSequence)format)) {
                        format = DEFAULT_DECIMAL_FORMAT;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat(format);
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(bd);
                }
                catch (Exception e) {
                    return dataObj.toString();
                }
            }
            if (dataObj instanceof Date && "time".equalsIgnoreCase(fieldTypeStr)) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd HH:mm:ss";
                }
                return DateUtils.format((Date)((Date)dataObj), (String)format);
            }
            if (dataObj instanceof Date && "date".equalsIgnoreCase(fieldTypeStr)) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd";
                }
                return DateUtils.format((Date)((Date)dataObj), (String)format);
            }
            if (dataObj instanceof String && "date".equalsIgnoreCase(fieldTypeStr)) {
                String format = fieldType.getFormatStr();
                if (StringUtil.isBlank((CharSequence)format)) {
                    format = "yyyy-MM-dd";
                }
                try {
                    dataObj = DateUtils.format((Date)DateUtils.stringToDate((String)dataObj.toString()), (String)format);
                }
                catch (Exception e) {
                    logger.error("{}format illigal! {}", dataObj, (Object)e);
                }
            } else {
                if ("integer".equalsIgnoreCase(fieldTypeStr) || "long".equalsIgnoreCase(fieldTypeStr)) {
                    if (dataObj == null) {
                        return "0";
                    }
                    return DataFormatUtils.formatInteger((Object)dataObj, (String)MICROMETER_DECIMAL_INIT_FORMAT);
                }
                if ("string".equalsIgnoreCase(fieldTypeStr) && dataObj == null) {
                    return "";
                }
            }
        }
        return dataObj == null ? null : dataObj.toString();
    }

    public static String checkData(Map<String, Object> argsMap, Map<String, FormulaVo> celltypeFormulas, Map<String, EntityField> typeMap) {
        String msg = "";
        if (argsMap == null) {
            return msg;
        }
        String cell = (String)argsMap.get("cellKey");
        String[] array = null;
        if (null != cell) {
            array = cell.split("#");
        }
        if (null != array && array.length == 3) {
            EntityField entityField;
            String matedata = array[0];
            String key = array[2];
            EntityField entityField2 = entityField = typeMap.get(cell) instanceof EntityField ? typeMap.get(cell) : (EntityField)JSONObject.parseObject((String)JSON.toJSONString((Object)typeMap.get(cell)), EntityField.class);
            if (entityField != null) {
                String fieldType = entityField.getFieldType();
                if ("Text".equals(fieldType)) {
                    if (entityField.getMaxLength() > 0) {
                        msg = MultiDataService.checkLength(argsMap, entityField);
                    }
                } else if ("Date".equals(fieldType)) {
                    msg = MultiDataService.checkDateFormat(argsMap);
                }
            }
        }
        return msg;
    }

    private static String checkLength(Map<String, Object> argsMap, EntityField entityField) {
        String value = (String)argsMap.get("value");
        int maxLength = entityField.getMaxLength();
        int currentLength = value.length();
        if (currentLength > maxLength) {
            String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5f97\u8d85\u8fc7%2$s\u5b57\u7b26", (String)"MultiDataService_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), argsMap.get("key"), maxLength);
            return msg;
        }
        return "";
    }

    private static String checkDateFormat(Map<String, Object> argsMap) {
        String value = (String)argsMap.get("value");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        SimpleDateFormat barDf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat chinessDf = new SimpleDateFormat(DateUtils.YYYYMMDD_CHINESE);
        try {
            if (value.contains("-")) {
                barDf.parse(value);
            } else {
                chinessDf.parse(value);
            }
        }
        catch (ParseException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:yyyy-MM-dd", (String)"MultiDataService_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), value);
            return msg;
        }
        return "";
    }
}

