/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.pay;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.bdtaxr.business.pay.DeclarePayServiceFactory;
import kd.taxc.bdtaxr.business.pay.IDeclarePayService;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.util.TaxTypeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class DeclarePayHelper {
    private static final Log logger = LogFactory.getLog(DeclarePayHelper.class);
    public static final String METHOD_MANUALDECLARE = "manualDeclare";
    public static final String METHOD_CANCELDECLARE = "cancelDeclare";
    public static final String METHOD_MANUALPAY = "manualPay";
    public static final String METHOD_CANCELPAY = "cancelPay";
    private static final Map<String, String> amtFieldMap = new HashMap<String, String>(){
        {
            this.put("cswhjss", "cswhjssbqybtse");
            this.put("jyffj", "jyffjbqybtsfe");
            this.put("dfjyfj", "dfjyfjbqybtsfe");
        }
    };

    public static void manualDeclare(List<Long> sbbIds) {
        DeclarePayHelper.invoke(sbbIds, METHOD_MANUALDECLARE);
    }

    public static void cancelDeclare(List<Long> sbbIds) {
        DeclarePayHelper.invoke(sbbIds, METHOD_CANCELDECLARE);
    }

    public static void manualPay(List<Long> sbbIds) {
        DeclarePayHelper.invoke(sbbIds, METHOD_MANUALPAY);
    }

    public static void cancelPay(List<Long> sbbIds) {
        DeclarePayHelper.invoke(sbbIds, METHOD_CANCELPAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invoke(List<Long> sbbIds, String methodName) {
        if (CollectionUtils.isEmpty(sbbIds)) {
            return;
        }
        CopyOnWriteArrayList locks = new CopyOnWriteArrayList();
        try {
            List lockSbbids = sbbIds.stream().filter(id -> DeclarePayHelper.tryLock(methodName, locks, id)).collect(Collectors.toList());
            DynamicObject[] nsrxxList = BusinessDataServiceHelper.load((Object[])lockSbbids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx"));
            Map<String, List<DynamicObject>> nsrxxMap = Stream.of(nsrxxList).collect(Collectors.groupingBy(DeclarePayHelper.getDynamicObjectStringFunction()));
            try (TXHandle handle = TX.required();){
                try {
                    for (Map.Entry<String, List<DynamicObject>> entry : nsrxxMap.entrySet()) {
                        IDeclarePayService operation = DeclarePayServiceFactory.getService(entry.getKey());
                        Method method = ReflectionUtils.findMethod(operation.getClass(), (String)methodName, (Class[])new Class[]{List.class});
                        method.invoke((Object)operation, entry.getValue());
                    }
                }
                catch (Exception e) {
                    logger.error("DeclarePayHelper error log ", (Throwable)e);
                    handle.markRollback();
                    throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"DeclarePayHelper_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
            }
        }
        finally {
            locks.forEach(lock -> {
                if (lock != null) {
                    lock.unlock();
                }
            });
        }
    }

    private static boolean tryLock(String methodName, List<DLock> locks, Long id) {
        DLock lock = DLock.create((String)methodName.concat(String.valueOf(id)));
        if (lock.tryLock()) {
            locks.add(lock);
            return true;
        }
        return false;
    }

    private static Function<DynamicObject, String> getDynamicObjectStringFunction() {
        return nsrxx -> {
            String type = nsrxx.getString("type");
            if (type.startsWith("zzs") || "fjsf".equals(type)) {
                return "zzs";
            }
            if ("ccxws".equals(type)) {
                return "ccxws";
            }
            if ("szys_a".equals(type) || "szys_b".equals(type)) {
                return "tcwat";
            }
            if (type.startsWith("qtsf")) {
                return "qtsf";
            }
            if ("dkdj".equals(type)) {
                return "dkdj";
            }
            if ("kjqysds".equals(type)) {
                return "kjqysds";
            }
            return "default";
        };
    }

    public static JSONObject packDeferApplyShowData(DynamicObject d, BigDecimal ybtse, Long sbbEntryId, String taxType) {
        JSONObject dyo = new JSONObject();
        dyo.put("sbbid", (Object)d.getLong("id"));
        dyo.put("sbbentryid", (Object)sbbEntryId);
        dyo.put("org", d.get("org"));
        String date = DateUtils.getStartToEndDate((Date)d.getDate("skssqq"), (Date)d.getDate("skssqz"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
        dyo.put("taxperiod", (Object)date);
        dyo.put("taxtype", (Object)taxType);
        dyo.put("type", (Object)TemplateTypeConstant.getNsrtypemap().getOrDefault(d.getString("type"), ""));
        dyo.put("taxlimit", d.get("taxlimit"));
        dyo.put("ybtse", (Object)ybtse);
        return dyo;
    }

    public static BigDecimal queryFjsfSubAmt(String sbbid, String taxType, String nsrType) {
        BigDecimal amt;
        if (nsrType.contains("ybnsr")) {
            String amtField = amtFieldMap.get(taxType);
            DynamicObject amount = QueryServiceHelper.queryOne((String)"tcvat_ybnsr_zb", (String)amtField, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid), new QFilter("ewblxh", "=", (Object)"1")});
            amt = amount != null ? amount.getBigDecimal(amtField) : BigDecimal.ZERO;
        } else if (nsrType.contains("xgmnsr")) {
            String amtField = amtFieldMap.get(taxType);
            DynamicObject amount = QueryServiceHelper.queryOne((String)"tcvat_xgm_zb", (String)amtField, (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid), new QFilter("ewblxh", "=", (Object)"5")});
            amt = amount != null ? amount.getBigDecimal(amtField) : BigDecimal.ZERO;
        } else {
            String ewblxh = String.valueOf(TaxTypeUtils.FJSF_SPLIT.indexOf(taxType) + 1);
            DynamicObject amount = QueryServiceHelper.queryOne((String)"tcvat_sb_fjsf", (String)"bqybse", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid), new QFilter("ewblxh", "=", (Object)ewblxh)});
            amt = amount != null ? amount.getBigDecimal("bqybse") : BigDecimal.ZERO;
        }
        return amt;
    }
}

