/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.pay.impl.ccxws;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.pay.impl.ccxws.CcxwsDimensionPayService;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class FcsCztdsysDimensionPayService
implements CcxwsDimensionPayService {
    @Override
    public void generateEntryEntity(DynamicObject payRecord, DynamicObjectCollection entryentity, long sbbid) {
        String taxtype = payRecord.getString("taxtype");
        String taxname = null;
        MultiLangEnumBridge multiLangEnumBridge = DeclareTaxType.nssbMatchBaseName((String)taxtype);
        if (null != multiLangEnumBridge) {
            taxname = multiLangEnumBridge.loadKDString();
        }
        QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)String.valueOf(sbbid));
        QFilter taxtypeFilter = new QFilter("taxtype", "=", (Object)taxname);
        QFilter skssqqFilter = new QFilter("startdate", "=", (Object)payRecord.getDate("skssqq"));
        QFilter skssqzFilter = new QFilter("enddate", "=", (Object)payRecord.getDate("skssqz"));
        DynamicObject[] sbb = BusinessDataServiceHelper.load((String)"tcret_ccxws_zb_hb", (String)"ybse,sm", (QFilter[])new QFilter[]{sbbidFilter, taxtypeFilter, skssqqFilter, skssqzFilter});
        Set sms = Arrays.stream(sbb).map(a -> a.getString("sm")).collect(Collectors.toSet());
        QFilter q1 = new QFilter("sbbid", "=", (Object)sbbid);
        for (String sm : sms) {
            String entryname = this.getEntryname("cztdsys".equalsIgnoreCase(taxtype) ? taxtype : sm);
            if ("cztdsys".equalsIgnoreCase(taxtype)) {
                q1 = new QFilter("sbbid", "=", (Object)sbbid).and(new QFilter("landlevel", "=", (Object)sm));
            }
            DynamicObjectCollection objectIds = QueryServiceHelper.query((String)entryname, (String)"id", (QFilter[])new QFilter[]{q1});
            DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])objectIds.stream().map(e -> e.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entryname));
            List notXgmList = Arrays.stream(objects).filter(e -> !e.getBoolean("isxgm")).collect(Collectors.toList());
            Map<String, List<DynamicObject>> objectsMap = Arrays.stream(objects).collect(Collectors.groupingBy(o -> o.getString("number") + "_" + DateUtils.format((Date)o.getDate("skssqq")) + "_" + DateUtils.format((Date)o.getDate("skssqz"))));
            HashMap xgm = new HashMap();
            objectsMap.forEach((key, value) -> xgm.put(key, value.stream().map(a -> a.getBigDecimal("currentjmamount")).collect(Collectors.toList()).stream().reduce(BigDecimal.ZERO, BigDecimal::add)));
            for (DynamicObject objectSum : notXgmList) {
                DynamicObject dynamicObject = entryentity.addNew();
                dynamicObject.set("taxitem", (Object)sm);
                BigDecimal amount = objectSum.getBigDecimal("currentpayable").subtract(objectSum.getBigDecimal("currentjmamount"));
                if (!CollectionUtils.isEmpty(xgm)) {
                    amount = amount.subtract(xgm.getOrDefault(objectSum.getString("number") + "_" + DateUtils.format((Date)objectSum.getDate("skssqq")) + "_" + DateUtils.format((Date)objectSum.getDate("skssqz")), BigDecimal.ZERO));
                }
                dynamicObject.set("yjjemx", (Object)amount);
                dynamicObject.set("sjjemx", (Object)BigDecimal.ZERO);
                dynamicObject.set("syqjjemx", (Object)amount);
                dynamicObject.set("delaypay", (Object)BigDecimal.ZERO);
                dynamicObject.set("projectnumber", objectSum.get("number"));
                if ("tcret_pbt_fcs_hire_sum".equals(entryname)) {
                    dynamicObject.set("projectnumber", objectSum.get("leasecontractno"));
                }
                dynamicObject.set("projectname", objectSum.get("name"));
                dynamicObject.set("sourceid", objectSum.get("sourceid.id"));
                dynamicObject.set("accorg", "tcret_pbt_fcs_hire_sum".equals(entryname) ? objectSum.get("sourceid.accorg") : objectSum.get("sourceid.accountorg"));
                dynamicObject.set("bizdimensiontype", objectSum.get("sourceid.bizdimensiontype"));
                dynamicObject.set("bizdimensionname", objectSum.get("sourceid.bizdimensionname"));
                dynamicObject.set("bizdimensionid", objectSum.get("sourceid.bizdimensionid"));
            }
        }
    }

    private String getEntryname(String taxtype) {
        String czjz = ResManager.loadKDString((String)"\u4ece\u79df\u8ba1\u5f81", (String)"FcsCztdsysDimensionPayService_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        String cjjz = ResManager.loadKDString((String)"\u4ece\u4ef7\u8ba1\u5f81", (String)"FcsCztdsysDimensionPayService_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        if (cjjz.equals(taxtype)) {
            return "tcret_pbt_fcs_price_sum";
        }
        if (czjz.equals(taxtype)) {
            return "tcret_pbt_fcs_hire_sum";
        }
        return "tcret_pbt_tds_sum";
    }
}

