/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.pay.impl.ccxws;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.pay.impl.ccxws.CcxwsDimensionPayService;
import kd.taxc.bdtaxr.common.taxdeclare.draft.org.OrgChangeRecordUtil;
import kd.taxc.bdtaxr.common.util.DiscountHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class YhsDimensionPayService
implements CcxwsDimensionPayService {
    @Override
    public void generateEntryEntity(DynamicObject payRecord, DynamicObjectCollection entryentity, long sbbid) {
        long orgId = payRecord.getLong("org");
        Object taxauthority = payRecord.get("taxauthority");
        long taxauthorityId = taxauthority instanceof Long ? ((Long)taxauthority).longValue() : ((DynamicObject)taxauthority).getLong("id");
        Date skssqq = payRecord.getDate("skssqq");
        Date skssqz = payRecord.getDate("skssqz");
        String isXxwlqy = "";
        QFilter qFilter = new QFilter("sbbid", "=", (Object)sbbid);
        DynamicObject object = QueryServiceHelper.queryOne((String)"tcret_declare_main", (String)"isxxwlqy", (QFilter[])new QFilter[]{qFilter});
        if (EmptyCheckUtils.isNotEmpty((Object)object)) {
            isXxwlqy = object.getString("isxxwlqy");
        }
        DynamicObject changeRecord = OrgChangeRecordUtil.loadChangeRecord((String)String.valueOf(orgId), (Date)skssqq, (Date)skssqz);
        this.generateFromTaxSource(entryentity, orgId, taxauthorityId, skssqq, skssqz, isXxwlqy, changeRecord);
        this.generateFromTaxAccount(entryentity, orgId, taxauthorityId, skssqq, skssqz, isXxwlqy, changeRecord);
    }

    private void generateFromTaxSource(DynamicObjectCollection entryentity, long orgId, long taxauthority, Date skssqq, Date skssqz, String isXxwlqy, DynamicObject changeRecord) {
        DynamicObject[] yhsTaxSourceInfos;
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("taxoffice", "=", (Object)taxauthority);
        QFilter q3 = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter q4 = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter q5 = new QFilter("datasource", "=", (Object)"useradd");
        QFilter q6 = new QFilter("isxgm", "=", (Object)"0");
        for (DynamicObject yhsTaxSourceInfo : yhsTaxSourceInfos = BusinessDataServiceHelper.load((String)"tcret_yhs_tax_source_info", (String)"accountorg,bizdimensiontype,bizdimensionname,bizdimensionid,taxitem,calctaxamount,taxrate,yjse,ynse,deductioncode,verifyrate,taxation", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6})) {
            BigDecimal yjjemx;
            DynamicObject entry = entryentity.addNew();
            entry.set("accorg", yhsTaxSourceInfo.get("accountorg"));
            entry.set("bizdimensiontype", yhsTaxSourceInfo.get("bizdimensiontype"));
            entry.set("bizdimensionname", yhsTaxSourceInfo.get("bizdimensionname"));
            entry.set("bizdimensionid", yhsTaxSourceInfo.get("bizdimensionid"));
            DynamicObject taxitem = yhsTaxSourceInfo.getDynamicObject("taxitem");
            entry.set("taxitem", (Object)taxitem.getString("name"));
            BigDecimal jmRate = DiscountHelper.calculateDiscountRate((DynamicObject)yhsTaxSourceInfo.getDynamicObject("deductioncode"), (String)isXxwlqy);
            BigDecimal ynse = yhsTaxSourceInfo.getBigDecimal("ynse");
            BigDecimal deducttax = BigDecimalUtil.multiplyObject((Object)ynse, (Object)jmRate, (int)2);
            if (changeRecord != null) {
                String reliefPolicyType = "true".equalsIgnoreCase(isXxwlqy) ? "isxxwlqy" : null;
                deducttax = DiscountHelper.ajustJmse((String)reliefPolicyType, (DynamicObject)changeRecord, (Date)skssqq, (Date)skssqz, (BigDecimal)deducttax);
            }
            BigDecimal calctaxamount = yhsTaxSourceInfo.getBigDecimal("calctaxamount");
            String taxrate = yhsTaxSourceInfo.getString("taxrate");
            BigDecimal taxrateBigDecimal = new BigDecimal(taxrate.replace("\u2030", ""));
            if (taxrate.contains("\u2030")) {
                taxrateBigDecimal = taxrateBigDecimal.divide(BigDecimal.valueOf(1000L));
            }
            if (Objects.equals("hdzs", yhsTaxSourceInfo.getString("taxation"))) {
                BigDecimal verifyrate = yhsTaxSourceInfo.getBigDecimal("verifyrate");
                yjjemx = BigDecimalUtil.subtractObject((Object)BigDecimalUtil.multiplyObject((Object)calctaxamount, (Object)taxrateBigDecimal, (int)2).multiply(verifyrate).setScale(2, 4), (Object)deducttax);
            } else {
                yjjemx = BigDecimalUtil.subtractObject((Object)BigDecimalUtil.multiplyObject((Object)calctaxamount, (Object)taxrateBigDecimal, (int)2), (Object)deducttax);
            }
            entry.set("yjjemx", (Object)yjjemx);
            entry.set("sjjemx", (Object)BigDecimal.ZERO);
            entry.set("syqjjemx", (Object)yjjemx);
            entry.set("delaypay", (Object)BigDecimal.ZERO);
        }
    }

    private void generateFromTaxAccount(DynamicObjectCollection entryentity, long orgId, long taxauthority, Date skssqq, Date skssqz, String isXxwlqy, DynamicObject changeRecord) {
        DynamicObject[] yhsTaxSourceInfos;
        QFilter serialnoFilter;
        DynamicObject[] yhsTaxSourceArr = this.getSyOfTzcj(orgId, taxauthority, skssqq, skssqz);
        Set serialnoSet = Arrays.stream(yhsTaxSourceArr).map(a -> a.getString("gathernumber")).collect(Collectors.toSet());
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{orgFilter, serialnoFilter = new QFilter("taxsourceno", "in", serialnoSet)};
        DynamicObjectCollection accountFbList = QueryServiceHelper.query((String)"tcret_yhs_tax_account_fb", (String)"orignalid", (QFilter[])filters);
        Set accountIds = accountFbList.stream().map(d -> d.getLong("orignalid")).collect(Collectors.toSet());
        if (accountIds.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", accountIds);
        for (DynamicObject yhsTaxSourceInfo : yhsTaxSourceInfos = BusinessDataServiceHelper.load((String)"tcret_yhs_tax_account", (String)"accountorg,bizdimensiontype,bizdimensionname,bizdimensionid,taxitem,subtaxitem,taxation,calctaxamount,taxrate,yjse,ynse,deductioncode,paytype,verifyrate", (QFilter[])new QFilter[]{qFilter})) {
            BigDecimal yjjemx;
            String taxrate;
            DynamicObject entry = entryentity.addNew();
            entry.set("accorg", yhsTaxSourceInfo.get("accountorg"));
            entry.set("bizdimensiontype", yhsTaxSourceInfo.get("bizdimensiontype"));
            entry.set("bizdimensionname", yhsTaxSourceInfo.get("bizdimensionname"));
            entry.set("bizdimensionid", yhsTaxSourceInfo.get("bizdimensionid"));
            DynamicObject taxitem = yhsTaxSourceInfo.getDynamicObject("taxitem");
            entry.set("taxitem", (Object)taxitem.getString("name"));
            String number = taxitem.getString("number");
            BigDecimal jmRate = DiscountHelper.calculateDiscountRate((DynamicObject)yhsTaxSourceInfo.getDynamicObject("deductioncode"), (String)isXxwlqy);
            if ("02001".equals(number)) {
                DynamicObject subtaxitem = yhsTaxSourceInfo.getDynamicObject("subtaxitem");
                taxrate = subtaxitem.getString("value");
            } else {
                taxrate = taxitem.getString("taxrate");
            }
            if ("ydjn".equals(yhsTaxSourceInfo.getString("paytype"))) {
                taxrate = yhsTaxSourceInfo.getString("taxrate");
            }
            BigDecimal taxrateBigDecimal = new BigDecimal(taxrate.replace("\u2030", ""));
            if (taxrate.contains("\u2030")) {
                taxrateBigDecimal = taxrateBigDecimal.divide(BigDecimal.valueOf(1000L));
            }
            BigDecimal verifybasis = yhsTaxSourceInfo.getBigDecimal("calctaxamount");
            if (Objects.equals("hdzs", yhsTaxSourceInfo.getString("taxation"))) {
                BigDecimal verifyrate = yhsTaxSourceInfo.getBigDecimal("verifyrate");
                verifybasis = verifyrate.multiply(verifybasis).setScale(2, 4);
            }
            BigDecimal ynse = taxrateBigDecimal.multiply(verifybasis == null ? BigDecimal.ZERO : verifybasis);
            BigDecimal deducttax = BigDecimalUtil.multiplyObject((Object)ynse, (Object)jmRate, (int)2);
            if (changeRecord != null) {
                String reliefPolicyType = "true".equalsIgnoreCase(isXxwlqy) ? "isxxwlqy" : null;
                deducttax = DiscountHelper.ajustJmse((String)reliefPolicyType, (DynamicObject)changeRecord, (Date)skssqq, (Date)skssqz, (BigDecimal)deducttax);
            }
            BigDecimal calctaxamount = yhsTaxSourceInfo.getBigDecimal("calctaxamount");
            if (Objects.equals("hdzs", yhsTaxSourceInfo.getString("taxation"))) {
                BigDecimal verifyrate = yhsTaxSourceInfo.getBigDecimal("verifyrate");
                yjjemx = BigDecimalUtil.subtractObject((Object)BigDecimalUtil.multiplyObject((Object)calctaxamount, (Object)taxrateBigDecimal, (int)2).multiply(verifyrate).setScale(2, 4), (Object)deducttax);
            } else {
                yjjemx = BigDecimalUtil.subtractObject((Object)BigDecimalUtil.multiplyObject((Object)calctaxamount, (Object)taxrateBigDecimal, (int)2), (Object)deducttax);
            }
            entry.set("yjjemx", (Object)yjjemx);
            entry.set("sjjemx", (Object)BigDecimal.ZERO);
            entry.set("syqjjemx", (Object)yjjemx);
            entry.set("delaypay", (Object)BigDecimal.ZERO);
        }
    }

    private DynamicObject[] getSyOfTzcj(long orgId, long taxauthority, Date skssqq, Date skssqz) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("taxoffice", "=", (Object)taxauthority);
        QFilter q3 = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter q4 = new QFilter("skssqz", "=", (Object)skssqz);
        QFilter q5 = new QFilter("datasource", "=", (Object)"fromacc");
        QFilter q6 = new QFilter("isxgm", "=", (Object)"0");
        QFilter q7 = new QFilter("calctaxamount", ">", (Object)BigDecimal.ZERO);
        return BusinessDataServiceHelper.load((String)"tcret_yhs_tax_source_info", (String)"gathernumber,accountorg,bizdimensiontype,bizdimensionname,bizdimensionid,taxitem,calctaxamount,taxrate,yjse,ynse,deductioncode,verifyrate", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6, q7});
    }
}

