/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.provision;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.business.provision.ICreateProvisionService;
import kd.taxc.bdtaxr.business.provision.impl.CitrtaCreateProvisionServiceImpl;
import kd.taxc.bdtaxr.business.provision.impl.GeneralCreateProvisionServiceImpl;
import kd.taxc.bdtaxr.business.provision.impl.ItpCreateProvisionServiceImpl;
import kd.taxc.bdtaxr.business.provision.impl.QysdsjbCreateProvisionServiceImpl;
import kd.taxc.bdtaxr.business.provision.impl.TotfSjjtCreateProvisionServiceImpl;
import kd.taxc.bdtaxr.business.provision.impl.ZssCreateProvisionServiceImpl;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;

public class TaxProvisionService {
    private static Map<AccrualListEnum, ICreateProvisionService> provisionMap = new HashMap<AccrualListEnum, ICreateProvisionService>();

    public void createTaxprovision(DynamicObject[] dataEntities) {
        Map<AccrualListEnum, List<DynamicObject>> groupedEntities = Arrays.stream(dataEntities).collect(Collectors.groupingBy(d -> {
            long taxtype = d.getDynamicObject("taxtype").getLong("id");
            String accountsettype = d.getString("accountsettype");
            String category = "";
            if (d.containsProperty("templatetype")) {
                if (d.get("templatetype") instanceof String) {
                    category = d.getString("templatetype");
                }
                if (d.get("templatetype") instanceof DynamicObject) {
                    category = d.getDynamicObject("templatetype").getString("number");
                }
            }
            return AccrualListEnum.valueOfBaseTaxIdAndAccountsettype((Long)taxtype, (String)accountsettype, (String)category);
        }));
        for (Map.Entry<AccrualListEnum, List<DynamicObject>> entry : groupedEntities.entrySet()) {
            AccrualListEnum accrualListEnum = entry.getKey();
            ICreateProvisionService provisionService = provisionMap.getOrDefault(accrualListEnum, new GeneralCreateProvisionServiceImpl());
            provisionService.createProvision(accrualListEnum, entry.getValue());
        }
    }

    static {
        provisionMap.put(AccrualListEnum.ZZS, new ZssCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.SDSJT_BD, new ItpCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.SDSJT_JT, new ItpCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.HW_QYSDS, new ItpCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.HW_ZZS, new ItpCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.QYSDSJB, new QysdsjbCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.QYSDSJTSBBD, new CitrtaCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.GHJF, new TotfSjjtCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.SLJSJJ, new TotfSjjtCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.LJCLF, new TotfSjjtCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.WHSYJSF, new TotfSjjtCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.CJRJYBZJ, new TotfSjjtCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.GHCBJ, new TotfSjjtCreateProvisionServiceImpl());
        provisionMap.put(AccrualListEnum.DWFHF, new TotfSjjtCreateProvisionServiceImpl());
    }
}

