/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.rule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.rule.impl.AbstractRuleEngineService;
import kd.taxc.bdtaxr.common.rule.dto.RuleAccessDetailDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.threadpools.Task;
import org.apache.commons.lang3.ObjectUtils;

public class AccessRuleAmountTask
extends Task {
    private static Log logger = LogFactory.getLog(AccessRuleAmountTask.class);
    private AbstractRuleEngineService ruleEngineService;
    private Long taxOrgId;
    private RuleEngineParamDto engineParamDto;
    private int batchSize = 8;
    private List<DynamicObject> accessConfigList = new ArrayList<DynamicObject>();

    public AccessRuleAmountTask(AbstractRuleEngineService ruleEngineService, Long taxOrgId, RuleEngineParamDto engineParamDto, List<DynamicObject> accessConfigList) {
        this.ruleEngineService = ruleEngineService;
        this.taxOrgId = taxOrgId;
        this.engineParamDto = engineParamDto;
        this.accessConfigList = accessConfigList;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition(this.accessConfigList, (int)this.batchSize);
    }

    public Object executor(Object accessConfigListObject) {
        ArrayList<Map<String, List<RuleAccessDetailDto>>> accessConfigResultList = new ArrayList<Map<String, List<RuleAccessDetailDto>>>();
        if (accessConfigListObject instanceof List) {
            List accessConfigList = (List)accessConfigListObject;
            Long startDate = System.currentTimeMillis();
            logger.info("{}\u6267\u884c\u53d6\u6570\u89c4\u5219\u7684\u6761\u6570:{}", (Object)((Object)((Object)this)).getClass().getName(), (Object)accessConfigList.size());
            logger.info("{}\u6267\u884c\u53d6\u6570\u89c4\u5219\u7684\u5f00\u59cb\u65f6\u95f4:{}", (Object)((Object)((Object)this)).getClass().getName(), (Object)System.currentTimeMillis());
            for (DynamicObject accessConfig : accessConfigList) {
                Map<String, List<RuleAccessDetailDto>> singleResutMap = this.ruleEngineService.accessSingleRuleConfigAmount(this.taxOrgId, this.engineParamDto, accessConfig);
                if (!ObjectUtils.isNotEmpty(singleResutMap)) continue;
                accessConfigResultList.add(singleResutMap);
            }
            logger.info("{}\u6267\u884c\u53d6\u6570\u89c4\u5219\u7684\u7ed3\u675f\u65f6\u95f4:{}", (Object)((Object)((Object)this)).getClass().getName(), (Object)System.currentTimeMillis());
            logger.info("{}\u6267\u884c\u53d6\u6570\u89c4\u5219\u7684\u603b\u8017\u65f6:{}ms,\u603b\u6761\u6570{}", new Object[]{((Object)((Object)this)).getClass().getName(), System.currentTimeMillis() - startDate, accessConfigList.size()});
        }
        return accessConfigResultList;
    }
}

