/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.rule.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.customsource.CustomSourceFactory;
import kd.taxc.bdtaxr.business.rule.AccessRuleAmountTask;
import kd.taxc.bdtaxr.business.rule.RuleAccessConfigService;
import kd.taxc.bdtaxr.business.rule.RuleEngineService;
import kd.taxc.bdtaxr.business.rule.impl.AbstractAccessConfigIdentify;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCardDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchDetailDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.rule.dto.RuleAccessDetailDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.rule.util.RuleAccessUtil;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineCalcFilterService;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.threadpools.ThreadPoolsService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractRuleEngineService
extends AbstractAccessConfigIdentify
implements RuleEngineService {
    private static Log logger = LogFactory.getLog(AbstractRuleEngineService.class);
    protected static final String CUSTOMESOURCE_SKSSQQ = "customsource_skssqq";
    protected static final String CUSTOMESOURCE_SKSSQZ = "customsource_skssqz";

    protected abstract RuleAccessConfigService registerRuleAccessConfigService();

    @Override
    public RuleFetchMainDto businessHandler(RuleEngineParamDto engineParamDto) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto(engineParamDto.getTaxOrgId(), engineParamDto.getSkssqq(), engineParamDto.getSkssqz(), engineParamDto.getTemplateId(), engineParamDto.getDraftPurpose());
        Map<Long, List<DynamicObject>> orgMatchAccessConfigMap = this.getAllOrgMatchAccessConfigMap(engineParamDto);
        ruleFetchMainDto = this.handleBuildRuleFetchMainDto(engineParamDto, this.getAllOrgAccessAmount(engineParamDto, orgMatchAccessConfigMap));
        ruleFetchMainDto.setTaxsystem(engineParamDto.getTaxationSys());
        ruleFetchMainDto.setTaxareagroup(engineParamDto.getTaxareagroup());
        if (EmptyCheckUtils.isNotEmpty((Object)engineParamDto.getExtendParams())) {
            ruleFetchMainDto.setCustomEvent(engineParamDto.getExtendParams().getOrDefault("customEvent", "").toString());
        }
        if (0L == this.callRuleFetchService(ruleFetchMainDto)) {
            RuleFetchMainDto fetchMainDto = new RuleFetchMainDto(engineParamDto.getTaxOrgId(), engineParamDto.getSkssqq(), engineParamDto.getSkssqz(), engineParamDto.getTemplateId(), engineParamDto.getDraftPurpose());
            fetchMainDto.setTaxsystem(engineParamDto.getTaxationSys());
            fetchMainDto.setTaxareagroup(engineParamDto.getTaxareagroup());
            return fetchMainDto;
        }
        this.saveOrDelDraftData(ruleFetchMainDto);
        return ruleFetchMainDto;
    }

    protected List<RuleEngineParamDto> handleSummaryTaxOrgList(RuleEngineParamDto ruleEngineParamDto) {
        return Collections.singletonList(ruleEngineParamDto);
    }

    protected RuleFetchMainDto handleBuildRuleFetchMainDto(RuleEngineParamDto engineParamDto, List<Map<Long, List<Map<String, List<RuleAccessDetailDto>>>>> allOrgAccessResult) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto(engineParamDto.getTaxOrgId(), engineParamDto.getSkssqq(), engineParamDto.getSkssqz(), engineParamDto.getTemplateId(), engineParamDto.getDraftPurpose());
        HashSet<String> accessProjectIdList = new HashSet<String>();
        allOrgAccessResult.stream().filter(orgMap -> orgMap.containsKey(engineParamDto.getTaxOrgId())).forEach(orgMap -> ((List)orgMap.get(engineParamDto.getTaxOrgId())).stream().forEach(entryMap -> entryMap.entrySet().stream().forEach(entry -> ((List)entry.getValue()).stream().forEach(detailDto -> accessProjectIdList.add(detailDto.getAccessConfigObject().getString(this.accessConfig_ProjectId))))));
        Map<String, String> rowColumnAccessProjectMap = this.getReportItemAccessProjectMap(engineParamDto, accessProjectIdList);
        Map calculateOrgAccessResult = allOrgAccessResult.stream().filter(o -> o.containsKey(engineParamDto.getTaxOrgId())).findFirst().orElseGet(() -> new HashMap());
        for (Map.Entry singleOrgAccessResult : calculateOrgAccessResult.entrySet()) {
            List allAccessConfigResultList = (List)singleOrgAccessResult.getValue();
            for (Map singleAccessConfigResultMap : allAccessConfigResultList) {
                singleAccessConfigResultMap.entrySet().stream().filter(entry -> StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)this.entryentity)).forEach(entry -> {
                    List accessDetailDtoList = (List)entry.getValue();
                    ArrayList<RuleFetchDetailDto> ruleFetchDetailDtoList = new ArrayList<RuleFetchDetailDto>(accessDetailDtoList.size());
                    BigDecimal sumFetchAmount = BigDecimal.ZERO;
                    BigDecimal sumOriginAmount = BigDecimal.ZERO;
                    DynamicObject accessConfigObject = null;
                    for (RuleAccessDetailDto accessDetailDto : accessDetailDtoList) {
                        if (ObjectUtils.isEmpty(accessConfigObject)) {
                            accessConfigObject = accessDetailDto.getAccessConfigObject();
                        }
                        RuleFetchDetailDto fetchDetailDto = new RuleFetchDetailDto(accessDetailDto.getSkssqq(), accessDetailDto.getSkssqz(), accessDetailDto.getBizName(), accessDetailDto.getDataSource(), accessDetailDto.getAmountField(), accessDetailDto.getFetchType(), accessDetailDto.getFetchDirection(), accessDetailDto.getFetchAmount(), accessDetailDto.getOriginAmount(), accessDetailDto.getAbsolute(), accessDetailDto.getFilterCondition());
                        fetchDetailDto.setConditionJson(accessDetailDto.getConditionJson());
                        fetchDetailDto.setAdvancedconfjson(accessDetailDto.getAdvancedConfJson());
                        ruleFetchDetailDtoList.add(fetchDetailDto);
                        sumFetchAmount = sumFetchAmount.add(accessDetailDto.getFetchAmount());
                        sumOriginAmount = sumOriginAmount.add(accessDetailDto.getOriginAmount());
                    }
                    String ruleId = ObjectUtils.isNotEmpty(accessConfigObject) ? accessConfigObject.getString("id") : "";
                    String ruleName = ObjectUtils.isNotEmpty(accessConfigObject) ? accessConfigObject.getString("name") : "";
                    String projectId = ObjectUtils.isNotEmpty((Object)accessConfigObject) ? accessConfigObject.getString(this.accessConfig_ProjectId) : "";
                    RuleFetchCardDto cardDto = new RuleFetchCardDto(ruleName, ruleId, ruleName, engineParamDto.getTaxOrgId(), sumFetchAmount);
                    cardDto.getRuleFetchDetailList().addAll(ruleFetchDetailDtoList);
                    RuleFetchCellSummaryDto cellSummaryDto = new RuleFetchCellSummaryDto(this.accessConfigEntityName, ruleId, projectId, (String)rowColumnAccessProjectMap.get(projectId), sumFetchAmount, sumOriginAmount);
                    cellSummaryDto.getRuleFetchCardList().add(cardDto);
                    ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
                });
            }
        }
        return ruleFetchMainDto;
    }

    protected Map<String, List<RuleAccessDetailDto>> handleBuildRuleAccessDetailDto(Long orgId, RuleEngineParamDto engineParamDto, DynamicObject accessConfig) {
        Date skssqq = engineParamDto.getSkssqq();
        Date skssqz = engineParamDto.getSkssqz();
        HashMap<String, List<RuleAccessDetailDto>> map = new HashMap<String, List<RuleAccessDetailDto>>(1);
        DynamicObjectCollection collection = accessConfig.getDynamicObjectCollection(this.entryentity);
        ArrayList<RuleAccessDetailDto> list = new ArrayList<RuleAccessDetailDto>(8);
        IDataEntityProperty vatRateProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty(this.vatrate);
        IDataEntityProperty baseDataTypeProperty = MetadataServiceHelper.getDataEntityType((String)this.accessConfigEntityName).findProperty("basedatatype");
        Boolean isContainBasedatatype = false;
        if (null != baseDataTypeProperty) {
            isContainBasedatatype = true;
        }
        for (DynamicObject row : collection) {
            String bizName = row.getString(this.bizname);
            String amountFieldEntity = "";
            String amountFieldNum = "";
            String baseDataType = "tctb_datasource_entry";
            if (isContainBasedatatype.booleanValue()) {
                if (StringUtil.equalsIgnoreCase((CharSequence)row.getString("basedatatype"), (CharSequence)"tctb_datasource_entry")) {
                    DynamicObject amountObject = BusinessDataServiceHelper.loadSingleFromCache((Object)row.getDynamicObject(this.amountfield).get("id"), (String)"tctb_datasource_entry", (String)"fieldsubname,fieldname");
                    amountFieldEntity = amountObject.getString("fieldsubname");
                    amountFieldNum = amountObject.getString("fieldname");
                } else {
                    amountFieldEntity = row.getString("basedatatype");
                    amountFieldNum = row.getDynamicObject(this.amountfield).getString("id");
                    baseDataType = row.getString("basedatatype");
                }
            } else {
                amountFieldEntity = row.getDynamicObject(this.amountfield).getString("fieldsubname");
                amountFieldNum = row.getDynamicObject(this.amountfield).getString("fieldname");
            }
            Long amountFieldId = row.getDynamicObject(this.amountfield).getLong("id");
            String dataDirection = row.getString(this.datadirection);
            String absoluteB = row.getString(this.absolute);
            String filterCondition = row.getString(this.filtercondition);
            String dataType = row.getString(this.datatype);
            Long dataSourceId = row.getDynamicObject(this.ftable).getLong("id");
            String advancedConf = row.getString(this.advancedconf);
            String conditionJsonS = row.getString(this.conditionjson);
            String advancedConfJson = row.getString(this.advancedconfjson);
            BigDecimal vatRate = null != vatRateProperty ? row.getBigDecimal(this.vatrate) : null;
            RuleAccessDetailDto detailDto = new RuleAccessDetailDto(accessConfig, orgId, skssqq, skssqz, bizName, dataSourceId, amountFieldId, dataDirection, absoluteB, filterCondition, dataType, advancedConf, conditionJsonS, advancedConfJson, amountFieldEntity, amountFieldNum, vatRate, baseDataType);
            list.add(detailDto);
        }
        map.put(this.entryentity, list);
        return map;
    }

    protected List<Long> handleOrgListByRelation(Long orgId, Date skssqq, Date skssqz, RuleAccessDetailDto detailRowDto) {
        List<Long> orgList = this.getOrgListByRelation(Collections.singletonList(orgId), skssqq, skssqz, detailRowDto.getDataSource());
        return orgList;
    }

    protected RuleAccessDetailDto handleDataSourceAmount(RuleAccessDetailDto ruleAccessDetailDto) {
        return ruleAccessDetailDto;
    }

    protected abstract void saveOrDelDraftData(RuleFetchMainDto var1);

    protected Map<Long, List<DynamicObject>> getAllOrgMatchAccessConfigMap(RuleEngineParamDto engineParamDto) {
        List<RuleEngineParamDto> summaryTaxOrgList = this.handleSummaryTaxOrgList(engineParamDto);
        HashMap<Long, List<DynamicObject>> orgMatchAccessConfigMap = new HashMap<Long, List<DynamicObject>>(8);
        for (RuleEngineParamDto paramDto : summaryTaxOrgList) {
            orgMatchAccessConfigMap.put(paramDto.getTaxOrgId(), this.registerRuleAccessConfigService().queryMatchAccessConfig(paramDto.getTaxOrgId(), paramDto.getAccessWhereFilter(), paramDto.getSharingPlanWhereFilter()));
        }
        return orgMatchAccessConfigMap;
    }

    protected List<Map<Long, List<Map<String, List<RuleAccessDetailDto>>>>> getAllOrgAccessAmount(RuleEngineParamDto engineParamDto, Map<Long, List<DynamicObject>> orgMatchAccessConfigMap) {
        long startDate = System.currentTimeMillis();
        logger.info("{}\u6267\u884cgetAllOrgAccessAmount\u5f00\u59cb\u65f6\u95f4:{}", (Object)this.getClass().getName(), (Object)System.currentTimeMillis());
        ArrayList<Map<Long, List<Map<String, List<RuleAccessDetailDto>>>>> allOrgResultList = new ArrayList<Map<Long, List<Map<String, List<RuleAccessDetailDto>>>>>(16);
        for (Map.Entry<Long, List<DynamicObject>> orgMatchAccessConfig : orgMatchAccessConfigMap.entrySet()) {
            HashMap singleOrgResultMap = new HashMap();
            Long taxOrgId = orgMatchAccessConfig.getKey();
            List<DynamicObject> accessConfigList = orgMatchAccessConfig.getValue();
            ArrayList singleOrgAccessConfigResultList = new ArrayList();
            AccessRuleAmountTask accessRuleAmountTask = new AccessRuleAmountTask(this, taxOrgId, engineParamDto, accessConfigList);
            List submitReturnFuture = ThreadPoolsService.getInstance().submitReturnFuture((Task)accessRuleAmountTask);
            try {
                for (Future future : submitReturnFuture) {
                    Object object = future.get();
                    if (!(object instanceof List) || !ObjectUtils.isNotEmpty(object)) continue;
                    singleOrgAccessConfigResultList.addAll((List)object);
                }
            }
            catch (Exception e) {
                logger.error("{}\u83b7\u53d6\u53d6\u6570\u7ed3\u679c\u5f02\u5e38:{}", (Object)this.getClass().getName(), (Object)e.getMessage());
            }
            singleOrgResultMap.put(taxOrgId, singleOrgAccessConfigResultList);
            allOrgResultList.add(singleOrgResultMap);
        }
        logger.info("{}\u6267\u884cgetAllOrgAccessAmount\u7ed3\u675f\u65f6\u95f4:{}", (Object)this.getClass().getName(), (Object)System.currentTimeMillis());
        logger.info("{}\u6267\u884cgetAllOrgAccessAmount\u603b\u8017\u65f6:{}ms,\u603b\u6761\u6570{}", new Object[]{this.getClass().getName(), System.currentTimeMillis() - startDate, orgMatchAccessConfigMap.get(engineParamDto.getTaxOrgId()) != null ? Integer.valueOf(orgMatchAccessConfigMap.get(engineParamDto.getTaxOrgId()).size()) : "0"});
        return allOrgResultList;
    }

    protected Map<String, String> getReportItemAccessProjectMap(RuleEngineParamDto engineParamDto, Set<String> accessProjectIdList) {
        HashMap<String, String> projectIdReportItemMap = new HashMap<String, String>();
        if (ObjectUtils.isNotEmpty(accessProjectIdList)) {
            QFilter templateIdQ = new QFilter("template", "=", (Object)engineParamDto.getTemplateId());
            DynamicObjectCollection col = QueryServiceHelper.query((String)"tpo_template_rule_fetch", (String)"reportitem.number,formula", (QFilter[])new QFilter[]{templateIdQ});
            Map<String, String> formulaReportItemMap = col.stream().filter(row -> StringUtil.isNotBlank((CharSequence)row.getString("reportitem.number"))).collect(Collectors.toMap(a -> a.getString("formula"), b -> b.getString("reportitem.number"), (m, n) -> n));
            List formulaList = col.stream().map(o -> o.getLong("formula")).collect(Collectors.toList());
            QFilter idQ = new QFilter("id", "in", formulaList);
            QFilter dataTypeQ = new QFilter("datatype", "=", (Object)"number");
            QFilter formulaQ = new QFilter("formula", "like", (Object)"{P[%");
            QFilter nameQ = new QFilter("name", "in", accessProjectIdList);
            DynamicObjectCollection ruleFetchCol = QueryServiceHelper.query((String)"tpo_rule_fetch", (String)"id,name", (QFilter[])new QFilter[]{idQ, formulaQ, dataTypeQ, nameQ});
            ruleFetchCol.stream().forEach(row -> {
                String cfr_ignored_0 = (String)projectIdReportItemMap.put(row.getString("name"), (String)formulaReportItemMap.get(row.getString("id")));
            });
        }
        return projectIdReportItemMap;
    }

    protected long callRuleFetchService(RuleFetchMainDto ruleFetchMainDto) {
        long startTime = System.currentTimeMillis();
        RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
        RuleFetchMainDto finalRuleFetchMainDto = ruleFetchMainDto;
        long result = 0L;
        try {
            logger.info("callRuleFetchService > begin[time = {}ms,org = {}]", (Object)(System.currentTimeMillis() - startTime), (Object)ruleFetchMainDto.getOrgId());
            if (DeclareConstant.REGETDATA_KEY.equals(ruleFetchMainDto.getCustomEvent())) {
                logger.info("callRuleFetchService > regetdata begin");
                RuleFetchMainDto queryAllMainDataFromDb = ruleFetchService.queryAllMainDataFromDb(ruleFetchMainDto);
                finalRuleFetchMainDto = ruleFetchService.mergeData(ruleFetchMainDto, queryAllMainDataFromDb);
            }
            result = ruleFetchService.saveFetchResult(finalRuleFetchMainDto, true);
            logger.info("callRuleFetchService > end [time = {}ms,org = {}]", (Object)(System.currentTimeMillis() - startTime), (Object)ruleFetchMainDto.getOrgId());
        }
        catch (Exception e) {
            logger.error("callRuleFetchService={}", (Object)e.getMessage());
        }
        return result;
    }

    protected List<Long> getOrgListByRelation(List<Long> orgList, Date skssqq, Date skssqz, Long tableId) {
        DynamicObject dataSourceObject = BusinessDataServiceHelper.loadSingleFromCache((Object)tableId, (String)"tctb_custom_datasource");
        String entryName = dataSourceObject.getString("entityname");
        Map orgRelationMap = TaxOrgTakeRelationServiceHelper.getOrgRelationMapByTaxOrgs(orgList, (Date)skssqq, (Date)skssqz);
        Map fieldMap = RuleAccessUtil.getTableFields((Long)tableId);
        String org = (String)fieldMap.get("orgstate");
        if (null != org) {
            String entityKey = entryName;
            String orgFieldName = org;
            if (org.contains(".")) {
                String[] split = org.split("\\.");
                entityKey = split[0];
                orgFieldName = split[1];
            }
            orgList = EngineCalcFilterService.getOrgListByRelation((Map)orgRelationMap, orgList, (String)entryName, (String)entityKey, (String)orgFieldName);
        }
        return orgList;
    }

    public Map<String, List<RuleAccessDetailDto>> accessSingleRuleConfigAmount(Long orgId, RuleEngineParamDto engineParamDto, DynamicObject accessConfig) {
        long startTime = System.currentTimeMillis();
        HashMap<String, List<RuleAccessDetailDto>> resultMap = new HashMap<String, List<RuleAccessDetailDto>>(1);
        Map<String, List<RuleAccessDetailDto>> entryEntityMap = this.handleBuildRuleAccessDetailDto(orgId, engineParamDto, accessConfig);
        for (Map.Entry<String, List<RuleAccessDetailDto>> row : entryEntityMap.entrySet()) {
            List<RuleAccessDetailDto> detailRowDtoList = row.getValue();
            String entryEntityKey = row.getKey();
            ArrayList<RuleAccessDetailDto> list = new ArrayList<RuleAccessDetailDto>();
            for (RuleAccessDetailDto ruleAccessDetailDto : detailRowDtoList) {
                RuleAccessDetailDto detailDto = this.calculateDataSourceAmount(orgId, engineParamDto, ruleAccessDetailDto);
                if (!ObjectUtils.isNotEmpty((Object)detailDto)) continue;
                this.handleDataSourceAmount(detailDto);
                list.add(detailDto);
            }
            if (!ObjectUtils.isNotEmpty(list)) continue;
            resultMap.put(entryEntityKey, list);
        }
        logger.info("accessSingleRuleConfigAmount[time = {}ms,org = {}]", (Object)(System.currentTimeMillis() - startTime), (Object)orgId);
        return resultMap;
    }

    protected RuleAccessDetailDto calculateDataSourceAmount(Long orgId, RuleEngineParamDto engineParamDto, RuleAccessDetailDto detailRowDto) {
        Long dataSourceId = detailRowDto.getDataSource();
        Date[] datePair = this.timeConversionBeforeCustomSourceQuery(engineParamDto, detailRowDto);
        BigDecimal originAmount = CustomSourceFactory.getInstance().queryBizDataRetSum(engineParamDto.getTaxOrgId(), datePair[0], datePair[1], dataSourceId, detailRowDto.getAmountFieldNum(), detailRowDto.getAmountFieldEntity(), detailRowDto.getConditionJson(), detailRowDto.getAdvancedConfJson(), engineParamDto.getTaxType());
        if (ObjectUtils.isEmpty((Object)originAmount)) {
            return null;
        }
        BigDecimal fetchAmount = this.convertFetchAmount(originAmount, detailRowDto);
        detailRowDto.setOriginAmount(originAmount);
        detailRowDto.setFetchAmount(fetchAmount);
        return detailRowDto;
    }

    protected Date[] timeConversionBeforeCustomSourceQuery(RuleEngineParamDto engineParamDto, RuleAccessDetailDto detailRowDto) {
        Date customsourceSkssqz;
        Date customsourceSkssqq = (Date)engineParamDto.getExtendParams().get(CUSTOMESOURCE_SKSSQQ);
        if (customsourceSkssqq == null) {
            customsourceSkssqq = engineParamDto.getSkssqq();
        }
        if ((customsourceSkssqz = (Date)engineParamDto.getExtendParams().get(CUSTOMESOURCE_SKSSQZ)) == null) {
            customsourceSkssqz = engineParamDto.getSkssqz();
        }
        return new Date[]{customsourceSkssqq, customsourceSkssqz};
    }

    protected BigDecimal convertFetchAmount(BigDecimal originAmount, RuleAccessDetailDto detailRowDto) {
        BigDecimal resultAmount = BigDecimal.ZERO;
        String absolute = detailRowDto.getAbsolute();
        BigDecimal numAfterPositive = StringUtil.equalsIgnoreCase((CharSequence)absolute, (CharSequence)"true") ? originAmount.abs() : originAmount;
        String dataDirection = detailRowDto.getFetchDirection();
        BigDecimal reverse = new BigDecimal(-1);
        resultAmount = StringUtil.equalsIgnoreCase((CharSequence)"positive", (CharSequence)dataDirection) ? numAfterPositive : numAfterPositive.multiply(reverse);
        String datatypeS = detailRowDto.getFetchType();
        BigDecimal vatRate = detailRowDto.getVatRate();
        if (StringUtil.isNotEmpty((CharSequence)datatypeS) && null != vatRate) {
            if (DataType.JSFLQS.getCode().equals(datatypeS)) {
                resultAmount = resultAmount.divide(BigDecimal.ONE.add(vatRate), 2, RoundingMode.HALF_UP);
            } else if (DataType.CYSLDSQS.getCode().equals(datatypeS)) {
                if (vatRate.compareTo(BigDecimal.ZERO) != 0) {
                    resultAmount = resultAmount.divide(vatRate, 2, RoundingMode.HALF_UP);
                }
            } else if (DataType.SEHSHSJ.getCode().equals(datatypeS)) {
                if (!vatRate.equals(BigDecimal.ZERO)) {
                    resultAmount = resultAmount.divide(vatRate, 2, RoundingMode.HALF_UP).multiply(BigDecimal.ONE.add(vatRate));
                }
            } else if (DataType.HSJHSSE.getCode().equals(datatypeS)) {
                if (!vatRate.equals(BigDecimal.ZERO)) {
                    BigDecimal numerator = resultAmount.multiply(vatRate);
                    BigDecimal denominator = vatRate.add(new BigDecimal(1));
                    resultAmount = numerator.divide(denominator, 2, RoundingMode.HALF_UP);
                }
            } else if (DataType.BHSJHSSE.getCode().equals(datatypeS) && !vatRate.equals(BigDecimal.ZERO)) {
                resultAmount = resultAmount.multiply(vatRate).setScale(2, RoundingMode.HALF_UP);
            }
        }
        return resultAmount;
    }
}

