/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.rule.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.rule.impl.AbstractRuleAccessConfigService;
import org.apache.commons.lang3.ObjectUtils;

public class ItpDraftDeclareBussinessImpl
extends AbstractRuleAccessConfigService {
    private static Log logger = LogFactory.getLog(ItpDraftDeclareBussinessImpl.class);

    public ItpDraftDeclareBussinessImpl() {
        this.accessConfigEntityName = "itp_accessconfig";
        this.accessConfigSelectFields = "number,name,status,creator,modifier,enable,createtime,modifytime,org,ruletype,taxationsys,accessproject,accounttype,ispreset,qslx,entryentity.bizname,entryentity.table,entryentity.absolute,entryentity.datatype,entryentity.datadirection,entryentity.filtercondition,entryentity.advancedconf,entryentity.conditionjson,entryentity.advancedconfjson,entryentity.vatrate,entryentity.basedatatype,entryentity.amountfield,id,entryentity.id,entryentity.seq";
        this.sharingplanEntityName = "itp_income_shardingplan";
        this.sharingplanSelectFields = "number,name,status,creator,modifier,enable,createtime,modifytime,taxationsys,ruleentity.rule,orgentity.org,id,ruleentity.id,ruleentity.seq,orgentity.id,orgentity.seq,ruleentity.rule.accessproject";
    }

    @Override
    public List<DynamicObject> queryMatchAccessConfig(Long orgId, QFilter accessWhereFilter, QFilter sharingPlanWhereFilter) {
        List<DynamicObject> privateAccessConfigList = this.queryPrivateAccessConfig(orgId, accessWhereFilter);
        List noRepeatPrivateAccessConfigList = privateAccessConfigList.stream().filter(this.distinctByKey(row -> row.getLong(this.accessConfig_ProjectId))).collect(Collectors.toList());
        List privateAccessProjectIds = noRepeatPrivateAccessConfigList.stream().map(row -> row.getLong(this.accessConfig_ProjectId)).collect(Collectors.toList());
        List<DynamicObject> sharingPlanList = this.querySharingPlanAccessConfig(orgId, sharingPlanWhereFilter);
        List publicAccessProjectIds = sharingPlanList.stream().filter(row -> !privateAccessProjectIds.contains(row.getLong(this.sharingPlan_Rule_AccessProject))).filter(this.distinctByKey(row -> row.getLong(this.sharingPlan_Rule_AccessProject))).map(o -> o.getLong(this.sharingPlan_Rule)).collect(Collectors.toList());
        ArrayList publicAccessConfigList = new ArrayList();
        if (ObjectUtils.isNotEmpty(publicAccessProjectIds)) {
            QFilter accessIdQ = new QFilter("id", "in", publicAccessProjectIds);
            QFilter publicFilter = new QFilter(this.accessConfig_RuleType, "=", (Object)"public");
            List<QFilter> list = this.buildEnableQfilter(this.accessConfigEntityName);
            list.stream().forEach(o -> accessIdQ.and(o));
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)this.accessConfigEntityName, (String)this.accessConfigSelectFields, (QFilter[])new QFilter[]{accessIdQ, publicFilter});
            if (ObjectUtils.isNotEmpty((Object)collection)) {
                Collections.addAll(publicAccessConfigList, collection);
            }
        }
        ArrayList<DynamicObject> allAccessConfigList = new ArrayList<DynamicObject>();
        allAccessConfigList.addAll(noRepeatPrivateAccessConfigList);
        allAccessConfigList.addAll(publicAccessConfigList);
        return allAccessConfigList;
    }

    @Override
    public List<DynamicObject> queryPrivateAccessConfig(Long orgId, QFilter accessWhereFilter) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        QFilter privateFilter = new QFilter(this.accessConfig_RuleType, "=", (Object)"private");
        List<QFilter> enableQList = this.buildEnableQfilter(this.accessConfigEntityName);
        DynamicObject[] privateAccessConfigList = BusinessDataServiceHelper.load((String)this.accessConfigEntityName, (String)this.accessConfigSelectFields, (QFilter[])new QFilter[]{accessWhereFilter, privateFilter});
        if (ObjectUtils.isNotEmpty((Object)privateAccessConfigList)) {
            Collections.addAll(list, privateAccessConfigList);
        }
        return list;
    }

    @Override
    public List<DynamicObject> querySharingPlanAccessConfig(Long orgId, QFilter sharingPlanWhereFilter) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        List<QFilter> enableQList = this.buildEnableQfilter(this.sharingplanEntityName);
        DynamicObjectCollection sharingPlanList = QueryServiceHelper.query((String)this.sharingplanEntityName, (String)this.sharingplanSelectFields, (QFilter[])new QFilter[]{sharingPlanWhereFilter});
        if (ObjectUtils.isEmpty((Object)sharingPlanList)) {
            return list;
        }
        sharingPlanList.stream().forEach(o -> list.add((DynamicObject)o));
        return list;
    }
}

