/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.rulefetch;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchService;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceHandler;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.RuleFetchConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.rulefetch.QueryRuleFetchParam;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCardDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCardEditDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchDetailDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class RuleFetchServiceImpl
implements RuleFetchService,
RuleFetchConstant {
    private static Log LOGGER = LogFactory.getLog(RuleFetchServiceImpl.class);

    @Override
    public long saveFetchResult(RuleFetchMainDto ruleFetchMainDto, boolean isRecal) {
        if (ruleFetchMainDto == null) {
            return 0L;
        }
        LOGGER.info("isrecal:{}", (Object)isRecal);
        LOGGER.info("\u4e0b\u94bb\u5361\u7247\u6570\u636e --- \u7ec4\u7ec7id\uff1a{}\uff0c\u6240\u5c5e\u671f\u8d77\uff1a{}\uff0c\u6240\u5c5e\u671f\u6b62\uff1a{}\uff0c\u5e95\u7a3f\u7528\u9014\uff1a{}\uff0c\u6570\u636e\u72b6\u6001\uff1a{}\uff0c\u7a0e\u5236\uff1a{}\uff0c\u8f96\u533a\uff1a{}, ruleFetchMainId:{}, templateId:{}, customEvent:{}", new Object[]{ruleFetchMainDto.getOrgId(), ruleFetchMainDto.getSkssqq(), ruleFetchMainDto.getSkssqz(), ruleFetchMainDto.getPurpose(), ruleFetchMainDto.getDatastatus(), ruleFetchMainDto.getTaxsystem(), ruleFetchMainDto.getTaxareagroup(), ruleFetchMainDto.getRuleFetchMainId(), ruleFetchMainDto.getTemplateId(), ruleFetchMainDto.getCustomEvent()});
        this.supplementDefaultInfo(ruleFetchMainDto);
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            if (isRecal) {
                ruleFetchMainDto.setDatastatus("0");
                this.delRuleFetchData(this.existedMainId(ruleFetchMainDto));
            } else {
                ruleFetchMainDto.setDatastatus("1");
            }
            DynamicObject mainObj = this.doPackageMainDto(ruleFetchMainDto, 0L);
            long mainId = mainObj.getLong("id");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObj});
            if (DeclareConstant.REGETDATA_KEY.equals(ruleFetchMainDto.getCustomEvent())) {
                SaveServiceHelper.save((DynamicObject[])this.doConvertSummaryList1(ruleFetchMainDto, mainId).toArray(new DynamicObject[0]));
            } else {
                SaveServiceHelper.save((DynamicObject[])this.doConvertSummaryList(ruleFetchMainDto, mainId).toArray(new DynamicObject[0]));
            }
            long l = mainId;
            return l;
        }
        catch (Exception e) {
            h.markRollback();
            LOGGER.error("RuleFetchService save error:{}", (Object)e.getMessage());
            long l = 0L;
            return l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    @Override
    public long addCellData(RuleFetchMainDto ruleFetchMainDto) {
        LOGGER.info("\u4e0b\u94bb\u5361\u7247\u6570\u636e --- \u7ec4\u7ec7id\uff1a{}\uff0c\u6240\u5c5e\u671f\u8d77\uff1a{}\uff0c\u6240\u5c5e\u671f\u6b62\uff1a{}\uff0c\u5e95\u7a3f\u7528\u9014\uff1a{}\uff0c\u6570\u636e\u72b6\u6001\uff1a{}\uff0c\u7a0e\u5236\uff1a{}\uff0c\u8f96\u533a\uff1a{}, ruleFetchMainId:{}, templateId:{}, customEvent:{}", new Object[]{ruleFetchMainDto.getOrgId(), ruleFetchMainDto.getSkssqq(), ruleFetchMainDto.getSkssqz(), ruleFetchMainDto.getPurpose(), ruleFetchMainDto.getDatastatus(), ruleFetchMainDto.getTaxsystem(), ruleFetchMainDto.getTaxareagroup(), ruleFetchMainDto.getRuleFetchMainId(), ruleFetchMainDto.getTemplateId(), ruleFetchMainDto.getCustomEvent()});
        if (StringUtil.isEmpty((CharSequence)ruleFetchMainDto.getDatastatus())) {
            ruleFetchMainDto.setDatastatus("0");
        }
        this.supplementDefaultInfo(ruleFetchMainDto);
        long mainId = RuleFetchServiceHandler.getRuleFetchMainId(ruleFetchMainDto);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdtaxr_rule_fetch_summary", (String)"reportitem", (QFilter[])new QFilter[]{new QFilter("rulefetchmainid", "=", (Object)mainId)});
        List<String> reportitems = collection.stream().map(v -> v.getString("reportitem")).collect(Collectors.toList());
        LOGGER.info("addCellData - mainId: {}", (Object)mainId);
        if (mainId != 0L) {
            if (DeclareConstant.REGETDATA_KEY.equals(ruleFetchMainDto.getCustomEvent())) {
                SaveServiceHelper.save((DynamicObject[])this.doConvertSummaryList1ByReportItems(ruleFetchMainDto, mainId, reportitems).toArray(new DynamicObject[0]));
            } else {
                SaveServiceHelper.save((DynamicObject[])this.doConvertSummaryListByReportItems(ruleFetchMainDto, mainId, reportitems).toArray(new DynamicObject[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u751f\u6210", (String)"RuleFetchServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        return mainId;
    }

    @Override
    public long saveFetchResult(RuleFetchMainDto ruleFetchMainDto) {
        LOGGER.info("\u4e0b\u94bb\u5361\u7247\u6570\u636e --- \u7ec4\u7ec7id\uff1a{}\uff0c\u6240\u5c5e\u671f\u8d77\uff1a{}\uff0c\u6240\u5c5e\u671f\u6b62\uff1a{}\uff0c\u5e95\u7a3f\u7528\u9014\uff1a{}\uff0c\u6570\u636e\u72b6\u6001\uff1a{}\uff0c\u7a0e\u5236\uff1a{}\uff0c\u8f96\u533a\uff1a{}, ruleFetchMainId:{}, templateId:{}, customEvent:{}", new Object[]{ruleFetchMainDto.getOrgId(), ruleFetchMainDto.getSkssqq(), ruleFetchMainDto.getSkssqz(), ruleFetchMainDto.getPurpose(), ruleFetchMainDto.getDatastatus(), ruleFetchMainDto.getTaxsystem(), ruleFetchMainDto.getTaxareagroup(), ruleFetchMainDto.getRuleFetchMainId(), ruleFetchMainDto.getTemplateId(), ruleFetchMainDto.getCustomEvent()});
        this.supplementDefaultInfo(ruleFetchMainDto);
        return this.saveFetchResult(ruleFetchMainDto, false);
    }

    @Override
    public DynamicObject getFetchDetail(QueryRuleFetchParam param) {
        if (param == null) {
            return null;
        }
        LOGGER.info("getFetchDetail - param: {}", (Object)JSONObject.toJSONString((Object)param));
        QFilter[] qFilters = RuleFetchServiceHandler.getQueryFilters(param);
        if (qFilters == null || qFilters.length == 0) {
            return null;
        }
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bdtaxr_rule_fetch_summary", (String)"id", (QFilter[])qFilters);
        if (CollectionUtils.isEmpty(Arrays.asList(ids)) || ids.length > 1) {
            return null;
        }
        LOGGER.info("getFetchDetail - id: {}", (Object)ids[0].getLong("id"));
        return BusinessDataServiceHelper.loadSingle((Object)ids[0].getLong("id"), (String)"bdtaxr_rule_fetch_summary");
    }

    @Override
    public RuleFetchMainDto queryAllMainDataFromDb(RuleFetchMainDto ruleFetchMainDto) {
        LOGGER.info("\u4e0b\u94bb\u5361\u7247\u6570\u636e --- \u7ec4\u7ec7id\uff1a{}\uff0c\u6240\u5c5e\u671f\u8d77\uff1a{}\uff0c\u6240\u5c5e\u671f\u6b62\uff1a{}\uff0c\u5e95\u7a3f\u7528\u9014\uff1a{}\uff0c\u6570\u636e\u72b6\u6001\uff1a{}\uff0c\u7a0e\u5236\uff1a{}\uff0c\u8f96\u533a\uff1a{}, ruleFetchMainId:{}, templateId:{}, customEvent:{}", new Object[]{ruleFetchMainDto.getOrgId(), ruleFetchMainDto.getSkssqq(), ruleFetchMainDto.getSkssqz(), ruleFetchMainDto.getPurpose(), ruleFetchMainDto.getDatastatus(), ruleFetchMainDto.getTaxsystem(), ruleFetchMainDto.getTaxareagroup(), ruleFetchMainDto.getRuleFetchMainId(), ruleFetchMainDto.getTemplateId(), ruleFetchMainDto.getCustomEvent()});
        this.supplementDefaultInfo(ruleFetchMainDto);
        DynamicObject mainData = this.getmainData(ruleFetchMainDto);
        if (mainData != null) {
            RuleFetchMainDto dbTempData = this.querySetDbData(mainData.getLong("id"));
            return dbTempData;
        }
        return null;
    }

    @Override
    public RuleFetchMainDto mergeData(RuleFetchMainDto calRuleFetchMainDto, RuleFetchMainDto queryAllMainData) {
        boolean dynamicRowCal = calRuleFetchMainDto.isDynamicRowCal();
        return this.mergeData(calRuleFetchMainDto, queryAllMainData, dynamicRowCal, true);
    }

    public RuleFetchMainDto mergeData(RuleFetchMainDto calRuleFetchMainDto, RuleFetchMainDto queryAllMainData, boolean dynamicRowCal, boolean isCheckDb) {
        if (EmptyCheckUtils.isEmpty((Object)queryAllMainData)) {
            return calRuleFetchMainDto;
        }
        List ruleFetchCellSummaryList = queryAllMainData.getRuleFetchCellSummaryList();
        Map<String, List<RuleFetchCellSummaryDto>> reportItemGroup = this.getCollectByReportItem(ruleFetchCellSummaryList);
        Map<String, List<RuleFetchCellSummaryDto>> reportItemGroup0 = this.getCollectByRuleItem(ruleFetchCellSummaryList);
        calRuleFetchMainDto.getRuleFetchCellSummaryList().forEach(dto -> {
            List ruleFetchCellSummaryDtos = null;
            if (!dynamicRowCal) {
                if (EmptyCheckUtils.isNotEmpty((Object)dto.getReportItem())) {
                    ruleFetchCellSummaryDtos = (List)reportItemGroup.get(dto.getReportItem());
                } else if (StringUtil.isNotEmpty((CharSequence)dto.getRuleTable()) && StringUtil.isNotEmpty((CharSequence)dto.getRuleId()) && StringUtil.isNotEmpty((CharSequence)dto.getRuleItem())) {
                    ruleFetchCellSummaryDtos = (List)reportItemGroup0.get(dto.getRuleTable() + dto.getRuleId() + dto.getRuleItem());
                }
            } else if (StringUtil.isNotEmpty((CharSequence)dto.getRuleTable()) && StringUtil.isNotEmpty((CharSequence)dto.getRuleId()) && StringUtil.isNotEmpty((CharSequence)dto.getRuleItem())) {
                ruleFetchCellSummaryDtos = (List)reportItemGroup0.get(dto.getRuleTable() + dto.getRuleId() + dto.getRuleItem());
            } else if (EmptyCheckUtils.isNotEmpty((Object)dto.getReportItem())) {
                ruleFetchCellSummaryDtos = (List)reportItemGroup.get(dto.getReportItem());
            }
            if (EmptyCheckUtils.isNotEmpty((Object)ruleFetchCellSummaryDtos)) {
                RuleFetchCellSummaryDto ruleFetchCellSummaryDto = null;
                Optional<RuleFetchCellSummaryDto> ruleFetchCellSummaryDtoOptional = ruleFetchCellSummaryDtos.stream().filter(v -> EmptyCheckUtils.isNotEmpty((Object)v.getReportItem())).findFirst();
                if (ruleFetchCellSummaryDtoOptional.isPresent()) {
                    ruleFetchCellSummaryDto = ruleFetchCellSummaryDtoOptional.get();
                }
                if (EmptyCheckUtils.isNotEmpty(ruleFetchCellSummaryDto)) {
                    Optional<RuleFetchCardDto> ruleFetchCardDto;
                    List cardEntry = ruleFetchCellSummaryDto.getRuleFetchCardList();
                    List editEntry = ruleFetchCellSummaryDto.getRuleFetchEditList();
                    dto.getRuleFetchCardList().forEach(c -> {
                        Optional<RuleFetchCardDto> cardOp = cardEntry.stream().filter(v -> v.getRuleId().equals(String.valueOf(c.getRuleId()))).findFirst();
                        if (cardOp.isPresent()) {
                            RuleFetchCardDto ruleFetchCardDto = cardOp.get();
                            c.setAdjustAmount(ruleFetchCardDto.getAdjustAmount());
                            c.setAdjustExplain(ruleFetchCardDto.getAdjustExplain());
                            c.setTotalAmount(BigDecimalUtil.addObject((Object)c.getAdjustAmount(), (Object)c.getAmount()));
                        }
                    });
                    if (dynamicRowCal && !(ruleFetchCardDto = dto.getRuleFetchCardList().stream().filter(v -> "0".equals(v.getRuleId())).findFirst()).isPresent()) {
                        dto.getRuleFetchCardList().addAll(cardEntry.stream().filter(v -> "0".equals(v.getRuleId())).collect(Collectors.toList()));
                    }
                    BigDecimal sumAdjustAmount = dto.getRuleFetchCardList().stream().map(RuleFetchCardDto::getAdjustAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    dto.setAdjustAmount(sumAdjustAmount);
                    dto.setOriginAmount(dto.getRuleFetchCardList().stream().map(RuleFetchCardDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
                    dto.setLastAmount(BigDecimalUtil.addObject((Object)dto.getOriginAmount(), (Object)dto.getAdjustAmount()));
                    dto.setRuleFetchEditList(editEntry);
                }
            }
        });
        if (isCheckDb) {
            List ruleFetchCellSummaryList1 = calRuleFetchMainDto.getRuleFetchCellSummaryList();
            Map<Object, Object> reportItemGroup1 = new HashMap();
            if (!dynamicRowCal) {
                reportItemGroup1 = this.getCollectByReportItem(ruleFetchCellSummaryList1);
            }
            Map<String, List<RuleFetchCellSummaryDto>> reportItemGroup2 = this.getCollectByRuleItem(ruleFetchCellSummaryList1);
            for (RuleFetchCellSummaryDto dto2 : queryAllMainData.getRuleFetchCellSummaryList()) {
                boolean exist = false;
                if (!dynamicRowCal) {
                    if (EmptyCheckUtils.isNotEmpty((Object)dto2.getReportItem())) {
                        exist = reportItemGroup1.containsKey(dto2.getReportItem());
                    } else if (StringUtil.isNotEmpty((CharSequence)dto2.getRuleTable()) && StringUtil.isNotEmpty((CharSequence)dto2.getRuleId()) && StringUtil.isNotEmpty((CharSequence)dto2.getRuleItem())) {
                        exist = reportItemGroup2.containsKey(dto2.getRuleTable() + dto2.getRuleId() + dto2.getRuleItem());
                    }
                } else if (StringUtil.isNotEmpty((CharSequence)dto2.getRuleTable()) && StringUtil.isNotEmpty((CharSequence)dto2.getRuleId()) && StringUtil.isNotEmpty((CharSequence)dto2.getRuleItem())) {
                    exist = reportItemGroup2.containsKey(dto2.getRuleTable() + dto2.getRuleId() + dto2.getRuleItem());
                }
                if (exist) continue;
                calRuleFetchMainDto.getRuleFetchCellSummaryList().add(dto2);
            }
        }
        return calRuleFetchMainDto;
    }

    private Map<String, List<RuleFetchCellSummaryDto>> getCollectByReportItem(List<RuleFetchCellSummaryDto> ruleFetchCellSummaryList) {
        return ruleFetchCellSummaryList.stream().collect(Collectors.groupingBy(RuleFetchCellSummaryDto::getReportItem));
    }

    private Map<String, List<RuleFetchCellSummaryDto>> getCollectByRuleItem(List<RuleFetchCellSummaryDto> ruleFetchCellSummaryList) {
        return ruleFetchCellSummaryList.stream().collect(Collectors.groupingBy(dto -> dto.getRuleTable() + dto.getRuleId() + dto.getRuleItem()));
    }

    @Override
    public void saveTempRuleFetchAdjustData(Map<String, String> data, DeclareRequestModel requestModel) {
        LOGGER.info("\u5f39\u7a97\u4e34\u65f6\u8c03\u6574\u6570\u636e\u4fdd\u5b58\uff1adata - {}\uff0crequestModel - {}", data, (Object)requestModel);
        if (requestModel == null || !requestModel.getRefresh().booleanValue() || requestModel.getBusinessMap().get("draftpurpose") == null) {
            LOGGER.info("\u5f39\u7a97\u6570\u636e\u5927\u4fdd\u5b58\uff1a\u6570\u636e\u4e3a\u7a7a\uff0c\u4e14\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u5f53\u524d\u8bf7\u6c42\u4e3a\u67e5\u770b\u6001\uff0c\u4e0d\u518d\u8fdb\u884c\u6570\u636e\u66f4\u65b0\uff01");
            return;
        }
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto();
        ruleFetchMainDto.setOrgId(requestModel.getOrgId());
        ruleFetchMainDto.setTemplateId(requestModel.getTemplateId());
        ruleFetchMainDto.setSkssqq(DateUtils.stringToDate((String)requestModel.getSkssqq()));
        ruleFetchMainDto.setSkssqz(DateUtils.stringToDate((String)requestModel.getSkssqz()));
        ruleFetchMainDto.setPurpose((String)requestModel.getBusinessMap().get("draftpurpose"));
        ruleFetchMainDto.setDatastatus("0");
        ruleFetchMainDto.setTaxsystem(requestModel.getTaxationsys());
        String taxareagroup = requestModel.getBusinessValue("taxareagroup");
        ruleFetchMainDto.setTaxareagroup(Long.valueOf(taxareagroup == null ? 0L : Long.parseLong(taxareagroup)));
        this.supplementDefaultInfo(ruleFetchMainDto);
        DynamicObject mainData = this.getmainData(ruleFetchMainDto);
        if (mainData != null) {
            long mainDataId = mainData.getLong("id");
            RuleFetchMainDto dbTempData = this.querySetDbData(mainDataId);
            List<DynamicObject> summaryList = this.mergeCatchAndDbData(dbTempData, data, mainDataId);
            try (TXHandle h = TX.required();){
                try {
                    QFilter mainIdFilter = new QFilter("rulefetchmainid", "=", (Object)mainDataId);
                    DeleteServiceHelper.delete((String)"bdtaxr_rule_fetch_summary", (QFilter[])new QFilter[]{mainIdFilter});
                    mainData.set("createtime", (Object)new Date());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainData});
                    SaveServiceHelper.save((DynamicObject[])summaryList.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    h.markRollback();
                    LOGGER.error((Throwable)e);
                    throw e;
                }
            }
            return;
        }
        ruleFetchMainDto.setDatastatus("1");
        mainData = this.getmainData(ruleFetchMainDto);
        if (mainData != null) {
            long mainDataId = mainData.getLong("id");
            RuleFetchMainDto dbTempData = this.querySetDbData(mainDataId);
            long mainId = DBUtils.getLongId((String)"bdtaxr_rule_fetch_main");
            mainData = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)mainData);
            mainData.set("id", (Object)mainId);
            List<DynamicObject> summaryList = this.mergeCatchAndDbData(dbTempData, data, mainId);
            try (TXHandle h = TX.required();){
                try {
                    mainData.set("datastatus", (Object)"0");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainData});
                    SaveServiceHelper.save((DynamicObject[])summaryList.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    h.markRollback();
                    LOGGER.error((Throwable)e);
                    throw e;
                }
            }
            return;
        }
        if (!CollectionUtils.isEmpty(data)) {
            // empty if block
        }
    }

    private List<DynamicObject> mergeCatchAndDbData(RuleFetchMainDto dbSetData, Map<String, String> data, long mainDataId) {
        ArrayList<DynamicObject> summaryList = new ArrayList<DynamicObject>(32);
        if (CollectionUtils.isEmpty(data)) {
            summaryList.addAll(this.doConvertSummaryList1(dbSetData, mainDataId));
        } else if (data != null) {
            List ruleFetchCellSummaryList = dbSetData.getRuleFetchCellSummaryList();
            Map<String, List<RuleFetchCellSummaryDto>> reportItemGroup = this.getCollectByReportItem(ruleFetchCellSummaryList);
            Map<String, List<RuleFetchCellSummaryDto>> ruleitemGroup1 = this.getCollectByRuleItem(ruleFetchCellSummaryList);
            data.forEach((key, value) -> {
                RuleFetchCellSummaryDto dto = (RuleFetchCellSummaryDto)JSONObject.parseObject((String)value, RuleFetchCellSummaryDto.class);
                List summaryDtos = null;
                if (StringUtil.isNotEmpty((CharSequence)dto.getReportItem())) {
                    summaryDtos = (List)reportItemGroup.get(dto.getReportItem());
                } else if (StringUtil.isNotEmpty((CharSequence)dto.getRuleTable()) && StringUtil.isNotEmpty((CharSequence)dto.getRuleId()) && StringUtil.isNotEmpty((CharSequence)dto.getRuleItem())) {
                    summaryDtos = (List)ruleitemGroup1.get(dto.getRuleTable() + dto.getRuleId() + dto.getRuleItem());
                }
                if (!CollectionUtils.isEmpty((Collection)summaryDtos)) {
                    RuleFetchCellSummaryDto summary = (RuleFetchCellSummaryDto)summaryDtos.get(0);
                    summary.setAdjustAmount(dto.getAdjustAmount());
                    summary.setLastAmount(dto.getLastAmount());
                    List cardEntry = summary.getRuleFetchCardList();
                    List editEntry = summary.getRuleFetchEditList();
                    cardEntry.forEach(c -> {
                        Optional<RuleFetchCardDto> cardOp = dto.getRuleFetchCardList().stream().filter(v -> v.getRuleId().equals(String.valueOf(c.getRuleId()))).findFirst();
                        if (cardOp.isPresent()) {
                            RuleFetchCardDto ruleFetchCardDto = cardOp.get();
                            if (c.getAdjustAmount().compareTo(ruleFetchCardDto.getAdjustAmount()) != 0) {
                                this.addEditRecordObj(editEntry, (RuleFetchCardDto)c, ruleFetchCardDto);
                            }
                            c.setAdjustAmount(ruleFetchCardDto.getAdjustAmount());
                            c.setTotalAmount(ruleFetchCardDto.getTotalAmount());
                            c.setAdjustExplain(ruleFetchCardDto.getAdjustExplain());
                        }
                    });
                }
            });
            summaryList.addAll(this.doConvertSummaryList1(dbSetData, mainDataId));
        }
        return summaryList;
    }

    private RuleFetchMainDto querySetDbData(long mainDataId) {
        DynamicObject mainDataObj = BusinessDataServiceHelper.loadSingle((Object)mainDataId, (String)"bdtaxr_rule_fetch_main");
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto(Long.valueOf(mainDataObj.getLong("org.id")), mainDataObj.getDate("skssqq"), mainDataObj.getDate("skssqz"), Long.valueOf(mainDataObj.getLong("templateid")), mainDataObj.getString("purpose"));
        ruleFetchMainDto.setTaxsystem(Long.valueOf(mainDataObj.getLong("taxsystem.id")));
        ruleFetchMainDto.setTaxareagroup(Long.valueOf(mainDataObj.getLong("taxareagroup.id")));
        ruleFetchMainDto.setRuleFetchMainId(Long.valueOf(mainDataId));
        QFilter mainIdFilter = new QFilter("rulefetchmainid", "=", (Object)mainDataId);
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bdtaxr_rule_fetch_summary", (String)"id", (QFilter[])new QFilter[]{mainIdFilter});
        Object[] summids = Arrays.stream(ids).map(a -> a.get("id")).toArray();
        DynamicObject[] summarys = BusinessDataServiceHelper.load((Object[])summids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bdtaxr_rule_fetch_summary"));
        List ruleFetchCellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
        for (DynamicObject summary : summarys) {
            RuleFetchCellSummaryDto ruleFetchCellSummaryDto = new RuleFetchCellSummaryDto(summary.getString("ruletable"), summary.getString("ruleid"), summary.getString("ruleitem"), summary.getString("reportitem"), summary.getBigDecimal("amount"), summary.getBigDecimal("originamount"), summary.getBigDecimal("adjustamount"), summary.getBigDecimal("lastamount"));
            ruleFetchCellSummaryDto.setRuleFetchMainId(Long.valueOf(mainDataId));
            List ruleFetchCardList = ruleFetchCellSummaryDto.getRuleFetchCardList();
            DynamicObjectCollection cardentryentity = summary.getDynamicObjectCollection("cardentryentity");
            for (DynamicObject cardObj : cardentryentity) {
                RuleFetchCardDto ruleFetchCardDto = new RuleFetchCardDto(cardObj.getString("cardname"), cardObj.getString("cardruleid"), cardObj.getString("cardrulename"), Long.valueOf(cardObj.getLong("fetchorg.id")), cardObj.getBigDecimal("cardadjustamount"), cardObj.getBigDecimal("cardtotalamount"), cardObj.getString("adjustexplain"));
                ruleFetchCardDto.setAmount(cardObj.getBigDecimal("cardamount"));
                List ruleFetchDetailList = ruleFetchCardDto.getRuleFetchDetailList();
                DynamicObjectCollection detailentryentity = cardObj.getDynamicObjectCollection("detailentryentity");
                for (DynamicObject detailObj : detailentryentity) {
                    RuleFetchDetailDto ruleFetchDetailDto = new RuleFetchDetailDto(detailObj.getDate("startdate"), detailObj.getDate("enddate"), detailObj.getString("bizname"), Long.valueOf(detailObj.getLong("datasource.id")), Long.valueOf(detailObj.getLong("amountfield.id")), detailObj.getString("amounttype"), detailObj.getString("fetchtype"), detailObj.getString("fetchdirection"), detailObj.getBigDecimal("detailfetchamount"), detailObj.getBigDecimal("detailoriginamount"), detailObj.getString("absolute"), detailObj.getString("filtercondition"), detailObj.getString("conditionjson"));
                    ruleFetchDetailList.add(ruleFetchDetailDto);
                }
                ruleFetchCardList.add(ruleFetchCardDto);
            }
            List ruleFetchEditList = ruleFetchCellSummaryDto.getRuleFetchEditList();
            DynamicObjectCollection editentryentity = summary.getDynamicObjectCollection("editentryentity");
            for (DynamicObject editObj : editentryentity) {
                RuleFetchCardEditDto ruleFetchCardEditDto = new RuleFetchCardEditDto(editObj.getString("adjusttype"), editObj.getString("rulename"), Long.valueOf(editObj.getLong("editfetchorg.id")), editObj.getBigDecimal("preadjust"), editObj.getBigDecimal("editadjustamount"), editObj.getBigDecimal("postadjust"), editObj.getString("editadjustexplain"));
                ruleFetchCardEditDto.setCreator(editObj.getString("creator.id"));
                Date modifytime = editObj.getDate("modifytime");
                if (modifytime != null) {
                    ruleFetchCardEditDto.setCreateTime(DateUtils.formatHMS((Date)modifytime));
                }
                ruleFetchEditList.add(ruleFetchCardEditDto);
            }
            ruleFetchCellSummaryList.add(ruleFetchCellSummaryDto);
        }
        return ruleFetchMainDto;
    }

    @Override
    public void saveRuleFetchAdjustData(Map<String, String> data, DeclareRequestModel requestModel) {
        LOGGER.info("\u5f39\u7a97\u6570\u636e\u5927\u4fdd\u5b58\uff1adata - {}\uff0crequestModel - {}", data, (Object)requestModel);
        if (CollectionUtils.isEmpty(data)) {
            if (requestModel == null || !requestModel.getRefresh().booleanValue()) {
                LOGGER.info("\u5f39\u7a97\u6570\u636e\u5927\u4fdd\u5b58\uff1a\u6570\u636e\u4e3a\u7a7a\uff0c\u4e14\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u5f53\u524d\u8bf7\u6c42\u4e3a\u67e5\u770b\u6001\uff0c\u4e0d\u518d\u8fdb\u884c\u6570\u636e\u66f4\u65b0\uff01");
                return;
            }
            RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto();
            ruleFetchMainDto.setTemplateId(requestModel.getTemplateId());
            ruleFetchMainDto.setOrgId(requestModel.getOrgId());
            ruleFetchMainDto.setSkssqq(DateUtils.stringToDate((String)requestModel.getSkssqq()));
            ruleFetchMainDto.setSkssqz(DateUtils.stringToDate((String)requestModel.getSkssqz()));
            ruleFetchMainDto.setPurpose((String)requestModel.getBusinessMap().get("draftpurpose"));
            ruleFetchMainDto.setTaxsystem(requestModel.getTaxationsys());
            String taxareagroup = requestModel.getBusinessValue("taxareagroup");
            ruleFetchMainDto.setTaxareagroup(Long.valueOf(taxareagroup == null ? 0L : Long.parseLong(taxareagroup)));
            this.supplementDefaultInfo(ruleFetchMainDto);
            ruleFetchMainDto.setDatastatus("0");
            DynamicObject mainData = this.getmainData(ruleFetchMainDto);
            if (mainData == null) {
                return;
            }
            try (TXHandle h = TX.required();){
                try {
                    ruleFetchMainDto.setDatastatus("1");
                    this.delRuleFetchData(ruleFetchMainDto);
                    mainData.set("datastatus", (Object)"1");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainData});
                }
                catch (Exception e) {
                    h.markRollback();
                    LOGGER.error((Throwable)e);
                    throw e;
                }
            }
            return;
        }
        if (data != null) {
            ArrayList summaryList = new ArrayList(data.size());
            ArrayList mainDataObj = new ArrayList(16);
            ArrayList mainData = new ArrayList(16);
            data.forEach((key, value) -> {
                RuleFetchCellSummaryDto dto = (RuleFetchCellSummaryDto)JSONObject.parseObject((String)value, RuleFetchCellSummaryDto.class);
                mainData.add(this.geMainDataById(dto.getRuleFetchMainId(), mainDataObj, mainData));
                DynamicObject summary = this.getFetchDetail(new QueryRuleFetchParam(dto));
                summary.set("adjustamount", (Object)dto.getAdjustAmount());
                summary.set("lastamount", (Object)dto.getLastAmount());
                DynamicObjectCollection cardEntry = summary.getDynamicObjectCollection("cardentryentity");
                DynamicObjectCollection editEntry = summary.getDynamicObjectCollection("editentryentity");
                cardEntry.forEach(c -> {
                    Optional<RuleFetchCardDto> cardOp = dto.getRuleFetchCardList().stream().filter(v -> v.getRuleId().equals(String.valueOf(c.getLong("cardruleid")))).findFirst();
                    if (cardOp.isPresent()) {
                        RuleFetchCardDto ruleFetchCardDto = cardOp.get();
                        if (c.getBigDecimal("cardadjustamount").compareTo(ruleFetchCardDto.getAdjustAmount()) != 0) {
                            this.addEditRecord(editEntry, (DynamicObject)c, ruleFetchCardDto);
                        }
                        this.modifyCard((DynamicObject)c, ruleFetchCardDto);
                    }
                });
                summaryList.add(summary);
            });
            RuleFetchMainDto ruleFetchMainDto = (RuleFetchMainDto)mainData.get(0);
            String dataStatus = ruleFetchMainDto.getDatastatus();
            try (TXHandle h = TX.required();){
                try {
                    if ("0".equals(dataStatus)) {
                        ruleFetchMainDto.setDatastatus("1");
                        this.delRuleFetchData(ruleFetchMainDto);
                        DynamicObject mainObject = (DynamicObject)mainDataObj.get(0);
                        mainObject.set("datastatus", (Object)"1");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject});
                    }
                    SaveServiceHelper.save((DynamicObject[])summaryList.toArray(new DynamicObject[0]));
                }
                catch (Exception e) {
                    h.markRollback();
                    LOGGER.error((Throwable)e);
                    throw e;
                }
            }
        }
    }

    @Override
    public void delRuleFetchData(Long ruleFetchMainId) {
        LOGGER.info("delRuleFetchData,param:{}", (Object)ruleFetchMainId);
        this.delRuleFetchDataByIds(Collections.singletonList(ruleFetchMainId));
    }

    private void delRuleFetchDataByIds(List<Long> ruleFetchMainIds) {
        try (TXHandle h = TX.required();){
            try {
                QFilter idFilter = new QFilter("id", "in", ruleFetchMainIds);
                DeleteServiceHelper.delete((String)"bdtaxr_rule_fetch_main", (QFilter[])new QFilter[]{idFilter});
                QFilter mainIdFilter = new QFilter("rulefetchmainid", "in", ruleFetchMainIds);
                DeleteServiceHelper.delete((String)"bdtaxr_rule_fetch_summary", (QFilter[])new QFilter[]{mainIdFilter});
            }
            catch (Exception e) {
                h.markRollback();
                LOGGER.error((Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void delRuleFetchData(RuleFetchMainDto ruleFetchMainDto) {
        this.supplementDefaultInfo(ruleFetchMainDto);
        List<Long> ruleFetchMainIds = RuleFetchServiceHandler.getRuleFetchMainIds(ruleFetchMainDto);
        this.delRuleFetchDataByIds(ruleFetchMainIds);
    }

    @Override
    public void delRuleFetchData(List<RuleFetchMainDto> ruleFetchMainDtoList) {
        if (CollectionUtils.isEmpty(ruleFetchMainDtoList)) {
            return;
        }
        this.delRuleFetchDataByIds(ruleFetchMainDtoList.stream().map(a -> {
            this.supplementDefaultInfo((RuleFetchMainDto)a);
            return a;
        }).flatMap(b -> RuleFetchServiceHandler.getRuleFetchMainIds(b).stream()).collect(Collectors.toList()));
    }

    private RuleFetchMainDto geMainDataById(long ruleFetchMainId, List<DynamicObject> mainDataObjs, List<RuleFetchMainDto> mainDatas) {
        RuleFetchMainDto ruleFetchMainDto = new RuleFetchMainDto();
        QFilter mainIdFilter = new QFilter("id", "=", (Object)ruleFetchMainId);
        DynamicObject[] mainDataObj = BusinessDataServiceHelper.load((String)"bdtaxr_rule_fetch_main", (String)"templateid,org,skssqq,skssqz,datastatus,taxsystem,taxareagroup,purpose", (QFilter[])new QFilter[]{mainIdFilter});
        if (mainDataObj.length == 0) {
            return ruleFetchMainDto;
        }
        DynamicObject mainData = mainDataObj[0];
        mainDataObjs.add(mainData);
        long templateId = mainData.getLong("templateid");
        long org = mainData.getLong("org.id");
        Date skssqq = mainData.getDate("skssqq");
        Date skssqz = mainData.getDate("skssqz");
        String dataStatus = mainData.getString("datastatus");
        ruleFetchMainDto.setOrgId(Long.valueOf(org));
        ruleFetchMainDto.setSkssqq(skssqq);
        ruleFetchMainDto.setSkssqz(skssqz);
        ruleFetchMainDto.setTemplateId(Long.valueOf(templateId));
        ruleFetchMainDto.setDatastatus(dataStatus);
        ruleFetchMainDto.setPurpose(mainData.getString("purpose"));
        ruleFetchMainDto.setTaxsystem(Long.valueOf(mainData.getLong("taxsystem.id")));
        ruleFetchMainDto.setTaxareagroup(Long.valueOf(mainData.getLong("taxareagroup.id")));
        mainDatas.add(ruleFetchMainDto);
        return ruleFetchMainDto;
    }

    public long existedMainId(RuleFetchMainDto ruleFetchMainDto) {
        LOGGER.info("\u4e0b\u94bb\u5361\u7247\u6570\u636e --- \u7ec4\u7ec7id\uff1a{}\uff0c\u6240\u5c5e\u671f\u8d77\uff1a{}\uff0c\u6240\u5c5e\u671f\u6b62\uff1a{}\uff0c\u5e95\u7a3f\u7528\u9014\uff1a{}\uff0c\u6570\u636e\u72b6\u6001\uff1a{}\uff0c\u7a0e\u5236\uff1a{}\uff0c\u8f96\u533a\uff1a{}, ruleFetchMainId:{}, templateId:{}, customEvent:{}", new Object[]{ruleFetchMainDto.getOrgId(), ruleFetchMainDto.getSkssqq(), ruleFetchMainDto.getSkssqz(), ruleFetchMainDto.getPurpose(), ruleFetchMainDto.getDatastatus(), ruleFetchMainDto.getTaxsystem(), ruleFetchMainDto.getTaxareagroup(), ruleFetchMainDto.getRuleFetchMainId(), ruleFetchMainDto.getTemplateId(), ruleFetchMainDto.getCustomEvent()});
        this.supplementDefaultInfo(ruleFetchMainDto);
        DynamicObject mainObj = this.getmainData(ruleFetchMainDto);
        return mainObj == null ? 0L : mainObj.getLong("id");
    }

    private void supplementDefaultInfo(RuleFetchMainDto ruleFetchMainDto) {
        if (ruleFetchMainDto != null) {
            if (StringUtil.isEmpty((CharSequence)ruleFetchMainDto.getDatastatus())) {
                ruleFetchMainDto.setDatastatus("0");
            }
            Long taxsystem = ruleFetchMainDto.getTaxsystem();
            Long taxareagroup = ruleFetchMainDto.getTaxareagroup();
            if (taxsystem == null || Objects.equals(taxsystem, 0L)) {
                ruleFetchMainDto.setTaxsystem(DEFALUT_TAXSYSTEM);
            }
            if (taxareagroup == null || Objects.equals(taxareagroup, 0L)) {
                ruleFetchMainDto.setTaxareagroup(DEFALUT_TAXAREAGROUP);
            }
        }
    }

    private DynamicObject getmainData(RuleFetchMainDto ruleFetchMainDto) {
        QFilter templateIdFilter = new QFilter("templateid", "=", (Object)ruleFetchMainDto.getTemplateId());
        QFilter orgFilter = new QFilter("org", "=", (Object)ruleFetchMainDto.getOrgId());
        QFilter skssqqFilter = new QFilter("skssqq", "=", (Object)ruleFetchMainDto.getSkssqq());
        QFilter skssqzFilter = new QFilter("skssqz", "=", (Object)ruleFetchMainDto.getSkssqz());
        QFilter purposeFilter = new QFilter("purpose", "=", (Object)ruleFetchMainDto.getPurpose());
        QFilter taxsystemFilter = new QFilter("taxsystem", "=", (Object)ruleFetchMainDto.getTaxsystem());
        QFilter taxareagroupFilter = new QFilter("taxareagroup", "=", (Object)ruleFetchMainDto.getTaxareagroup());
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)ruleFetchMainDto.getDatastatus());
        DynamicObject[] mainIds = BusinessDataServiceHelper.load((String)"bdtaxr_rule_fetch_main", (String)"id,org,skssqq,skssqz,templateid,creater,createtime,purpose,datastatus,taxsystem,taxareagroup,createtime", (QFilter[])new QFilter[]{templateIdFilter, orgFilter, skssqqFilter, skssqzFilter, purposeFilter, dataStatusFilter, taxsystemFilter, taxareagroupFilter});
        return mainIds.length == 0 ? null : mainIds[0];
    }

    private DynamicObject doPackageMainDto(RuleFetchMainDto ruleFetchMainDto, long mainId) {
        DynamicObject main = this.getmainData(ruleFetchMainDto);
        if (main == null || ObjectUtils.isEmpty((Object)main)) {
            main = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_rule_fetch_main");
            long mainIds = DBUtils.getLongId((String)"bdtaxr_rule_fetch_main");
            main.set("id", (Object)mainIds);
            main.set("taxsystem", (Object)DEFALUT_TAXSYSTEM);
            main.set("taxareagroup", (Object)DEFALUT_TAXAREAGROUP);
        }
        main.set("org", (Object)ruleFetchMainDto.getOrgId());
        main.set("skssqq", (Object)ruleFetchMainDto.getSkssqq());
        main.set("skssqz", (Object)ruleFetchMainDto.getSkssqz());
        main.set("templateid", (Object)ruleFetchMainDto.getTemplateId());
        main.set("purpose", (Object)ruleFetchMainDto.getPurpose());
        main.set("taxsystem", (Object)ruleFetchMainDto.getTaxsystem());
        main.set("taxareagroup", (Object)ruleFetchMainDto.getTaxareagroup());
        main.set("creater", (Object)RequestContext.get().getUserId());
        main.set("createtime", (Object)new Date());
        main.set("datastatus", (Object)ruleFetchMainDto.getDatastatus());
        return main;
    }

    private List<DynamicObject> doConvertSummaryList(RuleFetchMainDto ruleFetchMainDto, long mainId) {
        List ruleFetchCellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
        if (ruleFetchCellSummaryList == null) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(ruleFetchCellSummaryList.size());
        for (RuleFetchCellSummaryDto ruleFetchCellSummaryDto : ruleFetchCellSummaryList) {
            DynamicObject summary = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_rule_fetch_summary");
            summary.set("rulefetchmainid", (Object)mainId);
            summary.set("org", (Object)ruleFetchMainDto.getOrgId());
            summary.set("skssqq", (Object)ruleFetchMainDto.getSkssqq());
            summary.set("skssqz", (Object)ruleFetchMainDto.getSkssqz());
            summary.set("ruletable", (Object)ruleFetchCellSummaryDto.getRuleTable());
            summary.set("ruleid", (Object)ruleFetchCellSummaryDto.getRuleId());
            summary.set("ruleitem", (Object)ruleFetchCellSummaryDto.getRuleItem());
            summary.set("reportitem", (Object)ruleFetchCellSummaryDto.getReportItem());
            summary.set("amount", (Object)ruleFetchCellSummaryDto.getAmount());
            summary.set("originamount", (Object)ruleFetchCellSummaryDto.getAmount());
            summary.set("lastamount", (Object)ruleFetchCellSummaryDto.getAmount());
            this.doConvertCardList(ruleFetchCellSummaryDto, summary);
            list.add(summary);
        }
        return list;
    }

    private List<DynamicObject> doConvertSummaryListByReportItems(RuleFetchMainDto ruleFetchMainDto, long mainId, List<String> reportItems) {
        List ruleFetchCellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
        if (ruleFetchCellSummaryList == null) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(ruleFetchCellSummaryList.size());
        for (RuleFetchCellSummaryDto ruleFetchCellSummaryDto : ruleFetchCellSummaryList) {
            if (reportItems.contains(ruleFetchCellSummaryDto.getReportItem())) continue;
            DynamicObject summary = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_rule_fetch_summary");
            summary.set("rulefetchmainid", (Object)mainId);
            summary.set("org", (Object)ruleFetchMainDto.getOrgId());
            summary.set("skssqq", (Object)ruleFetchMainDto.getSkssqq());
            summary.set("skssqz", (Object)ruleFetchMainDto.getSkssqz());
            summary.set("ruletable", (Object)ruleFetchCellSummaryDto.getRuleTable());
            summary.set("ruleid", (Object)ruleFetchCellSummaryDto.getRuleId());
            summary.set("ruleitem", (Object)ruleFetchCellSummaryDto.getRuleItem());
            summary.set("reportitem", (Object)ruleFetchCellSummaryDto.getReportItem());
            summary.set("amount", (Object)ruleFetchCellSummaryDto.getAmount());
            summary.set("originamount", (Object)ruleFetchCellSummaryDto.getAmount());
            summary.set("lastamount", (Object)ruleFetchCellSummaryDto.getAmount());
            this.doConvertCardList(ruleFetchCellSummaryDto, summary);
            list.add(summary);
        }
        return list;
    }

    private void doConvertCardList(RuleFetchCellSummaryDto ruleFetchCellSummaryDto, DynamicObject summary) {
        DynamicObjectCollection cardEntry = summary.getDynamicObjectCollection("cardentryentity");
        List ruleFetchCardList = ruleFetchCellSummaryDto.getRuleFetchCardList();
        boolean notManualRecord = true;
        String manualStr = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"RuleFetchServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)ruleFetchCardList)) {
            for (RuleFetchCardDto ruleFetchCardDto : ruleFetchCardList) {
                DynamicObject card = cardEntry.addNew();
                card.set("cardname", (Object)ruleFetchCardDto.getCardName());
                if (manualStr.equals("cardname")) {
                    notManualRecord = false;
                }
                card.set("fetchorg", (Object)ruleFetchCardDto.getFetchOrg());
                card.set("cardruleid", (Object)ruleFetchCardDto.getRuleId());
                card.set("cardrulename", (Object)ruleFetchCardDto.getRuleName());
                card.set("cardamount", (Object)ruleFetchCardDto.getAmount());
                card.set("cardtotalamount", (Object)ruleFetchCardDto.getAmount());
                this.doConvertDetailList(ruleFetchCardDto, card);
            }
        }
        if (notManualRecord) {
            this.doCreateManualCard(cardEntry.addNew());
        }
    }

    private List<DynamicObject> doConvertSummaryList1(RuleFetchMainDto ruleFetchMainDto, long mainId) {
        List ruleFetchCellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
        if (ruleFetchCellSummaryList == null) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(ruleFetchCellSummaryList.size());
        for (RuleFetchCellSummaryDto ruleFetchCellSummaryDto : ruleFetchCellSummaryList) {
            DynamicObject summary = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_rule_fetch_summary");
            summary.set("rulefetchmainid", (Object)mainId);
            summary.set("org", (Object)ruleFetchMainDto.getOrgId());
            summary.set("skssqq", (Object)ruleFetchMainDto.getSkssqq());
            summary.set("skssqz", (Object)ruleFetchMainDto.getSkssqz());
            summary.set("ruletable", (Object)ruleFetchCellSummaryDto.getRuleTable());
            summary.set("ruleid", (Object)ruleFetchCellSummaryDto.getRuleId());
            summary.set("ruleitem", (Object)ruleFetchCellSummaryDto.getRuleItem());
            summary.set("reportitem", (Object)ruleFetchCellSummaryDto.getReportItem());
            summary.set("amount", (Object)ruleFetchCellSummaryDto.getAmount());
            summary.set("originamount", (Object)ruleFetchCellSummaryDto.getOriginAmount());
            summary.set("adjustamount", (Object)ruleFetchCellSummaryDto.getAdjustAmount());
            summary.set("lastamount", (Object)ruleFetchCellSummaryDto.getLastAmount());
            this.doConvertCardList1(ruleFetchCellSummaryDto, summary);
            this.doConvertEditList(ruleFetchCellSummaryDto, summary);
            list.add(summary);
        }
        return list;
    }

    private List<DynamicObject> doConvertSummaryList1ByReportItems(RuleFetchMainDto ruleFetchMainDto, long mainId, List<String> reportItems) {
        List ruleFetchCellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
        if (ruleFetchCellSummaryList == null) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(ruleFetchCellSummaryList.size());
        for (RuleFetchCellSummaryDto ruleFetchCellSummaryDto : ruleFetchCellSummaryList) {
            if (reportItems.contains(ruleFetchCellSummaryDto.getReportItem())) continue;
            DynamicObject summary = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_rule_fetch_summary");
            summary.set("rulefetchmainid", (Object)mainId);
            summary.set("org", (Object)ruleFetchMainDto.getOrgId());
            summary.set("skssqq", (Object)ruleFetchMainDto.getSkssqq());
            summary.set("skssqz", (Object)ruleFetchMainDto.getSkssqz());
            summary.set("ruletable", (Object)ruleFetchCellSummaryDto.getRuleTable());
            summary.set("ruleid", (Object)ruleFetchCellSummaryDto.getRuleId());
            summary.set("ruleitem", (Object)ruleFetchCellSummaryDto.getRuleItem());
            summary.set("reportitem", (Object)ruleFetchCellSummaryDto.getReportItem());
            summary.set("amount", (Object)ruleFetchCellSummaryDto.getAmount());
            summary.set("originamount", (Object)ruleFetchCellSummaryDto.getOriginAmount());
            summary.set("adjustamount", (Object)ruleFetchCellSummaryDto.getAdjustAmount());
            summary.set("lastamount", (Object)ruleFetchCellSummaryDto.getLastAmount());
            this.doConvertCardList1(ruleFetchCellSummaryDto, summary);
            this.doConvertEditList(ruleFetchCellSummaryDto, summary);
            list.add(summary);
        }
        return list;
    }

    private void doConvertEditList(RuleFetchCellSummaryDto ruleFetchCellSummaryDto, DynamicObject summary) {
        DynamicObjectCollection editEntry = summary.getDynamicObjectCollection("editentryentity");
        List ruleFetchEditList = ruleFetchCellSummaryDto.getRuleFetchEditList();
        if (!CollectionUtils.isEmpty((Collection)ruleFetchEditList)) {
            for (RuleFetchCardEditDto editDto : ruleFetchEditList) {
                DynamicObject edit = editEntry.addNew();
                edit.set("adjusttype", (Object)editDto.getAdjustType());
                edit.set("rulename", (Object)editDto.getRuleName());
                edit.set("editfetchorg", (Object)editDto.getFetchOrg());
                edit.set("preadjust", (Object)editDto.getPreAdjust());
                edit.set("editadjustamount", (Object)editDto.getAdjustAmount());
                edit.set("postadjust", (Object)editDto.getPostAdjust());
                edit.set("editadjustexplain", (Object)editDto.getAdjustExplain());
                edit.set("creator", (Object)(editDto.getCreator() == null ? 0L : Long.parseLong(editDto.getCreator())));
                edit.set("modifytime", editDto.getCreateTime() == null ? null : DateUtils.stringToDate2((String)editDto.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
        }
    }

    private void doConvertCardList1(RuleFetchCellSummaryDto ruleFetchCellSummaryDto, DynamicObject summary) {
        DynamicObjectCollection cardEntry = summary.getDynamicObjectCollection("cardentryentity");
        List ruleFetchCardList = ruleFetchCellSummaryDto.getRuleFetchCardList();
        boolean notManualRecord = true;
        String manualStr = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"RuleFetchServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)ruleFetchCardList)) {
            for (RuleFetchCardDto ruleFetchCardDto : ruleFetchCardList) {
                DynamicObject card = cardEntry.addNew();
                String cardName = ruleFetchCardDto.getCardName();
                card.set("cardname", (Object)cardName);
                if (manualStr.equals(cardName)) {
                    notManualRecord = false;
                }
                card.set("fetchorg", (Object)ruleFetchCardDto.getFetchOrg());
                card.set("cardruleid", (Object)ruleFetchCardDto.getRuleId());
                card.set("cardrulename", (Object)ruleFetchCardDto.getRuleName());
                card.set("cardamount", (Object)ruleFetchCardDto.getAmount());
                card.set("cardtotalamount", (Object)ruleFetchCardDto.getTotalAmount());
                card.set("cardadjustamount", (Object)ruleFetchCardDto.getAdjustAmount());
                card.set("adjustexplain", (Object)ruleFetchCardDto.getAdjustExplain());
                this.doConvertDetailList(ruleFetchCardDto, card);
            }
        }
        if (notManualRecord) {
            this.doCreateManualCard(cardEntry.addNew());
        }
    }

    private void doCreateManualCard(DynamicObject manualCard) {
        manualCard.set("cardname", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"RuleFetchServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
    }

    private void doConvertDetailList(RuleFetchCardDto ruleFetchCardDto, DynamicObject card) {
        DynamicObjectCollection detailEntry = card.getDynamicObjectCollection("detailentryentity");
        List ruleFetchDetailList = ruleFetchCardDto.getRuleFetchDetailList();
        for (RuleFetchDetailDto ruleFetchDetailDto : ruleFetchDetailList) {
            DynamicObject detail = detailEntry.addNew();
            detail.set("startdate", (Object)ruleFetchDetailDto.getSkssqq());
            detail.set("enddate", (Object)ruleFetchDetailDto.getSkssqz());
            String bizName = ruleFetchDetailDto.getBizName();
            detail.set("bizname", bizName == null ? null : (bizName.length() > 50 ? bizName.substring(0, 50) : bizName));
            detail.set("datasource", (Object)ruleFetchDetailDto.getDataSource());
            detail.set("amountfield", (Object)ruleFetchDetailDto.getAmountField());
            detail.set("fetchtype", (Object)ruleFetchDetailDto.getFetchType());
            detail.set("fetchdirection", (Object)ruleFetchDetailDto.getFetchDirection());
            detail.set("detailfetchamount", (Object)ruleFetchDetailDto.getFetchAmount());
            detail.set("detailoriginamount", (Object)ruleFetchDetailDto.getOriginAmount());
            detail.set("absolute", (Object)ruleFetchDetailDto.getAbsolute());
            detail.set("filtercondition", (Object)ruleFetchDetailDto.getFilterCondition());
            detail.set("conditionjson", (Object)ruleFetchDetailDto.getConditionJson());
            detail.set("advancedconfjson", (Object)ruleFetchDetailDto.getAdvancedconfjson());
            detail.set("amounttype", (Object)ruleFetchDetailDto.getAmountType());
        }
    }

    private void addEditRecord(DynamicObjectCollection editEntry, DynamicObject cardObj, RuleFetchCardDto ruleFetchCardDto) {
        DynamicObject editRecord = editEntry.addNew();
        String manualAdjust = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"RuleFetchServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        boolean isManualAdjust = manualAdjust.equals(ruleFetchCardDto.getCardName());
        editRecord.set("adjusttype", (Object)(isManualAdjust ? 2 : 1));
        editRecord.set("rulename", (Object)(isManualAdjust ? "--" : ruleFetchCardDto.getRuleName()));
        if (!isManualAdjust) {
            editRecord.set("editfetchorg", (Object)ruleFetchCardDto.getFetchOrg());
            editRecord.set("preadjust", cardObj.get("cardtotalamount"));
        }
        editRecord.set("editadjustamount", (Object)ruleFetchCardDto.getAdjustAmount());
        editRecord.set("postadjust", (Object)(isManualAdjust ? ruleFetchCardDto.getAdjustAmount() : ruleFetchCardDto.getTotalAmount()));
        editRecord.set("editadjustexplain", (Object)ruleFetchCardDto.getAdjustExplain());
        editRecord.set("creator", (Object)RequestContext.get().getCurrUserId());
        editRecord.set("modifytime", (Object)new Date());
    }

    private void addEditRecordObj(List<RuleFetchCardEditDto> editEntry, RuleFetchCardDto cardObj, RuleFetchCardDto ruleFetchCardDto) {
        RuleFetchCardEditDto editRecord = new RuleFetchCardEditDto();
        String manualAdjust = ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"RuleFetchServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        boolean isManualAdjust = manualAdjust.equals(ruleFetchCardDto.getCardName());
        editRecord.setAdjustType(isManualAdjust ? "2" : "1");
        editRecord.setRuleName(isManualAdjust ? "--" : ruleFetchCardDto.getRuleName());
        if (!isManualAdjust) {
            editRecord.setFetchOrg(ruleFetchCardDto.getFetchOrg());
            editRecord.setPreAdjust(cardObj.getTotalAmount());
        }
        editRecord.setAdjustAmount(ruleFetchCardDto.getAdjustAmount());
        editRecord.setPostAdjust(isManualAdjust ? ruleFetchCardDto.getAdjustAmount() : ruleFetchCardDto.getTotalAmount());
        editRecord.setAdjustExplain(ruleFetchCardDto.getAdjustExplain());
        editRecord.setCreator(String.valueOf(RequestContext.get().getCurrUserId()));
        editRecord.setCreateTime(DateUtils.formatHMS((Date)new Date()));
        editEntry.add(editRecord);
    }

    private void modifyCard(DynamicObject c, RuleFetchCardDto ruleFetchCardDto) {
        c.set("cardadjustamount", (Object)ruleFetchCardDto.getAdjustAmount());
        c.set("cardtotalamount", (Object)ruleFetchCardDto.getTotalAmount());
        c.set("adjustexplain", (Object)ruleFetchCardDto.getAdjustExplain());
    }
}

