/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.sharingscheme;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.service.sharingscheme.SharingSchemeAutoSharService;
import kd.taxc.bdtaxr.common.constant.tctb.TaxcMainConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.OrgServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class SharingSchemeAutoSharServiceImpl
implements SharingSchemeAutoSharService {
    private static final Log LOGGER = LogFactory.getLog(SharingSchemeAutoSharServiceImpl.class);
    private static final String TCVVT_SHARINGPLAN = "tcvvt_sharingplan";
    private static final String TCVAT_SBX_SHAREPLAN_FORM = "tcvat_sbx_shareplan";

    private Long getCurrentParent(Long orgid) {
        HashMap<String, List<Long>> condition = new HashMap<String, List<Long>>(4);
        condition.put("id", Collections.singletonList(orgid));
        List list = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"queryOrgListByCondition", (Object[])new Object[]{condition});
        if (EmptyCheckUtils.isNotEmpty((Object)list)) {
            Long parentid = (Long)((Map)list.get(0)).get("parentid");
            return parentid;
        }
        return null;
    }

    private Long getOldParent(Long orgid) {
        Long oldParent = null;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bdtaxr_old_org_parent_rec", (String)"oldparent,newparent", (QFilter[])new QFilter("id", "=", (Object)orgid).toArray());
        if (dynamicObject != null) {
            oldParent = dynamicObject.getLong("oldparent");
        }
        return oldParent;
    }

    private Boolean hasSharingScheme(Long orgid, Long parent, Long acctStdId) {
        if (parent != null && parent > 0L) {
            QFilter qFilter = new QFilter("org", "=", (Object)parent).and("planentity.entryautoshar", "=", (Object)Boolean.TRUE);
            String taxpayerType = this.getTaxpayerType(orgid);
            QFilter qFilter1 = new QFilter("createorg", "=", (Object)parent).and("autoshare", "=", (Object)Boolean.TRUE).and("accountstandard", "=", (Object)acctStdId);
            for (String entity : SHARING_SCHEME_ENTITY) {
                boolean exists;
                if (StringUtil.equalsIgnoreCase((CharSequence)entity, (CharSequence)TCVVT_SHARINGPLAN)) {
                    exists = QueryServiceHelper.exists((String)TCVVT_SHARINGPLAN, (QFilter[])qFilter1.toArray());
                    if (!exists) continue;
                    return Boolean.TRUE;
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)entity, (CharSequence)TCVAT_SBX_SHAREPLAN_FORM)) {
                    if (!StringUtil.isNotEmpty((CharSequence)taxpayerType)) continue;
                    QFilter sbxFilter = new QFilter("createorg", "=", (Object)parent).and("autoshar", "=", (Object)Boolean.TRUE);
                    sbxFilter.and(new QFilter("taxpayertype", "=", (Object)taxpayerType));
                    boolean exists2 = QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{sbxFilter});
                    if (!exists2) continue;
                    return Boolean.TRUE;
                }
                if (!(StringUtil.equalsIgnoreCase((CharSequence)entity, (CharSequence)"tccit_sbx_shareplan") ? (exists = QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter("createorg", "=", (Object)parent).and("autoshar", "=", (Object)Boolean.TRUE).toArray())) : (exists = QueryServiceHelper.exists((String)entity, (QFilter[])qFilter.toArray())))) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private Boolean includedSharingScheme(Long orgid, Long oldParent) {
        if (oldParent != null && oldParent > 0L && orgid != null && orgid > 0L) {
            QFilter qFilter = new QFilter("org", "=", (Object)oldParent).and("planentity.entryautoshar", "=", (Object)Boolean.TRUE);
            qFilter.and("planentity.orgentity.orgid", "=", (Object)orgid);
            String taxpayerType = this.getTaxpayerType(orgid);
            DynamicObjectCollection taxOrg = OrgUtils.queryTaxOrg((String)"accountingstandards", (QFilter)new QFilter("orgid.id", "=", (Object)orgid));
            Long acctStdId = ((DynamicObject)taxOrg.get(0)).getLong("accountingstandards");
            QFilter qFilter1 = new QFilter("createorg", "=", (Object)oldParent).and("autoshare", "=", (Object)Boolean.TRUE).and("accountstandard", "=", (Object)acctStdId);
            qFilter1.and("orgentity.org", "=", (Object)orgid);
            for (String entity : SHARING_SCHEME_ENTITY) {
                boolean exists;
                if (StringUtil.equalsIgnoreCase((CharSequence)entity, (CharSequence)TCVVT_SHARINGPLAN)) {
                    exists = QueryServiceHelper.exists((String)TCVVT_SHARINGPLAN, (QFilter[])qFilter1.toArray());
                    if (!exists) continue;
                    return Boolean.TRUE;
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)entity, (CharSequence)TCVAT_SBX_SHAREPLAN_FORM)) {
                    if (!StringUtil.isNotEmpty((CharSequence)taxpayerType)) continue;
                    QFilter sbxFilter = new QFilter("createorg", "=", (Object)oldParent).and("autoshar", "=", (Object)Boolean.TRUE);
                    sbxFilter.and("orgentity.org", "=", (Object)orgid);
                    sbxFilter.and(new QFilter("taxpayertype", "=", (Object)taxpayerType));
                    boolean exists2 = QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{sbxFilter});
                    if (!exists2) continue;
                    return Boolean.TRUE;
                }
                if (!(StringUtil.equalsIgnoreCase((CharSequence)entity, (CharSequence)"tccit_sbx_shareplan") ? (exists = QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter("createorg", "=", (Object)oldParent).and("autoshar", "=", (Object)Boolean.TRUE).and("orgentity.org", "=", (Object)orgid).toArray())) : (exists = QueryServiceHelper.exists((String)entity, (QFilter[])qFilter.toArray())))) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public Map<String, Object> getJudgeConditions(Long orgid) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DynamicObjectCollection taxOrg = OrgUtils.queryTaxOrg((String)"accountingstandards", (QFilter)new QFilter("orgid.id", "=", (Object)orgid));
        Long acctStdId = ((DynamicObject)taxOrg.get(0)).getLong("accountingstandards");
        if (orgid == null || orgid <= 0L) {
            throw new KDBizException("Invalid paramas");
        }
        Long currentParent = this.getCurrentParent(orgid);
        this.updateParentRecord(orgid, currentParent);
        Long oldParent = this.getOldParent(orgid);
        Boolean isChangedParent = !Objects.equals(oldParent, currentParent);
        Boolean hasOldSharingScheme = this.hasSharingScheme(orgid, oldParent, acctStdId);
        Boolean hasNewSharingScheme = isChangedParent != false ? this.hasSharingScheme(orgid, currentParent, acctStdId) : hasOldSharingScheme;
        Boolean includedOldSharingScheme = hasOldSharingScheme != false ? this.includedSharingScheme(orgid, oldParent) : Boolean.FALSE;
        Boolean includedNewSharingScheme = hasNewSharingScheme != false ? this.includedSharingScheme(orgid, currentParent) : Boolean.FALSE;
        result.put("getCurrentParent", currentParent);
        result.put("isChangedParent", isChangedParent);
        result.put("hasOldSharingScheme", hasOldSharingScheme);
        result.put("hasNewSharingScheme", hasNewSharingScheme);
        result.put("includedOldSharingScheme", includedOldSharingScheme);
        result.put("includedNewSharingScheme", includedNewSharingScheme);
        return result;
    }

    @Override
    public ApiResult addToSharingScheme(Long orgid) {
        if (orgid != null && orgid > 0L) {
            Long currentParent = this.getCurrentParent(orgid);
            ArrayList saveList = new ArrayList();
            if (currentParent != null && currentParent > 0L) {
                String taxpayerType = this.getTaxpayerType(orgid);
                QFilter qFilter = new QFilter("org", "=", (Object)currentParent).and("planentity.entryautoshar", "=", (Object)Boolean.TRUE);
                DynamicObjectCollection taxOrg = OrgUtils.queryTaxOrg((String)"accountingstandards", (QFilter)new QFilter("orgid.id", "=", (Object)orgid));
                Long apiResult = ((DynamicObject)taxOrg.get(0)).getLong("accountingstandards");
                QFilter qFilter1 = new QFilter("createorg", "=", (Object)currentParent).and("autoshare", "=", (Object)Boolean.TRUE).and("accountstandard", "=", (Object)apiResult);
                for (String entity : SHARING_SCHEME_ENTITY) {
                    ArrayList<DynamicObject> dynamicObjects;
                    DynamicObject[] recs;
                    List ids;
                    QFilter[] qFilters;
                    QFilter sbxFilter;
                    if (StringUtil.equalsIgnoreCase((CharSequence)entity, (CharSequence)TCVVT_SHARINGPLAN)) {
                        DynamicObject newSharingScheme = BusinessDataServiceHelper.loadSingle((String)TCVVT_SHARINGPLAN, (String)"orgentity.org", (QFilter[])qFilter1.toArray());
                        if (null == newSharingScheme) continue;
                        ArrayList<DynamicObject> dynamicObjects2 = new ArrayList<DynamicObject>(16);
                        DynamicObjectCollection collection = OrgServiceHelper.queryEnableOrgs((String)"id", null);
                        List orgIds = collection.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                        QFilter enables = new QFilter("taxorg", "in", orgIds);
                        DynamicObjectCollection qualifiedOrgs = OrgUtils.queryTaxOrg((String)"orgid.id as id", (QFilter)enables);
                        List qualifiedOrgIds = qualifiedOrgs.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                        if (qualifiedOrgIds.contains(orgid)) {
                            DynamicObjectCollection orgEntity = newSharingScheme.getDynamicObjectCollection("orgentity");
                            Optional<DynamicObject> find = orgEntity.stream().filter(a -> Objects.equals(a.get("org.id"), orgid)).findAny();
                            if (!find.isPresent()) {
                                DynamicObject newOrg = orgEntity.addNew();
                                newOrg.set("org", (Object)orgid);
                            }
                            dynamicObjects2.add(newSharingScheme);
                            this.removeFromOldSharingSchemeFinance(orgid);
                        }
                        saveList.add(dynamicObjects2);
                        continue;
                    }
                    if (StringUtil.equalsIgnoreCase((CharSequence)entity, (CharSequence)TCVAT_SBX_SHAREPLAN_FORM)) {
                        if (StringUtil.isEmpty((CharSequence)taxpayerType)) continue;
                        sbxFilter = new QFilter("createorg", "=", (Object)currentParent).and("autoshar", "=", (Object)Boolean.TRUE);
                        sbxFilter.and(new QFilter("taxpayertype", "=", (Object)taxpayerType));
                        qFilters = new QFilter[]{sbxFilter};
                        ids = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])qFilters, (String)"id asc", (int)10000);
                        if (!EmptyCheckUtils.isNotEmpty((Object)ids)) continue;
                        recs = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entity));
                        dynamicObjects = new ArrayList(16);
                        if (!StringUtil.equalsIgnoreCase((CharSequence)entity, (CharSequence)TCVAT_SBX_SHAREPLAN_FORM)) continue;
                        for (DynamicObject plan : recs) {
                            DynamicObjectCollection orgentitys;
                            Optional<DynamicObject> find;
                            boolean condition = this.isZzsType(entity, taxpayerType, plan);
                            if (plan.getBoolean("autoshar") && condition && !(find = (orgentitys = plan.getDynamicObjectCollection("orgentity")).stream().filter(a -> Objects.equals(a.get("org.id"), orgid)).findAny()).isPresent()) {
                                orgentitys.addNew().set("org", (Object)orgid);
                            }
                            dynamicObjects.add(plan);
                        }
                        saveList.add(dynamicObjects);
                        continue;
                    }
                    if (StringUtil.equalsIgnoreCase((CharSequence)entity, (CharSequence)"tccit_sbx_shareplan")) {
                        sbxFilter = new QFilter("createorg", "=", (Object)currentParent).and("autoshar", "=", (Object)Boolean.TRUE);
                        qFilters = new QFilter[]{sbxFilter};
                        ids = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])qFilters, (String)"id asc", (int)10000);
                        if (!EmptyCheckUtils.isNotEmpty((Object)ids)) continue;
                        recs = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entity));
                        dynamicObjects = new ArrayList<DynamicObject>(16);
                        if (!StringUtil.equalsIgnoreCase((CharSequence)entity, (CharSequence)"tccit_sbx_shareplan")) continue;
                        for (DynamicObject plan : recs) {
                            DynamicObjectCollection orgentitys;
                            Optional<DynamicObject> find;
                            if (plan.getBoolean("autoshar") && !(find = (orgentitys = plan.getDynamicObjectCollection("orgentity")).stream().filter(a -> Objects.equals(a.get("org.id"), orgid)).findAny()).isPresent()) {
                                orgentitys.addNew().set("org", (Object)orgid);
                            }
                            dynamicObjects.add(plan);
                        }
                        saveList.add(dynamicObjects);
                        continue;
                    }
                    qFilters = qFilter.toArray();
                    List ids2 = QueryServiceHelper.queryPrimaryKeys((String)entity, (QFilter[])qFilters, (String)"id asc", (int)10000);
                    if (!EmptyCheckUtils.isNotEmpty((Object)ids2)) continue;
                    DynamicObject[] recs2 = BusinessDataServiceHelper.load((Object[])ids2.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entity));
                    ArrayList<DynamicObject> dynamicObjects3 = new ArrayList<DynamicObject>(16);
                    for (DynamicObject rec : recs2) {
                        DynamicObjectCollection planentity = rec.getDynamicObjectCollection("planentity");
                        for (DynamicObject plan : planentity) {
                            DynamicObjectCollection orgentitys;
                            Optional<DynamicObject> find;
                            boolean condition = this.isZzsType(entity, taxpayerType, plan);
                            if (!plan.getBoolean("entryautoshar") || !condition || (find = (orgentitys = plan.getDynamicObjectCollection("orgentity")).stream().filter(a -> Objects.equals(a.get("orgid.id"), orgid)).findAny()).isPresent()) continue;
                            orgentitys.addNew().set("orgid", (Object)orgid);
                        }
                        dynamicObjects3.add(rec);
                    }
                    saveList.add(dynamicObjects3);
                }
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (List list : saveList) {
                        if (!EmptyCheckUtils.isNotEmpty((Object)list)) continue;
                        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
                    }
                }
                catch (Throwable t) {
                    h.markRollback();
                    LOGGER.error("SharingSchemeAutoSharService-addToSharingScheme save error", t);
                    ApiResult apiResult = ApiResult.fail((String)t.getMessage());
                    if (h != null) {
                        if (var5_5 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return apiResult;
                }
            }
        }
        return ApiResult.success(null);
    }

    private boolean isZzsType(String entity, String taxpayerType, DynamicObject plan) {
        return !entity.equalsIgnoreCase(TCVAT_SBX_SHAREPLAN_FORM) || Objects.equals(plan.getString("taxpayertype"), taxpayerType);
    }

    @Override
    public ApiResult removeFromOldSharingScheme(Long orgid) {
        if (orgid != null && orgid > 0L) {
            Long oldParent = this.getOldParent(orgid);
            Long currentParent = this.getCurrentParent(orgid);
            ArrayList saveList = new ArrayList();
            if (oldParent != null && oldParent > 0L) {
                String taxpayerType = this.getTaxpayerType(orgid);
                QFilter qFilter = new QFilter("org", "=", (Object)oldParent).and("planentity.entryautoshar", "=", (Object)Boolean.TRUE);
                qFilter.and("planentity.orgentity.orgid", "=", (Object)orgid);
                for (String apiResult : SHARING_SCHEME_ENTITY) {
                    DynamicObject[] recs;
                    DynamicObject plan;
                    int n;
                    int n2;
                    ArrayList<DynamicObject> dynamicObjects;
                    List ids;
                    QFilter[] qFilters;
                    QFilter sbxFilter;
                    if (StringUtil.equalsIgnoreCase((CharSequence)apiResult, (CharSequence)TCVVT_SHARINGPLAN)) continue;
                    if (StringUtil.equalsIgnoreCase((CharSequence)apiResult, (CharSequence)TCVAT_SBX_SHAREPLAN_FORM)) {
                        DynamicObject[] recs2;
                        if (StringUtil.isEmpty((CharSequence)taxpayerType)) continue;
                        sbxFilter = new QFilter("createorg", "=", (Object)oldParent).and("autoshar", "=", (Object)Boolean.TRUE);
                        sbxFilter.and("orgentity.org", "=", (Object)orgid);
                        sbxFilter.and(new QFilter("taxpayertype", "=", (Object)taxpayerType));
                        qFilters = new QFilter[]{sbxFilter};
                        ids = QueryServiceHelper.queryPrimaryKeys((String)apiResult, (QFilter[])qFilters, (String)"id asc", (int)10000);
                        if (!EmptyCheckUtils.isNotEmpty((Object)ids) || !EmptyCheckUtils.isNotEmpty((Object)(recs2 = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)apiResult))))) continue;
                        dynamicObjects = new ArrayList(16);
                        DynamicObject[] dynamicObjectArray = recs2;
                        n2 = dynamicObjectArray.length;
                        for (n = 0; n < n2; ++n) {
                            DynamicObjectCollection orgentitys;
                            Optional<DynamicObject> find;
                            plan = dynamicObjectArray[n];
                            boolean condition = this.isZzsType(apiResult, taxpayerType, plan);
                            if (plan.getBoolean("autoshar") && condition && (find = (orgentitys = plan.getDynamicObjectCollection("orgentity")).stream().filter(a -> Objects.equals(a.get("org.id"), orgid)).findAny()).isPresent()) {
                                orgentitys.remove((Object)find.get());
                            }
                            dynamicObjects.add(plan);
                        }
                        saveList.add(dynamicObjects);
                        continue;
                    }
                    if (StringUtil.equalsIgnoreCase((CharSequence)apiResult, (CharSequence)"tccit_sbx_shareplan")) {
                        DynamicObject[] recs2;
                        sbxFilter = new QFilter("createorg", "=", (Object)oldParent).and("autoshar", "=", (Object)Boolean.TRUE);
                        sbxFilter.and("orgentity.org", "=", (Object)orgid);
                        qFilters = new QFilter[]{sbxFilter};
                        ids = QueryServiceHelper.queryPrimaryKeys((String)apiResult, (QFilter[])qFilters, (String)"id asc", (int)10000);
                        if (!EmptyCheckUtils.isNotEmpty((Object)ids) || !EmptyCheckUtils.isNotEmpty((Object)(recs2 = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)apiResult))))) continue;
                        dynamicObjects = new ArrayList<DynamicObject>(16);
                        DynamicObject[] dynamicObjectArray = recs2;
                        n2 = dynamicObjectArray.length;
                        for (n = 0; n < n2; ++n) {
                            DynamicObjectCollection orgentitys;
                            Optional<DynamicObject> find;
                            plan = dynamicObjectArray[n];
                            if (plan.getBoolean("autoshar") && (find = (orgentitys = plan.getDynamicObjectCollection("orgentity")).stream().filter(a -> Objects.equals(a.get("org.id"), orgid)).findAny()).isPresent()) {
                                orgentitys.remove((Object)find.get());
                            }
                            dynamicObjects.add(plan);
                        }
                        saveList.add(dynamicObjects);
                        continue;
                    }
                    qFilters = qFilter.toArray();
                    List ids2 = QueryServiceHelper.queryPrimaryKeys((String)apiResult, (QFilter[])qFilters, (String)"id asc", (int)10000);
                    if (!EmptyCheckUtils.isNotEmpty((Object)ids2) || !EmptyCheckUtils.isNotEmpty((Object)(recs = BusinessDataServiceHelper.load((Object[])ids2.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)apiResult))))) continue;
                    ArrayList<DynamicObject> dynamicObjects2 = new ArrayList<DynamicObject>(16);
                    for (DynamicObject rec : recs) {
                        DynamicObjectCollection planentity = rec.getDynamicObjectCollection("planentity");
                        for (DynamicObject plan2 : planentity) {
                            DynamicObjectCollection orgentitys;
                            Optional<DynamicObject> find;
                            boolean condition = this.isZzsType(apiResult, taxpayerType, plan2);
                            if (!plan2.getBoolean("entryautoshar") || !condition || !(find = (orgentitys = plan2.getDynamicObjectCollection("orgentity")).stream().filter(a -> Objects.equals(a.get("orgid.id"), orgid)).findAny()).isPresent()) continue;
                            orgentitys.remove((Object)find.get());
                        }
                        dynamicObjects2.add(rec);
                    }
                    saveList.add(dynamicObjects2);
                }
            }
            QFilter qFilter1 = new QFilter("orgentity.org.id", "=", (Object)orgid).and("createorg", "!=", (Object)currentParent);
            QFilter qFilter2 = new QFilter("createorg", "=", (Object)currentParent).and("autoshare", "!=", (Object)Boolean.TRUE).and("orgentity.org.id", "=", (Object)orgid);
            for (String string : SHARING_SCHEME_ENTITY) {
                DynamicObject oldSharingScheme;
                if (!StringUtil.equalsIgnoreCase((CharSequence)string, (CharSequence)TCVVT_SHARINGPLAN) || null == (oldSharingScheme = BusinessDataServiceHelper.loadSingle((String)TCVVT_SHARINGPLAN, (String)"orgentity.org", (QFilter[])qFilter1.or(qFilter2).toArray()))) continue;
                ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
                DynamicObjectCollection orgentitys = oldSharingScheme.getDynamicObjectCollection("orgentity");
                Optional<DynamicObject> find = orgentitys.stream().filter(a -> Objects.equals(a.get("org.id"), orgid)).findAny();
                if (find.isPresent()) {
                    orgentitys.remove((Object)find.get());
                }
                dynamicObjects.add(oldSharingScheme);
                saveList.add(dynamicObjects);
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (List list : saveList) {
                        if (!EmptyCheckUtils.isNotEmpty((Object)list)) continue;
                        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
                    }
                }
                catch (Throwable t) {
                    h.markRollback();
                    LOGGER.error("SharingSchemeAutoSharService-removeFromOldSharingScheme save error", t);
                    ApiResult apiResult = ApiResult.fail((String)t.getMessage());
                    if (h != null) {
                        if (var8_9 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var8_9.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return apiResult;
                }
            }
        }
        return ApiResult.success(null);
    }

    public ApiResult removeFromOldSharingSchemeFinance(Long orgid) {
        if (orgid != null && orgid > 0L) {
            Long currentParent = this.getCurrentParent(orgid);
            ArrayList saveList = new ArrayList();
            QFilter qFilter1 = new QFilter("orgentity.org.id", "=", (Object)orgid).and("createorg", "!=", (Object)currentParent);
            QFilter qFilter2 = new QFilter("createorg", "=", (Object)currentParent).and("autoshare", "!=", (Object)Boolean.TRUE).and("orgentity.org.id", "=", (Object)orgid);
            for (String apiResult : SHARING_SCHEME_ENTITY) {
                DynamicObject oldSharingScheme;
                if (!StringUtil.equalsIgnoreCase((CharSequence)apiResult, (CharSequence)TCVVT_SHARINGPLAN) || null == (oldSharingScheme = BusinessDataServiceHelper.loadSingle((String)TCVVT_SHARINGPLAN, (String)"orgentity.org", (QFilter[])qFilter1.or(qFilter2).toArray()))) continue;
                ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(16);
                DynamicObjectCollection orgentitys = oldSharingScheme.getDynamicObjectCollection("orgentity");
                Optional<DynamicObject> find = orgentitys.stream().filter(a -> Objects.equals(a.get("org.id"), orgid)).findAny();
                if (find.isPresent()) {
                    orgentitys.remove((Object)find.get());
                }
                dynamicObjects.add(oldSharingScheme);
                saveList.add(dynamicObjects);
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    for (List list : saveList) {
                        if (!EmptyCheckUtils.isNotEmpty((Object)list)) continue;
                        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
                    }
                }
                catch (Throwable t) {
                    h.markRollback();
                    LOGGER.error("SharingSchemeAutoSharService-removeFromOldSharingScheme save error", t);
                    ApiResult apiResult = ApiResult.fail((String)t.getMessage());
                    if (h != null) {
                        if (var7_8 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var7_8.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return apiResult;
                }
            }
        }
        return ApiResult.success(null);
    }

    @Override
    public ApiResult updateParentRecord(Long orgid) {
        Long currentParent = this.getCurrentParent(orgid);
        this.updateParentRecord(orgid, currentParent);
        return ApiResult.success(null);
    }

    private void updateParentRecord(Long orgid, Long getCurrentParent) {
        DynamicObject record;
        DynamicObject dynamicObject = record = QueryServiceHelper.exists((String)"bdtaxr_old_org_parent_rec", (Object)orgid) ? BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bdtaxr_old_org_parent_rec") : null;
        if (record == null) {
            record = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_old_org_parent_rec");
            record.set("id", (Object)orgid);
            record.set("newparent", (Object)getCurrentParent);
        } else if (!Objects.equals(getCurrentParent, record.get("newparent.id"))) {
            record.set("oldparent", record.get("newparent.id"));
            record.set("newparent", (Object)getCurrentParent);
        }
        record.set("modifydate", (Object)new Date());
        record.set("modifier", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
    }

    private String getTaxpayerType(Long orgid) {
        List data;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainAndCategoryByOrgIdsAndTaxtype(Collections.singletonList(orgid), (String)TaxcMainConstant.TAXTYPE_ZZS);
        if (!(ObjectUtils.isEmpty((Object)result) || ObjectUtils.isEmpty((Object)result.getData()) || ObjectUtils.isEmpty((Object)((DynamicObject)(data = (List)result.getData()).get(0)).get("categoryentryentity")))) {
            DynamicObjectCollection categoryentryentity = ((DynamicObject)data.get(0)).getDynamicObjectCollection("categoryentryentity");
            return ((DynamicObject)categoryentryentity.get(0)).getString("taxpayertype");
        }
        return null;
    }
}

