/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxablelist;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.serviceImpl.taxablelist.TaxableListDeclareConsumerService;
import kd.taxc.bdtaxr.common.enums.DeclareCateGory;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessage;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessageData;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TotfTaxableListDeclareConsumerService
implements TaxableListDeclareConsumerService {
    private static final Log LOGGER = LogFactory.getLog(TotfTaxableListDeclareConsumerService.class);

    @Override
    public List<QFilter> getUpdateFilters(DeclareMQMessage declareMQMessage, DeclareCateGory declareCateGory) {
        List<QFilter> lists = DeclareMQEvent.DELETE.name().equals(declareMQMessage.getEvent()) ? this.doTotfEntryDataUpdate(declareMQMessage, declareCateGory) : this.doTotfUpdate(declareMQMessage, declareCateGory);
        return lists;
    }

    private List<QFilter> doTotfEntryDataUpdate(DeclareMQMessage declareMQMessage, DeclareCateGory declareCateGory) {
        ArrayList<QFilter> lists = new ArrayList<QFilter>();
        List datas = declareMQMessage.getData();
        Long org = declareMQMessage.getOrg();
        Long taxauthority = declareMQMessage.getTaxauthority();
        String category = declareCateGory.getCategory();
        Object anyOne = null;
        for (DeclareMQMessageData data : datas) {
            Date skssqq = DateUtils.stringToDate((String)data.getSkssqq());
            Date skssqz = DateUtils.stringToDate((String)data.getSkssqz());
            Long taxcatetory = this.getTaxcatetory(data);
            if (skssqq == null || skssqz == null) continue;
            QFilter keyFilter = new QFilter("skssqq", "=", (Object)DateUtils.trunc((Date)skssqq)).and(new QFilter("skssqz", "<=", (Object)DateUtils.trunc((Date)skssqz)));
            if (taxcatetory == null) continue;
            if (skssqq.equals(skssqz)) {
                keyFilter = new QFilter("sbbno", "=", (Object)data.getBillNo());
            }
            QFilter filter = new QFilter("org", "=", (Object)org).and("sbbcategory", "=", (Object)category).and("taxcatetory", "=", (Object)taxcatetory).and("taxauthority", "=", (Object)taxauthority);
            filter.and(keyFilter);
            lists.add(filter);
        }
        return lists;
    }

    private Long getTaxcatetory(DeclareMQMessageData data) {
        try {
            return Long.parseLong(data.getTaxType());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return 0L;
        }
    }

    private List<QFilter> doTotfUpdate(DeclareMQMessage declareMQMessage, DeclareCateGory declareCateGory) {
        ArrayList<QFilter> lists = new ArrayList<QFilter>();
        if (DeclareMQEvent.SAVE.name().equals(declareMQMessage.getEvent())) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage());
            }
        }
        String sbbid = declareMQMessage.getSbbid();
        Long org = declareMQMessage.getOrg();
        Long taxauthority = declareMQMessage.getTaxauthority();
        String category = declareCateGory.getCategory();
        QFilter qFilter = new QFilter("id", "=", (Object)(StringUtil.isNotBlank((CharSequence)sbbid) ? Long.parseLong(sbbid) : 0L));
        DynamicObjectCollection tcvat_nsrxx = QueryServiceHelper.query((String)"totf_tysb_declare_main", (String)"id,org,billno,type,declaredate,taxauthority,declarestatus,paystatus,entryentity.startdate as skssqq,entryentity.enddate as skssqz,entryentity.zspm as zspm", (QFilter[])new QFilter[]{qFilter});
        LOGGER.info("tcvat_nsrxx.size():{}", (Object)tcvat_nsrxx.size());
        Date declaredate = null;
        for (DynamicObject tcvatNsrxx : tcvat_nsrxx) {
            Date skssqq = tcvatNsrxx.getDate("skssqq");
            Date skssqz = tcvatNsrxx.getDate("skssqz");
            if (skssqq == null || skssqz == null) continue;
            org = tcvatNsrxx.getLong("org");
            taxauthority = tcvatNsrxx.getLong("taxauthority");
            Long taxcatetory = ZspmEnum.getTaxcatetoryByNameAndTemplateType((String)tcvatNsrxx.getString("zspm"), (String)category);
            QFilter dataFilter = new QFilter("skssqq", "=", (Object)DateUtils.trunc((Date)skssqq)).and("skssqz", "<=", (Object)DateUtils.trunc((Date)skssqz));
            if (taxcatetory == null) continue;
            declaredate = tcvatNsrxx.getDate("declaredate");
            if (skssqq.compareTo(skssqz) == 0 && declaredate != null) {
                dataFilter = new QFilter("skssqq", "=", (Object)declaredate).and("skssqz", "=", (Object)declaredate);
            }
            QFilter filter = new QFilter("org", "=", (Object)org).and("sbbcategory", "=", (Object)category).and("taxcatetory", "=", (Object)taxcatetory).and("taxauthority", "=", (Object)taxauthority);
            filter.and(dataFilter);
            lists.add(filter);
        }
        return lists;
    }
}

