/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxdeclare;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.business.multidideclare.DeclareCellKeyService;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.service.taxdeclare.BaseDataService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.refactor.formula.db.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.DeclareCellKeyVo;

public class BaseDataServiceImpl
implements BaseDataService {
    private static Log LOGGER = LogFactory.getLog(BaseDataServiceImpl.class);

    @Override
    public void queryBaseData(Map<String, String> showData, List<DynamicRowModel> dynamicRowList, DeclareRequestModel declareModel) {
        List formulas;
        long start = System.currentTimeMillis();
        HashMap<String, List<Map<String, String>>> pkListMap = new HashMap<String, List<Map<String, String>>>();
        HashMap<String, String> dataBaseMap = new HashMap<String, String>();
        String templateType = declareModel.getTemplateType();
        List list = formulas = declareModel.getFormulas() != null ? declareModel.getFormulas().getDbCellFormulasCopy() : null;
        if (CollectionUtils.isEmpty((Collection)formulas)) {
            formulas = QueryFormulaService.queryDBFormulaListByType((String)templateType, (String)"3", (String)declareModel.getTemplateId().toString());
        }
        Map<String, FormulaVo> cellTypeMap = this.exchangeFormulas(dynamicRowList, formulas);
        block12: for (Map.Entry<String, FormulaVo> entry : cellTypeMap.entrySet()) {
            String celltype;
            String key = entry.getKey();
            String text = showData.get(key);
            if (StringUtils.isEmpty((CharSequence)StringUtils.trimToEmpty((String)text))) continue;
            FormulaVo formulaVo = cellTypeMap.get(key);
            switch (celltype = formulaVo.getCellType()) {
                case "2": 
                case "3": 
                case "4": {
                    String[] strs;
                    for (String s : strs = text.split(",")) {
                        showData.put(key + s, s);
                    }
                    continue block12;
                }
                case "5": {
                    this.dealWithBaseDataNew(showData, pkListMap, formulaVo, dataBaseMap);
                    break;
                }
                case "7": {
                    this.dealWithSensitive(showData, declareModel, key, text);
                    break;
                }
            }
        }
        for (Map.Entry<String, Object> entry : pkListMap.entrySet()) {
            Map itemMap = TemplateShowUtils.parseCellTypeMap((String)entry.getKey());
            String tableName = (String)itemMap.get("val");
            String fieldName = (String)itemMap.get("text");
            String version = (String)itemMap.get("version");
            String language = TemplateShowUtils.getLanguage((Map)declareModel.getBusinessMap(), (Map)itemMap);
            List selectFieldList = TemplateShowUtils.parseBaseDataFieldList((String)fieldName);
            List items = (List)entry.getValue();
            ArrayList idList = new ArrayList(10);
            for (Map item : items) {
                String id = (String)item.get("id");
                idList.addAll(TemplateShowUtils.getBaseDataIdList((String)id));
            }
            QFilter qFilter = new QFilter("id", "in", idList);
            DynamicObjectCollection resultCollection = version.toLowerCase().contains("true") ? DeclareReportHelpService.getVersionBaseData(declareModel, tableName, String.join((CharSequence)",", selectFieldList), new QFilter[]{qFilter}) : TemplateShowUtils.queryData((String)tableName, (String)String.join((CharSequence)",", selectFieldList), (QFilter[])new QFilter[]{qFilter}, (String)language);
            HashMap<String, String> dataBase = new HashMap<String, String>();
            if (resultCollection == null) continue;
            for (DynamicObject result : resultCollection) {
                dataBase.put(result.getString("id"), TemplateShowUtils.getDisplayText((String)fieldName, (DynamicObject)result));
            }
            for (Map map : items) {
                String cellKey = (String)map.get("key");
                String id = (String)map.get("id");
                String value = TemplateShowUtils.getBaseDataDisplayText((String)id, dataBase);
                showData.put(cellKey + "_text", value);
            }
        }
        LOGGER.info("logflag TaxDeclarePlugin.queryBaseData cost:{}ms", (Object)(System.currentTimeMillis() - start));
    }

    private void dealWithSensitive(Map<String, String> showData, DeclareRequestModel declareModel, String key, String text) {
        String operation = declareModel.getOperation();
        if ("read".equals(operation)) {
            showData.put(key, StringUtil.dealWithSensitive((String)text));
        }
    }

    private void dealWithSensitive(Map<String, String> showData, Map<String, String> DBData, String operation, String key, String text) {
        if ("read".equals(operation)) {
            showData.put(key, StringUtil.dealWithSensitive((String)text));
        }
        if ("edit".equals(operation)) {
            showData.put(key, DBData.get(key));
        }
    }

    private void dealWithBaseData(Map<String, String> showData, Map<String, List<String>> pkListMap, Map<String, List<String>> basePkCellListMap, Map<String, List<String>> baseSelectFieldMap, Map<String, String> displayPopMap, String key, String text, FormulaVo formulaVo) {
        Map itemMap = TemplateShowUtils.parseCellType((String)formulaVo.getFormulaName());
        if (!itemMap.isEmpty()) {
            Map.Entry cellTypeEntry = itemMap.entrySet().iterator().next();
            String baseId = (String)cellTypeEntry.getKey() + "&" + key;
            String basetext = (String)cellTypeEntry.getValue();
            String valIndex = baseId + text;
            if (text.contains(".")) {
                text = text.split("\\.")[0];
            }
            if (text.contains(",")) {
                text = text.replace(",", "");
            }
            List cellList = basePkCellListMap.getOrDefault(baseId, new ArrayList());
            showData.put(key + "_text", showData.get(key + "jsmsextval"));
            cellList.add(key);
            basePkCellListMap.put(valIndex, cellList);
            List pkList = pkListMap.getOrDefault(baseId, new ArrayList());
            if (!pkList.contains(text)) {
                pkList.add(text);
            }
            List selectFieldList = TemplateShowUtils.parseBaseDataFieldList((String)basetext);
            baseSelectFieldMap.put(baseId, selectFieldList);
            pkListMap.put(baseId, pkList);
            displayPopMap.put(key, basetext);
        }
    }

    private void dealWithBaseDataNew(Map<String, String> showData, Map<String, List<Map<String, String>>> pkListMap, FormulaVo formulaVo, Map<String, String> dataBaseMap) {
        String formulaName = formulaVo.getFormulaName();
        String formulaNameStr = StringUtil.formatFormulaStr((String)formulaName);
        List<Map<String, String>> idList = pkListMap.get(formulaNameStr);
        if (idList == null) {
            idList = new ArrayList<Map<String, String>>(16);
            pkListMap.put(formulaNameStr, idList);
        }
        String formulaKey = formulaVo.getFormulaKey();
        String id = showData.get(formulaKey);
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{id})) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("key", formulaKey);
            map.put("id", id);
            idList.add(map);
            dataBaseMap.put(formulaKey, id);
        }
    }

    private Map<String, FormulaVo> exchangeFormulas(List<DynamicRowModel> dynamicRowList, List<FormulaVo> formulas) {
        HashMap<String, FormulaVo> cellTypeMap = new HashMap<String, FormulaVo>();
        for (FormulaVo formulaVo : formulas) {
            String celltype = formulaVo.getCellType();
            if (!"3".equals(celltype) && !"4".equals(celltype) && !"5".equals(celltype) && !"7".equals(celltype)) continue;
            if (CollectionUtils.isEmpty(dynamicRowList)) {
                cellTypeMap.put(formulaVo.getFormulaKey(), formulaVo);
                continue;
            }
            String[] formulakeySplit = formulaVo.getFormulaKey().split("#");
            String dynamicRowNo = formulakeySplit[0] + "#" + formulakeySplit[1];
            DynamicRowModel dynamicRowModel = dynamicRowList.stream().filter(e -> null != e.getDynRowNo() && e.getDynRowNo().equals(dynamicRowNo)).findFirst().orElse(null);
            if (null != dynamicRowModel && dynamicRowModel.getRowList() != null) {
                int startRow = dynamicRowModel.getStartRow().intValue();
                int dynamicRowSize = dynamicRowModel.getRowList().size();
                for (int i = Integer.parseInt(formulakeySplit[1]); i < dynamicRowSize + startRow; ++i) {
                    String formulakey = formulakeySplit[0] + "#" + i + "#" + formulakeySplit[2];
                    FormulaVo formulaVoNew = new FormulaVo(formulaVo);
                    formulaVoNew.setFormulaKey(formulakey);
                    cellTypeMap.put(formulakey, formulaVoNew);
                }
                continue;
            }
            cellTypeMap.put(formulaVo.getFormulaKey(), formulaVo);
        }
        return cellTypeMap;
    }

    @Override
    public void queryBaseDataMulti(Map<String, String> showData, Map<String, String> DBData, List<DynamicRowModel> dynamicRowList, DeclareRequestModel requestModel, Map<String, FormulaVo> cellTypeMap) {
        if (CollectionUtils.isEmpty(showData) || CollectionUtils.isEmpty(cellTypeMap)) {
            return;
        }
        long start = System.currentTimeMillis();
        HashMap<String, List<Map<String, String>>> pkListMap = new HashMap<String, List<Map<String, String>>>();
        HashMap<String, String> dataBaseMap = new HashMap<String, String>();
        for (Map.Entry<String, FormulaVo> entry : cellTypeMap.entrySet()) {
            String celltype;
            String key = entry.getKey();
            String text = showData.get(key);
            FormulaVo formulaVo = cellTypeMap.get(key);
            if (StringUtils.isEmpty((CharSequence)StringUtils.trimToEmpty((String)text))) {
                if (!"5".equalsIgnoreCase(formulaVo.getCellType()) || !showData.containsKey(key)) continue;
                showData.put(key + "_text", "");
                continue;
            }
            switch (celltype = formulaVo.getCellType()) {
                case "3": 
                case "4": {
                    break;
                }
                case "5": {
                    this.dealWithBaseDataNew(showData, pkListMap, formulaVo, dataBaseMap);
                    break;
                }
                case "7": {
                    this.dealWithSensitive(showData, DBData, requestModel.getOperation(), key, text);
                    break;
                }
            }
        }
        for (Map.Entry<String, Object> entry : pkListMap.entrySet()) {
            Map itemMap = TemplateShowUtils.parseCellTypeMap((String)entry.getKey());
            String tableName = (String)itemMap.get("val");
            String fieldName = (String)itemMap.get("text");
            String version = (String)itemMap.get("version");
            String language = TemplateShowUtils.getLanguage((Map)requestModel.getBusinessMap(), (Map)itemMap);
            List selectFieldList = TemplateShowUtils.parseBaseDataFieldList((String)fieldName);
            List items = (List)entry.getValue();
            ArrayList idList = new ArrayList(10);
            for (Map item : items) {
                String id = (String)item.get("id");
                idList.addAll(TemplateShowUtils.getBaseDataIdList((String)id));
            }
            QFilter qFilter = new QFilter("id", "in", idList);
            DynamicObjectCollection resultCollection = version.toLowerCase().contains("true") ? DeclareReportHelpService.getVersionBaseData(requestModel, tableName, String.join((CharSequence)",", selectFieldList), new QFilter[]{qFilter}) : TemplateShowUtils.queryData((String)tableName, (String)String.join((CharSequence)",", selectFieldList), (QFilter[])new QFilter[]{qFilter}, (String)language);
            HashMap<String, String> dataBase = new HashMap<String, String>();
            if (resultCollection != null) {
                for (DynamicObject result : resultCollection) {
                    dataBase.put(result.getString("id"), TemplateShowUtils.getDisplayText((String)fieldName, (DynamicObject)result));
                }
            }
            for (Map map : items) {
                String cellKey = (String)map.get("key");
                String id = (String)map.get("id");
                String value = TemplateShowUtils.getBaseDataDisplayText((String)id, dataBase);
                showData.put(cellKey + "_text", value);
            }
        }
        LOGGER.info("TaxDeclarePlugin.queryBaseData:" + (System.currentTimeMillis() - start));
    }

    @Override
    public void queryBaseDataById(Map<String, FormulaVo> cellTypeFormulas, String cellId, String value, Map<String, String> showData, DeclareRequestModel requestModel) {
        FormulaVo f = cellTypeFormulas.get(cellId);
        if (f == null || !f.getCellType().equals("5")) {
            return;
        }
        String displayText = TemplateShowUtils.getBaseDataDisplayText((String)value, (String)f.getFormulaName(), (Map)requestModel.getBusinessMap());
        if (StringUtil.isNotEmpty((CharSequence)displayText)) {
            showData.put(cellId + "_text", displayText);
        }
    }

    @Override
    public void queryBaseDataRefProps(Map<String, String> showData, List<DynamicRowModel> dynamicRowList, DeclareRequestModel requestModel) {
        if (CollectionUtils.isEmpty(showData)) {
            return;
        }
        Map cellTypeMap = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{requestModel.getTemplateId(), dynamicRowList});
        if (CollectionUtils.isEmpty((Map)cellTypeMap)) {
            return;
        }
        long start = System.currentTimeMillis();
        HashMap<String, List<Map<String, String>>> pkListMap = new HashMap<String, List<Map<String, String>>>();
        HashMap<String, String> dataBaseMap = new HashMap<String, String>();
        for (Map.Entry entry : cellTypeMap.entrySet()) {
            String celltype;
            String key = (String)entry.getKey();
            String text = showData.get(key);
            FormulaVo formulaVo = (FormulaVo)cellTypeMap.get(key);
            if (StringUtils.isEmpty((CharSequence)StringUtils.trimToEmpty((String)text)) || !"5".equals(celltype = formulaVo.getCellType())) continue;
            this.dealWithBaseDataNew(showData, pkListMap, formulaVo, dataBaseMap);
        }
        for (Map.Entry entry : pkListMap.entrySet()) {
            Map itemMap = TemplateShowUtils.parseCellTypeMap((String)((String)entry.getKey()));
            String tableName = (String)itemMap.get("val");
            String refprops = (String)itemMap.get("refprops");
            String version = (String)itemMap.get("version");
            String language = TemplateShowUtils.getLanguage((Map)requestModel.getBusinessMap(), (Map)itemMap);
            if (StringUtils.isBlank((CharSequence)refprops)) continue;
            EntityInfo entityInfo = MetadataUtil.getEntityById((String)tableName);
            Map<Object, Object> typeMap = new HashMap(10);
            if (entityInfo != null) {
                typeMap = entityInfo.getFieldList().stream().collect(Collectors.toMap(k -> k.getFieldId(), v -> v, (k1, k2) -> k1));
            }
            ArrayList selectFieldList = Lists.newArrayList((Object[])refprops.split(","));
            boolean hasIdField = true;
            if (!selectFieldList.contains("id")) {
                selectFieldList.add("id");
                hasIdField = false;
            }
            List items = (List)entry.getValue();
            HashSet idList = new HashSet(10);
            for (Map item : items) {
                String id = (String)item.get("id");
                idList.addAll(TemplateShowUtils.getBaseDataIdList((String)id));
            }
            QFilter qFilter = new QFilter("id", "in", idList);
            DynamicObjectCollection resultCollection = version.toLowerCase().contains("true") ? DeclareReportHelpService.getVersionBaseData(requestModel, tableName, String.join((CharSequence)",", selectFieldList), new QFilter[]{qFilter}) : TemplateShowUtils.queryData((String)tableName, (String)String.join((CharSequence)",", selectFieldList), (QFilter[])new QFilter[]{qFilter}, (String)language);
            if (CollectionUtils.isEmpty((Collection)resultCollection)) continue;
            Map<String, DynamicObject> dataBase = resultCollection.stream().collect(Collectors.toMap(k -> k.getString("id"), v -> v, (v1, v2) -> v2));
            Map<Object, Object> dynamicRowModelMap = new HashMap(10);
            if (!CollectionUtils.isEmpty(dynamicRowList)) {
                dynamicRowModelMap = dynamicRowList.stream().collect(Collectors.toMap(k -> DeclareCellKeyService.getRowMemberByDynamicRowNo(k.getDynRowNo()), v -> v, (v1, v2) -> v2));
            }
            for (Map map : items) {
                String cellKey = (String)map.get("key");
                DeclareCellKeyVo cellKeyVo = DeclareCellKeyService.getMembersByCellKey(cellKey);
                if (cellKeyVo == null) continue;
                String id = (String)map.get("id");
                for (String field : selectFieldList) {
                    if (!hasIdField && "id".equals(field)) continue;
                    String key = String.format("%s_%s", cellKey, field);
                    String value = TemplateShowUtils.getBaseDataPropertyValue((String)id, dataBase, (String)field, typeMap);
                    showData.put(key, value);
                    DynamicRowModel dynamicRowModel = (DynamicRowModel)dynamicRowModelMap.get(cellKeyVo.getRowMember());
                    if (dynamicRowModel == null) continue;
                    int startRow = 1;
                    if (dynamicRowModel.getStartRow() != null) {
                        startRow = dynamicRowModel.getStartRow().intValue();
                    }
                    int rowIndex = cellKeyVo.getIndex() - startRow;
                    if (CollectionUtils.isEmpty((Collection)dynamicRowModel.getRowList()) || rowIndex < 0 || rowIndex >= dynamicRowModel.getRowList().size()) continue;
                    ((Map)dynamicRowModel.getRowList().get(rowIndex)).put(key, value);
                }
            }
        }
        LOGGER.info("TaxDeclarePlugin.queryBaseDataRefProps:" + (System.currentTimeMillis() - start));
    }
}

