/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxdeclare;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.constant.TaxDeclareConstant;
import kd.taxc.bdtaxr.business.formula.FormulaService;
import kd.taxc.bdtaxr.business.formula.impl.FormulaServiceImpl;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.service.taxdeclare.ChangeDataService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.request.FormulaRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.helper.TaxcPrivacyHelper;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.FormulaCalVo;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ChangeDataServiceImpl
implements ChangeDataService {
    private static Log logger = LogFactory.getLog(ChangeDataServiceImpl.class);
    private static FormulaService formulaService = new FormulaServiceImpl();
    public static final String EWBLXH = "ewblxh";
    public static final String SPLIT_STRING = "#";

    @Override
    public Map<String, String> changeData(DeclareResponseModel responseModel, DeclareRequestModel requestModel, String value, Map<String, String> changCellMap, Map<String, String> currentMap, List<Map<String, Object>> listKeyValue, String ... cellId) {
        if (cellId == null) {
            return null;
        }
        long time1 = System.currentTimeMillis();
        Map<String, String> resultData = new HashMap<String, String>(currentMap.size());
        if (cellId != null) {
            FormulaRequestModel formulaRequestModel = new FormulaRequestModel();
            long time2 = System.currentTimeMillis();
            Map businessMap = requestModel.getBusinessMap();
            logger.info("logflag\u83b7\u53d6\u53c2\u6570\u8017\u65f6:{}ms", (Object)(System.currentTimeMillis() - time2));
            HashMap<String, String> paramMap = new HashMap<String, String>(currentMap.size());
            paramMap.putAll(businessMap);
            paramMap.putAll(currentMap);
            FormulaCalVo formulaCalVo = new FormulaCalVo();
            formulaCalVo.setParamMap(paramMap);
            formulaCalVo.setBusinessParam(formulaRequestModel.getRuleParamMap());
            ArrayList<String> cellKeyList = new ArrayList<String>(cellId.length);
            for (String id : cellId) {
                cellKeyList.add(id);
            }
            formulaCalVo.setCellKeyList(cellKeyList);
            formulaCalVo.setCellValue(value);
            formulaCalVo.setTemplateId(responseModel.getTemplateId());
            formulaCalVo.setMetadataMap(responseModel.getMetaDataMap());
            List list = responseModel.getDynRowList();
            HashMap<String, String> initDbMap = new HashMap<String, String>();
            if (paramMap != null) {
                paramMap.entrySet().stream().forEach(v -> initDbMap.put((String)v.getKey(), String.valueOf(v.getValue())));
            }
            if (listKeyValue != null) {
                for (Map<String, Object> el : listKeyValue) {
                    initDbMap.put(el.get("cellKey").toString(), el.get("value").toString());
                }
            } else if (value != null) {
                for (String id : cellId) {
                    initDbMap.put(id, value);
                }
            }
            formulaCalVo.setDataMap(initDbMap);
            formulaCalVo.setDynRowList(list);
            Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, list);
            formulaCalVo.setMetaTypeMap(typeMap);
            long time = System.currentTimeMillis();
            formulaCalVo.setFormulas(requestModel.getFormulas().clone());
            resultData = formulaService.cal(formulaCalVo);
            TaxDeclarePluginService.removeInvalidKey(requestModel.getMetaDataMap(), list, new DeclareService(), resultData);
            logger.info("logflag\u8ba1\u7b97\u65f6\u95f4:" + (System.currentTimeMillis() - time));
            currentMap.putAll(resultData);
            formulaCalVo = null;
        }
        logger.info("logflag changeData\u8017\u65f6:" + (System.currentTimeMillis() - time1));
        return resultData;
    }

    @Override
    public String parasValue(String cellId, String value, List<DynamicRowModel> dynRowList, Map<String, EntityField> typeMap) {
        EntityField entityField = null;
        for (Map.Entry<String, EntityField> entry : typeMap.entrySet()) {
            if (cellId.equals(entry.getKey())) {
                entityField = entry.getValue();
                break;
            }
            if (!this.getFirstDynRowCellId(cellId, dynRowList).equals(entry.getKey())) continue;
            entityField = entry.getValue();
            break;
        }
        if (null != entityField && Arrays.asList(TaxDeclareConstant.NUMBER_TYPES).contains(entityField.getFieldType())) {
            value = StringUtils.isNotBlank((CharSequence)value) ? value.replaceAll(",", "") : "0";
            value = TemplateUtils.dataFormatPreSave((Object)value, (EntityField)entityField);
        }
        return value;
    }

    private String getFirstDynRowCellId(String cellId, List<DynamicRowModel> dynRowList) {
        if (dynRowList == null) {
            return "";
        }
        DynamicRowModel obj = dynRowList.stream().filter(e -> e.getDynRowNo().split(SPLIT_STRING)[0].equals(cellId.split(SPLIT_STRING)[0]) && NumberUtils.isDigits((String)cellId.split(SPLIT_STRING)[1]) && (long)Integer.parseInt(cellId.split(SPLIT_STRING)[1]) >= e.getStartRow()).findFirst().orElse(null);
        if (obj == null) {
            return "";
        }
        return obj.getDynRowNo() + SPLIT_STRING + cellId.split(SPLIT_STRING)[2];
    }

    @Override
    public Map<String, String> changeToShow(Map<String, String> srcMap, DeclareResponseModel responseModel, Map<String, EntityField> typeMap, String operation) {
        long l = System.currentTimeMillis();
        HashMap<String, String> dynRowMap = new HashMap<String, String>();
        if (responseModel != null && responseModel.getDynRowList() != null) {
            for (DynamicRowModel dynRow : responseModel.getDynRowList()) {
                dynRowMap.put(dynRow.getDynRowNo().split(SPLIT_STRING)[0], dynRow.getDynRowNo());
            }
        }
        HashMap<String, String> dataMap = new HashMap<String, String>(16);
        Set<Map.Entry<String, String>> entrySet = srcMap.entrySet();
        Iterator<Map.Entry<String, String>> it = entrySet.iterator();
        Set<String> excludeFields = this.excludeField();
        Set<String> excludeField3 = this.excludeField3();
        while (it.hasNext()) {
            Map.Entry<String, String> ent = it.next();
            String key = ent.getKey();
            EntityField entityField = typeMap.get(key);
            String result = ent.getValue();
            if (key.contains(SPLIT_STRING)) {
                String[] ary = key.split(SPLIT_STRING);
                String taxTypeKey = ary[0] + SPLIT_STRING + ary[1] + "#taxtype";
                if ("tcret_ccxws_zb_hb".equals(ary[0]) && "ybse".equals(ary[2]) && result.contains(".") && ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"ChangeDataServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]).equals(srcMap.get(taxTypeKey))) {
                    entityField = new EntityField();
                    entityField.setScale(2);
                    entityField.setFieldType("Decimal");
                    result = TemplateUtils.dataFormat((Object)result, (EntityField)entityField);
                } else if ("tcetr_declare_main".equals(ary[0]) && "month".equals(ary[2])) {
                    entityField = new EntityField();
                    entityField.setFieldType("Date");
                    entityField.setFieldName("tcetr_declare_main#month");
                    result = TemplateUtils.dataFormat((Object)result, (EntityField)entityField);
                } else if (excludeFields.contains(ent.getKey())) {
                    result = new BigDecimal(ent.getValue()).toBigInteger().toString();
                } else if (this.zeroNoDisplay().contains(ent.getKey())) {
                    result = null == ent.getValue() || StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)ent.getValue()) ? "" : TemplateUtilsOld.dataFormat((Object)ent.getValue(), (EntityField)entityField);
                } else if (excludeField3.contains(ent.getKey())) {
                    result = TemplateUtilsOld.defaultDataFormat((Object)ent.getValue(), (EntityField)entityField);
                } else {
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)dynRowMap.get(ary[0])))) {
                        String ketTemp = ary[0] + "#1#" + ary[2];
                        entityField = typeMap.get(key) == null ? typeMap.get(ketTemp) : typeMap.get(key);
                    }
                    result = TemplateUtils.dataFormat((Object)ent.getValue(), (EntityField)entityField);
                }
                if ("read".equals(operation)) {
                    result = TaxcPrivacyHelper.desensitizeByMeta((String)ary[0], (String)ary[2], (String)result);
                }
            }
            dataMap.put(key, result);
        }
        long l1 = System.currentTimeMillis();
        logger.info("logflag changeToShow cost:{}ms", (Object)(l1 - l));
        return dataMap;
    }

    @Override
    public Map<String, List<List<Cell>>> deleteTemplateRow(Map<String, List<List<Cell>>> dynamicRowMap, String dynamicRowNo, String cellKey) {
        int startRow;
        List<List<Cell>> TempleteDynamicRowList = dynamicRowMap.get(dynamicRowNo);
        block0: for (List<Cell> listCell : TempleteDynamicRowList) {
            for (Cell c : listCell) {
                if (!c.getCellKey().equals(cellKey)) continue;
                TempleteDynamicRowList.remove(listCell);
                break block0;
            }
        }
        for (int i = startRow = Integer.parseInt(dynamicRowNo.split(SPLIT_STRING)[1]); i <= TempleteDynamicRowList.size() + startRow - 1; ++i) {
            for (Cell c : TempleteDynamicRowList.get(i - startRow)) {
                if (c.getCellKey().contains(SPLIT_STRING + i + SPLIT_STRING) || !c.isDynRowCell()) break;
                int firstIndex = c.getCellKey().indexOf(SPLIT_STRING);
                int secondIndex = StringUtils.ordinalIndexOf((CharSequence)c.getCellKey(), (CharSequence)SPLIT_STRING, (int)2);
                String oldString = c.getCellKey().substring(firstIndex, secondIndex + 1);
                String newString = SPLIT_STRING + i + SPLIT_STRING;
                c.setCellKey(c.getCellKey().replace(oldString, newString));
                c.setText(c.getText().replace(oldString, newString));
                if (c.getFormulaVo() == null) continue;
                c.getFormulaVo().setFormulaKey(c.getFormulaVo().getFormulaKey().replace(oldString, newString));
            }
        }
        dynamicRowMap.put(dynamicRowNo, TempleteDynamicRowList);
        return dynamicRowMap;
    }

    @Override
    public void deleteDataRow(DeclareResponseModel responseModel, Map<String, String> currentMap, int startRow, String cellKey, List<Map<String, String>> list) {
        List dynRowList = responseModel.getDynRowList();
        String[] cursorKeys = cellKey.split(SPLIT_STRING);
        int rowNo = Integer.parseInt(cursorKeys[1]);
        boolean delete = false;
        List dynamicRowList = null;
        for (DynamicRowModel l : dynRowList) {
            if (l.getRowList() == null || !cellKey.split(SPLIT_STRING)[0].equals(l.getDynRowNo().split(SPLIT_STRING)[0])) continue;
            for (int j = 0; j < l.getRowList().size(); ++j) {
                Map m = (Map)l.getRowList().get(j);
                if (!m.containsKey(cellKey)) continue;
                delete = true;
                l.getRowList().remove(m);
                break;
            }
            if (!delete && l.getRowList().size() + startRow - 1 >= rowNo) {
                l.getRowList().remove(rowNo - startRow);
            }
            dynamicRowList = l.getRowList();
        }
        if (dynamicRowList == null) {
            return;
        }
        for (int i = 0; i < dynamicRowList.size(); ++i) {
            int nextNo;
            Map map;
            String nextkey;
            if (!delete || !(nextkey = (String)(map = (Map)dynamicRowList.get(i)).keySet().iterator().next()).split(SPLIT_STRING)[0].equals(cellKey.split(SPLIT_STRING)[0]) || (nextNo = Integer.parseInt(nextkey.split(SPLIT_STRING)[1])) <= rowNo) continue;
            HashMap<String, String> moveMap = new HashMap<String, String>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                moveMap.put(entry.getKey().toString().replace(SPLIT_STRING + nextNo + SPLIT_STRING, SPLIT_STRING + (nextNo - 1) + SPLIT_STRING), entry.getValue() == null ? null : entry.getValue().toString());
            }
            Collections.replaceAll(dynamicRowList, map, moveMap);
        }
        int cursorNo = rowNo;
        if (null != dynamicRowList && rowNo == dynamicRowList.size() + startRow) {
            for (int j = 0; j < list.size(); ++j) {
                currentMap.remove(list.get(j).get("cellKey"));
                currentMap.remove(list.get(j).get("cellKey") + "_text");
            }
        }
        for (int i = rowNo - startRow; i < dynamicRowList.size(); ++i) {
            for (int j = 0; j < list.size(); ++j) {
                String o;
                FormulaVo formulaVo;
                String cusorKey = list.get(j).get("cellKey").replace(SPLIT_STRING + rowNo + SPLIT_STRING, SPLIT_STRING + cursorNo + SPLIT_STRING);
                String netxtKey = list.get(j).get("cellKey").replace(SPLIT_STRING + rowNo + SPLIT_STRING, SPLIT_STRING + (cursorNo + 1) + SPLIT_STRING);
                currentMap.put(cusorKey, currentMap.get(netxtKey));
                if (i != dynamicRowList.size() - 1) continue;
                currentMap.remove(netxtKey);
                if (list.get(j).get("formulaVo") == null || (formulaVo = (FormulaVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)(o = list.get(j).get("formulaVo"))), FormulaVo.class)) == null || !formulaVo.getCellType().equals("5")) continue;
                currentMap.remove(netxtKey + "_text");
            }
            ++cursorNo;
        }
    }

    @Override
    public void deleteDataRowWithCells(DeclareResponseModel responseModel, Map<String, String> currentMap, int startRow, String cellKey, List<Cell> cells) {
        List dynRowList = responseModel.getDynRowList();
        String[] cursorKeys = cellKey.split(SPLIT_STRING);
        int rowNo = Integer.parseInt(cursorKeys[1]);
        boolean delete = false;
        List dynamicRowList = null;
        for (DynamicRowModel l : dynRowList) {
            if (l.getRowList() == null || !cellKey.split(SPLIT_STRING)[0].equals(l.getDynRowNo().split(SPLIT_STRING)[0])) continue;
            for (int j = 0; j < l.getRowList().size(); ++j) {
                Map m = (Map)l.getRowList().get(j);
                if (!m.containsKey(cellKey)) continue;
                delete = true;
                l.getRowList().remove(m);
                m.forEach((k, v) -> {
                    currentMap.remove(k);
                    currentMap.remove(k + "_text");
                });
                break;
            }
            if (!delete && l.getRowList().size() + startRow - 1 >= rowNo) {
                Map map = (Map)l.getRowList().get(rowNo - startRow);
                map.forEach((k, v) -> {
                    currentMap.remove(k);
                    currentMap.remove(k + "_text");
                });
                l.getRowList().remove(rowNo - startRow);
            }
            dynamicRowList = l.getRowList();
        }
        if (dynamicRowList == null) {
            return;
        }
        for (int i = 0; i < dynamicRowList.size(); ++i) {
            int nextNo;
            Map map;
            String nextkey;
            if (!delete || !(nextkey = (String)(map = (Map)dynamicRowList.get(i)).keySet().iterator().next()).split(SPLIT_STRING)[0].equals(cellKey.split(SPLIT_STRING)[0]) || (nextNo = Integer.parseInt(nextkey.split(SPLIT_STRING)[1])) <= rowNo) continue;
            HashMap<String, String> moveMap = new HashMap<String, String>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                moveMap.put(entry.getKey().toString().replace(SPLIT_STRING + nextNo + SPLIT_STRING, SPLIT_STRING + (nextNo - 1) + SPLIT_STRING), entry.getValue().toString());
            }
            Collections.replaceAll(dynamicRowList, map, moveMap);
        }
        int cursorNo = rowNo;
        if (null != dynamicRowList && rowNo == dynamicRowList.size() + startRow) {
            for (int j = 0; j < cells.size(); ++j) {
                currentMap.remove(cells.get(j).getCellKey());
                currentMap.remove(cells.get(j).getCellKey() + "_text");
            }
        }
        for (int i = rowNo - startRow; i < dynamicRowList.size(); ++i) {
            for (int j = 0; j < cells.size(); ++j) {
                FormulaVo formulaVo;
                String cusorKey = cells.get(j).getCellKey().replace(SPLIT_STRING + rowNo + SPLIT_STRING, SPLIT_STRING + cursorNo + SPLIT_STRING);
                String netxtKey = cells.get(j).getCellKey().replace(SPLIT_STRING + rowNo + SPLIT_STRING, SPLIT_STRING + (cursorNo + 1) + SPLIT_STRING);
                currentMap.put(cusorKey, currentMap.get(netxtKey));
                if (i != dynamicRowList.size() - 1) continue;
                currentMap.remove(netxtKey);
                if (cells.get(j).getFormulaVo() == null || (formulaVo = cells.get(j).getFormulaVo()) == null || !formulaVo.getCellType().equals("5")) continue;
                currentMap.remove(netxtKey + "_text");
            }
            ++cursorNo;
        }
    }

    @Override
    public TemplateVo addTemplateRow(TemplateVo templateMap, DynamicRowModel dynamicRow) {
        String dynamicRowNo = dynamicRow.getDynRowNo();
        int startRowNo = dynamicRow.getStartRow().intValue();
        Map dynamicRowMap = templateMap.getDynamicRow();
        List TempleteDynamicRowList = (List)dynamicRowMap.get(dynamicRowNo);
        Map sheetCellMap = templateMap.getSheetCellMap();
        ArrayList cellListCopy = new ArrayList();
        ((List)TempleteDynamicRowList.get(0)).forEach(c -> {
            Cell cell = (Cell)SerializationUtils.clone((Serializable)((Serializable)JSON.parseObject((String)JSON.toJSONString((Object)c), Cell.class)));
            cell.setDisablefrontop(cell.isDisablefrontop());
            cellListCopy.add(cell);
        });
        String sheetId = "-1";
        for (Cell c2 : cellListCopy) {
            Map cells;
            c2.setCellKey(c2.getCellKey().replace(SPLIT_STRING + startRowNo + SPLIT_STRING, SPLIT_STRING + (startRowNo + TempleteDynamicRowList.size()) + SPLIT_STRING));
            c2.setText(c2.getText().replace(SPLIT_STRING + startRowNo + SPLIT_STRING, SPLIT_STRING + (startRowNo + TempleteDynamicRowList.size()) + SPLIT_STRING));
            if (c2.getFormulaVo() != null) {
                c2.getFormulaVo().setFormulaKey(c2.getFormulaVo().getFormulaKey().replace(SPLIT_STRING + startRowNo + SPLIT_STRING, SPLIT_STRING + (startRowNo + TempleteDynamicRowList.size()) + SPLIT_STRING));
            }
            if (StringUtil.isBlank((CharSequence)sheetId) || Integer.parseInt(sheetId) < 0) {
                sheetId = c2.getSheetId();
            }
            if ((cells = sheetCellMap == null ? null : (Map)sheetCellMap.get(sheetId)) == null) continue;
            String cellKey = c2.getCellKey();
            cellKey = cellKey.endsWith("%") ? cellKey.substring(0, cellKey.length() - 1) : cellKey;
            cells.put(cellKey, cellKey);
            sheetCellMap.put(sheetId, cells);
        }
        templateMap.setSheetCellMap(sheetCellMap);
        TempleteDynamicRowList.add(cellListCopy);
        dynamicRowMap.put(dynamicRowNo, TempleteDynamicRowList);
        templateMap.setDynamicRow(dynamicRowMap);
        return templateMap;
    }

    @Override
    public void addDataRow(DeclareResponseModel responseModel, Map<String, String> currentMap, List<Map<String, Object>> list, String matchKey) {
        HashMap<String, String> addMap = new HashMap<String, String>(list.size());
        for (Map<String, Object> el : list) {
            currentMap.put(el.get("cellKey").toString(), el.get("value").toString());
        }
        for (DynamicRowModel m : responseModel.getDynRowList()) {
            if (!matchKey.split(SPLIT_STRING)[0].equals(m.getDynRowNo().split(SPLIT_STRING)[0])) continue;
            if (m.getRowList() == null) {
                m.setRowList(new ArrayList());
            }
            if (m.getRowList().size() == 0 || m.getRowList().size() > 0 && this.existKey(m.getRowList(), matchKey)) {
                for (Map<String, Object> el : list) {
                    addMap.put(el.get("cellKey").toString(), el.get("value").toString());
                }
            } else {
                for (String key : ((Map)m.getRowList().get(0)).keySet()) {
                    addMap.put(key, "");
                }
            }
            m.getRowList().add(addMap);
            break;
        }
    }

    private boolean existKey(List<Map<String, String>> list, String key) {
        String[] keys = key.split(SPLIT_STRING);
        key = keys[0] + SPLIT_STRING + (Integer.parseInt(keys[1]) - 1) + SPLIT_STRING + keys[2];
        for (Map<String, String> map : list) {
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    private Set<String> excludeField3() {
        String table = "tccit_qysds_a107041";
        String column = "hj";
        List rows = IntStream.range(4, 33).boxed().filter(s -> !Lists.newArrayList((Object[])new Integer[]{10, 13, 30}).contains(s)).map(s -> s.toString()).collect(Collectors.toList());
        Set<String> excludeFields = Lists.newArrayList((Object[])new String[]{SPLIT_STRING, "_"}).stream().flatMap(flag -> rows.stream().map(row -> table + flag + row + flag + column)).collect(Collectors.toSet());
        String table2 = "tccit_qysds_a107042";
        String column2 = "je";
        ArrayList rows2 = Lists.newArrayList((Object[])new String[]{"1", "2", "3", "6", "7", "10", "11", "22"});
        Set excludeFields2 = Lists.newArrayList((Object[])new String[]{SPLIT_STRING, "_"}).stream().flatMap(flag -> rows2.stream().map(row -> table2 + flag + row + flag + column2)).collect(Collectors.toSet());
        excludeFields.addAll(excludeFields2);
        return excludeFields;
    }

    private Set<String> zeroNoDisplay() {
        HashSet result = Sets.newHashSet((Object[])new String[]{"tccit_qysds_a000000#1#sbssqnd", "tccit_qysds_a000000#1#ssqxynd", "tccit_qysds_a000000#1#zsbh1", "tccit_qysds_a000000#1#zsbh2"});
        return result;
    }

    private Set<String> excludeField() {
        String table = "tccit_qysds_a105040";
        String column = "1";
        ArrayList rows = Lists.newArrayList((Object[])new String[]{"qwnd", "qsind", "qsand", "qend", "qynd", "bn"});
        Set<String> excludeFields = Lists.newArrayList((Object[])new String[]{SPLIT_STRING, "_"}).stream().flatMap(flag -> rows.stream().map(row -> table + flag + column + flag + row)).collect(Collectors.toSet());
        return excludeFields;
    }
}

