/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxdeclare;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareRequestService;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.declare.initparam.InitParamsService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.db.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseFormulaService;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;

public class DeclareRequestServiceImpl
implements DeclareRequestService {
    @Override
    public DeclareRequestModel buildFromParams(String orgId, String type, String skssqq, String skssqz) {
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
        requestModel.setTemplateType(type);
        requestModel.setSkssqq(skssqq);
        requestModel.setSkssqz(skssqz);
        Map businessMap = InitParamsService.getInitParams((String)requestModel.getTemplateType()).buildBizParam(requestModel);
        requestModel.setBusinessMap(businessMap);
        return requestModel;
    }

    @Override
    public DeclareRequestModel build(String requestJson) {
        DynamicObject declareMain;
        DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)requestJson, DeclareRequestModel.class);
        if (requestModel == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (String)"DeclareRequestServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        TaxDeclarePluginService.checkParams(requestModel);
        Long sbbid = requestModel.getId();
        String billNo = requestModel.getBillNo();
        if (sbbid == null) {
            declareMain = YbnsrServiceHelper.queryYbnsrWithEx((String)String.valueOf(requestModel.getOrgId()), (String)requestModel.getTemplateType(), (String)requestModel.getSkssqq(), (String)requestModel.getSkssqz(), (Map)requestModel.getExtendParams());
            if (declareMain != null) {
                sbbid = Long.valueOf(declareMain.getString("id"));
                billNo = declareMain.getString("billno");
            } else {
                sbbid = TaxDeclarePluginService.generateSBBId(null);
                billNo = DeclareUtils.getBillNo((String)String.valueOf(requestModel.getOrgId()), (Date)DateUtils.stringToDate((String)requestModel.getSkssqq()), (Date)DateUtils.stringToDate((String)requestModel.getSkssqz()), (String)requestModel.getTemplateType());
            }
            if (sbbid == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u8868id\u4e3a\u7a7a", (String)"DeclareRequestServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            requestModel.setId(sbbid);
            requestModel.setBillNo(billNo);
        }
        if (StringUtil.isBlank((CharSequence)billNo) && (declareMain = YbnsrServiceHelper.queryYbnsrWithId((String)String.valueOf(sbbid))) != null && StringUtil.isNotBlank((CharSequence)(billNo = declareMain.getString("billno")))) {
            requestModel.setBillNo(billNo);
        }
        String zerodeclare = (String)requestModel.getBusinessMap().get("zerodeclare");
        Long templateId = requestModel.getTemplateId();
        if (templateId == null || templateId == 0L) {
            TemplateVo templateVo = TaxDeclarePluginService.getTemplateVo(requestModel, "1".equals(zerodeclare));
            if (templateVo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\uff0c\u6682\u4e0d\u652f\u6301\u7533\u62a5", (String)"DeclareRequestServiceImpl_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            templateId = templateVo.getTemplateId();
            requestModel.setTemplateId(templateId);
            requestModel.setTemplateNumber(templateVo.getTemplateNumber());
            requestModel.setBaseTemplate(templateVo.getTemplate());
        }
        Map metaMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId((Long)templateId);
        requestModel.setMetaDataMap(metaMap);
        Map businessMap = InitParamsService.getInitParams((String)requestModel.getTemplateType()).buildBizParam(requestModel);
        if (requestModel.getBusinessMap() != null) {
            businessMap.forEach((k, v) -> requestModel.getBusinessMap().putIfAbsent(k, v));
        } else {
            requestModel.setBusinessMap(businessMap);
        }
        Map dbCalFormulas = QueryFormulaService.queryDBFormulaById((Long)templateId);
        List dbCheckFormulas = QueryFormulaService.queryDBFormulaType((String)requestModel.getTemplateType(), (String)requestModel.getSkssqq(), (String)requestModel.getSkssqz(), (String)String.valueOf(templateId));
        List dbCellFormulas = QueryFormulaService.queryDBFormulaListByType((String)requestModel.getTemplateType(), (String)"3", (String)String.valueOf(templateId));
        FormulaCollectionVo formulaCollectionVo = new FormulaCollectionVo(dbCheckFormulas, dbCalFormulas, dbCellFormulas);
        requestModel.setFormulas(formulaCollectionVo);
        dbCalFormulas.values().forEach(formulaVo -> ParseFormulaService.parseDetail((FormulaVo)formulaVo));
        dbCheckFormulas.forEach(formulaVo -> ParseFormulaService.parseDetail((FormulaVo)formulaVo));
        return requestModel;
    }
}

