/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxdeclare;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.multidideclare.MultiDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.SavetaxDeclareService;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.handler.QueryOrSaveDeclareHandler;
import kd.taxc.bdtaxr.common.declare.handler.QueryOrSaveDeclareServiceFactory;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.dto.TaxDeclareSaveDataDto;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.CellType;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.DeclareReportFactory;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class SavetaxDeclareServiceImpl
implements SavetaxDeclareService {
    private static Log LOGGER = LogFactory.getLog(SavetaxDeclareServiceImpl.class);
    private static DeclareReportService declareReportService;
    private static List<String> editSaveExcludeFields;

    @Override
    public Map<String, String> saveTaxDeclare(String ssbId, Map<String, String> updateMap, Map<String, String> currMap, Map<String, String> remarkMap, DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, String> newData) {
        DynamicObject declareObj;
        if (requestModel == null || responseModel == null) {
            throw new IllegalArgumentException("Illegal parameters!!!");
        }
        ArrayList<DynamicObject> hisList = new ArrayList<DynamicObject>();
        if (StringUtil.isNotBlank((CharSequence)requestModel.getUniKey()) && (declareObj = YbnsrServiceHelper.queryYbnsrWithEx((String)String.valueOf(requestModel.getOrgId()), (String)requestModel.getTemplateType(), (String)requestModel.getSkssqq(), (String)requestModel.getSkssqz(), (Map)requestModel.getExtendParams())) != null) {
            ssbId = declareObj.getString("id");
            responseModel.setId(Long.valueOf(ssbId));
            requestModel.setBillNo(declareObj.getString("billno"));
        }
        this.convertHisList(ssbId, updateMap, currMap, newData, remarkMap, responseModel, requestModel, hisList);
        requestModel.setId(responseModel.getId());
        boolean hasHis = !CollectionUtils.isEmpty(hisList);
        boolean isNsrxx = newData.containsKey("tcvat_nsrxx#1#ewblxh");
        if (hasHis && isNsrxx) {
            newData.put("tcvat_nsrxx#1#modifytime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            newData.put("tcvat_nsrxx#1#modifier", RequestContext.get().getUserId());
        }
        QueryOrSaveDeclareHandler handler = QueryOrSaveDeclareServiceFactory.create((Long)responseModel.getTemplateId());
        Map metaDataMap = responseModel.getMetaDataMap();
        Map<String, String> filterNewData = newData;
        if (EmptyCheckUtils.isNotEmpty((Object)metaDataMap)) {
            filterNewData = newData.entrySet().stream().filter(a -> metaDataMap.containsKey(((String)a.getKey()).split("#")[0])).collect(Collectors.toMap(k -> (String)k.getKey(), v -> (String)v.getValue()));
        }
        Map resultMap = handler.save(requestModel, filterNewData, responseModel.getData(), metaDataMap);
        ssbId = String.valueOf(requestModel.getId());
        this.doSaveCellAndNxx(ssbId, hisList, hasHis, isNsrxx);
        return resultMap;
    }

    private void doSaveCellAndNxx(String ssbId, List<DynamicObject> hisList, boolean hasHis, boolean isNsrxx) {
        if (hasHis) {
            DynamicObject declareMain;
            SaveServiceHelper.save((DynamicObject[])hisList.toArray(new DynamicObject[0]));
            if (isNsrxx && (declareMain = BusinessDataServiceHelper.loadSingle((Object)ssbId, (String)"tcvat_nsrxx")) != null) {
                declareMain.set("ismodified", (Object)1);
                SaveServiceHelper.update((DynamicObject)declareMain);
            }
        }
    }

    private void convertHisList(String ssbId, Map<String, String> updateMap, Map<String, String> currMap, Map<String, String> newData, Map<String, String> remarkMap, DeclareResponseModel responseModel, DeclareRequestModel requestModel, List<DynamicObject> hisList) {
        if (requestModel.getRefresh().booleanValue()) {
            this.doConvertRecaleCellEditHis(ssbId, newData, responseModel, hisList, remarkMap, updateMap);
        }
        this.doConvertCellEditHis(ssbId, updateMap, currMap, remarkMap, responseModel, hisList);
    }

    private void doConvertCellEditHis(String ssbId, Map<String, String> updateMap, Map<String, String> currMap, Map<String, String> remarkMap, DeclareResponseModel responseModel, List<DynamicObject> hisList) {
        if (updateMap != null && !updateMap.isEmpty()) {
            HashMap basePkListMap = new HashMap();
            HashMap baseFieldListMap = new HashMap();
            HashMap cellTypeMap = new HashMap();
            HashMap<String, DynamicObject> baseValueMap = new HashMap<String, DynamicObject>();
            for (Map.Entry entry : basePkListMap.entrySet()) {
                QFilter qFilter = new QFilter("id", "in", entry.getValue());
                DynamicObjectCollection resultCollection = QueryServiceHelper.query((String)((String)entry.getKey()), (String)String.join((CharSequence)",", (Iterable)baseFieldListMap.get(entry.getKey())), (QFilter[])new QFilter[]{qFilter});
                if (resultCollection == null) continue;
                for (DynamicObject result : resultCollection) {
                    String valIndex = (String)entry.getKey() + result.getString("id");
                    baseValueMap.put(valIndex, result);
                }
            }
            Map<String, EntityField> typeMap = this.getTypeMap(responseModel);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tctb_declare_his");
            RequestContext context = RequestContext.get();
            for (Map.Entry<String, String> entry : updateMap.entrySet()) {
                DynamicObject dObj = new DynamicObject((DynamicObjectType)mainEntityType);
                dObj.set("sbbid", (Object)ssbId);
                dObj.set("cellid", (Object)entry.getKey());
                dObj.set("modifytype", (Object)"2");
                EntityField type = typeMap.get(entry.getKey());
                String formatValue = TemplateUtils.dataFormatPreSave((Object)entry.getValue(), (EntityField)type);
                if (null != type && "Decimal".equals(type.getFieldType()) && StringUtils.isNotBlank((CharSequence)formatValue)) {
                    formatValue = formatValue.replaceAll(",", "");
                }
                CellType cellType = (CellType)cellTypeMap.get(entry.getKey());
                String originalvalue = null;
                if (null != currMap) {
                    originalvalue = currMap.get(entry.getKey());
                    if (null != type && "Decimal".equals(type.getFieldType()) && StringUtils.isNotBlank((CharSequence)originalvalue)) {
                        originalvalue = originalvalue.replaceAll(",", "");
                        originalvalue = TemplateUtils.dataFormatPreSave((Object)originalvalue, (EntityField)type);
                    }
                }
                if (cellType != null && "5".equals(cellType.getCellType())) {
                    DynamicObject baseObj;
                    DynamicObject baseObj2;
                    BigDecimal origDec = BigDecimalUtil.toBigDecimal((Object)originalvalue);
                    if (BigDecimal.ZERO.compareTo(origDec) != 0) {
                        baseObj2 = (DynamicObject)baseValueMap.get(cellType.getBaseEntityId() + origDec.longValue());
                        dObj.set("originalvalue", (Object)TemplateShowUtils.getDisplayText((String)cellType.getDisplayConfig(), (DynamicObject)baseObj2));
                    } else {
                        baseObj2 = (DynamicObject)baseValueMap.get(cellType.getBaseEntityId() + originalvalue);
                        dObj.set("originalvalue", (Object)TemplateShowUtils.getDisplayText((String)cellType.getDisplayConfig(), (DynamicObject)baseObj2));
                    }
                    BigDecimal tarDec = BigDecimalUtil.toBigDecimal((Object)formatValue);
                    if (BigDecimal.ZERO.compareTo(origDec) != 0) {
                        baseObj = (DynamicObject)baseValueMap.get(cellType.getBaseEntityId() + tarDec.longValue());
                        dObj.set("targetvalue", (Object)TemplateShowUtils.getDisplayText((String)cellType.getDisplayConfig(), (DynamicObject)baseObj));
                    } else {
                        baseObj = (DynamicObject)baseValueMap.get(cellType.getBaseEntityId() + formatValue);
                        dObj.set("targetvalue", (Object)TemplateShowUtils.getDisplayText((String)cellType.getDisplayConfig(), (DynamicObject)baseObj));
                    }
                } else if (cellType != null && cellType.getItemMap() != null) {
                    dObj.set("originalvalue", (Object)SavetaxDeclareServiceImpl.getItemName(originalvalue, cellType.getItemMap()));
                    dObj.set("targetvalue", (Object)SavetaxDeclareServiceImpl.getItemName(formatValue, cellType.getItemMap()));
                } else {
                    dObj.set("originalvalue", (Object)originalvalue);
                    dObj.set("targetvalue", (Object)formatValue);
                }
                if (remarkMap != null) {
                    dObj.set("remark", (Object)remarkMap.get(entry.getKey()));
                }
                dObj.set("modifierfield", (Object)context.getUserId());
                dObj.set("modifydatefield", (Object)new Date());
                hisList.add(dObj);
            }
        }
    }

    private Map<String, EntityField> getTypeMap(DeclareResponseModel responseModel) {
        Map listTab = null != responseModel && responseModel.getMetaDataMap() != null ? responseModel.getMetaDataMap() : Collections.emptyMap();
        return TemplateUtils.getAllFieldTypeToShow(listTab);
    }

    @Override
    public boolean saveRiskItem(String sbbId, List<Map<String, String>> checkResultList, List<Map<String, String>> riskResultList, int saveType) {
        return new DeclareService().saveRiskItem(sbbId, checkResultList, riskResultList, saveType);
    }

    private static String getItemName(String value, Map<String, String> itemMap) {
        if (value == null || itemMap == null) {
            return null;
        }
        String[] strs = value.split(",");
        StringBuilder sb = new StringBuilder();
        int size = itemMap.size();
        for (String str : strs) {
            String text = itemMap.get(str);
            if (size == 1 && itemMap.containsKey(str) && StringUtils.isEmpty((CharSequence)text)) {
                sb.append(ResManager.loadKDString((String)"\u9009\u62e9", (String)"SavetaxDeclareServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)text)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(text);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseResult saveTaxDeclareData(TaxDeclareSaveDataDto saveDataDto) {
        BaseResult result = new BaseResult();
        Long modelId = saveDataDto.getModelId();
        long orgId = saveDataDto.getOrgId();
        String skssqq = saveDataDto.getSkssqq();
        String skssqz = saveDataDto.getSkssqz();
        Long sbbId = saveDataDto.getSbbId();
        Map updateMap = saveDataDto.getUpdateMap();
        Map currMap = saveDataDto.getCurrMap();
        Map remarkMap = saveDataDto.getRemarkMap();
        HashMap<String, EntityField> typeMap = saveDataDto.getTypeMap();
        if (typeMap == null) {
            typeMap = new HashMap<String, EntityField>(1);
        }
        String templateType = saveDataDto.getTemplateType();
        HashMap<String, String> newMaps = saveDataDto.getNewMaps();
        if (updateMap != null) {
            newMaps.putAll(updateMap);
        }
        if (CollectionUtils.isEmpty((Map)newMaps)) {
            result.setData((Object)currMap);
            result.setCode(BaseResult.OK);
            return result;
        }
        HashMap resultMap = new HashMap(currMap.size());
        resultMap.putAll(currMap);
        if (newMaps != null) {
            resultMap.putAll(newMaps);
        }
        DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)modelId);
        String mainTable = declareTable.getMainTable();
        String detailTable = declareTable.getDetalTable();
        Map<String, Long> rowMember = MultiDataService.getRowColMember(modelId, "tpo_row_member");
        Map<String, Long> colMember = MultiDataService.getRowColMember(modelId, "tpo_col_member");
        QFilter sbbidFlter = new QFilter("entryid", "=", (Object)sbbId);
        boolean createNew = false;
        QFilter extendFilter = null;
        declareReportService = DeclareReportFactory.createHandler((String)templateType);
        if (declareReportService != null) {
            extendFilter = declareReportService.getDeclareMainQueryExtendFilter(saveDataDto.getExtendParams());
        }
        DLock lock = null;
        if ("add".equals(saveDataDto.getCustomEvent())) {
            if (StringUtil.isEmpty((CharSequence)saveDataDto.getUniKey())) {
                throw new KDBizException("uniKey is null!");
            }
            lock = DLock.create((String)saveDataDto.getUniKey());
            boolean getLock = lock.tryLock();
            if (!getLock) {
                result.setCode(BaseResult.FAIL);
                result.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u62ff\u5230\u9501\uff01", (String)"SavetaxDeclareServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return result;
            }
        }
        DynamicObject mainObj = null;
        try {
            mainObj = YbnsrService.queryMultiDeclareMain((String)mainTable, (long)orgId, (String)templateType, (String)skssqq, (String)skssqz, (QFilter)extendFilter);
            if (mainObj != null && "add".equals(saveDataDto.getCustomEvent())) {
                result.setCode(BaseResult.FAIL);
                result.setMessage(ResManager.loadKDString((String)"\u65b0\u589e\u64cd\u4f5c\u65f6\u5f53\u524d\u4e3b\u8868\u6570\u636e\u4e0d\u4e3a\u7a7a\uff01", (String)"SavetaxDeclareServiceImpl_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                BaseResult baseResult = result;
                return baseResult;
            }
            DataEntityPropertyCollection propertyCollection = null;
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)mainTable);
            propertyCollection = mainEntityType.getProperties();
            if (mainObj == null) {
                mainObj = new DynamicObject((DynamicObjectType)mainEntityType);
                mainObj.set("id", (Object)sbbId);
                mainObj.set("templatetype", (Object)templateType);
                createNew = true;
            }
            DynamicObjectCollection coll = QueryServiceHelper.query((String)detailTable, (String)"cellnumber, value", (QFilter[])new QFilter[]{sbbidFlter});
            ArrayList<Object> deleteList = new ArrayList<Object>(1);
            if (newMaps == null) {
                newMaps = new HashMap<String, String>(currMap.size());
                for (Map.Entry entry : currMap.entrySet()) {
                    if (!entry.getKey().toString().startsWith(mainTable + "#")) continue;
                    newMaps.put(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            ArrayList keys = new ArrayList(newMaps.keySet());
            for (String key : keys) {
                if (!key.contains("#")) {
                    newMaps.remove(key);
                    continue;
                }
                if (!key.startsWith(mainTable + "#")) continue;
                String[] keySplit = key.split("#");
                String string = keySplit[keySplit.length - 1];
                if (createNew || !editSaveExcludeFields.contains(string)) {
                    String propertType = "";
                    if (propertyCollection == null) {
                        newMaps.remove(key);
                        continue;
                    }
                    if (propertyCollection.get((Object)string) == null) {
                        newMaps.remove(key);
                        continue;
                    }
                    if (((IDataEntityProperty)propertyCollection.get((Object)string)).getPropertyType() == null) {
                        newMaps.remove(key);
                        continue;
                    }
                    try {
                        propertType = ((IDataEntityProperty)propertyCollection.get((Object)string)).getPropertyType().getName();
                    }
                    catch (Exception e) {
                        LOGGER.error("\u5143\u6570\u636e\u4e0d\u5b58\u5728\u6b64\u5c5e\u6027!" + e);
                    }
                    Object value = newMaps.remove(key);
                    if (propertType == null || value == null) continue;
                    if (propertType.equals("java.util.Date")) {
                        try {
                            String dateFormat = "yyyy-MM-dd HH:mm:ss";
                            if (typeMap != null && typeMap.get(key) != null && StringUtil.isNotEmpty((CharSequence)((EntityField)typeMap.get(key)).getFormatStr())) {
                                dateFormat = ((EntityField)typeMap.get(key)).getFormatStr();
                            }
                            value = DateUtils.stringToDate((String)value.toString(), (String)dateFormat);
                        }
                        catch (Exception e) {
                            LOGGER.error("{}: \u683c\u5f0f\u8f6c\u6362\u5931\u8d25\uff01 {}", value, (Object)e);
                        }
                    }
                    if (propertType.equals("long") || propertType.equals("kd.bos.dataentity.entity.DynamicObject")) {
                        try {
                            value = Long.valueOf(value.toString());
                        }
                        catch (Exception e) {
                            LOGGER.error("{}: \u683c\u5f0f\u8f6c\u6362\u5931\u8d25\uff01 {}", value, (Object)e);
                        }
                    }
                    mainObj.set(string, value);
                }
                newMaps.remove(key);
            }
            if (coll != null) {
                for (DynamicObject obj : coll) {
                    String number = obj.getString("cellnumber");
                    String string = obj.getString("value");
                    if (newMaps.get(number) != null && ((String)newMaps.get(number)).equals(string)) {
                        newMaps.remove(number);
                        continue;
                    }
                    if (newMaps.containsKey(number)) continue;
                    deleteList.add(number);
                }
                deleteList.addAll(newMaps.keySet());
            }
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(newMaps.size());
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)detailTable);
            for (Map.Entry entry : newMaps.entrySet()) {
                EntityField field;
                String key = entry.getKey().toString();
                String[] keySplit = key.split("#");
                DynamicObject obj = new DynamicObject((DynamicObjectType)entityType);
                obj.set("id", (Object)UUID.randomUUID());
                obj.set("entryid", (Object)sbbId);
                if (rowMember.get(keySplit[0]) != null) {
                    obj.set("row", (Object)rowMember.get(keySplit[0]));
                }
                if (colMember.get(keySplit[keySplit.length - 1]) != null) {
                    obj.set("column", (Object)colMember.get(keySplit[keySplit.length - 1]));
                }
                obj.set("cellnumber", (Object)key);
                String fieldType = "";
                EntityField entityField = field = typeMap == null ? null : (EntityField)typeMap.get(key);
                if (field != null && !StringUtils.isEmpty((CharSequence)field.getFieldType())) {
                    fieldType = field.getFieldType();
                }
                obj.set("valuetype", (Object)fieldType);
                obj.set("value", entry.getValue());
                if (keySplit.length == 3) {
                    obj.set("dynrowno", (Object)(keySplit[0] + "#1"));
                    obj.set("index", (Object)keySplit[1]);
                }
                list.add(obj);
            }
            Throwable throwable = null;
            try (TXHandle h = TX.requiresNew();){
                try {
                    DynamicObject[] dataEntities = new DynamicObject[]{mainObj};
                    SaveServiceHelper.save((DynamicObject[])dataEntities);
                    if (deleteList.size() > 0) {
                        QFilter numberFilter = new QFilter("cellnumber", "in", deleteList);
                        DeleteServiceHelper.delete((String)detailTable, (QFilter[])new QFilter[]{sbbidFlter, numberFilter});
                        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                    LOGGER.error("taxc-DeferPayRptPlugin pay fail:", (Object)e.getMessage());
                    result.setCode(BaseResult.FAIL);
                    result.setMessage(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4fdd\u5b58\u5f02\u5e38\uff0c\u5df2\u56de\u6eda\uff01", (String)"SavetaxDeclareServiceImpl_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    BaseResult baseResult = result;
                    if (h != null) {
                        if (throwable != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            h.close();
                        }
                    }
                    if (lock != null) {
                        lock.unlock();
                    }
                    return baseResult;
                }
            }
            catch (Throwable throwable3) {
                Throwable throwable4 = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            result.setCode(BaseResult.FAIL);
            result.setMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f02\u5e38\uff01", (String)"SavetaxDeclareServiceImpl_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            BaseResult baseResult = result;
            return baseResult;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        try {
            if (!createNew) {
                this.updateHisData(sbbId, updateMap, currMap, typeMap, remarkMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("edit history data update fail!");
        }
        result.setData(resultMap);
        result.setCode(BaseResult.OK);
        return result;
    }

    public void doConvertRecaleCellEditHis(String sbbId, Map<String, String> curData, DeclareResponseModel responseModel, List<DynamicObject> hisList, Map<String, String> remarkMap, Map<String, String> updateMap) {
        Map<String, String> cellEditHistoryMap = this.doQueryCellEditHistory(sbbId);
        Map<String, String> changedCellMap = cellEditHistoryMap.entrySet().stream().filter(k -> !((String)k.getValue()).equals(curData.get(k.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> k2));
        if (CollectionUtils.isEmpty(changedCellMap)) {
            return;
        }
        Map<String, EntityField> typeMap = this.getTypeMap(responseModel);
        for (Map.Entry<String, String> entry : changedCellMap.entrySet()) {
            DynamicObject dObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctb_declare_his"));
            dObj.set("sbbid", (Object)sbbId);
            dObj.set("cellid", (Object)entry.getKey());
            dObj.set("modifytype", (Object)"1");
            if (updateMap != null && updateMap.containsKey(entry.getKey())) {
                dObj.set("modifytype", (Object)"2");
            }
            String originalvalue = TemplateUtils.dataFormatPreSave((Object)entry.getValue(), (EntityField)typeMap.get(entry.getKey()));
            if (null != typeMap.get(entry.getKey()) && "Decimal".equals(typeMap.get(entry.getKey()).getFieldType()) && StringUtils.isNotBlank((CharSequence)originalvalue)) {
                originalvalue = originalvalue.replaceAll(",", "");
            }
            String targetvalue = curData.get(entry.getKey());
            if (null != typeMap.get(entry.getKey()) && "Decimal".equals(typeMap.get(entry.getKey()).getFieldType()) && StringUtils.isNotBlank((CharSequence)targetvalue)) {
                targetvalue = targetvalue.replaceAll(",", "");
            }
            if (StringUtil.isBlank((CharSequence)originalvalue) && StringUtil.isBlank((CharSequence)targetvalue)) continue;
            if (remarkMap != null) {
                dObj.set("remark", (Object)remarkMap.get(entry.getKey()));
            }
            dObj.set("originalvalue", (Object)originalvalue);
            dObj.set("targetvalue", (Object)targetvalue);
            dObj.set("modifierfield", (Object)RequestContext.get().getUserId());
            dObj.set("modifydatefield", (Object)new Date());
            hisList.add(dObj);
        }
        if (!CollectionUtils.isEmpty(updateMap)) {
            Map<String, String> temp = updateMap.entrySet().stream().filter(k -> !changedCellMap.containsKey(k.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> k2));
            updateMap.clear();
            updateMap.putAll(temp);
        }
    }

    private Map<String, String> doQueryCellEditHistory(String sbbid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tctb_declare_his");
        DynamicObjectCollection changedCells = QueryServiceHelper.query((String)"tctb_declare_his", (String)"id,cellid,sbbid,targetvalue,remark,modifytype,originalvalue,modifierfield,modifydatefield", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbid)});
        if (CollectionUtils.isEmpty((Collection)changedCells)) {
            return new HashMap<String, String>();
        }
        return changedCells.stream().collect(Collectors.groupingBy(c -> c.getString("cellid"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((List)v.getValue()).stream().max(Comparator.comparing(d -> d.getLong("id"))).orElseGet(() -> new DynamicObject((DynamicObjectType)mainEntityType)).getString("targetvalue"), (v1, v2) -> v1));
    }

    private void updateHisData(long ssbId, Map<String, String> updateData, Map<String, String> currMap, Map<String, EntityField> typeMap, Map<String, String> remarkMap) {
        if (typeMap == null) {
            typeMap = new HashMap<String, EntityField>(1);
        }
        ArrayList<DynamicObject> hisList = new ArrayList<DynamicObject>();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tctb_declare_his");
        for (Map.Entry<String, String> entry : updateData.entrySet()) {
            DynamicObject dObj = new DynamicObject((DynamicObjectType)mainEntityType);
            dObj.set("sbbid", (Object)ssbId);
            dObj.set("cellid", (Object)entry.getKey());
            dObj.set("modifytype", (Object)"2");
            EntityField cellType = typeMap.get(entry.getKey());
            String formatValue = MultiDataService.dataFormat(entry.getValue(), cellType);
            if (null != typeMap.get(entry.getKey()) && "Decimal".equals(cellType.getFieldType()) && StringUtils.isNotBlank((CharSequence)formatValue)) {
                formatValue = formatValue.replaceAll(",", "");
            }
            String originalvalue = null;
            if (null != currMap) {
                originalvalue = currMap.get(entry.getKey());
                if (null != typeMap.get(entry.getKey()) && "Decimal".equals(cellType.getFieldType()) && StringUtils.isNotBlank((CharSequence)originalvalue)) {
                    originalvalue = originalvalue.replaceAll(",", "");
                }
            }
            dObj.set("originalvalue", originalvalue);
            dObj.set("targetvalue", (Object)formatValue);
            if (remarkMap != null) {
                dObj.set("remark", (Object)remarkMap.get(entry.getKey()));
            }
            RequestContext context = RequestContext.get();
            dObj.set("modifierfield", (Object)context.getUserId());
            dObj.set("modifydatefield", (Object)new Date());
            hisList.add(dObj);
        }
        if (!CollectionUtils.isEmpty(hisList)) {
            DynamicObject[] arrInsertDobj = new DynamicObject[hisList.size()];
            arrInsertDobj = hisList.toArray(arrInsertDobj);
            SaveServiceHelper.save((DynamicObject[])arrInsertDobj);
        }
    }

    static {
        editSaveExcludeFields = Lists.newArrayList((Object[])new String[]{"billno", "org", "skssqq", "skssqz", "templateid", "createtime", "creator", "attachment"});
    }
}

