/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxdeclare;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.taxc.bdtaxr.business.formula.TemplateFormulaSerivce;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareTemplateService;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareTemplateServiceImpl;
import kd.taxc.bdtaxr.business.template.DynamicRowMSService;
import kd.taxc.bdtaxr.business.template.impl.DynamicRowMSServiceImpl;
import kd.taxc.bdtaxr.common.db.MapToTableUtils;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.declare.initparam.InitParamsService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.request.FormulaRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.FormulaCalResult;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.refactor.formula.service.CacheFormulaService;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import org.apache.commons.collections.CollectionUtils;

public class TaxDeclareDataServiceImpl
implements TaxDeclareDataService {
    private static Log LOGGER = LogFactory.getLog(TaxDeclareDataServiceImpl.class);
    private static DynamicRowMSService dynamicRowMSService = new DynamicRowMSServiceImpl();
    private static DeclareTemplateService declareTemplateService = new DeclareTemplateServiceImpl();
    private static final Set<String> FORMULA_DEFAULT_VALUE_ENTITY = Sets.newHashSet((Object[])new String[]{"tctb_declare_entry", "tccit_qysds_a107040", "tccit_qysds_a105080", "tccit_qysds_a107012_mx", "tccit_qysds_a105070", "tcvat_ybnsr_fb2"});

    @Override
    public DeclareResponseModel queryData(DeclareRequestModel declareModel) {
        Long templateId;
        DeclareResponseModel responseModel = new DeclareResponseModel();
        if (null == declareModel) {
            return responseModel;
        }
        Long id = declareModel.getId();
        Map data = new HashMap();
        Long l = templateId = declareModel.getTemplateId() != null ? declareModel.getTemplateId() : this.getTemplateId(declareModel);
        if (null == templateId) {
            return responseModel;
        }
        Map metaMap = new HashMap();
        declareModel.setTemplateId(templateId);
        metaMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId((Long)templateId);
        Map businessMap = declareModel.getBusinessMap().size() == 0 ? InitParamsService.getInitParams((String)declareModel.getTemplateType()).buildBizParam(declareModel) : declareModel.getBusinessMap();
        Map map = YbnsrService.queryYbnsrTable((String)String.valueOf(declareModel.getId()), metaMap);
        List dynRowList = DynamicRowService.getInitedDynData((Map)map, (Long)templateId);
        data = MapToTableUtils.tableToMapNew((Map)map, metaMap);
        responseModel.setId(id);
        responseModel.setTemplateId(templateId);
        responseModel.setMetaDataMap(metaMap);
        responseModel.setData(data);
        responseModel.setDynRowList(dynRowList);
        responseModel.setParamMap(businessMap);
        return responseModel;
    }

    @Override
    public DeclareResponseModel refreshData(DeclareRequestModel declareModel, Map<String, EntityField> metaTypeMap) {
        List<Sheet> baseTemplate;
        long l = System.currentTimeMillis();
        DeclareResponseModel responseModel = new DeclareResponseModel();
        if (null == declareModel) {
            return responseModel;
        }
        Long id = declareModel.getId() != null ? declareModel.getId() : TaxDeclareDataServiceImpl.generateSBBId(null);
        declareModel.setId(id);
        HashMap<String, String> data = new HashMap<String, String>();
        Long templateId = declareModel.getTemplateId();
        if (null == templateId) {
            return responseModel;
        }
        Map metaMap = declareModel.getMetaDataMap();
        List dynRowList = null;
        FormulaRequestModel formulaRequest = new FormulaRequestModel();
        formulaRequest.setTemplateId(templateId);
        Map businessMap = declareModel.getBusinessMap().size() == 0 ? InitParamsService.getInitParams((String)declareModel.getTemplateType()).buildBizParam(declareModel) : declareModel.getBusinessMap();
        HashMap paramMap = new HashMap();
        HashMap<String, Long> ruleParamMap = new HashMap<String, Long>();
        ruleParamMap.put("orgId", declareModel.getOrgId());
        if (declareModel.getExtendParams() != null && declareModel.getExtendParams().size() > 0) {
            ruleParamMap.putAll(declareModel.getExtendParams());
        }
        if (businessMap != null) {
            paramMap.putAll(businessMap);
            ruleParamMap.putAll(businessMap);
        }
        ruleParamMap.put("sbbid", id);
        formulaRequest.setRuleParamMap(ruleParamMap);
        formulaRequest.setParamMap(paramMap);
        String result = dynamicRowMSService.getDynamicRowList(formulaRequest.getTemplateId(), formulaRequest.getRuleParamMap());
        dynRowList = JsonUtil.fromJsonList((String)result, DynamicRowModel.class);
        if (CollectionUtils.isNotEmpty((Collection)dynRowList)) {
            Map<String, Object> dynMap = dynamicRowMSService.getDynRowData(result);
            formulaRequest.getParamMap().putAll(dynMap);
        }
        if (CollectionUtils.isEmpty((Collection)(baseTemplate = declareModel.getBaseTemplate()))) {
            baseTemplate = this.getBaseTemplateByTemplateId(templateId);
        }
        Map<String, String> reportItems = this.getAllReportItems(baseTemplate, dynRowList);
        metaTypeMap = TaxDeclarePluginService.expanFieldsTypeByDynRow(metaTypeMap, dynRowList);
        FormulaCollectionVo allFormulas = CacheFormulaService.getAllFormulasVo((Long)templateId, (List)dynRowList);
        formulaRequest.setDynRowList(dynRowList);
        DeclareService declareService = new DeclareService();
        Map nsrxxMap = new DeclareService().createYbnsr(declareModel, true);
        formulaRequest.setDataMap(nsrxxMap);
        Map preDataMap = declareModel.getPreData();
        if (preDataMap != null && !preDataMap.isEmpty()) {
            formulaRequest.getDataMap().putAll(preDataMap);
            allFormulas = this.removeFormulaByPreData(allFormulas, preDataMap);
        }
        formulaRequest.setFormulas(allFormulas);
        TemplateFormulaSerivce formulaSerivce = new TemplateFormulaSerivce();
        FormulaCalResult calResult = formulaSerivce.initCal(formulaRequest, metaMap, metaTypeMap);
        Map calMap = calResult.getData();
        TaxDeclarePluginService.removeInvalidKey(metaMap, dynRowList, declareService, calMap);
        data.putAll(calMap);
        data.putAll(nsrxxMap);
        this.addDefaultData(data, reportItems, metaTypeMap);
        LOGGER.info("\u91cd\u65b0\u8ba1\u7b97\u53d6\u6570data\uff1a{}\uff0c\u6a21\u677f\u7c7b\u578b\uff1a{}", data, (Object)declareModel.getTemplateType());
        responseModel.setId(id);
        responseModel.setTemplateId(templateId);
        responseModel.setMetaDataMap(metaMap);
        responseModel.setData(data);
        responseModel.setErrorInfo(calResult.getErrorInfo());
        responseModel.setDynRowList(dynRowList);
        HashMap<String, String> param = new HashMap<String, String>();
        for (Map.Entry entry : paramMap.entrySet()) {
            try {
                param.put(entry.getKey().toString(), entry.getValue().toString());
            }
            catch (Exception e) {
                LOGGER.error("Illigal params:" + e);
            }
        }
        responseModel.setParamMap(param);
        long l1 = System.currentTimeMillis();
        LOGGER.info("refreshData cost:{}ms", (Object)(l1 - l));
        return responseModel;
    }

    @Override
    public List<DynamicRowModel> calDynRowData(DeclareRequestModel declareModel) {
        Map businessMap;
        HashMap<String, Object> ruleParamMap = new HashMap<String, Object>();
        ruleParamMap.put("orgId", declareModel.getOrgId());
        if (declareModel.getExtendParams() != null && declareModel.getExtendParams().size() > 0) {
            ruleParamMap.putAll(declareModel.getExtendParams());
        }
        Map map = businessMap = declareModel.getBusinessMap().size() == 0 ? InitParamsService.getInitParams((String)declareModel.getTemplateType()).buildBizParam(declareModel) : declareModel.getBusinessMap();
        if (businessMap != null) {
            ruleParamMap.putAll(businessMap);
        }
        Long id = declareModel.getId() != null ? declareModel.getId() : TaxDeclareDataServiceImpl.generateSBBId(null);
        ruleParamMap.put("sbbid", id);
        Long templateId = declareModel.getTemplateId();
        if (null == templateId) {
            return new ArrayList<DynamicRowModel>(0);
        }
        String result = dynamicRowMSService.getDynamicRowList(templateId, ruleParamMap);
        List dynRowList = JsonUtil.fromJsonList((String)result, DynamicRowModel.class);
        return dynRowList;
    }

    @Override
    public DeclareResponseModel calData(DeclareRequestModel declareModel, Map<String, EntityField> metaTypeMap, List<DynamicRowModel> dynRowList) {
        List<Sheet> baseTemplate;
        long l = System.currentTimeMillis();
        DeclareResponseModel responseModel = new DeclareResponseModel();
        if (null == declareModel) {
            return responseModel;
        }
        Long id = declareModel.getId() != null ? declareModel.getId() : TaxDeclareDataServiceImpl.generateSBBId(null);
        declareModel.setId(id);
        HashMap<String, String> data = new HashMap<String, String>();
        Long templateId = declareModel.getTemplateId();
        if (null == templateId) {
            return responseModel;
        }
        Map metaMap = declareModel.getMetaDataMap();
        FormulaRequestModel formulaRequest = new FormulaRequestModel();
        formulaRequest.setTemplateId(templateId);
        Map businessMap = declareModel.getBusinessMap().size() == 0 ? InitParamsService.getInitParams((String)declareModel.getTemplateType()).buildBizParam(declareModel) : declareModel.getBusinessMap();
        HashMap paramMap = new HashMap();
        HashMap<String, Long> ruleParamMap = new HashMap<String, Long>();
        ruleParamMap.put("orgId", declareModel.getOrgId());
        if (declareModel.getExtendParams() != null && declareModel.getExtendParams().size() > 0) {
            ruleParamMap.putAll(declareModel.getExtendParams());
        }
        if (businessMap != null) {
            paramMap.putAll(businessMap);
            ruleParamMap.putAll(businessMap);
        }
        ruleParamMap.put("sbbid", id);
        formulaRequest.setRuleParamMap(ruleParamMap);
        formulaRequest.setParamMap(paramMap);
        String result = dynamicRowMSService.getDynamicRowList(formulaRequest.getTemplateId(), formulaRequest.getRuleParamMap());
        if (CollectionUtils.isNotEmpty(dynRowList)) {
            Map<String, Object> dynMap = dynamicRowMSService.getDynRowData(JSONObject.toJSONString(dynRowList));
            formulaRequest.getParamMap().putAll(dynMap);
        }
        if (CollectionUtils.isEmpty((Collection)(baseTemplate = declareModel.getBaseTemplate()))) {
            baseTemplate = this.getBaseTemplateByTemplateId(templateId);
        }
        Map<String, String> reportItems = this.getAllReportItems(baseTemplate, dynRowList);
        metaTypeMap = TaxDeclarePluginService.expanFieldsTypeByDynRow(metaTypeMap, dynRowList);
        FormulaCollectionVo allFormulas = CacheFormulaService.getAllFormulasVo((Long)templateId, dynRowList);
        formulaRequest.setDynRowList(dynRowList);
        DeclareService declareService = new DeclareService();
        Map nsrxxMap = new DeclareService().createYbnsr(declareModel, true);
        formulaRequest.setDataMap(nsrxxMap);
        Map preDataMap = declareModel.getPreData();
        if (preDataMap != null && !preDataMap.isEmpty()) {
            formulaRequest.getDataMap().putAll(preDataMap);
            allFormulas = this.removeFormulaByPreData(allFormulas, preDataMap);
        }
        formulaRequest.setFormulas(allFormulas);
        TemplateFormulaSerivce formulaSerivce = new TemplateFormulaSerivce();
        FormulaCalResult calResult = formulaSerivce.initCal(formulaRequest, metaMap, metaTypeMap);
        Map calMap = calResult.getData();
        TaxDeclarePluginService.removeInvalidKey(metaMap, dynRowList, declareService, calMap);
        data.putAll(calMap);
        data.putAll(nsrxxMap);
        this.addDefaultData(data, reportItems, metaTypeMap);
        LOGGER.info("\u91cd\u65b0\u8ba1\u7b97\u53d6\u6570data\uff1a{}\uff0c\u6a21\u677f\u7c7b\u578b\uff1a{}", data, (Object)declareModel.getTemplateType());
        responseModel.setId(id);
        responseModel.setTemplateId(templateId);
        responseModel.setMetaDataMap(metaMap);
        responseModel.setData(data);
        responseModel.setErrorInfo(calResult.getErrorInfo());
        responseModel.setDynRowList(dynRowList);
        HashMap<String, String> param = new HashMap<String, String>();
        for (Map.Entry entry : paramMap.entrySet()) {
            try {
                param.put(entry.getKey().toString(), entry.getValue().toString());
            }
            catch (Exception e) {
                LOGGER.error("Illigal params:" + e);
            }
        }
        responseModel.setParamMap(param);
        long l1 = System.currentTimeMillis();
        LOGGER.info("refreshData cost:{}ms", (Object)(l1 - l));
        return responseModel;
    }

    private List<Sheet> getBaseTemplateByTemplateId(Long templateId) {
        DynamicObject templateContentObj = TemplateUtils.getTemplateDynamicObjectById((Long)templateId);
        String templateContent = templateContentObj.getString("content_tag");
        return SpreadUtils.getSheets((String)templateContent, null);
    }

    private Map<String, String> getAllReportItems(List<Sheet> baseTemplate, List<DynamicRowModel> dynRowModelList) {
        if (CollectionUtils.isEmpty(baseTemplate)) {
            return null;
        }
        HashMap<String, String> items = new HashMap<String, String>(baseTemplate.size() * 20);
        Map<String, Map<String, String>> sheetCellMap = this.getReportItemsByTemplate(baseTemplate, dynRowModelList);
        for (Map<String, String> value : sheetCellMap.values()) {
            items.putAll(value);
        }
        return items;
    }

    public Map<String, Map<String, String>> getReportItemsByTemplate(List<Sheet> baseTemplate, List<DynamicRowModel> dynRowModelList) {
        HashMap<String, Map<String, String>> sheetCellMap = new HashMap<String, Map<String, String>>(baseTemplate.size());
        for (Sheet e : baseTemplate) {
            HashMap<String, String> cellsMap = new HashMap<String, String>();
            List rowList = e.getRowList();
            if (CollectionUtils.isEmpty((Collection)rowList)) continue;
            for (int i = 0; i < rowList.size(); ++i) {
                List cellList = (List)rowList.get(i);
                if (CollectionUtils.isEmpty((Collection)cellList)) continue;
                int dynRowListSize = 0;
                boolean rowListMatch = false;
                boolean isDynamicRow = false;
                for (Cell cell : cellList) {
                    String cellKey = cell.getCellKey();
                    if (cellKey == null || !cellKey.contains("#")) continue;
                    if (!rowListMatch) {
                        DynamicRowModel model;
                        DynamicRowModel dynamicRowModel = model = CollectionUtils.isEmpty(dynRowModelList) ? null : DynamicRowService.matchDyn(dynRowModelList, (String)cellKey);
                        if (model != null) {
                            List dynRowList = model.getRowList();
                            isDynamicRow = true;
                            dynRowListSize = CollectionUtils.isEmpty((Collection)dynRowList) ? 0 : dynRowList.size();
                        }
                    }
                    rowListMatch = true;
                    if (isDynamicRow && dynRowListSize == 0) continue;
                    cellsMap.put(cellKey, cellKey);
                    for (int j = 2; j <= dynRowListSize; ++j) {
                        String newCellKey = DynamicRowService.getNewKey((String)cellKey, (long)j);
                        cellsMap.put(newCellKey, newCellKey);
                    }
                }
            }
            sheetCellMap.put(e.getId(), cellsMap);
        }
        return sheetCellMap;
    }

    private FormulaCollectionVo removeFormulaByPreData(FormulaCollectionVo allFormulas, Map<String, String> preData) {
        if (preData == null || preData.isEmpty()) {
            return allFormulas;
        }
        Map formulaVoMap = allFormulas.getFormulas();
        Map ruleFormulasMap = allFormulas.getRformulas();
        Map mFormulasMap = allFormulas.getMformulas();
        Map qformulasMap = allFormulas.getQformulas();
        for (String key : preData.keySet()) {
            formulaVoMap.remove(key);
            ruleFormulasMap.remove(key);
            mFormulasMap.remove(key);
            qformulasMap.remove(key);
        }
        allFormulas.setFormulas(formulaVoMap);
        allFormulas.setRformulas(ruleFormulasMap);
        allFormulas.setMformulas(mFormulasMap);
        allFormulas.setQformulas(qformulasMap);
        return allFormulas;
    }

    @Override
    public DeclareResponseModel queryHistoryData(DeclareRequestModel declareModel, Map<String, Object> customParams) {
        return this.queryDeclareData(declareModel, customParams, "bdtaxr_history_sbb");
    }

    @Override
    public DeclareResponseModel queryTaxBureauData(DeclareRequestModel declareModel, Map<String, Object> customParams) {
        return this.queryDeclareData(declareModel, customParams, "bdtaxr_taxbureau_sbb");
    }

    private DeclareResponseModel queryDeclareData(DeclareRequestModel declareModel, Map<String, Object> customParams, String entitySbb) {
        DeclareResponseModel responseModel = new DeclareResponseModel();
        String sbbid = (String)customParams.get("sbbid");
        DynamicObject historySbb = BusinessDataServiceHelper.loadSingle((String)entitySbb, (String)"templateid,org,type,skssqq,skssqz,declaredata_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sbbid))});
        if (historySbb == null) {
            return responseModel;
        }
        Map originalData = (Map)JsonUtil.fromJson((String)historySbb.getString("declaredata_tag"), Map.class);
        HashMap<String, String> data = new HashMap<String, String>(originalData.size());
        originalData.forEach((k, v) -> data.put((String)k, v != null ? v.toString() : null));
        Long templateId = Long.valueOf(historySbb.getString("templateid"));
        Map metaMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId((Long)templateId);
        Map businessMap = declareModel.getBusinessMap().size() == 0 ? InitParamsService.getInitParams((String)declareModel.getTemplateType()).buildBizParam(declareModel) : declareModel.getBusinessMap();
        List dynRowList = DynamicRowService.getDynRowSetList((Long)templateId);
        this.setDynRowList(dynRowList, data);
        responseModel.setId(Long.valueOf(sbbid));
        responseModel.setTemplateId(templateId);
        responseModel.setMetaDataMap(metaMap);
        responseModel.setData(data);
        responseModel.setDynRowList(dynRowList);
        responseModel.setParamMap(businessMap);
        return responseModel;
    }

    private void setDynRowList(List<DynamicRowModel> dynRowList, Map<String, String> data) {
        if (EmptyCheckUtils.isNotEmpty(dynRowList)) {
            Map<String, DynamicRowModel> dynRowMap = dynRowList.stream().collect(Collectors.toMap(d -> d.getDynRowNo().split("#")[0], r -> r));
            HashMap<String, List> dynRowListEntityMap = new HashMap<String, List>();
            HashMap<String, Map> rowDataMap = new HashMap<String, Map>();
            for (Map.Entry<String, String> entry : data.entrySet()) {
                String[] split = entry.getKey().split("#");
                String entity = split[0];
                String ewblxh = split[1];
                List mapList = dynRowListEntityMap.computeIfAbsent(entity, t -> new ArrayList());
                Map rowMap = rowDataMap.computeIfAbsent(entity + "#" + ewblxh, t -> {
                    DynamicRowModel dynamicRowModel = (DynamicRowModel)dynRowMap.get(entity);
                    if (dynamicRowModel == null) {
                        HashMap objectObjectHashMap = new HashMap();
                        mapList.add(objectObjectHashMap);
                        return objectObjectHashMap;
                    }
                    try {
                        Long ewblxhInt = Long.parseLong(ewblxh);
                        if (ewblxhInt >= dynamicRowModel.getStartRow()) {
                            HashMap objectObjectHashMap = new HashMap();
                            mapList.add(objectObjectHashMap);
                            return objectObjectHashMap;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                });
                if (rowMap == null) continue;
                rowMap.put(entry.getKey(), entry.getValue());
            }
            for (DynamicRowModel dynamicRowModel : dynRowList) {
                String dynRowNo = dynamicRowModel.getDynRowNo();
                dynamicRowModel.setRowList((List)dynRowListEntityMap.get(dynRowNo.split("#")[0]));
            }
        }
    }

    public static Long generateSBBId(String entityName) {
        if (StringUtils.isNotBlank((CharSequence)entityName)) {
            return DBServiceHelper.genLongIds((String)entityName, (int)1)[0];
        }
        return DBServiceHelper.genLongIds((String)"tcvat_nsrxx", (int)1)[0];
    }

    private Long getTemplateId(DeclareRequestModel declareModel) {
        if (null == declareModel || StringUtils.isBlank((CharSequence)declareModel.getSkssqq()) || StringUtils.isBlank((CharSequence)declareModel.getSkssqz()) || StringUtils.isBlank((CharSequence)declareModel.getTemplateType())) {
            return null;
        }
        return declareTemplateService.getTemplateId(declareModel.getTemplateType(), String.valueOf(declareModel.getOrgId()), DateUtils.stringToDate((String)declareModel.getSkssqq(), (String)"yyyy-MM-dd"), DateUtils.stringToDate((String)declareModel.getSkssqz(), (String)"yyyy-MM-dd"));
    }

    @Override
    public List<DynamicRowModel> getDynRowList(DeclareRequestModel declareModel) {
        Map businessMap = declareModel.getBusinessMap();
        HashMap paramMap = new HashMap();
        HashMap<String, Object> ruleParamMap = new HashMap<String, Object>();
        ruleParamMap.put("orgId", declareModel.getOrgId());
        if (declareModel.getExtendParams() != null && declareModel.getExtendParams().size() > 0) {
            ruleParamMap.putAll(declareModel.getExtendParams());
        }
        if (businessMap != null) {
            paramMap.putAll(businessMap);
            ruleParamMap.putAll(businessMap);
        }
        if (declareModel.getBusinessValue("maindataid") != null) {
            ruleParamMap.put("maindataid", Long.valueOf(declareModel.getBusinessValue("maindataid")));
        }
        ruleParamMap.put("sbbid", declareModel.getId());
        ruleParamMap.put("skssqq", declareModel.getSkssqq());
        ruleParamMap.put("skssqz", declareModel.getSkssqz());
        ruleParamMap.put("operation", declareModel.getOperation());
        ruleParamMap.put("modelId", declareModel.getModelId());
        ruleParamMap.put("templateId", declareModel.getTemplateId());
        ruleParamMap.put("cacheId", UUID.randomUUID());
        ruleParamMap.put("customEvent", declareModel.getCustomEvent());
        String result = dynamicRowMSService.getDynamicRowList(declareModel.getTemplateId(), ruleParamMap);
        return JsonUtil.fromJsonList((String)result, DynamicRowModel.class);
    }

    private void addDefaultData(Map<String, String> data, Map<String, String> reportItemMap, Map<String, EntityField> metaTypeMap) {
        if (reportItemMap == null || reportItemMap.isEmpty()) {
            return;
        }
        for (String reportItemKey : reportItemMap.keySet()) {
            if (data.get(reportItemKey) != null || metaTypeMap == null || metaTypeMap.get(reportItemKey) == null) continue;
            EntityField entityField = metaTypeMap.get(reportItemKey);
            String value = DataFormatUtils.dataFormatByFieldType((Object)"", (EntityField)entityField);
            data.put(reportItemKey, value);
        }
    }

    @Deprecated
    private void addDefaultData(Map<String, String> data, Map<String, String> metaMap, List<DynamicRowModel> dynRowList, Long templateId) {
        HashMap<String, String> dynTableMap = new HashMap<String, String>();
        if (dynRowList != null) {
            for (DynamicRowModel dynamicRowModel : dynRowList) {
                String dynRowNo = dynamicRowModel.getDynRowNo();
                String tableName = dynRowNo.split("#")[0];
                dynTableMap.put(tableName, tableName);
            }
        }
        Map entityFieldMap = TemplateUtils.getAllEntity(metaMap);
        Map metadataRowList = TemplateFormulaServiceHelper.getMetadataRowList((Long)templateId);
        entityFieldMap.entrySet().stream().forEach(v -> {
            String key = (String)v.getKey();
            String[] split = key.split("#");
            String tableName = split[0];
            EntityField fieldType = (EntityField)v.getValue();
            if ("#Integer#Decimal#decimal".contains(fieldType.getFieldType()) && !data.containsKey(key) && !dynTableMap.containsKey(tableName)) {
                Set formulaRows = (Set)metadataRowList.get(tableName);
                if (FORMULA_DEFAULT_VALUE_ENTITY.contains(tableName)) {
                    String prefix = split[0] + "#" + split[1] + "#";
                    if (formulaRows != null && formulaRows.contains(prefix)) {
                        data.put(key, TemplateUtils.dataFormatPreSave((Object)"0", (EntityField)fieldType));
                    }
                } else {
                    data.put(key, TemplateUtils.dataFormatPreSave((Object)"0", (EntityField)fieldType));
                }
            }
            if ("text".equalsIgnoreCase(fieldType.getFieldType()) && !data.containsKey(key) && !dynTableMap.containsKey(tableName)) {
                data.put(key, TemplateUtils.dataFormatPreSave((Object)"", (EntityField)fieldType));
            }
        });
    }
}

