/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxdeclare;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.formula.FormulaService;
import kd.taxc.bdtaxr.business.formula.impl.FormulaServiceImpl;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.service.taxdeclare.BaseDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.ChangeDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareRequestService;
import kd.taxc.bdtaxr.business.service.taxdeclare.SavetaxDeclareService;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareReportService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.BaseDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.ChangeDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareRequestServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.SavetaxDeclareServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.business.subplugin.declare.DeclareBizExtendHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.DeclareReportCalculateFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.DeclareReportCalculateService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.DeclareReportHideFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.DeclareReportHideService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.DeclareReportSaveFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.DeclareReportSaveService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.DeclareReportTreeFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.service.DeclareReportTreeService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.refactor.declare.savecheck.TaxDeclareCheckFactory;
import kd.taxc.bdtaxr.common.refactor.formula.service.CacheFormulaService;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.TctrcwarningVo;

public class TaxDeclareReportServiceImpl
implements TaxDeclareReportService {
    private static Log LOGGER = LogFactory.getLog(TaxDeclareReportServiceImpl.class);
    private DeclareReportCalculateService declareReportCalculateService;
    private DeclareReportTreeService declareReportTreeService;
    private DeclareReportSaveService declareReportSaveService;
    private DeclareRequestService declareRequestService = new DeclareRequestServiceImpl();
    private static TaxDeclareDataService taxDeclareDataService = new TaxDeclareDataServiceImpl();
    private static BaseDataService baseDataService = new BaseDataServiceImpl();
    private static ChangeDataService changeDataService = new ChangeDataServiceImpl();
    private static SavetaxDeclareService savetaxDeclareService = new SavetaxDeclareServiceImpl();
    private static FormulaService formulaService = new FormulaServiceImpl();
    private DeclareReportHideService declareReportHideService;

    @Override
    public void generateDeclare() {
    }

    @Override
    public void recalDeclare(String declareRequestJson) {
        DeclareRequestModel requestModel = this.declareRequestService.build(declareRequestJson);
        requestModel.setRefresh(Boolean.valueOf(true));
        requestModel.setOperation("edit");
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, null);
        DeclareResponseModel responseModel = taxDeclareDataService.refreshData(requestModel, typeMap);
        this.declareReportCalculateService = DeclareReportCalculateFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportCalculateService != null) {
            responseModel = this.declareReportCalculateService.afterCalculate(requestModel, responseModel, responseModel.getDynRowList(), typeMap);
        }
        TaxDeclarePluginService.checkResponse(requestModel, responseModel);
        Map currentMap = responseModel.getData();
        List<Map<String, String>> checkResultList = formulaService.checkFormulasNew(requestModel, currentMap, responseModel.getParamMap(), responseModel.getDynRowList());
        TctrcwarningVo riskResultMap = TaxDeclarePluginService.getRiskResult(requestModel);
        BaseResult baseResult = TaxDeclareCheckFactory.createHandler((String)requestModel.getTemplateType()).beforeSaveCheck(null, currentMap, responseModel);
        if (500 == baseResult.getCode()) {
            throw new KDBizException("Calculate Response Data Error!");
        }
        String sbbId = String.valueOf(requestModel.getId());
        Map<String, String> resultMap = savetaxDeclareService.saveTaxDeclare(sbbId, null, currentMap, null, requestModel, responseModel, currentMap);
        savetaxDeclareService.saveRiskItem(sbbId, checkResultList, riskResultMap.getTctrcwarning(), 2);
        Map<String, Object> treeData = null;
        this.declareReportTreeService = DeclareReportTreeFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportTreeService != null) {
            treeData = this.declareReportTreeService.loadTreeByCurrentData(requestModel, responseModel, requestModel.getSheetName(), requestModel.getDataSource(), currentMap);
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>(1);
        if (requestModel.getExtendParams() != null) {
            requestMap.putAll(requestModel.getExtendParams());
        }
        requestMap.put("orgId", requestModel.getOrgId());
        requestMap.put("skssqq", requestModel.getSkssqq());
        requestMap.put("skssqz", requestModel.getSkssqz());
        requestMap.put("Id", requestModel.getId());
        requestMap.putAll(requestModel.getBusinessMap());
        requestMap.put("remarks", requestModel.getBusinessValue("remarks"));
        HashMap<String, Object> resultMap1 = new HashMap<String, Object>(resultMap);
        this.declareReportSaveService = DeclareReportSaveFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportSaveService != null) {
            BaseResult saveResult = this.declareReportSaveService.saveTeeData(requestModel, treeData == null || treeData.isEmpty() ? null : treeData.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue())));
            BaseResult baseResult2 = this.declareReportSaveService.saveBusinessData(requestMap, resultMap1);
        }
        DeclareBizExtendHelper.saveBusinessData(requestMap, resultMap1);
    }

    @Override
    public String export(DeclareRequestModel requestModel, boolean isNewTemplate) {
        Map<String, String> valMap;
        Map<String, EntityField> typeMap = null;
        Map cellTypeFormulas = null;
        if (isNewTemplate) {
            long start = System.currentTimeMillis();
            DeclareResponseModel responseModel = taxDeclareDataService.queryData(requestModel);
            LOGGER.info("TaxDeclareReportServiceImpl.queryData:" + (System.currentTimeMillis() - start));
            valMap = responseModel.getData();
            typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, responseModel.getDynRowList());
            valMap = changeDataService.changeToShow(valMap, responseModel, typeMap, "");
            cellTypeFormulas = CacheFormulaService.getCellTypeFormulas((Long)requestModel.getTemplateId(), (List)responseModel.getDynRowList());
            baseDataService.queryBaseData(valMap, responseModel.getDynRowList(), requestModel);
        } else {
            valMap = TemplateShowUtils.queryData((String)requestModel.getTemplateType(), (String)requestModel.getId().toString(), (String)"_");
        }
        List<String> hideSheets = null;
        this.declareReportHideService = DeclareReportHideFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportHideService != null) {
            hideSheets = this.declareReportHideService.hideSheets(requestModel);
        }
        DynamicObject template = TemplateUtils.getTemplateDynamicObjectById((Long)requestModel.getTemplateId());
        long start = System.currentTimeMillis();
        String templateHtml = isNewTemplate ? kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils.downResultExcelNew((DynamicObject)template, hideSheets, (Map)valMap, typeMap, cellTypeFormulas) : TemplateShowUtils.downResultExcel((DynamicObject)template, hideSheets, (Map)valMap);
        LOGGER.info("TaxDeclareReportServiceImpl.downResultExcelNew:" + (System.currentTimeMillis() - start));
        return templateHtml;
    }
}

