/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxdeclare;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.serviceImpl.taxablelist.TaxableListDeclareConsumerFactory;
import kd.taxc.bdtaxr.business.serviceImpl.taxablelist.TaxableListDeclareConsumerService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxableListDraftConsumer;
import kd.taxc.bdtaxr.common.enums.DeclareCateGory;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessage;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessageData;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TaxableListDeclareConsumer
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(TaxableListDraftConsumer.class);
    private static final String BDTAXR_TAXABLE_LISTING = "bdtaxr_taxable_listing";
    private static final String FIELDS = "org,skssqq,skssqz,paystatus,declarestatus,taxcatetory,taxauthority,month,sbbcategory,dgcategory,draftstatus,sbbno,templateid,templatetype,modifytime";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        String str = (String)message;
        LOGGER.info("TaxableListDeclareConsumer messageId:{}, message:{}", (Object)messageId, (Object)str);
        try {
            DeclareMQMessage declareMQMessage = (DeclareMQMessage)SerializationUtils.fromJsonString((String)str, DeclareMQMessage.class);
            String templateType = declareMQMessage.getDeclareType();
            DeclareCateGory declareCateGory = DeclareCateGory.valueOfTemplateType((String)templateType);
            if (declareCateGory != null) {
                String sbbid = declareMQMessage.getSbbid();
                Long org = declareMQMessage.getOrg();
                Long taxauthority = declareMQMessage.getTaxauthority();
                String category = declareCateGory.getCategory();
                Date month = DateUtils.getFirstDateOfMonth((Date)new Date());
                if ("totf".equals(declareCateGory.getAppId()) && declareCateGory != DeclareCateGory.WHSYJSF) {
                    this.callUpdateTaxableList(declareMQMessage, declareCateGory, declareCateGory.getAppId());
                } else if ("tcret".equals(declareCateGory.getAppId())) {
                    this.callUpdateTaxableList(declareMQMessage, declareCateGory, declareCateGory.getAppId());
                } else if ("gtcp".equals(declareCateGory.getAppId())) {
                    Date skssqq = DateUtils.stringToDate((String)declareMQMessage.getSkssqq());
                    Date skssqz = DateUtils.stringToDate((String)declareMQMessage.getSkssqz());
                    QFilter filter = new QFilter("org", "=", (Object)org).and("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)skssqz))).and("sbbcategory", "=", (Object)category).and("taxationsys", "=", (Object)declareMQMessage.getTaxationsys()).and("taxareagroup", "=", (Object)declareMQMessage.getTaxareagroup());
                    this.updateStatus(declareMQMessage, filter);
                } else {
                    Date skssqq = DateUtils.stringToDate((String)declareMQMessage.getSkssqq());
                    Date skssqz = DateUtils.stringToDate((String)declareMQMessage.getSkssqz());
                    if (DeclareMQEvent.PAY.name().equals(declareMQMessage.getTopic())) {
                        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(sbbid));
                        DynamicObject tcvat_nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,org,skssqq,skssqz", (QFilter[])new QFilter[]{qFilter});
                        skssqq = tcvat_nsrxx.getDate("skssqq");
                        skssqz = tcvat_nsrxx.getDate("skssqz");
                    }
                    QFilter filter = new QFilter("org", "=", (Object)org).and("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)skssqz))).and("sbbcategory", "=", (Object)category);
                    if (declareCateGory == DeclareCateGory.WHSYJSF) {
                        filter.and("taxcatetory", "=", (Object)DeclareTaxType.WHSYJSF.getBaseTaxId());
                    }
                    if (!Arrays.asList("tcvat", "tccit", "tcct").contains(declareCateGory.getAppId())) {
                        filter.and("taxauthority", "=", (Object)taxauthority);
                    }
                    this.updateStatus(declareMQMessage, filter);
                }
                acker.ack(messageId);
                LOGGER.info("TaxableListDeclareConsumer ack messageId:{}, message:{}", (Object)messageId, (Object)str);
                return;
            }
        }
        catch (Throwable throwable) {
            LOGGER.error(String.format("TaxableListDeclareConsumer execute error!messageId:%s, message:%s", messageId, str), throwable);
            acker.discard(messageId);
        }
        acker.discard(messageId);
        LOGGER.info("TaxableListDeclareConsumer discard messageId:{}, message:{}", (Object)messageId, (Object)str);
    }

    private void callUpdateTaxableList(DeclareMQMessage declareMQMessage, DeclareCateGory declareCateGory, String appId) {
        TaxableListDeclareConsumerService service = TaxableListDeclareConsumerFactory.getService(appId);
        List<QFilter> lists = service.getUpdateFilters(declareMQMessage, declareCateGory);
        if (EmptyCheckUtils.isNotEmpty(lists)) {
            for (QFilter qFilter : lists) {
                if (qFilter == null) continue;
                this.updateStatus(declareMQMessage, qFilter);
            }
        }
    }

    private void doEntryDataUpdate(DeclareMQMessage declareMQMessage, Long org, Long taxauthority, String category, Date month) {
        List datas = declareMQMessage.getData();
        for (DeclareMQMessageData data : datas) {
            Date skssqq = DateUtils.stringToDate((String)data.getSkssqq());
            Date skssqz = DateUtils.stringToDate((String)data.getSkssqz());
            Long taxcatetory = this.getTaxcatetory(data);
            QFilter filter = new QFilter("org", "=", (Object)org).and("skssqq", "=", (Object)DateUtils.trunc((Date)skssqq)).and("skssqz", "<=", (Object)DateUtils.trunc((Date)skssqz)).and("sbbcategory", "=", (Object)category).and("taxcatetory", "=", (Object)taxcatetory).and("taxauthority", "=", (Object)taxauthority);
            this.updateStatus(declareMQMessage, filter);
        }
    }

    private Long getTaxcatetory(DeclareMQMessageData data) {
        try {
            return Long.parseLong(data.getTaxType());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return 0L;
        }
    }

    private void doTotfUpdate(DeclareMQMessage declareMQMessage, String sbbid, String category, Date month) {
        if (DeclareMQEvent.SAVE.name().equals(declareMQMessage.getEvent())) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage());
            }
        }
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(sbbid));
        DynamicObjectCollection tcvat_nsrxx = QueryServiceHelper.query((String)"totf_tysb_declare_main", (String)"id,org,billno,type,declaredate,taxauthority,declarestatus,paystatus,entryentity.startdate as skssqq,entryentity.enddate as skssqz,entryentity.zspm as zspm", (QFilter[])new QFilter[]{qFilter});
        LOGGER.info("tcvat_nsrxx.size():{}", (Object)tcvat_nsrxx.size());
        if (tcvat_nsrxx.size() > 0) {
            for (DynamicObject tcvatNsrxx : tcvat_nsrxx) {
                if (tcvatNsrxx.getString("zspm") == null) continue;
                Date skssqq = tcvatNsrxx.getDate("skssqq");
                Date skssqz = tcvatNsrxx.getDate("skssqz");
                Long org = tcvatNsrxx.getLong("org");
                Long taxauthority = tcvatNsrxx.getLong("taxauthority");
                Long taxcatetory = ZspmEnum.getTaxcatetoryByNameAndTemplateType((String)tcvatNsrxx.getString("zspm"), (String)category);
                if (taxcatetory == null) continue;
                QFilter filter = new QFilter("org", "=", (Object)org).and("skssqq", "=", (Object)DateUtils.trunc((Date)skssqq)).and("skssqz", "<=", (Object)DateUtils.trunc((Date)skssqz)).and("sbbcategory", "=", (Object)category).and("taxcatetory", "=", (Object)taxcatetory).and("taxauthority", "=", (Object)taxauthority);
                this.updateStatus(declareMQMessage, filter);
            }
        }
    }

    private void updateStatus(DeclareMQMessage declareMQMessage, QFilter filter) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)BDTAXR_TAXABLE_LISTING, (String)FIELDS, (QFilter[])filter.toArray());
        if (load != null) {
            Date now = new Date();
            for (DynamicObject dynamicObject : load) {
                if (DeclareMQEvent.DELETE.name().equals(declareMQMessage.getEvent())) {
                    dynamicObject.set("paystatus", (Object)"unpaid");
                    dynamicObject.set("declarestatus", (Object)"nodata");
                    dynamicObject.set("sbbno", null);
                } else {
                    dynamicObject.set("paystatus", (Object)declareMQMessage.getPaystatus());
                    dynamicObject.set("declarestatus", (Object)declareMQMessage.getDeclarestatus());
                    dynamicObject.set("sbbno", (Object)declareMQMessage.getBillno());
                }
                dynamicObject.set("modifytime", (Object)now);
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }
}

