/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxdeclare;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.enums.DraftCateGory;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.draft.DraftMQMessage;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxableListDraftConsumer
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(TaxableListDraftConsumer.class);
    private static final String BDTAXR_TAXABLE_LISTING = "bdtaxr_taxable_listing";
    private static final String FIELDS = "org,skssqq,skssqz,paystatus,declarestatus,taxcatetory,taxauthority,month,sbbcategory,dgcategory,draftstatus,sbbno,draftno,templateid,templatetype,modifytime";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        String str = (String)message;
        LOGGER.info("TaxableListDraftConsumer messageId:{}, message:{}", (Object)messageId, (Object)str);
        try {
            DraftMQMessage draftMQMessage = (DraftMQMessage)SerializationUtils.fromJsonString((String)str, DraftMQMessage.class);
            String drafttype = draftMQMessage.getDrafttype();
            DraftCateGory draftCateGory = DraftCateGory.valueOfDraftType((String)drafttype);
            if (draftCateGory != null) {
                DynamicObject[] load;
                Date skssqq = DateUtils.stringToDate((String)draftMQMessage.getSkssqq());
                Date skssqz = DateUtils.stringToDate((String)draftMQMessage.getSkssqz());
                Date now = new Date();
                Long org = draftMQMessage.getOrg();
                QFilter filter = new QFilter("org", "=", (Object)org).and("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)skssqz))).and("dgcategory", "=", (Object)draftCateGory.getCategory());
                if ("gtcp".equals(draftCateGory.getAppId())) {
                    filter.and("taxationsys", "=", (Object)draftMQMessage.getTaxationsys()).and("taxareagroup", "=", (Object)draftMQMessage.getTaxareagroup());
                }
                if ((load = BusinessDataServiceHelper.load((String)BDTAXR_TAXABLE_LISTING, (String)FIELDS, (QFilter[])filter.toArray())) != null) {
                    for (DynamicObject dynamicObject : load) {
                        if (DeclareMQEvent.DELETE.name().equals(draftMQMessage.getEvent())) {
                            dynamicObject.set("draftstatus", (Object)"nodata");
                            dynamicObject.set("draftno", null);
                        } else {
                            dynamicObject.set("draftstatus", (Object)draftMQMessage.getBillstatus());
                            if (StringUtils.isNotBlank((CharSequence)draftMQMessage.getBillno())) {
                                dynamicObject.set("draftno", (Object)draftMQMessage.getBillno());
                            }
                        }
                        dynamicObject.set("modifytime", (Object)now);
                    }
                    SaveServiceHelper.save((DynamicObject[])load);
                }
                acker.ack(messageId);
                LOGGER.info("TaxableListDraftConsumer ack messageId:{}, message:{}", (Object)messageId, (Object)str);
                return;
            }
        }
        catch (Throwable throwable) {
            LOGGER.error(String.format("TaxableListDraftConsumer execute error!messageId:%s, message:%s", messageId, str), throwable);
            acker.discard(messageId);
        }
        acker.discard(messageId);
        LOGGER.info("TaxableListDraftConsumer discard messageId:{}, message:{}", (Object)messageId, (Object)str);
    }
}

