/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.serviceImpl.taxdeclare;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxableListService;
import kd.taxc.bdtaxr.business.task.helper.TaxMainValidateHelper;
import kd.taxc.bdtaxr.common.constant.RuleFetchConstant;
import kd.taxc.bdtaxr.common.db.DynamicObjectUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxableListEnum;
import kd.taxc.bdtaxr.common.helper.bos.view.ViewDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.address.RegisterAddressUtil;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.TaxBaseDataUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.EngineResponse;

public class TaxableListServiceImpl
implements TaxableListService {
    private static final Log LOGGER = LogFactory.getLog(TaxableListServiceImpl.class);
    private static final ArrayList<String> TAX_CARD_ENABLE_LIST = Lists.newArrayList((Object[])new String[]{"tcvat", "tccit", "totf"});
    private static final ArrayList<String> LICENSE_ZERO_DECLARE_LIST = Lists.newArrayList((Object[])new String[]{"tcvat", "tccit"});
    private static final ArrayList<String> QYSDSNB_TYPE = Lists.newArrayList((Object[])new String[]{"qysdsnb", "qysdsnb_fzjg", "qysds_hdzs_nb"});
    private static final String BDTAXR_TAXABLE_LISTING = "bdtaxr_taxable_listing";

    @Override
    public List<Map<String, Object>> queryTimely(List<Long> orgList, List<String> sbbCategories, List<String> draftCategors, Date queryDate, int queryType) {
        LOGGER.info("TaxableListServiceImpl-queryTimely \u8bf7\u6c42\u53c2\u6570\uff1aorgList:{},sbbCategories:{},draftCategories:{},queryDate:{},queryType:{},", new Object[]{orgList != null ? orgList.size() : 0, sbbCategories != null ? sbbCategories.size() : 0, draftCategors != null ? draftCategors.size() : 0, queryDate, queryType});
        if (queryDate == null) {
            queryDate = new Date();
        }
        if (orgList == null) {
            TaxResult allOrg = ViewDataServiceHelper.getAllOrg();
            orgList = (List<Long>)TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer((List)((List)allOrg.getData())).getData();
        }
        if (EmptyCheckUtils.isEmpty(orgList)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        List<Object> result = new ArrayList(orgList.size() * 8);
        TaxableListEnum[] taxableListEnums = TaxableListEnum.values();
        orgList = this.filterTaxMain(orgList);
        switch (queryType) {
            case 1: {
                List<TaxableListEnum> collect;
                if (draftCategors != null) {
                    collect = draftCategors.stream().map(a -> TaxableListEnum.valueOfDgCode((String)a)).flatMap(Collection::stream).collect(Collectors.toList());
                    taxableListEnums = collect.toArray(new TaxableListEnum[collect.size()]);
                }
                result = this.queryDraftList(orgList, queryDate, taxableListEnums);
                break;
            }
            case 2: {
                List<TaxableListEnum> collect;
                if (sbbCategories != null) {
                    collect = sbbCategories.stream().map(a -> TaxableListEnum.valueOfSbbCode((String)a)).flatMap(Collection::stream).collect(Collectors.toList());
                    taxableListEnums = collect.toArray(new TaxableListEnum[collect.size()]);
                }
                result = this.queryDeclareList(orgList, queryDate, taxableListEnums);
                break;
            }
            case 3: {
                List<TaxableListEnum> collect;
                if (draftCategors != null) {
                    collect = draftCategors.stream().map(a -> TaxableListEnum.valueOfDgCode((String)a)).flatMap(Collection::stream).collect(Collectors.toList());
                    taxableListEnums = collect.toArray(new TaxableListEnum[collect.size()]);
                } else {
                    taxableListEnums = TaxableListEnum.values();
                }
                List<Map<String, Object>> draftList = this.queryDraftList(orgList, queryDate, taxableListEnums);
                if (sbbCategories != null) {
                    List<TaxableListEnum> collect2 = sbbCategories.stream().map(a -> TaxableListEnum.valueOfSbbCode((String)a)).flatMap(Collection::stream).collect(Collectors.toList());
                    taxableListEnums = collect2.toArray(new TaxableListEnum[collect2.size()]);
                } else {
                    taxableListEnums = TaxableListEnum.values();
                }
                List<Map<String, Object>> declareList = this.queryDeclareList(orgList, queryDate, taxableListEnums);
                result.addAll(this.mergeData(declareList, draftList));
            }
        }
        ArrayList<Map<String, Object>> filterResult = new ArrayList<Map<String, Object>>(result.size());
        Map<Long, DynamicObject> orgTaxcMainMap = this.queryOrgTaxcMainMap(orgList);
        for (Map map : result) {
            String category = (String)map.get("sbbcategory");
            if (category == null) {
                category = (String)map.get("dgcategory");
            }
            boolean registerTimeBeforeExecuteTime = TaxMainValidateHelper.registerTimeBeforeExecuteTime(orgTaxcMainMap.get(map.get("org")), queryDate, category);
            boolean inDeclarePeriod = this.inDeclarePeriod(map, queryDate, category);
            if (!registerTimeBeforeExecuteTime || !inDeclarePeriod) continue;
            filterResult.add(map);
        }
        LOGGER.info("TaxableListServiceImpl-queryTimely \u7ed3\u679c\uff1a{}", (Object)result.size());
        LOGGER.info("TaxableListServiceImpl-queryTimely \u8fc7\u6ee4\u7ed3\u679c\uff1a{}", (Object)filterResult.size());
        return filterResult;
    }

    private List<Map<String, Object>> queryDraftList(List<Long> orgList, Date queryDate, TaxableListEnum[] taxableListEnums) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map<String, List<TaxableListEnum>> group = Arrays.stream(taxableListEnums).filter(a -> StringUtil.isNotEmpty((CharSequence)a.getDgCategory())).collect(Collectors.groupingBy(a -> a.getAppId()));
        for (Map.Entry<String, List<TaxableListEnum>> entry : group.entrySet()) {
            String appId = entry.getKey();
            Optional<TaxableListEnum> any = entry.getValue().stream().filter(a -> StringUtil.isNotEmpty((CharSequence)a.getDgCategory())).findAny();
            if (!any.isPresent()) continue;
            List<Long> appOrgList = this.doBatchFilter(appId, orgList, 1);
            List<String> draftCategories = entry.getValue().stream().map(a -> a.getDgCategory()).distinct().collect(Collectors.toList());
            List<Map<String, Object>> draftList = this.getRecordList(appOrgList, queryDate, appId, draftCategories, "queryDraftTaxableList");
            result.addAll(draftList);
        }
        return result;
    }

    private List<Map<String, Object>> queryDeclareList(List<Long> orgList, Date queryDate, TaxableListEnum[] taxableListEnums) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map<String, List<TaxableListEnum>> group = Arrays.stream(taxableListEnums).filter(a -> StringUtil.isNotEmpty((CharSequence)a.getSbbCategory())).collect(Collectors.groupingBy(a -> a.getAppId()));
        for (Map.Entry<String, List<TaxableListEnum>> entry : group.entrySet()) {
            String appId = entry.getKey();
            LicenseCheckResult licenseCheckResult = (LicenseCheckResult)TaxcLicenseCheckDataServiceHelper.checkTxftPerformGroup((String)appId).getData();
            if (!licenseCheckResult.getHasLicense().booleanValue()) {
                LOGGER.error("\u6ca1\u6709\u8bb8\u53efmsg:{},\u5e94\u7528\uff1a{}", (Object)licenseCheckResult.getMsg(), (Object)appId);
                continue;
            }
            Optional<TaxableListEnum> any = entry.getValue().stream().filter(a -> StringUtil.isNotEmpty((CharSequence)a.getSbbCategory())).findAny();
            if (!any.isPresent()) continue;
            List<Long> appOrgList = this.doBatchFilter(appId, orgList, 2);
            List<String> declareCategories = entry.getValue().stream().map(a -> a.getSbbCategory()).distinct().collect(Collectors.toList());
            List<Map<String, Object>> taxableList = this.getRecordList(appOrgList, queryDate, appId, declareCategories, "queryDeclareTaxableList");
            result.addAll(taxableList);
        }
        return result;
    }

    private List<Long> doBatchFilter(String appId, List<Long> orgList, int queryType) {
        List filteOrgList = orgList;
        if (queryType == 3 || EmptyCheckUtils.isEmpty(filteOrgList)) {
            return filteOrgList;
        }
        if (queryType == 2) {
            if (LICENSE_ZERO_DECLARE_LIST.contains(appId)) {
                TaxResult result = TaxcLicenseCheckDataServiceHelper.checkBatch(filteOrgList, (String)appId);
                Map licenseMap = result == null ? new HashMap() : (Map)result.getData();
                Map zeroDeclareMap = SystemParamUtil.getAppParameterBatch((String)appId, (String)"zerodeclare", (List)filteOrgList);
                filteOrgList = filteOrgList.stream().filter(a -> Objects.equals(zeroDeclareMap.get(a), true) || Boolean.FALSE.equals(licenseMap.getOrDefault(a, Boolean.TRUE))).collect(Collectors.toList());
            }
        } else if (queryType == 1) {
            LicenseCheckResult licenseCheckResult = LicenseCheckServiceHelper.checkTxftPerformGroup((String)"tcdrs");
            if (!licenseCheckResult.getHasLicense().booleanValue()) {
                LOGGER.info("{}\u6ca1\u6709\u5e95\u7a3f\u8bb8\u53ef", (Object)appId);
                return new ArrayList<Long>();
            }
            if (LICENSE_ZERO_DECLARE_LIST.contains(appId)) {
                TaxResult result = TaxcLicenseCheckDataServiceHelper.checkBatch((List)filteOrgList, (String)appId);
                Map licenseMap = result == null ? new HashMap() : (Map)result.getData();
                filteOrgList = filteOrgList.stream().filter(a -> Boolean.FALSE.equals(licenseMap.getOrDefault(a, Boolean.TRUE))).collect(Collectors.toList());
            }
        }
        if (EmptyCheckUtils.isNotEmpty(filteOrgList) && TAX_CARD_ENABLE_LIST.contains(appId)) {
            filteOrgList = TaxBaseDataUtils.getTaxEnableFromTaxMain(filteOrgList, (String)appId);
        }
        return filteOrgList;
    }

    private List<Long> filterTaxMain(List<Long> filteOrgList) {
        if (EmptyCheckUtils.isNotEmpty(filteOrgList)) {
            Map<Long, Map<String, String>> isTaxPayerAuthMap = this.validationTaxOrgMustInputBatch(filteOrgList, "tcvat_draft_page", Boolean.TRUE);
            filteOrgList = filteOrgList.stream().filter(a -> {
                Map map = (Map)isTaxPayerAuthMap.get(a);
                return map != null && Objects.equals(map.get("code"), "false");
            }).collect(Collectors.toList());
        }
        return filteOrgList;
    }

    public Map<Long, Map<String, String>> validationTaxOrgMustInputBatch(List<Long> orgList, String name, boolean needErrorMsg) {
        HashMap<Long, Map<String, String>> result = new HashMap<Long, Map<String, String>>();
        for (Long org : orgList) {
            Map<String, String> map = this.requestOrgMustInput(name, needErrorMsg, org);
            result.put(org, map);
        }
        return result;
    }

    private Map<String, String> requestOrgMustInput(String name, boolean needErrorMsg, Long org) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"OrgService", (String)"validationTaxOrgMustInput", (Object[])new Object[]{org, name, needErrorMsg});
    }

    private List<Map<String, Object>> getRecordList(List<Long> orgList, Date queryDate, String appId, List<String> categories, String declareMethodName) {
        try {
            LOGGER.info("TaxableListServiceImpl-getRecordList \u8bf7\u6c42\u53c2\u6570\uff1aappId:{},categories:{},orgList.length:{},queryDate:{},declareMethodName:{},", new Object[]{appId, JsonUtil.toJson(categories), orgList.size(), queryDate, declareMethodName});
            if (EmptyCheckUtils.isNotEmpty(orgList)) {
                List result = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)appId, (String)"TaxableListQueryService", (String)declareMethodName, (Object[])new Object[]{orgList, categories, queryDate});
                LOGGER.info("TaxableListServiceImpl-getRecordList \u7ed3\u679c\uff1aappId:{},{}", (Object)appId, (Object)(result == null ? 0 : result.size()));
                return result;
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("TaxableListServiceImpl-getRecordList error %s-%s:orglist:%s,categories:%s,appid:%s", "TaxableListQueryService", declareMethodName, orgList.size(), JsonUtil.toJson(categories), appId), (Throwable)e);
        }
        return new ArrayList<Map<String, Object>>(0);
    }

    private List<Map<String, Object>> mergeData(List<Map<String, Object>> declareList, List<Map<String, Object>> draftList) {
        if (EmptyCheckUtils.isEmpty(declareList)) {
            return draftList;
        }
        if (EmptyCheckUtils.isNotEmpty(declareList) && EmptyCheckUtils.isNotEmpty(draftList)) {
            Map<String, Map> dgMap = draftList.stream().collect(Collectors.toMap(this::getUniqKey, b -> b, (m, n) -> m));
            ArrayList<String> containsKeys = new ArrayList<String>();
            for (Map<String, Object> map : declareList) {
                String uniqKey = this.getUniqKey(map);
                if (!dgMap.containsKey(uniqKey)) continue;
                containsKeys.add(uniqKey);
                Map dg = dgMap.get(uniqKey);
                map.put("draftstatus", dg.get("draftstatus"));
                map.put("draftno", dg.get("draftno"));
                map.put("dgcategory", dg.get("dgcategory"));
            }
            declareList.addAll(draftList.stream().filter(d -> !containsKeys.contains(this.getUniqKey((Map<String, Object>)d))).collect(Collectors.toList()));
        }
        return declareList;
    }

    private String getUniqKey(Map<String, Object> a) {
        return String.format("%s-%s-%s-%s-%s-%s-%s", a.get("org"), DateUtils.format((Date)((Date)a.get("skssqq"))), DateUtils.format((Date)((Date)a.get("skssqz"))), a.getOrDefault("taxauthority", 0L), a.getOrDefault("taxcatetory", 0L), a.getOrDefault("taxationsys", 0L), a.getOrDefault("taxareagroup", 0L));
    }

    @Override
    public List<Map<String, Object>> queryFromDb(List<Long> orgList, List<Long> taxCategories, Date queryDate) {
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter taxFilter = new QFilter("taxcatetory", "in", taxCategories);
        QFilter monthFilter = new QFilter("month", "<=", (Object)DateUtils.getLastDateOfMonth((Date)queryDate)).and("month", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)queryDate));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)BDTAXR_TAXABLE_LISTING, (String)"id,org,skssqq,skssqz,paystatus,declarestatus,taxcatetory,taxauthority,sbbcategory,dgcategory,draftstatus,sbbno,month,modifytime,templatetype,templateid,deadline,taxationsys,taxareagroup", (QFilter[])new QFilter[]{orgFilter, taxFilter, monthFilter});
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap map = new HashMap();
            DynamicObjectUtils.transferDynamicObjectToMap((DynamicObject)dynamicObject, map);
            result.add(map);
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> queryFromDb(List<Long> orgList, List<Long> taxCategories, Date queryDate, List<String> templateTypes) {
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter taxFilter = new QFilter("taxcatetory", "in", taxCategories);
        QFilter monthFilter = new QFilter("month", "<=", (Object)DateUtils.getLastDateOfMonth((Date)queryDate)).and("month", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)queryDate));
        QFilter[] filters = new QFilter[]{orgFilter, taxFilter, monthFilter};
        if (!CollectionUtils.isEmpty(templateTypes)) {
            QFilter templateTypeFilter = new QFilter("templatetype", "in", templateTypes);
            filters = new QFilter[]{orgFilter, taxFilter, monthFilter, templateTypeFilter};
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)BDTAXR_TAXABLE_LISTING, (String)"id,org,skssqq,skssqz,paystatus,declarestatus,taxcatetory,taxauthority,sbbcategory,dgcategory,draftstatus,sbbno,month,modifytime,templatetype,templateid,deadline,taxationsys,taxareagroup", (QFilter[])filters);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap map = new HashMap();
            DynamicObjectUtils.transferDynamicObjectToMap((DynamicObject)dynamicObject, map);
            result.add(map);
        }
        return result;
    }

    @Override
    public void updateTaxableListToDB() {
        Date now = new Date();
        this.updateToDBByCondition(now, null, null, null);
    }

    @Override
    public String updateToDBByCondition(Date declareDate, List<Long> orgList, List<String> sbbCategories, List<String> draftCategors) {
        EngineResponse engineResponse = new EngineResponse();
        try {
            Date month = DateUtils.getFirstDateOfMonth((Date)declareDate);
            LOGGER.info("start taxableListService.queryTimely");
            long l = System.currentTimeMillis();
            List<Map<String, Object>> maps = this.queryTimely(orgList, sbbCategories, draftCategors, declareDate, 3);
            LOGGER.info("end taxableListService.queryTimely cost time:{}", (Object)(System.currentTimeMillis() - l));
            int size = maps != null ? maps.size() : 0;
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(size * 2);
            for (Map<String, Object> objectMap : maps) {
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)BDTAXR_TAXABLE_LISTING));
                objectMap.forEach((k, v) -> dynamicObject.set(k, v));
                Date deadLine = this.calcDeadLine(objectMap, declareDate);
                dynamicObject.set("deadline", (Object)deadLine);
                dynamicObject.set("month", (Object)month);
                dynamicObject.set("modifytime", (Object)declareDate);
                dynamicObject.set("skssqq", (Object)DateUtils.trunc((Date)dynamicObject.getDate("skssqq")));
                dynamicObject.set("skssqz", (Object)DateUtils.trunc((Date)dynamicObject.getDate("skssqz")));
                dynamicObjectList.add(dynamicObject);
            }
            try (TXHandle h = TX.required((String)"updateTaxableList");){
                try {
                    QFilter qFilter = new QFilter("month", "=", (Object)month);
                    if (EmptyCheckUtils.isNotEmpty(orgList)) {
                        qFilter.and("org", "in", orgList);
                    }
                    DeleteServiceHelper.delete((String)BDTAXR_TAXABLE_LISTING, (QFilter[])qFilter.toArray());
                    if (EmptyCheckUtils.isNotEmpty(dynamicObjectList)) {
                        List partitions = Lists.partition(dynamicObjectList, (int)200);
                        for (List partition : partitions) {
                            SaveServiceHelper.save((DynamicObject[])partition.toArray(new DynamicObject[partition.size()]));
                        }
                    }
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw t;
                }
            }
            return SerializationUtils.toJsonString((Object)EngineResponse.success((String)"success", null));
        }
        catch (Exception e) {
            LOGGER.error("updateToDBByCondition Error!", (Throwable)e);
            engineResponse.setSuccess(Boolean.FALSE);
            engineResponse.setMessage(e.getMessage());
            return SerializationUtils.toJsonString((Object)engineResponse);
        }
    }

    private Map<Long, DynamicObject> queryOrgTaxcMainMap(List<Long> orgList) {
        Map<Long, Object> orgMap = new HashMap<Long, DynamicObject>();
        TaxResult taxcMainResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(orgList);
        if (taxcMainResult != null && taxcMainResult.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)taxcMainResult.getData()))) {
            List data = (List)taxcMainResult.getData();
            orgMap = data.stream().collect(Collectors.groupingBy(d -> d.getLong("orgid.id"), Collectors.reducing(null, (m, n) -> n)));
        }
        return orgMap;
    }

    private boolean inDeclarePeriod(Map<String, Object> map, Date declareDate, String category) {
        Date skssqq = (Date)map.get("skssqq");
        Date skssqz = (Date)map.get("skssqz");
        if (category == null) {
            return true;
        }
        switch (category) {
            case "zzs": 
            case "qysdsjb": {
                int minus = DateUtils.monthOfD1MinusD2((Date)skssqz, (Date)skssqq);
                if (minus == 0) {
                    return DateUtils.monthOfD1MinusD2((Date)declareDate, (Date)skssqq) == 1;
                }
                if (minus != 2) break;
                return DateUtils.isFirstMonthWithinSeason((Date)declareDate) && DateUtils.monthOfD1MinusD2((Date)declareDate, (Date)DateUtils.getFirstDateOfMonth((Date)skssqz)) == 1;
            }
            case "qysdsnb": {
                return DateUtils.getYearOfDate((Date)declareDate) - DateUtils.getYearOfDate((Date)skssqz) == 1 && DateUtils.isFront5Month((Date)declareDate);
            }
        }
        return true;
    }

    private Date calcDeadLine(Map<String, Object> objectMap, Date queryDate) {
        block6: {
            TaxableListDto dto = TaxableListDto.getInstanceFromMap(objectMap);
            if (dto.getTaxationsys() != null && !RuleFetchConstant.DEFALUT_TAXSYSTEM.equals(dto.getTaxationsys())) {
                return dto.getDeadline();
            }
            Long taxcatetory = dto.getTaxcatetory();
            String calenderTaxType = RegisterAddressUtil.getCalenderTaxType((Long)taxcatetory);
            if (calenderTaxType != null) {
                try {
                    List taxCalenderDate = RegisterAddressUtil.getTaxCalenderDate((Object)dto.getOrg(), (String)calenderTaxType, (Date)queryDate);
                    if (taxCalenderDate == null || taxCalenderDate.size() <= 0) break block6;
                    if (QYSDSNB_TYPE.contains(dto.getTemplatetype())) {
                        Optional<Map> first = taxCalenderDate.stream().filter(a -> "3".equals(a.get("methods"))).findFirst();
                        if (first.isPresent()) {
                            Date taxdate = (Date)first.get().get("taxdate");
                            return DateUtils.getDayLast((Date)taxdate);
                        }
                        break block6;
                    }
                    Date taxdate = (Date)((Map)taxCalenderDate.get(0)).get("taxdate");
                    return DateUtils.getDayLast((Date)taxdate);
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                }
            }
        }
        return null;
    }
}

