/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.task;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.enums.AccrualListEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.AccrualRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;

public class SingleAccrualTask
extends AbstractTask {
    private static final String SERVICE_NAME = "AccrualService";
    private static final String METHOD_NAME = "generate";
    private static final Log logger = LogFactory.getLog(SingleAccrualTask.class);

    public void execute(RequestContext context, Map<String, Object> map) throws KDException {
        try {
            String category = (String)map.get("category");
            AccrualListEnum cateGory = AccrualListEnum.valueOfCateGory((String)category);
            if (cateGory != null) {
                Object taxcatetory;
                Object taxareagroup;
                AccrualRequest accrualRequest = new AccrualRequest();
                accrualRequest.setOrgId(String.valueOf(map.get("orgid")));
                accrualRequest.setSkssqq(DateUtils.stringToDate((String)((String)map.get("startdate"))));
                accrualRequest.setSkssqz(DateUtils.stringToDate((String)((String)map.get("enddate"))));
                Object taxsystem = map.get("taxsystem");
                if (EmptyCheckUtils.isNotEmpty((Object)taxsystem)) {
                    accrualRequest.setTaxsystem(Long.valueOf(Long.parseLong(String.valueOf(taxsystem))));
                }
                if (EmptyCheckUtils.isNotEmpty((Object)(taxareagroup = map.get("taxareagroup")))) {
                    accrualRequest.setTaxareagroup(Long.valueOf(Long.parseLong(String.valueOf(taxareagroup))));
                }
                if (EmptyCheckUtils.isNotEmpty((Object)(taxcatetory = map.get("taxcatetory")))) {
                    accrualRequest.setTaxcatetory(Long.valueOf(Long.parseLong(String.valueOf(taxcatetory))));
                }
                accrualRequest.setCategory(category);
                accrualRequest.setAccrualDate(DateUtils.stringToDate((String)((String)map.get("executetime"))));
                String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)cateGory.getAppId(), (String)SERVICE_NAME, (String)METHOD_NAME, (Object[])new Object[]{SerializationUtils.toJsonString((Object)accrualRequest)});
                EngineResponse response = (EngineResponse)SerializationUtils.fromJsonString((String)result, EngineResponse.class);
                Boolean success = response.getSuccess();
                Map responseData = (Map)response.getData();
                HashMap<String, Object> params = new HashMap<String, Object>();
                if (Objects.nonNull(responseData)) {
                    if (Objects.nonNull(responseData.get("skssqq"))) {
                        params.put("skssqq", DateUtils.stringToDate((String)((String)responseData.get("skssqq"))));
                    }
                    if (Objects.nonNull(responseData.get("skssqz"))) {
                        params.put("skssqz", DateUtils.stringToDate((String)((String)responseData.get("skssqz"))));
                    }
                }
                params.put("success", success.toString());
                params.put("taskId", this.taskId);
                params.put("taskSerialNumber", map.get("taskSerialNumber"));
                params.put("executeDetail", response.getMessage());
                logger.info("\u7a0e\u52a1\u5de5\u4f5c\u53f0\u751f\u6210\u8ba1\u63d0\u5e95\u7a3f\u66f4\u65b0\u65e5\u5fd7\u53c2\u6570taskId\uff1a{}\uff1b\u7ed3\u679c\uff1a{}\uff1b\u6267\u884c\u8be6\u60c5\uff1a{}", new Object[]{this.taskId, success.toString(), response.getMessage()});
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaskMonistorService", (String)"updateTaskInfo", (Object[])new Object[]{params});
            }
        }
        catch (Throwable e) {
            logger.error("SingleAccrualTask error", e);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("success", Boolean.FALSE.toString());
            params.put("taskId", this.taskId);
            params.put("taskSerialNumber", map.get("taskSerialNumber"));
            params.put("executeDetail", e.getMessage());
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaskMonistorService", (String)"updateTaskInfo", (Object[])new Object[]{params});
            throw e;
        }
    }
}

