/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.task;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.business.task.helper.TaxMainValidateHelper;
import kd.taxc.bdtaxr.business.taskmonitor.AbstractTaskMonitorDetail;
import kd.taxc.bdtaxr.common.enums.DraftCateGory;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.DraftRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;

public class SingleDaftTask
extends AbstractTaskMonitorDetail {
    public static final String SERVICE_NAME = "DraftService";
    public static final String METHOD_NAME = "generate";
    private static final Log logger = LogFactory.getLog(SingleDaftTask.class);

    public Map<String, Object> buildSubTaskParams(RequestContext requestContext, Map<String, Object> map) {
        String category = (String)map.get("category");
        DraftCateGory cateGory = DraftCateGory.valueOfCode((String)category);
        if (cateGory != null) {
            Long orgId;
            EngineResponse response;
            DraftRequest draftRequest = new DraftRequest();
            draftRequest.setCategory(category);
            draftRequest.setDataType("schedule");
            draftRequest.setOrgId((String)map.get("orgid"));
            draftRequest.setStartDate(map.get("startdate") instanceof String ? DateUtils.stringToDate((String)((String)map.get("startdate"))) : null);
            draftRequest.setEndDate(map.get("enddate") instanceof String ? DateUtils.stringToDate((String)((String)map.get("enddate"))) : null);
            draftRequest.setExecuteTime(DateUtils.stringToDate((String)((String)map.get("executetime"))));
            if (map.get("taxationsys") != null) {
                draftRequest.setTaxationsys(Long.valueOf(String.valueOf(map.get("taxationsys"))));
            }
            draftRequest.setTaxareagroup((Long)map.get("taxareagroup"));
            if (map.get("taxcatetory") != null) {
                draftRequest.setTaxcatetory(Long.valueOf(String.valueOf(map.get("taxcatetory"))));
            }
            if ((response = TaxMainValidateHelper.buildResponseIfRegisterTimeAfterExecuteTime(orgId = Long.valueOf(Long.parseLong(String.valueOf(map.get("orgid")))), draftRequest.getExecuteTime())) == null) {
                String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)cateGory.getAppId(), (String)SERVICE_NAME, (String)METHOD_NAME, (Object[])new Object[]{SerializationUtils.toJsonString((Object)draftRequest)});
                response = (EngineResponse)SerializationUtils.fromJsonString((String)result, EngineResponse.class);
            }
            Boolean success = response.getSuccess();
            Map responseData = (Map)response.getData();
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (Objects.nonNull(responseData)) {
                if (Objects.nonNull(responseData.get("skssqq"))) {
                    params.put("skssqq", DateUtils.stringToDate((String)((String)responseData.get("skssqq"))));
                }
                if (Objects.nonNull(responseData.get("skssqz"))) {
                    params.put("skssqz", DateUtils.stringToDate((String)((String)responseData.get("skssqz"))));
                }
            }
            params.put("success", success.toString());
            params.put("taskId", this.taskId);
            params.put("taskSerialNumber", map.get("taskSerialNumber"));
            params.put("executeDetail", response.getMessage());
            logger.info("\u7a0e\u52a1\u5de5\u4f5c\u53f0\u751f\u6210\u5e95\u7a3f\u66f4\u65b0\u65e5\u5fd7\u53c2\u6570taskId\uff1a{}\uff1b\u7ed3\u679c\uff1a{}\uff1b\u6267\u884c\u8be6\u60c5\uff1a{}", new Object[]{this.taskId, success.toString(), response.getMessage()});
            return params;
        }
        return null;
    }
}

