/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.task;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.business.task.SingleDeclareTask;
import kd.taxc.bdtaxr.business.task.helper.TaxMainValidateHelper;
import kd.taxc.bdtaxr.common.enums.DeclareCateGory;
import kd.taxc.bdtaxr.common.enums.DraftCateGory;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.DeclareRequest;
import kd.taxc.bdtaxr.common.vo.DraftRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;

public class SingleSjjsTask
extends AbstractTask {
    public static final String DRAFT_SERVICE_NAME = "DraftService";
    public static final String DRAFT_METHOD_NAME = "generate";
    public static final String DECLARE_SERVICE_NAME = "DeclareService";
    public static final String DECLARE_METHOD_NAME = "generate";
    private static final Log logger = LogFactory.getLog(SingleDeclareTask.class);
    private static final HashMap<String, String> tipMap = new HashMap();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            String dgcategory = (String)map.get("dgcategory");
            String sbbcategory = (String)map.get("sbbcategory");
            String orgid = (String)map.get("orgid");
            DraftCateGory dgcateGory = DraftCateGory.valueOfCode((String)dgcategory);
            Date executetime = DateUtils.stringToDate((String)((String)map.get("executetime")));
            EngineResponse draftResponse = TaxMainValidateHelper.buildResponseIfRegisterTimeAfterExecuteTime(Long.parseLong(orgid), executetime);
            EngineResponse declareResponse = TaxMainValidateHelper.buildResponseIfRegisterTimeAfterExecuteTime(Long.parseLong(orgid), executetime);
            if (dgcateGory != null && map.get("draftstatus").equals("nodata")) {
                DraftRequest draftRequest = new DraftRequest();
                draftRequest.setCategory(dgcategory);
                draftRequest.setDataType("schedule");
                draftRequest.setOrgId(orgid);
                draftRequest.setStartDate(map.get("startdate") instanceof String ? DateUtils.stringToDate((String)((String)map.get("startdate"))) : null);
                draftRequest.setEndDate(map.get("enddate") instanceof String ? DateUtils.stringToDate((String)((String)map.get("enddate"))) : null);
                draftRequest.setExecuteTime(executetime);
                if (draftResponse == null) {
                    String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)dgcateGory.getAppId(), (String)DRAFT_SERVICE_NAME, (String)"generate", (Object[])new Object[]{SerializationUtils.toJsonString((Object)draftRequest)});
                    draftResponse = (EngineResponse)SerializationUtils.fromJsonString((String)result, EngineResponse.class);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)sbbcategory)) {
                DeclareCateGory sbbcateGory = DeclareCateGory.valueOfCode((String)sbbcategory);
                DeclareRequest declareRequest = new DeclareRequest();
                declareRequest.setCategory(sbbcategory);
                declareRequest.setDataType("schedule");
                declareRequest.setOrgId(orgid);
                declareRequest.setTaxcatetory((String)map.get("taxcatetory"));
                declareRequest.setExecuteTime(executetime);
                declareRequest.setStartDate(map.get("startdate") instanceof String ? DateUtils.stringToDate((String)((String)map.get("startdate"))) : null);
                declareRequest.setEndDate(map.get("enddate") instanceof String ? DateUtils.stringToDate((String)((String)map.get("enddate"))) : null);
                declareRequest.setCombineDeclare(Boolean.valueOf(Boolean.parseBoolean((String)map.get("combinedeclare"))));
                declareRequest.setTaxauthority((Long)map.get("taxauthority"));
                if (declareResponse == null) {
                    String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)sbbcateGory.getAppId(), (String)DECLARE_SERVICE_NAME, (String)"generate", (Object[])new Object[]{SerializationUtils.toJsonString((Object)declareRequest)});
                    declareResponse = (EngineResponse)SerializationUtils.fromJsonString((String)result, EngineResponse.class);
                }
                this.invokeTaskMonistor(dgcateGory, draftResponse, declareResponse, map);
            }
        }
        catch (Throwable e) {
            logger.error("SingleSjjsTask error", e);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("success", Boolean.FALSE.toString());
            params.put("taskId", this.taskId);
            params.put("taskSerialNumber", map.get("taskSerialNumber"));
            params.put("executeDetail", e.getMessage());
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaskMonistorService", (String)"updateTaskInfo", (Object[])new Object[]{params});
            throw e;
        }
    }

    private void invokeTaskMonistor(DraftCateGory dgcateGory, EngineResponse draftResponse, EngineResponse declareResponse, Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        Boolean declareSuccess = declareResponse.getSuccess();
        String declareMessage = declareResponse.getMessage();
        Boolean success = declareSuccess;
        if (dgcateGory != null) {
            Boolean draftSuccess = draftResponse.getSuccess();
            String draftMessage = draftResponse.getMessage();
            stringBuilder.append(String.format(ResManager.loadKDString((String)"\u5e95\u7a3f%1$s\u7533\u62a5\u8868%2$s", (String)"SingleSjjsTask_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), tipMap.get(draftSuccess.toString()), tipMap.get(declareSuccess.toString())));
            success = draftSuccess != false && declareSuccess != false;
            if (!success.booleanValue()) {
                stringBuilder.append(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a", (String)"SingleSjjsTask_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                if (!draftSuccess.booleanValue()) {
                    stringBuilder.append(draftMessage);
                }
                if (!declareSuccess.booleanValue()) {
                    stringBuilder.append(declareMessage);
                }
            }
        } else {
            stringBuilder.append(declareMessage);
        }
        Map responseData = (Map)declareResponse.getData();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (Objects.nonNull(responseData)) {
            if (Objects.nonNull(responseData.get("skssqq"))) {
                params.put("skssqq", DateUtils.stringToDate((String)((String)responseData.get("skssqq"))));
            }
            if (Objects.nonNull(responseData.get("skssqz"))) {
                params.put("skssqz", DateUtils.stringToDate((String)((String)responseData.get("skssqz"))));
            }
        }
        params.put("success", Boolean.toString(success));
        params.put("taskId", this.taskId);
        params.put("taskSerialNumber", map.get("taskSerialNumber"));
        params.put("executeDetail", stringBuilder.toString());
        logger.info("\u7a0e\u52a1\u5de5\u4f5c\u53f0\u7a0e\u91d1\u8ba1\u7b97\u66f4\u65b0\u65e5\u5fd7\u53c2\u6570taskId\uff1a{}\uff1b\u7ed3\u679c\uff1a{}\uff1b\u6267\u884c\u8be6\u60c5\uff1a{}", new Object[]{this.taskId, Boolean.toString(success), stringBuilder.toString()});
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaskMonistorService", (String)"updateTaskInfo", (Object[])new Object[]{params});
    }

    static {
        tipMap.put("true", ResManager.loadKDString((String)"\u3010\u751f\u6210\u6210\u529f\u3011", (String)"SingleSjjsTask_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        tipMap.put("false", ResManager.loadKDString((String)"\u3010\u751f\u6210\u5931\u8d25\u3011", (String)"SingleSjjsTask_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
    }
}

