/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.task.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BatchGenerateTaskOrgQueryHelper {
    public static List<String> getOrgList(Map<String, Object> map) {
        List<Object> orgList = new ArrayList();
        String orgs = (String)map.get("orgList");
        String taxLabel = (String)map.get("taxlabel");
        if (taxLabel != null) {
            Map taxlabelMap = (Map)JsonUtil.fromJson((String)taxLabel, Map.class);
            Long id = (Long)taxlabelMap.get("id");
            TaxResult orgAttrResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgAttrIds(Collections.singletonList(id));
            if (orgAttrResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)orgAttrResult.getData()))) {
                orgList = ((List)orgAttrResult.getData()).stream().map(String::valueOf).collect(Collectors.toList());
                if (StringUtils.isNotBlank((String)orgs)) {
                    orgList.addAll(Arrays.stream(orgs.split(",")).collect(Collectors.toList()));
                }
            }
        } else {
            orgList = StringUtils.isBlank((String)orgs) ? BatchGenerateTaskOrgQueryHelper.queryOrgList() : Arrays.stream(orgs.split(",")).collect(Collectors.toList());
        }
        return orgList;
    }

    private static List<String> queryOrgList() {
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByIsTaxpayer();
        return ((List)result.getData()).stream().map(o -> o.getString("taxorg.id")).collect(Collectors.toList());
    }
}

