/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.task.helper;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.EngineResponse;

public class TaxMainValidateHelper {
    public static EngineResponse buildResponseIfRegisterTimeAfterExecuteTime(Long orgId, Date executeTime) {
        DynamicObject data;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        if (result != null && result.isSuccess() && !TaxMainValidateHelper.registerTimeBeforeExecuteTimeAtMonth(data = (DynamicObject)result.getData(), executeTime)) {
            return EngineResponse.failByMsgCode((String)ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u672c\u6708\u65b0\u6ce8\u518c\u767b\u8bb0\uff0c\u672c\u6708\u65e0\u9700\u7533\u62a5\u3002", (String)"TaxMainValidateHelper_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)"");
        }
        return null;
    }

    public static boolean registerTimeBeforeExecuteTime(DynamicObject data, Date executeTime, String category) {
        if (category == null) {
            return true;
        }
        switch (category) {
            case "zzs": 
            case "qysdsjb": {
                return TaxMainValidateHelper.registerTimeBeforeExecuteTimeAtMonth(data, executeTime);
            }
            case "qysdsnb": {
                return TaxMainValidateHelper.registerTimeBeforeExecuteTimeAtYear(data, executeTime);
            }
        }
        return true;
    }

    public static boolean registerTimeBeforeExecuteTimeAtMonth(DynamicObject data, Date executeTime) {
        Date firstDayOfRegisterTime = DateUtils.getFirstDateOfMonth((Date)data.getDate("registertime"));
        return DateUtils.monthOfD1MinusD2((Date)executeTime, (Date)firstDayOfRegisterTime) > 0;
    }

    public static boolean registerTimeBeforeExecuteTimeAtYear(DynamicObject data, Date executeTime) {
        return DateUtils.getYearOfDate((Date)executeTime) - DateUtils.getYearOfDate((Date)data.getDate("registertime")) > 0;
    }
}

