/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxcode;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeDetailDto;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeResultDto;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeSubDetailDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxCodeResultBussiness {
    private static final Logger log = LoggerFactory.getLogger(TaxCodeResultBussiness.class);
    private static Log LOGGER = LogFactory.getLog(TaxCodeResultBussiness.class);

    public static DynamicObject[] getTaxDetails(long templateid, Long org, Date skssqq, Date skssqz, Object taxationsys, Object taxtype, Object taxareagroup, String reportkey, Object draftpurpose, String operation) {
        QFilter filter = new QFilter("templateid", "=", (Object)templateid).and("reportkey", "=", (Object)reportkey).and("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)skssqz).and("orgid", "=", (Object)org);
        if (!ObjectUtils.isEmpty((Object)taxationsys)) {
            filter.and("taxationsys", "=", (Object)Long.valueOf(taxationsys.toString()));
        }
        if (!ObjectUtils.isEmpty((Object)taxtype)) {
            filter.and("taxtype", "=", (Object)Long.valueOf(taxtype.toString()));
        }
        if (!ObjectUtils.isEmpty((Object)taxareagroup)) {
            filter.and("taxareagroup", "=", (Object)Long.valueOf(taxareagroup.toString()));
        }
        if (!ObjectUtils.isEmpty((Object)draftpurpose)) {
            filter.and("draftpurpose", "like", (Object)("%" + draftpurpose + "%"));
        }
        if ("read".equals(operation)) {
            filter.and("datastatus", "=", (Object)"1");
        } else {
            filter.and("datastatus", "=", (Object)"0");
        }
        return BusinessDataServiceHelper.load((String)"bdtaxr_tax_details", (String)"id,orgid,range,taxrate,intervalamount,intervalrateamount,taxcodetype,taxratetype", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject[] queryTaxcodeResult(long templateid, Long org, Date skssqq, Date skssqz, Object taxationsys, Object taxtype, Object taxareagroup, String reportkey, Object draftpurpose, String operation) {
        QFilter filter = new QFilter("templateid", "=", (Object)templateid).and("reportkey", "=", (Object)reportkey).and("skssqq", "=", (Object)skssqq).and("skssqz", "=", (Object)skssqz).and("orgid", "=", (Object)org);
        if (!ObjectUtils.isEmpty((Object)taxationsys)) {
            filter.and("taxationsys", "=", (Object)Long.valueOf(taxationsys.toString()));
        }
        if (!ObjectUtils.isEmpty((Object)taxtype)) {
            filter.and("taxtype", "=", (Object)Long.valueOf(taxtype.toString()));
        }
        if (!ObjectUtils.isEmpty((Object)taxareagroup)) {
            filter.and("taxareagroup", "=", (Object)Long.valueOf(taxareagroup.toString()));
        }
        if (!ObjectUtils.isEmpty((Object)draftpurpose)) {
            filter.and("draftpurpose", "like", (Object)("%" + draftpurpose + "%"));
        }
        if ("read".equals(operation)) {
            filter.and("datastatus", "=", (Object)"1");
        } else {
            filter.and("datastatus", "=", (Object)"0");
        }
        return BusinessDataServiceHelper.load((String)"bdtaxr_taxcode_result", (String)"id,orgid,splitstartdate,entryentity.resultnumber,entryentity.resultname,entryentity.intervalstartdate,entryentity.intervalenddate,entryentity.taxcodetype,entryentity.taxratetype,entryentity.days,entryentity.proportion,entryentity.taxbaseamount,entryentity.sumintervalamount,subentryentity.interval,subentryentity.intervalamount,subentryentity.intervaltaxrate,subentryentity.intervaltaxamount", (QFilter[])new QFilter[]{filter});
    }

    public static Map<String, Map<String, String>> queryTaxcodeResult(Map<String, Object> customParams) {
        LinkedHashMap<String, Map<String, String>> resultMap = new LinkedHashMap<String, Map<String, String>>(16);
        DynamicObject[] rows = TaxCodeResultBussiness.queryTaxcodeResult((Long)customParams.get("templateId"), Long.valueOf(customParams.get("org").toString()), DateUtils.stringToDate2((String)customParams.get("skssqq").toString()), DateUtils.stringToDate2((String)customParams.get("skssqz").toString()), customParams.get("taxationsys"), customParams.get("taxcategory"), customParams.get("taxareagroup"), customParams.get("cellid").toString(), customParams.get("draftpurpose"), customParams.get("operation").toString());
        if (ObjectUtils.isNotEmpty((Object)rows)) {
            for (DynamicObject row : rows) {
                DynamicObjectCollection collection = row.getDynamicObjectCollection("entryentity");
                if (!ObjectUtils.isNotEmpty((Object)collection)) continue;
                for (DynamicObject col : collection) {
                    LinkedHashMap<String, String> detailMap = new LinkedHashMap<String, String>(16);
                    detailMap.put("resultnumber", col.getString("resultnumber"));
                    detailMap.put("resultname", col.getString("resultname"));
                    detailMap.put("intervalstartdate", ObjectUtils.isEmpty((Object)col.get("intervalstartdate")) ? "" : DateUtils.format((Date)col.getDate("intervalstartdate")));
                    detailMap.put("intervalenddate", ObjectUtils.isEmpty((Object)col.get("intervalenddate")) ? "" : DateUtils.format((Date)col.getDate("intervalenddate")));
                    detailMap.put("intervaldate", String.format(ResManager.loadKDString((String)"%1$s\u81f3%2$s", (String)"TaxCodeResultBussiness_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), detailMap.get("intervalstartdate"), detailMap.get("intervalenddate")));
                    resultMap.put(col.getString("id"), detailMap);
                }
            }
        }
        return resultMap;
    }

    public static boolean saveTaxcodeResult(Long draftid) {
        DynamicObject[] dynamicObjectNewTaxs;
        DynamicObject[] dynamicObjects = TaxCodeResultBussiness.loadTaxdetails(draftid, false);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("datastatus", (Object)"1");
            }
        }
        if (ObjectUtils.isNotEmpty((Object)(dynamicObjectNewTaxs = TaxCodeResultBussiness.loadTaxcodeResult(draftid, false)))) {
            for (DynamicObject dynamicObject : dynamicObjectNewTaxs) {
                dynamicObject.set("datastatus", (Object)"1");
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)"bdtaxr_tax_details", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)draftid).and("datastatus", "=", (Object)"1")});
                DeleteServiceHelper.delete((String)"bdtaxr_taxcode_result", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)draftid).and("datastatus", "=", (Object)"1")});
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                SaveServiceHelper.save((DynamicObject[])dynamicObjectNewTaxs);
            }
            catch (Exception e) {
                h.markRollback();
                LOGGER.error("saveTaxcodeResult error:{}", (Object)e.getMessage());
                boolean bl = false;
                if (h != null) {
                    if (var4_7 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var4_7.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    public static void buildCopyData(Long draftid) {
        DynamicObject[] dynamicObjectNewTaxs;
        ArrayList<DynamicObject> newCopyOldTaxDataList = new ArrayList<DynamicObject>(12);
        ArrayList<DynamicObject> newCopyNewTaxDataList = new ArrayList<DynamicObject>(12);
        DynamicObject[] dynamicObjects = TaxCodeResultBussiness.loadTaxdetails(draftid, true);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            newCopyOldTaxDataList.addAll(TaxCodeResultBussiness.buildOldTaxScheduleData(dynamicObjects));
        }
        if (ObjectUtils.isNotEmpty((Object)(dynamicObjectNewTaxs = TaxCodeResultBussiness.loadTaxcodeResult(draftid, true)))) {
            newCopyNewTaxDataList.addAll(TaxCodeResultBussiness.buildNewTaxScheduleData(dynamicObjectNewTaxs));
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)"bdtaxr_tax_details", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)draftid).and("datastatus", "=", (Object)"0")});
                DeleteServiceHelper.delete((String)"bdtaxr_taxcode_result", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)draftid).and("datastatus", "=", (Object)"0")});
                SaveServiceHelper.save((DynamicObject[])newCopyOldTaxDataList.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])newCopyNewTaxDataList.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                h.markRollback();
                LOGGER.error("TaxCodeResultBussiness buildCopyData error:{}", (Object)e.getMessage());
            }
        }
    }

    public static List<DynamicObject> buildOldTaxScheduleData(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(12);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject taxDetails = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_tax_details");
            taxDetails.set("orgid", (Object)dynamicObject.getLong("orgid.id"));
            taxDetails.set("draftid", (Object)dynamicObject.getLong("draftid"));
            taxDetails.set("range", (Object)dynamicObject.getString("range"));
            taxDetails.set("reportkey", (Object)dynamicObject.getString("reportkey"));
            taxDetails.set("skssqq", (Object)dynamicObject.getDate("skssqq"));
            taxDetails.set("skssqz", (Object)dynamicObject.getDate("skssqz"));
            taxDetails.set("taxareagroup", (Object)dynamicObject.getLong("taxareagroup.id"));
            taxDetails.set("taxationsys", (Object)dynamicObject.getLong("taxationsys.id"));
            taxDetails.set("taxcodetype", (Object)dynamicObject.getLong("taxcodetype.id"));
            taxDetails.set("taxrate", dynamicObject.get("taxrate"));
            taxDetails.set("taxtype", (Object)dynamicObject.getLong("taxtype.id"));
            taxDetails.set("templateid", dynamicObject.get("templateid"));
            taxDetails.set("taxratetype", (Object)dynamicObject.getLong("taxratetype.id"));
            taxDetails.set("draftpurpose", (Object)dynamicObject.getString("draftpurpose"));
            taxDetails.set("datastatus", (Object)"0");
            result.add(taxDetails);
        }
        return result;
    }

    public static List<DynamicObject> buildNewTaxScheduleData(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(12);
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_taxcode_result");
            result.set("draftid", (Object)dynamicObject.getLong("draftid"));
            result.set("orgid", (Object)dynamicObject.getLong("orgid.id"));
            result.set("templateid", (Object)dynamicObject.getLong("templateid"));
            result.set("taxationsys", (Object)dynamicObject.getLong("taxationsys.id"));
            result.set("taxtype", (Object)dynamicObject.getLong("taxtype.id"));
            result.set("skssqq", (Object)dynamicObject.getDate("skssqq"));
            result.set("skssqz", (Object)dynamicObject.getDate("skssqz"));
            result.set("taxareagroup", (Object)dynamicObject.getLong("taxareagroup.id"));
            result.set("reportkey", (Object)dynamicObject.getString("reportkey"));
            result.set("draftpurpose", (Object)dynamicObject.getString("draftpurpose"));
            result.set("splitstartdate", (Object)dynamicObject.getDate("splitstartdate"));
            result.set("taxamount", dynamicObject.get("taxamount"));
            result.set("taxcode", (Object)dynamicObject.getString("taxcode"));
            result.set("createdate", (Object)dynamicObject.getDate("createdate"));
            result.set("creater", (Object)dynamicObject.getLong("creater.id"));
            result.set("datastatus", (Object)"0");
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            if (ObjectUtils.isNotEmpty((Object)dynamicObjectCollection)) {
                for (DynamicObject col : dynamicObjectCollection) {
                    DynamicObject detail = result.getDynamicObjectCollection("entryentity").addNew();
                    detail.set("totaldays", col.get("totaldays"));
                    detail.set("days", col.get("days"));
                    detail.set("proportion", col.get("proportion"));
                    detail.set("taxbaseamount", col.get("taxbaseamount"));
                    detail.set("sumintervalamount", col.get("sumintervalamount"));
                    detail.set("intervalstartdate", (Object)col.getDate("intervalstartdate"));
                    detail.set("intervalenddate", (Object)col.getDate("intervalenddate"));
                    detail.set("resultnumber", col.get("resultnumber"));
                    detail.set("resultname", col.get("resultname"));
                    detail.set("resultsource", col.get("resultsource.id"));
                    detail.set("resultid", col.get("resultid"));
                    detail.set("startdate", col.get("startdate"));
                    detail.set("enddate", col.get("enddate"));
                    detail.set("taxcodetype", (Object)col.getLong("taxcodetype.id"));
                    detail.set("taxratetype", (Object)col.getLong("taxratetype.id"));
                    detail.set("seq", col.get("seq"));
                    DynamicObjectCollection subentryentity = col.getDynamicObjectCollection("subentryentity");
                    if (!ObjectUtils.isNotEmpty((Object)subentryentity)) continue;
                    for (DynamicObject scol : subentryentity) {
                        DynamicObject subDetail = detail.getDynamicObjectCollection("subentryentity").addNew();
                        subDetail.set("seq", scol.get("seq"));
                        subDetail.set("interval", scol.get("interval"));
                        subDetail.set("intervaljson_tag", scol.get("intervaljson_tag"));
                        subDetail.set("intervaltaxrate", scol.get("intervaltaxrate"));
                        subDetail.set("intervalamount", scol.get("intervalamount"));
                        subDetail.set("intervaltaxamount", scol.get("intervaltaxamount"));
                    }
                }
            }
            resultList.add(result);
        }
        return resultList;
    }

    public static DynamicObject[] loadTaxdetails(Long draftid, boolean ispersistence) {
        QFilter filter = new QFilter("draftid", "=", (Object)draftid);
        if (ispersistence) {
            filter.and("datastatus", "=", (Object)"1");
        } else {
            filter.and("datastatus", "=", (Object)"0");
        }
        return BusinessDataServiceHelper.load((String)"bdtaxr_tax_details", (String)"id,draftid,orgid,templateid,range,taxrate,intervalamount,intervalrateamount,taxationsys,taxtype,skssqq,skssqz,reportkey,taxcodetype,taxareagroup,taxratetype,draftpurpose,datastatus", (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject[] loadTaxcodeResult(Long draftid, boolean ispersistence) {
        QFilter filter = new QFilter("draftid", "=", (Object)draftid);
        if (ispersistence) {
            filter.and("datastatus", "=", (Object)"1");
        } else {
            filter.and("datastatus", "=", (Object)"0");
        }
        return BusinessDataServiceHelper.load((String)"bdtaxr_taxcode_result", (String)"id,orgid,draftid,templateid,taxamount,taxationsys,taxtype,skssqq,skssqz,splitstartdate,reportkey,totaldays,taxareagroup,draftpurpose,datastatus,createdate,creater,taxcode,entryentity.resultnumber,entryentity.resultname,entryentity.intervalstartdate,entryentity.intervalenddate,\" +\n                \"entryentity.taxcodetype,entryentity.taxratetype,entryentity.days,entryentity.proportion,entryentity.taxbaseamount,entryentity.seq,entryentity.resultsource,entryentity.startdate,entryentity.enddate,entryentity.resultid,entryentity.taxcodetype,entryentity.sumintervalamount,entryentity.subentryentity,subentryentity,subentryentity.seq,subentryentity.intervaljson_tag,subentryentity.interval,subentryentity,subentryentity.intervalamount,subentryentity.intervaltaxrate,subentryentity.intervaltaxamount", (QFilter[])new QFilter[]{filter});
    }

    public static void deleteOldResult(TaxcodeResultDto resultDto, List<String> cellkeyList) {
        QFilter qfilter = new QFilter("orgid", "=", (Object)resultDto.getOrgId());
        qfilter.and(new QFilter("taxationsys", "=", (Object)resultDto.getTaxationsys()));
        qfilter.and(new QFilter("taxtype", "=", (Object)resultDto.getTaxtype()));
        qfilter.and(new QFilter("reportkey", "in", cellkeyList));
        qfilter.and(new QFilter("taxareagroup", "=", (Object)resultDto.getTaxareagroup()));
        qfilter.and(new QFilter("templateid", "=", (Object)resultDto.getTemplateId()));
        qfilter.and(new QFilter("draftpurpose", "=", (Object)resultDto.getDraftpurpose()));
        qfilter.and(new QFilter("skssqq", "=", (Object)resultDto.getSkssqq()));
        qfilter.and(new QFilter("skssqz", "=", (Object)resultDto.getSkssqz()));
        qfilter.and(new QFilter("datastatus", "=", (Object)"0"));
        DeleteServiceHelper.delete((String)"bdtaxr_taxcode_result", (QFilter[])new QFilter[]{qfilter});
        DeleteServiceHelper.delete((String)"bdtaxr_tax_details", (QFilter[])new QFilter[]{qfilter});
    }

    public static void saveResult(List<TaxcodeResultDto> resultDtoList) {
        ArrayList<DynamicObject> saveResultList = new ArrayList<DynamicObject>(12);
        if (ObjectUtils.isNotEmpty(resultDtoList)) {
            try {
                for (TaxcodeResultDto resultDto : resultDtoList) {
                    if (ObjectUtils.isEmpty((Object)resultDto.getTaxcodeDetailDtoList())) continue;
                    BigDecimal taxAmount = BigDecimal.ZERO;
                    Long taxcodeId = 0L;
                    for (TaxcodeDetailDto taxcodeDetailDto : resultDto.getTaxcodeDetailDtoList()) {
                        taxAmount = taxAmount.add(taxcodeDetailDto.getSumIntervalAmount());
                        taxcodeId = taxcodeDetailDto.getTaxCodeId();
                    }
                    DynamicObject result = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_taxcode_result");
                    result.set("draftid", (Object)resultDto.getDraftId());
                    result.set("orgid", (Object)resultDto.getOrgId());
                    result.set("templateid", (Object)resultDto.getTemplateId());
                    result.set("taxationsys", (Object)resultDto.getTaxationsys());
                    result.set("taxtype", (Object)resultDto.getTaxtype());
                    result.set("skssqq", (Object)resultDto.getSkssqq());
                    result.set("skssqz", (Object)resultDto.getSkssqz());
                    result.set("taxareagroup", (Object)resultDto.getTaxareagroup());
                    result.set("reportkey", (Object)resultDto.getReportkey());
                    result.set("draftpurpose", (Object)resultDto.getDraftpurpose());
                    result.set("splitstartdate", (Object)resultDto.getSplitstartdate());
                    result.set("taxamount", (Object)taxAmount);
                    result.set("taxcode", (Object)taxcodeId);
                    result.set("createdate", (Object)new Date());
                    result.set("creater", (Object)RequestContext.get().getCurrUserId());
                    result.set("datastatus", (Object)"0");
                    int detailSeq = 1;
                    for (TaxcodeDetailDto taxcodeDetailDto : resultDto.getTaxcodeDetailDtoList()) {
                        DynamicObject detail = result.getDynamicObjectCollection("entryentity").addNew();
                        detail.set("totaldays", (Object)taxcodeDetailDto.getTotalDays());
                        detail.set("days", (Object)taxcodeDetailDto.getDays());
                        detail.set("proportion", (Object)taxcodeDetailDto.getProportion());
                        detail.set("taxbaseamount", (Object)taxcodeDetailDto.getTaxbaseAmount());
                        detail.set("sumintervalamount", (Object)taxcodeDetailDto.getSumIntervalAmount());
                        detail.set("intervalstartdate", (Object)taxcodeDetailDto.getIntervalStartdate());
                        detail.set("intervalenddate", (Object)taxcodeDetailDto.getIntervalEnddate());
                        detail.set("resultnumber", (Object)taxcodeDetailDto.getResultNumber());
                        detail.set("resultname", (Object)taxcodeDetailDto.getResultName());
                        detail.set("resultsource", (Object)taxcodeDetailDto.getResultSource());
                        detail.set("resultid", (Object)taxcodeDetailDto.getResultId());
                        detail.set("startdate", (Object)taxcodeDetailDto.getStartDate());
                        detail.set("enddate", (Object)taxcodeDetailDto.getEndDate());
                        detail.set("taxcodetype", (Object)taxcodeDetailDto.getTaxcodeType());
                        detail.set("taxratetype", (Object)taxcodeDetailDto.getTaxrateType());
                        detail.set("seq", (Object)detailSeq++);
                        int subDetailSeq = 1;
                        for (TaxcodeSubDetailDto subDetailDto : taxcodeDetailDto.getTaxcodeSubDetailDtoList()) {
                            DynamicObject subDetail = detail.getDynamicObjectCollection("subentryentity").addNew();
                            subDetail.set("seq", (Object)subDetailSeq++);
                            subDetail.set("interval", (Object)subDetailDto.getInterval());
                            subDetail.set("intervaljson_tag", (Object)subDetailDto.getIntervaljson());
                            subDetail.set("intervaltaxrate", (Object)subDetailDto.getIntervalTaxRate());
                            subDetail.set("intervalamount", (Object)subDetailDto.getIntervalAmount());
                            subDetail.set("intervaltaxamount", (Object)subDetailDto.getIntervalTaxAmount());
                        }
                    }
                    saveResultList.add(result);
                }
            }
            catch (Exception e) {
                log.info("TaxCodeResultBussiness saveResult:{}", (Object)e.getMessage());
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveResultList.toArray(new DynamicObject[saveResultList.size()]));
    }
}

