/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxcode.calculatetypestrategy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.taxc.bdtaxr.business.taxcode.calculatetypestrategy.AbstractCalculateRowTypeStrategy;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeDetailDto;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeSubDetailDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TaxRateCalculateStrategy
extends AbstractCalculateRowTypeStrategy {
    private static final Log logger = LogFactory.getLog(TaxRateCalculateStrategy.class);
    private static final String EXTENT = "extent";
    private static final String EXTENTJSON_TAG = "extentjson_tag";
    private static final String MINIMUMTAX = "minimumtax";
    private static final String TAXRATE = "taxrate";
    private static final String TAXRATE_TYPE = "taxratetype";
    private static final String VALUETYPE = "valuetype";

    @Override
    public TaxcodeDetailDto calculateService(TaxcodeDetailDto taxcodeDetailDto, BigDecimal originalAmount, Date splitStartDate, Date skssqq, Date skssqz) {
        TaxcodeDetailDto detailDto = new TaxcodeDetailDto(taxcodeDetailDto.getTaxCodeId(), taxcodeDetailDto.getTaxCodeNumber(), taxcodeDetailDto.getTaxCodeName(), taxcodeDetailDto.getTaxcodeType(), taxcodeDetailDto.getResultSource(), taxcodeDetailDto.getResultId(), taxcodeDetailDto.getResultNumber(), taxcodeDetailDto.getResultName(), taxcodeDetailDto.getResultObject());
        DynamicObject row = taxcodeDetailDto.getResultObject();
        if (ObjectUtils.isEmpty((Object)row)) {
            return null;
        }
        Date startDate = row.getDate("activedate");
        Date endDate = row.getDate("expdate");
        if (ObjectUtils.isEmpty((Object)splitStartDate)) {
            return null;
        }
        Date[] dates = DateUtils.getIntersectionDate((Date)splitStartDate, (Date)skssqz, (Date)startDate, (Date)endDate);
        if (ObjectUtils.isEmpty((Object)dates) || ObjectUtils.isNotEmpty((Object)dates) && (null == dates[0] || null == dates[1])) {
            return null;
        }
        int days = DateUtils.getDayDiff((Date)dates[0], (Date)dates[1]) + 1;
        int totalDays = DateUtils.getDayDiff((Date)splitStartDate, (Date)skssqz) + 1;
        BigDecimal proportion = BigDecimalUtil.divideObject((Object)new BigDecimal(days), (Object)new BigDecimal(totalDays), (int)4);
        BigDecimal taxbaseAmount = originalAmount.multiply(BigDecimalUtil.divideObject((Object)new BigDecimal(days), (Object)new BigDecimal(totalDays), (int)10000)).setScale(2, 4);
        detailDto.setTotalDays(Integer.valueOf(totalDays));
        detailDto.setDays(Integer.valueOf(days));
        detailDto.setProportion(proportion);
        detailDto.setTaxbaseAmount(taxbaseAmount);
        detailDto.setStartDate(startDate);
        detailDto.setEndDate(endDate);
        detailDto.setIntervalStartdate(dates[0]);
        detailDto.setIntervalEnddate(dates[1]);
        detailDto.setTaxrateType(taxcodeDetailDto.getTaxrateType());
        DynamicObject taxratetypeObject = row.getDynamicObject(TAXRATE_TYPE);
        String taxRateType = taxratetypeObject.getString("number");
        TaxRateTypeEnum taxRateTypeEnum = TaxRateTypeEnum.getEnumByTaxRateType(taxRateType);
        if (null != taxRateTypeEnum) {
            List<TaxcodeSubDetailDto> list = taxRateTypeEnum.calculateAmount(row, taxbaseAmount);
            detailDto.getTaxcodeSubDetailDtoList().addAll(list);
            AtomicReference<BigDecimal> totalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            list.stream().forEach(o -> totalAmount.set(((BigDecimal)totalAmount.get()).add(o.getIntervalTaxAmount())));
            detailDto.setSumIntervalAmount(totalAmount.get());
        }
        return detailDto;
    }

    static enum TaxRateTypeEnum {
        SLLX_01("SLLX-01"){

            @Override
            public List<TaxcodeSubDetailDto> calculateAmount(DynamicObject taxRateRow, BigDecimal calculateAmount) {
                ArrayList<TaxcodeSubDetailDto> taxcodeSubDetailDtoList = new ArrayList<TaxcodeSubDetailDto>(8);
                BigDecimal intervalTaxRate = taxRateRow.getBigDecimal(TaxRateCalculateStrategy.TAXRATE);
                String extent = ResManager.loadKDString((String)"\u533a\u95f4>0", (String)"TaxRateCalculateStrategy_3", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                String extentJson = "{\"_Type_\":\"FilterCondition\",\"FilterRow\":[{\"_Type_\":\"SimpleFilterRow\",\"RightBracket\":\"\",\"LeftBracket\":\"\",\"Value\":[{\"_Type_\":\"FilterValue\",\"Value\":0,\"Id\":\"40ANZWRN7DM6\"}],\"CompareType\":\"21\",\"Id\":\"40ANZWRN9HRG\",\"Logic\":\"0\",\"FieldName\":\"extent\"}]}";
                BigDecimal intervalTaxAmount = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)calculateAmount, (Object)new BigDecimal("0.01"), (int)10), (Object)intervalTaxRate, (int)2);
                TaxcodeSubDetailDto taxcodeSubDetailDto = new TaxcodeSubDetailDto(extent, extentJson, BigDecimalUtil.multiplyObject((Object)intervalTaxRate, (Object)new BigDecimal("0.01"), (int)10), calculateAmount, intervalTaxAmount);
                taxcodeSubDetailDtoList.add(taxcodeSubDetailDto);
                logger.info("\u6bd4\u4f8b\u7a0e\u7387\u7684\u6700\u7ec8\u91d1\u989d\uff1a", (Object)intervalTaxAmount);
                return taxcodeSubDetailDtoList;
            }
        }
        ,
        SLLX_02("SLLX-02"){

            @Override
            public List<TaxcodeSubDetailDto> calculateAmount(DynamicObject taxRateRow, BigDecimal calculateAmount) {
                return new ArrayList<TaxcodeSubDetailDto>(8);
            }
        }
        ,
        SLLX_03("SLLX-03"){

            @Override
            public List<TaxcodeSubDetailDto> calculateAmount(DynamicObject taxRateRow, BigDecimal calculateAmount) {
                ArrayList<TaxcodeSubDetailDto> taxcodeSubDetailDtoList = new ArrayList<TaxcodeSubDetailDto>(8);
                BigDecimal intervalTaxRate = taxRateRow.getBigDecimal(TaxRateCalculateStrategy.TAXRATE);
                String valuetype = taxRateRow.getString(TaxRateCalculateStrategy.VALUETYPE);
                if ("1".equalsIgnoreCase(valuetype)) {
                    intervalTaxRate = intervalTaxRate.divide(new BigDecimal("100"), 6, 4);
                }
                String extent = "";
                TaxcodeSubDetailDto taxcodeSubDetailDto = new TaxcodeSubDetailDto(extent, intervalTaxRate, calculateAmount, intervalTaxRate);
                taxcodeSubDetailDtoList.add(taxcodeSubDetailDto);
                logger.info("\u51cf\u514d\u7387\u7684\u6700\u7ec8\u91d1\u989d\uff1a", (Object)intervalTaxRate);
                return taxcodeSubDetailDtoList;
            }
        }
        ,
        SLLX_04("SLLX-04"){

            @Override
            public List<TaxcodeSubDetailDto> calculateAmount(DynamicObject taxRateRow, BigDecimal calculateAmount) {
                DynamicObjectCollection detailRows = taxRateRow.getDynamicObjectCollection("entryentity");
                ArrayList<TaxcodeSubDetailDto> taxcodeSubDetailDtoList = new ArrayList<TaxcodeSubDetailDto>(8);
                if (detailRows != null && detailRows.size() > 0) {
                    for (DynamicObject detailRow : detailRows) {
                        String extent = detailRow.getString(TaxRateCalculateStrategy.EXTENT);
                        String extentjson = detailRow.getString(TaxRateCalculateStrategy.EXTENTJSON_TAG);
                        BigDecimal intervalTaxRate = detailRow.getBigDecimal(TaxRateCalculateStrategy.MINIMUMTAX);
                        ArrayList<String> list = new ArrayList<String>(16);
                        Pattern pattern = Pattern.compile(extent.trim().indexOf(".") == -1 ? "\\d+" : "\\d+\\.\\d+");
                        Matcher matcher = pattern.matcher(extent.trim());
                        while (matcher.find()) {
                            list.add(matcher.group());
                        }
                        Collections.sort(list, new Comparator<String>(){

                            @Override
                            public int compare(String p1, String p2) {
                                return new BigDecimal(p1).compareTo(new BigDecimal(p2));
                            }
                        });
                        BigDecimal intervalAmount = BigDecimal.ZERO;
                        if (list.size() == 1) {
                            BigDecimal amount = new BigDecimal((String)list.get(0));
                            if (extent.contains(ResManager.loadKDString((String)"\u5927\u4e8e", (String)"TaxRateCalculateStrategy_0", (String)"taxc-bdtaxr", (Object[])new Object[0]))) {
                                intervalAmount = calculateAmount.compareTo(amount) > 0 ? BigDecimalUtil.subtractObject((Object)calculateAmount, (Object)amount, (int)2) : BigDecimal.ZERO;
                            } else if (extent.contains(ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"TaxRateCalculateStrategy_1", (String)"taxc-bdtaxr", (Object[])new Object[0]))) {
                                intervalAmount = calculateAmount.compareTo(amount) > 0 ? amount : BigDecimalUtil.subtractObject((Object)calculateAmount, (Object)BigDecimal.ZERO, (int)2);
                            }
                        } else {
                            BigDecimal max = new BigDecimal((String)list.get(1));
                            BigDecimal min = new BigDecimal((String)list.get(0));
                            intervalAmount = calculateAmount.compareTo(min) < 0 ? BigDecimal.ZERO : (calculateAmount.compareTo(max) > 0 ? BigDecimalUtil.subtractObject((Object)max, (Object)min, (int)2) : BigDecimalUtil.subtractObject((Object)calculateAmount, (Object)min, (int)2));
                        }
                        BigDecimal intervalTaxAmount = BigDecimalUtil.divideObject((Object)BigDecimalUtil.multiplyObject((Object)intervalAmount, (Object)intervalTaxRate, (int)4), (Object)100, (int)2);
                        TaxcodeSubDetailDto taxcodeSubDetailDto = new TaxcodeSubDetailDto(extent, extentjson, BigDecimalUtil.multiplyObject((Object)intervalTaxRate, (Object)new BigDecimal("0.01"), (int)10), intervalAmount, intervalTaxAmount);
                        taxcodeSubDetailDtoList.add(taxcodeSubDetailDto);
                    }
                    logger.info("\u8d85\u989d\u7d2f\u8fdb\u7a0e\u7387\u7684\u6700\u7ec8\u91d1\u989d\uff1a" + SerializationUtils.toJsonString(taxcodeSubDetailDtoList));
                }
                return taxcodeSubDetailDtoList;
            }
        }
        ,
        SLLX_05("SLLX-05"){

            @Override
            public List<TaxcodeSubDetailDto> calculateAmount(DynamicObject taxRateRow, BigDecimal calculateAmount) {
                DynamicObjectCollection detailRows = taxRateRow.getDynamicObjectCollection("entryentity");
                ArrayList<TaxcodeSubDetailDto> taxcodeSubDetailDtoList = new ArrayList<TaxcodeSubDetailDto>(8);
                BigDecimal lastTaxRate = BigDecimal.ZERO;
                if (detailRows != null && detailRows.size() > 0) {
                    boolean flag = false;
                    for (DynamicObject detailRow : detailRows) {
                        BigDecimal intervalAmount = BigDecimal.ZERO;
                        BigDecimal intervalTaxAmount = BigDecimal.ZERO;
                        String extent = detailRow.getString(TaxRateCalculateStrategy.EXTENT);
                        String extentjson = detailRow.getString(TaxRateCalculateStrategy.EXTENTJSON_TAG);
                        BigDecimal intervalTaxRate = detailRow.getBigDecimal(TaxRateCalculateStrategy.MINIMUMTAX);
                        ArrayList<String> list = new ArrayList<String>(16);
                        Pattern pattern = Pattern.compile(extent.trim().indexOf(".") == -1 ? "\\d+" : "\\d+\\.\\d+");
                        Matcher matcher = pattern.matcher(extent.trim());
                        while (matcher.find()) {
                            list.add(matcher.group());
                        }
                        Collections.sort(list, new Comparator<String>(){

                            @Override
                            public int compare(String p1, String p2) {
                                return new BigDecimal(p1).compareTo(new BigDecimal(p2));
                            }
                        });
                        if (!flag) {
                            if (list.size() == 1) {
                                BigDecimal amount = new BigDecimal((String)list.get(0));
                                if (extent.contains(ResManager.loadKDString((String)"\u5927\u4e8e", (String)"TaxRateCalculateStrategy_0", (String)"taxc-bdtaxr", (Object[])new Object[0]))) {
                                    if (calculateAmount.compareTo(amount) > 0) {
                                        lastTaxRate = detailRow.getBigDecimal(TaxRateCalculateStrategy.MINIMUMTAX);
                                        intervalAmount = lastTaxRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : calculateAmount;
                                        intervalTaxAmount = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)calculateAmount, (Object)new BigDecimal("0.01"), (int)10), (Object)lastTaxRate, (int)2);
                                        flag = true;
                                    }
                                    if (extent.contains(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"TaxRateCalculateStrategy_2", (String)"taxc-bdtaxr", (Object[])new Object[0])) && calculateAmount.compareTo(amount) == 0) {
                                        lastTaxRate = detailRow.getBigDecimal(TaxRateCalculateStrategy.MINIMUMTAX);
                                        intervalAmount = lastTaxRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : calculateAmount;
                                        intervalTaxAmount = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)calculateAmount, (Object)new BigDecimal("0.01"), (int)10), (Object)lastTaxRate, (int)2);
                                        flag = true;
                                    }
                                } else if (extent.contains(ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"TaxRateCalculateStrategy_1", (String)"taxc-bdtaxr", (Object[])new Object[0]))) {
                                    if (calculateAmount.compareTo(amount) <= 0) {
                                        lastTaxRate = detailRow.getBigDecimal(TaxRateCalculateStrategy.MINIMUMTAX);
                                        intervalAmount = lastTaxRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : calculateAmount;
                                        intervalTaxAmount = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)calculateAmount, (Object)new BigDecimal("0.01"), (int)10), (Object)lastTaxRate, (int)2);
                                        flag = true;
                                    }
                                    if (extent.contains(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"TaxRateCalculateStrategy_2", (String)"taxc-bdtaxr", (Object[])new Object[0])) && calculateAmount.compareTo(amount) == 0) {
                                        lastTaxRate = detailRow.getBigDecimal(TaxRateCalculateStrategy.MINIMUMTAX);
                                        intervalAmount = lastTaxRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : calculateAmount;
                                        intervalTaxAmount = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)calculateAmount, (Object)new BigDecimal("0.01"), (int)10), (Object)lastTaxRate, (int)2);
                                        flag = true;
                                    }
                                } else if (extent.contains(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"TaxRateCalculateStrategy_2", (String)"taxc-bdtaxr", (Object[])new Object[0])) && calculateAmount.compareTo(amount) == 0) {
                                    lastTaxRate = detailRow.getBigDecimal(TaxRateCalculateStrategy.MINIMUMTAX);
                                    intervalAmount = lastTaxRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : calculateAmount;
                                    intervalTaxAmount = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)calculateAmount, (Object)new BigDecimal("0.01"), (int)10), (Object)lastTaxRate, (int)2);
                                    flag = true;
                                }
                            } else {
                                BigDecimal max = new BigDecimal((String)list.get(1));
                                BigDecimal min = new BigDecimal((String)list.get(0));
                                if (calculateAmount.compareTo(min) >= 0 && calculateAmount.compareTo(max) <= 0) {
                                    lastTaxRate = detailRow.getBigDecimal(TaxRateCalculateStrategy.MINIMUMTAX);
                                    flag = true;
                                    intervalAmount = lastTaxRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : calculateAmount;
                                    intervalTaxAmount = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)calculateAmount, (Object)new BigDecimal("0.01"), (int)10), (Object)lastTaxRate, (int)2);
                                }
                            }
                        }
                        TaxcodeSubDetailDto taxcodeSubDetailDto = new TaxcodeSubDetailDto(extent, extentjson, BigDecimalUtil.multiplyObject((Object)intervalTaxRate, (Object)new BigDecimal("0.01"), (int)10), intervalAmount, intervalTaxAmount);
                        taxcodeSubDetailDtoList.add(taxcodeSubDetailDto);
                    }
                    logger.info("\u5168\u989d\u7d2f\u8fdb\u7a0e\u7387:", (Object)lastTaxRate.toString());
                    logger.info("\u5168\u989d\u7d2f\u8fdb\u91d1\u989d:", (Object)calculateAmount.toString());
                    logger.info("\u5168\u989d\u7d2f\u8fdb\u7a0e\u7387\u7b97\u51fa\u7684\u6700\u7ec8\u91d1\u989d\uff1a", (Object)((Object)taxcodeSubDetailDtoList).toString());
                }
                return taxcodeSubDetailDtoList;
            }
        };

        private String taxRateType;

        public abstract List<TaxcodeSubDetailDto> calculateAmount(DynamicObject var1, BigDecimal var2);

        private TaxRateTypeEnum(String taxRateType) {
            this.taxRateType = taxRateType;
        }

        public String getTaxRateType() {
            return this.taxRateType;
        }

        public static TaxRateTypeEnum getEnumByTaxRateType(String taxRateType) {
            for (TaxRateTypeEnum taxRateTypeEnum : TaxRateTypeEnum.values()) {
                if (!taxRateTypeEnum.getTaxRateType().equals(taxRateType)) continue;
                return taxRateTypeEnum;
            }
            return null;
        }
    }
}

