/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxcode.callservice;

import kd.taxc.bdtaxr.business.taxcode.callservice.AbstractCallService;
import kd.taxc.bdtaxr.business.taxcode.callservice.AdditionalTaxCallService;
import kd.taxc.bdtaxr.business.taxcode.callservice.AdditionalTaxNotReliefRateCallService;
import kd.taxc.bdtaxr.business.taxcode.callservice.CacheCallService;
import kd.taxc.bdtaxr.business.taxcode.callservice.DefaultCallService;
import kd.taxc.bdtaxr.business.taxcode.callservice.TaxRateNotReliefRateCallService;
import kd.taxc.bdtaxr.business.taxcode.callservice.TaxRateReliefRateCallService;

public class CallServiceFactory {
    public static AbstractCallService getCallService(String taxCodeRowType) {
        CallServiceEnum[] values;
        for (CallServiceEnum value : values = CallServiceEnum.values()) {
            if (!value.type.equals(taxCodeRowType)) continue;
            return value.getCallService();
        }
        return CallServiceEnum.DEFAULT.getCallService();
    }

    public static enum CallServiceEnum {
        DEFAULT("default", new DefaultCallService()),
        CACHE_CALL("cache_call", new CacheCallService()),
        ADDITIONALTAX("additionaltax", new AdditionalTaxCallService()),
        ADDITIONALTAX_NOTRELIEFRATE("additionaltax_notreliefrate", new AdditionalTaxNotReliefRateCallService()),
        TAXRATE_RELIEFRATE("taxrate_reliefrate", new TaxRateReliefRateCallService()),
        TAXRATE_NOTRELIEFRATE("taxrate_notreliefrate", new TaxRateNotReliefRateCallService());

        private String type;
        private AbstractCallService callService;

        private CallServiceEnum(String type, AbstractCallService callService) {
            this.type = type;
            this.callService = callService;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public AbstractCallService getCallService() {
            return this.callService;
        }
    }
}

