/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereport.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class GtcpOverseasVatJtAndSBThanServiceImpl
implements DeclareReportService {
    public Long getSbbId(Map<String, String> params) {
        return null;
    }

    public Long getModleId() {
        Map modelMap = MultiTableEnum.MODEL_MAP;
        for (Map.Entry entry : modelMap.entrySet()) {
            if (!this.getModelNumber().equalsIgnoreCase((String)entry.getValue())) continue;
            return Long.valueOf((String)entry.getKey());
        }
        return 0L;
    }

    public String getBillNumber(Date startDate, Date endDate, String orgId, Map<String, String> businessParams) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gtcp_normal_jt_list");
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("skssqq", (Object)startDate);
        dynamicObject.set("skssqz", (Object)endDate);
        dynamicObject.set("taxsystem", (Object)businessParams.get("taxsystem"));
        dynamicObject.set("taxtype", (Object)businessParams.get("taxtype"));
        dynamicObject.set("taxareagroup", (Object)businessParams.get("taxareagroup"));
        String number = codeRuleService.readNumber("gtcp_jt_declare_than_list", dynamicObject, null);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"gtcp_jt_declare_than_list", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
        if (obj != null) {
            codeRuleService.getNumber("gtcp_jt_declare_than_list", dynamicObject, null);
            number = codeRuleService.readNumber("gtcp_jt_declare_than_list", dynamicObject, null);
        }
        return number;
    }

    public QFilter getDeclareMainQueryExtendFilter(Map<String, Object> extendParams) {
        long taxcategoryId;
        if (extendParams == null) {
            return null;
        }
        long taxsystemId = extendParams.get("taxsystem") == null ? 0L : Long.parseLong(extendParams.get("taxsystem").toString());
        long taxareagroupId = extendParams.get("taxareagroup") == null ? 0L : Long.parseLong(extendParams.get("taxareagroup").toString());
        long l = taxcategoryId = extendParams.get("taxcategory") == null ? 0L : Long.parseLong(extendParams.get("taxcategory").toString());
        if (taxcategoryId == 0L) {
            taxcategoryId = extendParams.get("taxtype") == null ? 0L : Long.parseLong(extendParams.get("taxtype").toString());
        }
        String draftpurpose = ObjectUtils.isEmpty((Object)extendParams.get("draftpurpose")) ? "" : extendParams.get("draftpurpose").toString();
        return new QFilter("taxsystem", "=", (Object)taxsystemId).and("taxareagroup", "=", (Object)taxareagroupId).and("taxtype", "=", (Object)taxcategoryId).and("draftpurpose", "=", (Object)draftpurpose);
    }

    public List<QFilter> getDeclareMainQueryMainFilter(long orgId, String type, String startData, String endData) {
        int month = 0;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("templatetype", "=", (Object)type));
        qFilters.add(new QFilter("skssqq", "=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)startData), (int)month)));
        qFilters.add(new QFilter("skssqz", "=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)endData), (int)month)));
        return qFilters;
    }

    private String getModelNumber() {
        return "TSD001";
    }
}

