/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereport.service.impl;

import java.util.Date;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class GxDeclareReportServiceImpl
implements DeclareReportService {
    private static final String ENTITY_NAME = "rdesd_fzz_gx_query_list";

    public Long getSbbId(Map<String, String> params) {
        DynamicObject dynamicObject;
        Long orgId = Long.valueOf(params.get("orgid"));
        Date skssq = DateUtils.stringToDate((String)params.get("skssqq"));
        Date skssz = DateUtils.stringToDate((String)params.get("skssqz"));
        QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId).and("templatetype", "=", (Object)params.get("templatetype")).and("skssqq", "=", (Object)skssq).and("skssqz", "=", (Object)skssz);
        MultiTableEnum modelNumber = MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber());
        if (modelNumber != null && (dynamicObject = QueryServiceHelper.queryOne((String)modelNumber.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{defaultQfilter})) != null) {
            return dynamicObject.getLong("id");
        }
        return null;
    }

    public Long getModleId() {
        Map modelMap = MultiTableEnum.MODEL_MAP;
        for (Map.Entry entry : modelMap.entrySet()) {
            if (!this.getModelNumber().equalsIgnoreCase((String)entry.getValue())) continue;
            return Long.valueOf((String)entry.getKey());
        }
        return 0L;
    }

    public String getBillNumber(Date startDate, Date endDate, String orgId, Map<String, String> businessParams) {
        return null;
    }

    private String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    public String getBillNumber(Date startDate, Date endDate, String orgId) {
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("skssqq", (Object)startDate);
        dynamicObject.set("skssqz", (Object)endDate);
        String number = codeRuleService.readNumber(ENTITY_NAME, dynamicObject, null);
        boolean exists = QueryServiceHelper.exists((String)ENTITY_NAME, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
        if (exists) {
            codeRuleService.getNumber(ENTITY_NAME, dynamicObject, null);
            number = codeRuleService.readNumber(ENTITY_NAME, dynamicObject, null);
        }
        return number;
    }

    public QFilter getDeclareMainQueryExtendFilter(Map<String, Object> extendParams) {
        return null;
    }

    public String getUniKey(Map<String, String> mainTableMap) {
        String orgId = mainTableMap.get("org");
        String skssq = mainTableMap.get("skssqq");
        String skssz = mainTableMap.get("skssqz");
        return String.format("%s_%s_%s_%s", orgId, skssq, skssz, mainTableMap.get("templatetype"));
    }
}

