/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereport.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class OverseasDeclareReportServiceImpl
implements DeclareReportService {
    public static final String GTCP_NORMAL_DRAFT_LIST = "gtcp_normal_draft_list";
    public static final String GTCP_NORMAL_JT_LIST = "gtcp_normal_jt_list";

    public Long getSbbId(Map<String, String> params) {
        DynamicObject dynamicObject;
        Long orgId = Long.valueOf(params.get("orgid"));
        Long taxareagroup = Long.valueOf(params.get("taxareagroup"));
        Long taxtype = Long.valueOf(params.get("taxtype"));
        Long taxsystem = Long.valueOf(params.get("taxsystem"));
        String draftpurpose = params.get("draftpurpose");
        Date skssq = DateUtils.stringToDate((String)params.get("skssqq"));
        Date skssz = DateUtils.stringToDate((String)params.get("skssqz"));
        QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId).and("templatetype", "=", (Object)params.get("templatetype")).and("skssqq", "=", (Object)skssq).and("skssqz", "=", (Object)skssz).and("taxsystem", "=", (Object)taxsystem).and("taxareagroup", "=", (Object)taxareagroup).and("draftpurpose", "=", (Object)draftpurpose).and("taxtype", "=", (Object)taxtype);
        MultiTableEnum modelNumber = MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber());
        if (modelNumber != null && (dynamicObject = QueryServiceHelper.queryOne((String)modelNumber.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{defaultQfilter})) != null) {
            return dynamicObject.getLong("id");
        }
        return null;
    }

    public Long getModleId() {
        Map modelMap = MultiTableEnum.MODEL_MAP;
        for (Map.Entry entry : modelMap.entrySet()) {
            if (!this.getModelNumber().equalsIgnoreCase((String)entry.getValue())) continue;
            return Long.valueOf((String)entry.getKey());
        }
        return 0L;
    }

    public String getBillNumber(Date startDate, Date endDate, String orgId, Map<String, String> businessParams) {
        String draftpurpose = businessParams.get("draftpurpose");
        String entityName = "sjjt".equalsIgnoreCase(draftpurpose) ? GTCP_NORMAL_JT_LIST : GTCP_NORMAL_DRAFT_LIST;
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        dyo.set("org", (Object)orgId);
        dyo.set("taxareagroup", (Object)businessParams.get("taxareagroup"));
        String value = businessParams.get("taxcategory") == null ? businessParams.get("taxtype") : businessParams.get("taxcategory");
        dyo.set("taxtype", (Object)value);
        dyo.set("skssqq", (Object)startDate);
        dyo.set("skssqz", (Object)endDate);
        String number = codeRuleService.readNumber(entityName, dyo, null);
        boolean exists = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
        if (exists) {
            codeRuleService.getNumber(entityName, dyo, null);
            number = codeRuleService.readNumber(entityName, dyo, null);
        }
        return number;
    }

    private String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    public QFilter getDeclareMainQueryExtendFilter(Map<String, Object> extendParams) {
        long taxcategoryId;
        if (extendParams == null) {
            return null;
        }
        long taxsystemId = extendParams.get("taxsystem") == null ? 0L : Long.parseLong(extendParams.get("taxsystem").toString());
        long taxareagroupId = extendParams.get("taxareagroup") == null ? 0L : Long.parseLong(extendParams.get("taxareagroup").toString());
        long l = taxcategoryId = extendParams.get("taxcategory") == null ? 0L : Long.parseLong(extendParams.get("taxcategory").toString());
        if (taxcategoryId == 0L) {
            taxcategoryId = extendParams.get("taxtype") == null ? 0L : Long.parseLong(extendParams.get("taxtype").toString());
        }
        String draftpurpose = ObjectUtils.isEmpty((Object)extendParams.get("draftpurpose")) ? "" : extendParams.get("draftpurpose").toString();
        return new QFilter("taxsystem", "=", (Object)taxsystemId).and("taxareagroup", "=", (Object)taxareagroupId).and("taxtype", "=", (Object)taxcategoryId).and("draftpurpose", "=", (Object)draftpurpose);
    }

    public String getUniKey(Map<String, String> mainTableMap) {
        String orgId = mainTableMap.get("org");
        String skssq = mainTableMap.get("skssqq");
        String skssz = mainTableMap.get("skssqz");
        String taxSystem = mainTableMap.get("taxationsys");
        String taxCategory = mainTableMap.get("taxtype");
        String taxAreaGroup = mainTableMap.get("taxareagroup");
        String templateType = mainTableMap.get("templateType");
        String draftpurpose = mainTableMap.get("draftpurpose");
        return String.format("%s_%s_%s_%s_%s_%s_%s_%s", orgId, taxSystem, taxCategory, taxAreaGroup, skssq, skssz, draftpurpose, templateType);
    }

    public List<QFilter> getDeclareMainQueryMainFilter(long orgId, String type, String startData, String endData) {
        int month = 0;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("templatetype", "=", (Object)type));
        qFilters.add(new QFilter("skssqq", "=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)startData), (int)month)));
        qFilters.add(new QFilter("skssqz", "=", (Object)DateUtils.addMonth((Date)DateUtils.stringToDate((String)endData), (int)month)));
        return qFilters;
    }
}

