/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereport.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections4.CollectionUtils;

public class TssqbDeclareReportServiceImpl
implements DeclareReportService {
    public Long getSbbId(Map<String, String> params) {
        DynamicObject dynamicObject;
        Long orgId = Long.valueOf(params.get("orgid"));
        Date skssq = DateUtils.stringToDate((String)params.get("skssqq"));
        Date skssz = DateUtils.stringToDate((String)params.get("skssqz"));
        QFilter defaultQfilter = new QFilter("org", "=", (Object)orgId).and("templatetype", "=", (Object)params.get("templatetype")).and("skssqq", "=", (Object)skssq).and("skssqz", "=", (Object)skssz);
        MultiTableEnum modelNumber = MultiTableEnum.getMultiTableByModelNumber((String)MultiTableEnum.TSD001.getModel());
        if (modelNumber != null && (dynamicObject = QueryServiceHelper.queryOne((String)modelNumber.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{defaultQfilter})) != null) {
            return dynamicObject.getLong("id");
        }
        return null;
    }

    public QFilter getDeclareMainQueryExtendFilter(Map<String, Object> extendParams) {
        Object draftIds = extendParams.get("draftIds");
        if (draftIds != null) {
            List draftIdList = Stream.of(draftIds.toString().split(",")).map(Long::new).collect(Collectors.toList());
            List tssqbIds = QueryServiceHelper.query((String)"tcvat_tssqb_query", (String)"id", (QFilter[])new QFilter[]{new QFilter("jzjtdraft.fbasedataid.id", "in", draftIdList)}).stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(tssqbIds)) {
                return new QFilter("id", "in", tssqbIds);
            }
        }
        return QFilter.isNull((String)"id");
    }

    public Long getModleId() {
        Map modelMap = MultiTableEnum.MODEL_MAP;
        for (Map.Entry entry : modelMap.entrySet()) {
            if (!MultiTableEnum.TSD001.getModel().equalsIgnoreCase((String)entry.getValue())) continue;
            return Long.valueOf((String)entry.getKey());
        }
        return 0L;
    }

    public String getBillNumber(Date startDate, Date endDate, String orgId, Map<String, String> businessParams) {
        String number = businessParams.get("billno");
        if (StringUtils.isBlank((CharSequence)number)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_tssqb_query");
            number = DeclareServiceHelper.generateSBBNo((String)"tcvat_tssqb_query", (DynamicObject)dynamicObject, (String)orgId);
        }
        return number;
    }
}

