/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.DeclareReportCalculateService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.refactor.formula.context.CalFormulaContext;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaCollectionVo;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.FormulaCalVo;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.formplugin.taxdeclare.enums.BoaderCardUnitEnum;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.BorderCardAVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.BorderCardBVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.BorderCardVo;
import org.apache.commons.lang3.ObjectUtils;

public class ItpDeclareReportCalculateServiceImpl
implements DeclareReportCalculateService {
    @Override
    public Map<String, String> customAdjustAndCascade(DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, String> currentMap) {
        return DeclareReportCalculateService.super.customAdjustAndCascade(requestModel, responseModel, currentMap);
    }

    @Override
    public List<BorderCardVo> getDeclareTaxDataBoard(DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, String> currentMap) {
        ArrayList<BorderCardVo> borderCardVoList = new ArrayList<BorderCardVo>(4);
        BorderCardAVo borderCardAVo = new BorderCardAVo();
        borderCardAVo.setMainTitle(ResManager.loadKDString((String)"ETR\u5206\u6790", (String)"ItpDeclareReportCalculateServiceImpl_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        borderCardAVo.setCardBVoList(new ArrayList<BorderCardBVo>());
        String ztType = ObjectUtils.isNotEmpty((Object)requestModel.getExtendParams()) && requestModel.getExtendParams().containsKey("accountsettype") ? requestModel.getExtendParams().get("accountsettype").toString() : "";
        DynamicObject etrInfo = this.getEtrInfo(requestModel.getOrgId(), DateUtils.stringToDate2((String)requestModel.getSkssqq()), DateUtils.stringToDate2((String)requestModel.getSkssqz()), requestModel.getTaxationsys(), ztType);
        BigDecimal jsnyxsfl_tb = new BigDecimal("0.00");
        BigDecimal jsndqsdsfy_tb = new BigDecimal("0.00");
        BigDecimal jsndysdsfy_tb = new BigDecimal("0.00");
        if (etrInfo != null) {
            jsnyxsfl_tb = etrInfo.getBigDecimal("jsnyxsfl").multiply(new BigDecimal("100"));
            jsndqsdsfy_tb = etrInfo.getBigDecimal("jsndqsdsfy").multiply(new BigDecimal("100"));
            jsndysdsfy_tb = etrInfo.getBigDecimal("jsndysdsfy").multiply(new BigDecimal("100"));
        }
        BigDecimal yxsfl = this.getYxsfl(currentMap, ztType).multiply(new BigDecimal("100")).setScale(2, 4);
        BigDecimal jsnyxsfl = this.getJsnyxsfl(yxsfl, jsnyxsfl_tb).setScale(2, 4);
        BigDecimal dqsdsfy = this.getDqsdsfy(currentMap, ztType).multiply(new BigDecimal("100")).setScale(2, 4);
        BigDecimal jsndqsdsfy = this.getJsndqsdsfy(dqsdsfy, jsndqsdsfy_tb).setScale(2, 4);
        BigDecimal dysdsfy = this.getDysdsfy(currentMap, ztType).multiply(new BigDecimal("100")).setScale(2, 4);
        BigDecimal jsndysdsfy = this.getJsndysdsfy(dysdsfy, jsndysdsfy_tb).setScale(2, 4);
        BorderCardBVo borderCardBVo1 = new BorderCardBVo();
        borderCardBVo1.setTitle(ResManager.loadKDString((String)"\u6709\u6548\u7a0e\u8d1f\u7387\uff08ETR\uff09", (String)"ItpDeclareReportCalculateServiceImpl_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        borderCardBVo1.setKey("yxsfl");
        borderCardBVo1.setNumber(yxsfl.toString());
        borderCardBVo1.setChange(jsnyxsfl.toString());
        borderCardBVo1.setUnit(BoaderCardUnitEnum.PERCENT);
        BorderCardBVo borderCardBVo2 = new BorderCardBVo();
        borderCardBVo2.setTitle(ResManager.loadKDString((String)"\u5f53\u671f\u6240\u5f97\u7a0e\u8d39\u7528/\u7a0e\u524d\u5229\u6da6", (String)"ItpDeclareReportCalculateServiceImpl_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        borderCardBVo2.setKey("dqsdsfy");
        borderCardBVo2.setNumber(dqsdsfy.toString());
        borderCardBVo2.setChange(jsndqsdsfy.toString());
        borderCardBVo2.setUnit(BoaderCardUnitEnum.PERCENT);
        BorderCardBVo borderCardBVo3 = new BorderCardBVo();
        borderCardBVo3.setTitle(ResManager.loadKDString((String)"\u9012\u5ef6\u6240\u5f97\u7a0e\u8d39\u7528/\u7a0e\u524d\u5229\u6da6", (String)"ItpDeclareReportCalculateServiceImpl_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        borderCardBVo3.setKey("dysdsfy");
        borderCardBVo3.setNumber(dysdsfy.toString());
        borderCardBVo3.setChange(jsndysdsfy.toString());
        borderCardBVo3.setUnit(BoaderCardUnitEnum.PERCENT);
        borderCardAVo.getCardBVoList().add(borderCardBVo1);
        borderCardAVo.getCardBVoList().add(borderCardBVo2);
        borderCardAVo.getCardBVoList().add(borderCardBVo3);
        borderCardVoList.add(borderCardAVo);
        return borderCardVoList;
    }

    @Override
    public void beforeCalFormula(DeclareRequestModel requestModel, CalFormulaContext context, Map<String, String> data, FormulaCalVo formulaCalVo, FormulaCollectionVo formulas, Map<String, String> variableKeys) {
        DeclareReportCalculateService.super.beforeCalFormula(requestModel, context, data, formulaCalVo, formulas, variableKeys);
    }

    @Override
    public void afterCalFormula(DeclareRequestModel requestModel, CalFormulaContext context, Map<String, String> data, FormulaCalVo formulaCalVo, FormulaCollectionVo formulas, Map<String, String> variableKeys) {
        DeclareReportCalculateService.super.afterCalFormula(requestModel, context, data, formulaCalVo, formulas, variableKeys);
    }

    @Override
    public Map<String, String> getVariableKeys(DeclareResponseModel responseModel, Map<String, String> changeCellMap) {
        return DeclareReportCalculateService.super.getVariableKeys(responseModel, changeCellMap);
    }

    public BigDecimal getYxsfl(Map<String, String> currentMap, String zt) {
        BigDecimal dqsdsfy = new BigDecimal(currentMap.get("sjjs_dqsdsfy_bnyjfy#sjjs_je") == null || "".equalsIgnoreCase(currentMap.get("sjjs_dqsdsfy_bnyjfy#sjjs_je")) ? "0" : currentMap.get("sjjs_dqsdsfy_bnyjfy#sjjs_je"));
        BigDecimal dysdsfy = new BigDecimal(currentMap.get("sjjs_dysdsfy_bnyjfy#sjjs_je") == null || "".equalsIgnoreCase(currentMap.get("sjjs_dysdsfy_bnyjfy#sjjs_je")) ? "0" : currentMap.get("sjjs_dysdsfy_bnyjfy#sjjs_je"));
        BigDecimal ztValue = BigDecimal.ZERO;
        if ("jtzt".equalsIgnoreCase(zt)) {
            ztValue = new BigDecimal(currentMap.get("dqsds_sqlr_jt#dqsds_hj") == null || "".equalsIgnoreCase(currentMap.get("dqsds_sqlr_jt#dqsds_hj")) ? "0" : currentMap.get("dqsds_sqlr_jt#dqsds_hj"));
        } else if ("bdzt".equalsIgnoreCase(zt)) {
            ztValue = new BigDecimal(currentMap.get("dqsds_sqlr_bd#dqsds_hj") == null || "".equalsIgnoreCase(currentMap.get("dqsds_sqlr_bd#dqsds_hj")) ? "0" : currentMap.get("dqsds_sqlr_bd#dqsds_hj"));
        }
        if (0L == ztValue.longValue()) {
            return BigDecimal.ZERO;
        }
        return dqsdsfy.add(dysdsfy).divide(ztValue, 4, 4);
    }

    private BigDecimal getJsnyxsfl(BigDecimal getYxsfl, BigDecimal getYxsfl_tb) {
        return getYxsfl.subtract(getYxsfl_tb).setScale(4, 4);
    }

    public BigDecimal getDqsdsfy(Map<String, String> currentMap, String zt) {
        BigDecimal dqsdsfy = new BigDecimal(currentMap.get("sjjs_dqsdsfy_bnyjfy#sjjs_je") == null || "".equalsIgnoreCase(currentMap.get("sjjs_dqsdsfy_bnyjfy#sjjs_je")) ? "0" : currentMap.get("sjjs_dqsdsfy_bnyjfy#sjjs_je"));
        BigDecimal ztValue = BigDecimal.ZERO;
        if ("jtzt".equalsIgnoreCase(zt)) {
            ztValue = new BigDecimal(currentMap.get("dqsds_sqlr_jt#dqsds_hj") == null || "".equalsIgnoreCase(currentMap.get("dqsds_sqlr_jt#dqsds_hj")) ? "0" : currentMap.get("dqsds_sqlr_jt#dqsds_hj"));
        } else if ("bdzt".equalsIgnoreCase(zt)) {
            ztValue = new BigDecimal(currentMap.get("dqsds_sqlr_bd#dqsds_hj") == null || "".equalsIgnoreCase(currentMap.get("dqsds_sqlr_bd#dqsds_hj")) ? "0" : currentMap.get("dqsds_sqlr_bd#dqsds_hj"));
        }
        if (0L == ztValue.longValue()) {
            return BigDecimal.ZERO;
        }
        return dqsdsfy.divide(ztValue, 4, 4);
    }

    private BigDecimal getJsndqsdsfy(BigDecimal dqsdsfy, BigDecimal dqsdsfy_tb) {
        return dqsdsfy.subtract(dqsdsfy_tb).setScale(4, 4);
    }

    public BigDecimal getDysdsfy(Map<String, String> currentMap, String zt) {
        BigDecimal dysdsfy = new BigDecimal(currentMap.get("sjjs_dysdsfy_bnyjfy#sjjs_je") == null || "".equalsIgnoreCase(currentMap.get("sjjs_dysdsfy_bnyjfy#sjjs_je")) ? "0" : currentMap.get("sjjs_dysdsfy_bnyjfy#sjjs_je"));
        BigDecimal ztValue = BigDecimal.ZERO;
        if ("jtzt".equalsIgnoreCase(zt)) {
            ztValue = new BigDecimal(currentMap.get("dqsds_sqlr_jt#dqsds_hj") == null || "".equalsIgnoreCase(currentMap.get("dqsds_sqlr_jt#dqsds_hj")) ? "0" : currentMap.get("dqsds_sqlr_jt#dqsds_hj"));
        } else if ("bdzt".equalsIgnoreCase(zt)) {
            ztValue = new BigDecimal(currentMap.get("dqsds_sqlr_bd#dqsds_hj") == null || "".equalsIgnoreCase(currentMap.get("dqsds_sqlr_bd#dqsds_hj")) ? "0" : currentMap.get("dqsds_sqlr_bd#dqsds_hj"));
        }
        if (0L == ztValue.longValue()) {
            return BigDecimal.ZERO;
        }
        return dysdsfy.divide(ztValue, 4, 4);
    }

    private BigDecimal getJsndysdsfy(BigDecimal dysdsfy, BigDecimal dysdsfy_tb) {
        return dysdsfy.subtract(dysdsfy_tb).setScale(4, 4);
    }

    public DynamicObject getEtrInfo(Long orgId, Date skssqq, Date skssqz, Long taxationsysId, String zt) {
        QFilter orgQfilter = new QFilter("org", "=", (Object)orgId);
        QFilter taxqFilter = new QFilter("taxsystem", "=", (Object)taxationsysId);
        QFilter ztqFilter = new QFilter("accountsettype", "=", (Object)zt);
        QFilter sksqFilter = new QFilter("skssqq", "=", (Object)DateUtils.addMonth((Date)skssqq, (int)-12)).and("skssqz", "=", (Object)DateUtils.addMonth((Date)skssqz, (int)-12));
        return BusinessDataServiceHelper.loadSingle((String)"itp_draft_etr", (String)"id,yxsfl,jsnyxsfl,dqsdsfy,jsndqsdsfy,dysdsfy,jsndysdsfy", (QFilter[])new QFilter[]{orgQfilter, taxqFilter, taxqFilter, ztqFilter, sksqFilter});
    }
}

