/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.DeclareReportCalculateService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;

public class QysdsyjDeclareReportCalculateServiceImpl
implements DeclareReportCalculateService {
    private static Log LOGGER = LogFactory.getLog(QysdsyjDeclareReportCalculateServiceImpl.class);

    @Override
    public Map<String, String> afterCalculate(Map<String, String> showData) {
        this.calData(showData);
        return showData;
    }

    @Override
    public DeclareResponseModel afterCalculate(DeclareRequestModel declareModel, DeclareResponseModel data, List<DynamicRowModel> dynRowList, Map<String, EntityField> typeMap) {
        Map resultData = data.getData();
        String fpblStr = (String)resultData.get("tccit_qysds_fzjgxx#15#fpbl");
        try {
            double fpbl = Double.parseDouble(fpblStr);
            if (fpbl != 1.0) {
                return data;
            }
        }
        catch (Exception e) {
            LOGGER.error("Double.parseDouble fpbl error:" + fpblStr);
        }
        this.calData(resultData);
        return data;
    }

    private void calData(Map<String, String> resultData) {
        try {
            List dynData = resultData.entrySet().stream().filter(e -> ((String)e.getKey()).contains("tccit_qysds_fzjgxx_dyn")).collect(Collectors.toList());
            String fpseSum = resultData.get("tccit_qysds_fzjgxx#15#fpse");
            double sum = Double.parseDouble(fpseSum);
            String fzjgftdsdse = resultData.get("tccit_qysds_zjgxx#1#fzjgftdsdse");
            double fzjgftdsdseAmount = Double.parseDouble(fzjgftdsdse);
            String ynsdse = resultData.get("tccit_qysds_zjgxx#1#ynsdse");
            double ynsdseAmount = Double.parseDouble(ynsdse);
            String zjgmc = resultData.get("tccit_qysds_zjgxx#1#zjgmc");
            Optional<Map.Entry> exist = dynData.stream().filter(e -> ((String)e.getKey()).contains("fzjgmc")).filter(e -> zjgmc.equals(e.getValue())).findFirst();
            if (exist.isPresent()) {
                if (sum != ynsdseAmount) {
                    double dValue = sum - ynsdseAmount;
                    double oValue = Double.parseDouble(resultData.get("tccit_qysds_fzjgxx_dyn#1#fpse"));
                    resultData.put("tccit_qysds_fzjgxx_dyn#1#fpse", String.valueOf(oValue - dValue));
                    double newSum = resultData.entrySet().stream().filter(e -> ((String)e.getKey()).contains("tccit_qysds_fzjgxx_dyn")).filter(e -> ((String)e.getKey()).contains("fpse")).map(Map.Entry::getValue).mapToDouble(Double::parseDouble).sum();
                    resultData.put("tccit_qysds_fzjgxx#15#fpse", String.valueOf(newSum));
                }
            } else if (sum != fzjgftdsdseAmount) {
                double dValue = sum - fzjgftdsdseAmount;
                double oValue = Double.parseDouble(resultData.get("tccit_qysds_fzjgxx_dyn#1#fpse"));
                resultData.put("tccit_qysds_fzjgxx_dyn#1#fpse", String.valueOf(oValue - dValue));
                double newSum = resultData.entrySet().stream().filter(e -> ((String)e.getKey()).contains("tccit_qysds_fzjgxx_dyn")).filter(e -> ((String)e.getKey()).contains("fpse")).map(Map.Entry::getValue).mapToDouble(Double::parseDouble).sum();
                resultData.put("tccit_qysds_fzjgxx#15#fpse", String.valueOf(newSum));
            }
        }
        catch (Exception e2) {
            LOGGER.info("\u6240\u5f97\u7a0e\u9884\u7f34\u5206\u652f\u673a\u6784\u5c3e\u5dee\u5904\u7406\u51fa\u9519\uff1a" + e2);
        }
    }

    @Override
    public Map<String, String> customAdjustAndCascade(DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, String> currentMap) {
        List items = currentMap.keySet().stream().filter(s -> s.matches("tccit_qysds_ext_dyn3#\\d+#item")).collect(Collectors.toList());
        String spItemId = "1408002055339105280";
        if (items != null && items.size() > 0) {
            for (String item : items) {
                if (spItemId.equals(currentMap.get(item))) continue;
                String sprateKey = item.replaceAll("item", "sprate");
                currentMap.put(sprateKey, "");
            }
        }
        return currentMap;
    }
}

