/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.DeclareReportHideService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class UsaCitDeclareReportHideImpl
implements DeclareReportHideService {
    public static final String USA_CIT_TAX_AREA_LIST = "USA_CIT_TAX_AREA_LIST";
    public static final String ADD = "add";
    protected static final String RECALC_KEY = "recalc";
    protected static final String REGETDATA_KEY = "regetdata";
    public static final List<String> ALL_VALUEABLE_AREA_LIST = Arrays.asList("Federation", "Texas (FT)", "State income tax overview", "Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut", "Delaware", "Florida", "Georgia", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", "Kentucky", "Louisiana", "Maine", "Maryland", "Massachusetts", "Michigan", "Minnesota", "Mississippi", "Missouri", "Montana", "Nebraska", "New Hampshire", "New Jersey", "New Mexico", "New York", "North Carolina", "North Dakota", "Oklahoma", "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", "Tennessee", "Utah", "Vermont", "Virginia", "West Virginia", "Wisconsin", "Washington D.C.");
    private static final List<String> VALUEABLE_AREA_LIST = Arrays.asList("Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut", "Delaware", "Florida", "Georgia", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", "Kentucky", "Louisiana", "Maine", "Maryland", "Massachusetts", "Michigan", "Minnesota", "Mississippi", "Missouri", "Montana", "Nebraska", "New Hampshire", "New Jersey", "New Mexico", "New York", "North Carolina", "North Dakota", "Oklahoma", "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", "Tennessee", "Utah", "Vermont", "Virginia", "West Virginia", "Wisconsin", "Washington D.C.");
    private static final Map<String, String> STATE_INCOME_TAX_OVERVIEW_HIDEROW = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("Alabama", "Alabama_state");
            this.put("Alaska", "Alaska_state");
            this.put("Arizona", "Arizona_state");
            this.put("Arkansas", "Arkansas_state");
            this.put("California", "California_state");
            this.put("Colorado", "Colorado_state");
            this.put("Connecticut", "Connecticut_state");
            this.put("Delaware", "Delaware_state");
            this.put("Florida", "Florida_state");
            this.put("Georgia", "Georgia_state");
            this.put("Hawaii", "Hawaii_state");
            this.put("Idaho", "Idaho_state");
            this.put("Illinois", "Illinois_state");
            this.put("Indiana", "Indiana_state");
            this.put("Iowa", "Iowa_state");
            this.put("Kansas", "Kansas_state");
            this.put("Kentucky", "Kentucky_state");
            this.put("Louisiana", "Louisiana_state");
            this.put("Maine", "Maine_state");
            this.put("Maryland", "Maryland_state");
            this.put("Massachusetts", "Massachusetts_state");
            this.put("Michigan", "Michigan_state");
            this.put("Minnesota", "Minnesota_state");
            this.put("Mississippi", "Mississippi_state");
            this.put("Missouri", "Missouri_state");
            this.put("Montana", "Montana_state");
            this.put("Nebraska", "Nebraska_state");
            this.put("New Hampshire", "New_Hampshire_state");
            this.put("New Jersey", "New_Jersey_state");
            this.put("New Mexico", "New_Mexico_state");
            this.put("New York", "New_York_state");
            this.put("North Carolina", "North_Carolina_state");
            this.put("North Dakota", "North_Dakota_state");
            this.put("Oklahoma", "Oklahoma_state");
            this.put("Oregon", "Oregon_state");
            this.put("Pennsylvania", "Pennsylvania_state");
            this.put("Rhode Island", "Rhode_Island_state");
            this.put("South Carolina", "South_Carolina_state");
            this.put("Tennessee", "Tennessee_state");
            this.put("Utah", "Utah_state");
            this.put("Vermont", "Vermont_state");
            this.put("Virginia", "Virginia_state");
            this.put("Washington D.C.", "Washington_DC_state");
            this.put("West Virginia", "West_Virginia_state");
            this.put("Wisconsin", "Wisconsin_state");
        }
    };

    @Override
    public List<String> hideRow(List<DynamicRowModel> dynRowList) {
        return null;
    }

    @Override
    public List<String> hideModificationNotes() {
        return null;
    }

    @Override
    public List<String> hideSheets(DeclareRequestModel requestModel) {
        Map extendParams = requestModel.getExtendParams();
        List<String> hideSheets = new ArrayList<String>();
        String customEvent = requestModel.getCustomEvent();
        String operation = requestModel.getOperation();
        if (ADD.equalsIgnoreCase(customEvent) || RECALC_KEY.equalsIgnoreCase(customEvent) || REGETDATA_KEY.equalsIgnoreCase(customEvent)) {
            if (MapUtils.isEmpty((Map)extendParams)) {
                return hideSheets;
            }
            if (extendParams.containsKey(USA_CIT_TAX_AREA_LIST) && extendParams.get(USA_CIT_TAX_AREA_LIST) != null) {
                String taxAreaIdsStr = extendParams.get(USA_CIT_TAX_AREA_LIST).toString();
                List taxAreaIds = SerializationUtils.fromJsonStringToList((String)taxAreaIdsStr, Long.class);
                if (!taxAreaIds.contains(1681071243350195200L)) {
                    hideSheets.add("Texas (FT)");
                }
                QFilter filter = new QFilter("id", "in", (Object)taxAreaIds);
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bastax_taxareagroup", (String)"id,name", (QFilter[])filter.toArray());
                List nameList = dynamicObjects.stream().map(m -> m.getString("name")).distinct().collect(Collectors.toList());
                List collect = VALUEABLE_AREA_LIST.stream().filter(m -> !nameList.contains(m)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)) {
                    hideSheets.addAll(collect);
                }
            }
        } else {
            QFilter filter;
            DynamicObjectCollection notHideSheets;
            Long id = requestModel.getId();
            if (id != null && CollectionUtils.isNotEmpty((Collection)(notHideSheets = QueryServiceHelper.query((String)"gtcp_draft_tab", (String)"id,tab,draftid", (QFilter[])(filter = new QFilter("draftid", "=", (Object)id)).toArray())))) {
                List tabList = notHideSheets.stream().map(m -> m.getString("tab")).distinct().collect(Collectors.toList());
                hideSheets = ALL_VALUEABLE_AREA_LIST.stream().filter(m -> !tabList.contains(m)).collect(Collectors.toList());
            }
        }
        return hideSheets;
    }

    @Override
    public List<String> hideRowByRequestModel(DeclareRequestModel requestModel) {
        ArrayList<String> list = new ArrayList<String>(32);
        list.add("tpo_declare_main_tsd");
        list.add("Federal_taxable_income_before_other_taxes_and_licenses_spec");
        Object draftpurpose = requestModel.getExtendParams().get("draftpurpose");
        if (StringUtil.equalsIgnoreCase((CharSequence)((String)draftpurpose), (CharSequence)"sjjt")) {
            list.add("Estimated_tax_penalty");
            list.add("Tax_paid_and_refundable_credit");
            list.add("Tax_paid_and_refundable_credit_fe_dyn");
            list.add("Amount_dueto_be_refunded");
            list.add("Tax_paid_and_refundable_credit_item");
            list.add("Tax_paid_and_refundable_credit_maine_dyn");
            list.add("Amount_dueto_be_refunded_maine");
            list.add("Prior_payment");
            list.add("Net_tax_due");
            list.add("Penalty");
            list.add("Interest_Texas_FT");
            list.add("Total_amount_due_and_payable");
            list.add("Tax_paid_and_refundable_credit_common_item");
            list.add("Amount_dueto_be_refunded_common");
            list.add("Alabama_Tax_paid_and_refundable_credit_dyn");
            list.add("Alaska_Tax_paid_and_refundable_credit_dyn");
            list.add("Arizona_Tax_paid_and_refundable_credit_dyn");
            list.add("Arkansas_Tax_paid_and_refundable_credit_dyn");
            list.add("California_Tax_paid_and_refundable_credit_dyn");
            list.add("Colorado_Tax_paid_and_refundable_credit_dyn");
            list.add("Connecticut_Tax_paid_and_refundable_credit_dyn");
            list.add("Delaware_Tax_paid_and_refundable_credit_dyn");
            list.add("Florida_Tax_paid_and_refundable_credit_dyn");
            list.add("Georgia_Tax_paid_and_refundable_credit_dyn");
            list.add("Hawaii_Tax_paid_and_refundable_credit_dyn");
            list.add("Idaho_Tax_paid_and_refundable_credit_dyn");
            list.add("Illinois_Tax_paid_and_refundable_credit_dyn");
            list.add("Indiana_Tax_paid_and_refundable_credit_dyn");
            list.add("Iowa_Tax_paid_and_refundable_credit_dyn");
            list.add("Kansas_Tax_paid_and_refundable_credit_dyn");
            list.add("Kentucky_Tax_paid_and_refundable_credit_dyn");
            list.add("Louisiana_Tax_paid_and_refundable_credit_dyn");
            list.add("Maryland_Tax_paid_and_refundable_credit_dyn");
            list.add("Massachusetts_Tax_paid_and_refundable_credit_dyn");
            list.add("Michigan_Tax_paid_and_refundable_credit_dyn");
            list.add("Minnesota_Tax_paid_and_refundable_credit_dyn");
            list.add("Mississippi_Tax_paid_and_refundable_credit_dyn");
            list.add("Missouri_Tax_paid_and_refundable_credit_dyn");
            list.add("Montana_Tax_paid_and_refundable_credit_dyn");
            list.add("Nebraska_Tax_paid_and_refundable_credit_dyn");
            list.add("New_Hampshire_Tax_paid_and_refundable_credit_dyn");
            list.add("New_Jersey_Tax_paid_and_refundable_credit_dyn");
            list.add("New_Mexico_Tax_paid_and_refundable_credit_dyn");
            list.add("New_York_Tax_paid_and_refundable_credit_dyn");
            list.add("North_Carolina_Tax_paid_and_refundable_credit_dyn");
            list.add("North_Dakota_Tax_paid_and_refundable_credit_dyn");
            list.add("Oklahoma_Tax_paid_and_refundable_credit_dyn");
            list.add("Oregon_Tax_paid_and_refundable_credit_dyn");
            list.add("Pennsylvania_Tax_paid_and_refundable_credit_dyn");
            list.add("Rhode_Island_Tax_paid_and_refundable_credit_dyn");
            list.add("South_Carolina_Tax_paid_and_refundable_credit_dyn");
            list.add("Tennessee_Tax_paid_and_refundable_credit_dyn");
            list.add("Utah_Tax_paid_and_refundable_credit_dyn");
            list.add("Vermont_Tax_paid_and_refundable_credit_dyn");
            list.add("Virginia_Tax_paid_and_refundable_credit_dyn");
            list.add("Washington_DC_Tax_paid_and_refundable_credit_dyn");
            list.add("West_Virginia_Tax_paid_and_refundable_credit_dyn");
            list.add("Wisconsin_Tax_paid_and_refundable_credit_dyn");
        } else {
            list.add("Amount_accrued");
            list.add("Amount_to_be_accrued");
        }
        Map extendParams = requestModel.getExtendParams();
        List<Object> hideSheets = new ArrayList<String>();
        String customEvent = requestModel.getCustomEvent();
        String operation = requestModel.getOperation();
        if (ADD.equalsIgnoreCase(customEvent) || RECALC_KEY.equalsIgnoreCase(customEvent) || REGETDATA_KEY.equalsIgnoreCase(customEvent)) {
            if (MapUtils.isEmpty((Map)extendParams)) {
                return list;
            }
            if (extendParams.containsKey(USA_CIT_TAX_AREA_LIST) && extendParams.get(USA_CIT_TAX_AREA_LIST) != null) {
                String taxAreaIdsStr = extendParams.get(USA_CIT_TAX_AREA_LIST).toString();
                List taxAreaIds = SerializationUtils.fromJsonStringToList((String)taxAreaIdsStr, Long.class);
                if (!taxAreaIds.contains(1681071243350195200L)) {
                    hideSheets.add("Texas (FT)");
                }
                QFilter filter = new QFilter("id", "in", (Object)taxAreaIds);
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bastax_taxareagroup", (String)"id,name", (QFilter[])filter.toArray());
                List nameList = dynamicObjects.stream().map(m -> m.getString("name")).distinct().collect(Collectors.toList());
                List collect = VALUEABLE_AREA_LIST.stream().filter(m -> !nameList.contains(m)).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)) {
                    hideSheets.addAll(collect);
                }
            }
        } else {
            QFilter filter;
            DynamicObjectCollection notHideSheets;
            Long id = requestModel.getId();
            if (id != null && CollectionUtils.isNotEmpty((Collection)(notHideSheets = QueryServiceHelper.query((String)"gtcp_draft_tab", (String)"id,tab,draftid", (QFilter[])(filter = new QFilter("draftid", "=", (Object)id)).toArray())))) {
                List tabList = notHideSheets.stream().map(m -> m.getString("tab")).distinct().collect(Collectors.toList());
                hideSheets = ALL_VALUEABLE_AREA_LIST.stream().filter(m -> !tabList.contains(m)).collect(Collectors.toList());
            }
        }
        hideSheets.stream().filter(row -> STATE_INCOME_TAX_OVERVIEW_HIDEROW.containsKey(row)).forEach(row -> list.add(STATE_INCOME_TAX_OVERVIEW_HIDEROW.get(row)));
        return list;
    }

    @Override
    public List<String> hideCol(DeclareRequestModel requestModel) {
        ArrayList<String> list = new ArrayList<String>();
        Object draftpurpose = requestModel.getExtendParams().get("draftpurpose");
        if (StringUtil.equalsIgnoreCase((CharSequence)((String)draftpurpose), (CharSequence)"sjjt")) {
            list.add("Amount_dueto_be_refunded");
        } else {
            list.add("Amount_to_be_accrued");
        }
        return list;
    }
}

